/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.image.operator;

import com.dfsek.terra.addons.image.image.Image;
import com.dfsek.terra.addons.image.util.ColorUtil;
import com.dfsek.terra.addons.image.util.MathUtil;
import com.dfsek.terra.api.noise.NoiseSampler;
import net.jafama.FastMath;

public class DistanceTransform {
    private final double[][] distances;
    private final int width;
    private final int height;
    private double minDistance;
    private double maxDistance;
    private static final double MAX_DISTANCE_CAP = 1.0E7;

    public DistanceTransform(Image image, ColorUtil.Channel channel, int threshold, boolean clampToMaxEdgeDistance, CostFunction costFunction, boolean invertThreshold) {
        int y;
        int x;
        boolean[][] binaryImage = new boolean[image.getWidth()][image.getHeight()];
        for (int x2 = 0; x2 < image.getWidth(); ++x2) {
            for (int y2 = 0; y2 < image.getHeight(); ++y2) {
                binaryImage[x2][y2] = ColorUtil.getChannel(image.getRGB(x2, y2), channel) > threshold ^ invertThreshold;
            }
        }
        boolean[][] binaryImageEdge = new boolean[image.getWidth()][image.getHeight()];
        for (int x3 = 0; x3 < image.getWidth(); ++x3) {
            for (int y3 = 0; y3 < image.getHeight(); ++y3) {
                binaryImageEdge[x3][y3] = !binaryImage[x3][y3] ? false : x3 > 0 && !binaryImage[x3 - 1][y3] || y3 > 0 && !binaryImage[x3][y3 - 1] || x3 < image.getWidth() - 1 && !binaryImage[x3 + 1][y3] || y3 < image.getHeight() - 1 && !binaryImage[x3][y3 + 1];
            }
        }
        double[][] function = new double[image.getWidth()][image.getHeight()];
        for (x = 0; x < image.getWidth(); ++x) {
            for (y = 0; y < image.getHeight(); ++y) {
                double[] dArray = function[x];
                dArray[y] = switch (costFunction) {
                    default -> throw new IncompatibleClassChangeError();
                    case CostFunction.Channel -> ColorUtil.getChannel(image.getRGB(x, y), channel);
                    case CostFunction.Threshold -> {
                        if (binaryImage[x][y]) {
                            yield 1.0E7;
                        }
                        yield 0.0;
                    }
                    case CostFunction.ThresholdEdge, CostFunction.ThresholdEdgeSigned -> binaryImageEdge[x][y] ? 0.0 : 1.0E7;
                };
            }
        }
        this.distances = this.calculateDistance2D(function);
        if (costFunction == CostFunction.ThresholdEdgeSigned) {
            for (x = 0; x < image.getWidth(); ++x) {
                for (y = 0; y < image.getHeight(); ++y) {
                    double[] dArray = this.distances[x];
                    int n = y;
                    dArray[n] = dArray[n] * (binaryImage[x][y] ? 1.0 : -1.0);
                }
            }
        }
        if (clampToMaxEdgeDistance) {
            int x4;
            double max = Double.NEGATIVE_INFINITY;
            for (x4 = 0; x4 < image.getWidth(); ++x4) {
                max = Math.max(max, this.distances[x4][0]);
                max = Math.max(max, this.distances[x4][image.getHeight() - 1]);
            }
            for (int y4 = 0; y4 < image.getHeight(); ++y4) {
                max = Math.max(max, this.distances[0][y4]);
                max = Math.max(max, this.distances[image.getWidth() - 1][y4]);
            }
            for (x4 = 0; x4 < image.getWidth(); ++x4) {
                for (int y5 = 0; y5 < image.getHeight(); ++y5) {
                    this.distances[x4][y5] = Math.max(max, this.distances[x4][y5]);
                }
            }
        }
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.setOutputRange();
    }

    private double[][] calculateDistance2D(double[][] f) {
        double[][] d = new double[f.length][f[0].length];
        for (int x = 0; x < f.length; ++x) {
            d[x] = this.calculateDistance1D(f[x]);
        }
        double[] row = new double[f.length];
        for (int y = 0; y < f[0].length; ++y) {
            int x;
            for (x = 0; x < f[0].length; ++x) {
                row[x] = d[x][y];
            }
            row = this.calculateDistance1D(row);
            for (x = 0; x < f[0].length; ++x) {
                d[x][y] = FastMath.sqrt(row[x]);
            }
        }
        return d;
    }

    private double[] calculateDistance1D(double[] f) {
        double[] d = new double[f.length];
        int[] v = new int[f.length];
        double[] z = new double[f.length + 1];
        int k = 0;
        v[0] = 0;
        z[0] = -2.147483648E9;
        z[1] = 2.147483647E9;
        int q = 1;
        while (q <= f.length - 1) {
            double s = (f[q] + (double)FastMath.pow2(q) - (f[v[k]] + (double)FastMath.pow2(v[k]))) / (double)(2 * q - 2 * v[k]);
            while (s <= z[k]) {
                s = (f[q] + (double)FastMath.pow2(q) - (f[v[--k]] + (double)FastMath.pow2(v[k]))) / (double)(2 * q - 2 * v[k]);
            }
            v[++k] = q++;
            z[k] = s;
            z[k + 1] = 2.147483647E9;
        }
        k = 0;
        for (q = 0; q <= f.length - 1; ++q) {
            while (z[k + 1] < (double)q) {
                ++k;
            }
            d[q] = (double)FastMath.pow2(q - v[k]) + f[v[k]];
        }
        return d;
    }

    private void normalize(Normalization normalization) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                double d = this.distances[x][y];
                double[] dArray = this.distances[x];
                dArray[y] = switch (normalization) {
                    default -> throw new IncompatibleClassChangeError();
                    case Normalization.None -> this.distances[x][y];
                    case Normalization.Linear -> MathUtil.lerp(d, this.minDistance, -1.0, this.maxDistance, 1.0);
                    case Normalization.SmoothPreserveZero -> this.minDistance > 0.0 || this.maxDistance < 0.0 ? MathUtil.lerp(this.distances[x][y], this.minDistance, -1.0, this.maxDistance, 1.0) : (d > 0.0 ? FastMath.pow2(d / this.maxDistance) : (d < 0.0 ? -FastMath.pow2(d / this.minDistance) : 0.0));
                };
            }
        }
        this.setOutputRange();
    }

    private void setOutputRange() {
        double minDistance = Double.POSITIVE_INFINITY;
        double maxDistance = Double.NEGATIVE_INFINITY;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                minDistance = Math.min(minDistance, this.distances[x][y]);
                maxDistance = Math.max(maxDistance, this.distances[x][y]);
            }
        }
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
    }

    public static enum CostFunction {
        Channel,
        Threshold,
        ThresholdEdge,
        ThresholdEdgeSigned;

    }

    public static enum Normalization {
        None,
        Linear,
        SmoothPreserveZero;

    }

    public static class Noise
    implements NoiseSampler {
        private final DistanceTransform transform;

        public Noise(DistanceTransform transform, Normalization normalization) {
            this.transform = transform;
            transform.normalize(normalization);
        }

        public double noise(long seed, double x, double y) {
            if (x < 0.0 || y < 0.0 || x >= (double)this.transform.width || y >= (double)this.transform.height) {
                return this.transform.minDistance;
            }
            return this.transform.distances[FastMath.floorToInt(x)][FastMath.floorToInt(y)];
        }

        public double noise(long seed, double x, double y, double z) {
            return this.noise(seed, x, z);
        }
    }
}

