/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.image.noisesampler;

import com.dfsek.terra.addons.image.colorsampler.ColorSampler;
import com.dfsek.terra.addons.image.util.ColorUtil;
import com.dfsek.terra.addons.image.util.MathUtil;
import com.dfsek.terra.api.noise.NoiseSampler;

public class ChannelNoiseSampler
implements NoiseSampler {
    private final ColorSampler colorSampler;
    private final ColorUtil.Channel channel;
    private final boolean normalize;
    private final boolean premultiply;

    public ChannelNoiseSampler(ColorSampler colorSampler, ColorUtil.Channel channel, boolean normalize, boolean premultiply) {
        this.colorSampler = colorSampler;
        this.channel = channel;
        this.normalize = normalize;
        this.premultiply = premultiply;
    }

    public double noise(long seed, double x, double y) {
        int sample = this.colorSampler.apply((int)x, (int)y);
        int premultiplied = this.premultiply ? ColorUtil.premultiply(sample) : sample;
        double channelValue = this.channel.from(premultiplied);
        return this.normalize ? MathUtil.lerp(channelValue, 0.0, -1.0, 255.0, 1.0) : channelValue;
    }

    public double noise(long seed, double x, double y, double z) {
        return this.noise(seed, x, z);
    }
}

