/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.image.converter;

import com.dfsek.terra.addons.image.converter.ColorConverter;
import com.dfsek.terra.addons.image.util.ColorUtil;
import com.dfsek.terra.addons.image.util.MapUtil;
import java.util.HashSet;
import java.util.Map;

public class ExactColorConverter<T>
implements ColorConverter<T> {
    private final Map<Integer, T> map;
    private final T fallback;
    private final boolean ignoreAlpha;

    public ExactColorConverter(Map<Integer, T> map, T fallback, boolean ignoreAlpha) {
        if (ignoreAlpha) {
            map = MapUtil.mapKeys(map, ColorUtil::zeroAlpha);
        }
        this.map = map;
        this.fallback = fallback;
        this.ignoreAlpha = ignoreAlpha;
    }

    @Override
    public T apply(int color) {
        T lookup;
        if (this.ignoreAlpha) {
            color = ColorUtil.zeroAlpha(color);
        }
        return (lookup = this.map.get(color)) != null ? lookup : this.fallback;
    }

    @Override
    public Iterable<T> getEntries() {
        HashSet<T> entries = new HashSet<T>(this.map.values());
        entries.add(this.fallback);
        return entries;
    }
}

