/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.image.colorsampler.mutate;

import com.dfsek.terra.addons.image.colorsampler.ColorSampler;
import net.jafama.FastMath;

public class RotateColorSampler
implements ColorSampler {
    private final ColorSampler sampler;
    private final double radians;
    private final RotationMethod rotationMethod;

    public RotateColorSampler(ColorSampler sampler, double degrees) {
        this.sampler = sampler;
        double normalizedDegrees = degrees % 360.0;
        if (normalizedDegrees < 0.0) {
            normalizedDegrees += 360.0;
        }
        this.rotationMethod = normalizedDegrees == 0.0 ? RotationMethod.DEG_0 : (normalizedDegrees == 90.0 ? RotationMethod.DEG_90 : (normalizedDegrees == 180.0 ? RotationMethod.DEG_180 : (normalizedDegrees == 270.0 ? RotationMethod.DEG_270 : RotationMethod.RAD_ANY)));
        this.radians = FastMath.toRadians(degrees);
    }

    @Override
    public int apply(int x, int z) {
        int rx = switch (this.rotationMethod) {
            default -> throw new IncompatibleClassChangeError();
            case RotationMethod.DEG_0 -> x;
            case RotationMethod.DEG_90 -> -z;
            case RotationMethod.DEG_180 -> -x;
            case RotationMethod.DEG_270 -> z;
            case RotationMethod.RAD_ANY -> (int)((double)x * FastMath.cos(this.radians) - (double)z * FastMath.sin(this.radians));
        };
        int rz = switch (this.rotationMethod) {
            default -> throw new IncompatibleClassChangeError();
            case RotationMethod.DEG_0 -> z;
            case RotationMethod.DEG_90 -> x;
            case RotationMethod.DEG_180 -> -z;
            case RotationMethod.DEG_270 -> -x;
            case RotationMethod.RAD_ANY -> (int)((double)z * FastMath.cos(this.radians) + (double)x * FastMath.sin(this.radians));
        };
        return this.sampler.apply(rx, rz);
    }

    private static enum RotationMethod {
        DEG_0,
        DEG_90,
        DEG_180,
        DEG_270,
        RAD_ANY;

    }
}

