/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.HologramPackets.v1_8_R3.runnable;

import me.PM2.HologramPackets.EntityHitbox;
import me.PM2.HologramPackets.Main.NameTagAPI;
import me.PM2.HologramPackets.v1_8_R3.Util;
import me.PM2.HologramPackets.v1_8_R3.cache.CacheManager;
import me.PM2.HologramPackets.v1_8_R3.cache.LineCacheManager;
import me.PM2.HologramPackets.v1_8_R3.cache.PacketUpdateTaskManager;
import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityTeleport;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class PacketUpdateTask
implements Runnable {
    private final Player player;
    private final EntityLiving entityLiving;
    private final Entity entity;
    private BukkitTask task;
    private final double additionalY;

    public PacketUpdateTask(Player player, EntityLiving entityLiving, Entity entity) {
        this(player, entityLiving, entity, 0.0);
    }

    public PacketUpdateTask(Player player, EntityLiving entityLiving, Entity entity, double d) {
        this.player = player;
        this.entityLiving = entityLiving;
        this.entity = entity;
        this.additionalY = d;
        this.task = Bukkit.getScheduler().runTaskTimer((Plugin)NameTagAPI.getInstance(), (Runnable)this, 0L, 1L);
        PacketUpdateTaskManager.addEntry(entityLiving, this);
    }

    @Override
    public void run() {
        if (!this.player.isOnline()) {
            CacheManager.removePlayerFromCache(this.player);
            LineCacheManager.removePlayerFromCache(this.player);
            this.clear();
            return;
        }
        if (this.entity.isDead()) {
            PacketPlayOutEntityDestroy packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{this.entityLiving.getId()});
            Util.sendPacket(this.player, packetPlayOutEntityDestroy);
            CacheManager.removeEntityFromCache(this.entity);
            LineCacheManager.removeEntityFromCache(this.entity);
            this.clear();
            return;
        }
        Location location = this.entity.getLocation();
        double d = location.getY() + EntityHitbox.getFromEntity(this.entity).getLocationModifier().getY() + this.additionalY;
        this.entityLiving.setLocation(location.getX(), d, location.getZ(), location.getYaw(), location.getPitch());
        PacketPlayOutEntityTeleport packetPlayOutEntityTeleport = new PacketPlayOutEntityTeleport((net.minecraft.server.v1_8_R3.Entity)this.entityLiving);
        Util.sendPacket(this.player, packetPlayOutEntityTeleport);
    }

    public void clear() {
        if (this.task != null) {
            Bukkit.getScheduler().cancelTask(this.task.getTaskId());
            this.task = null;
        }
    }
}

