/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.HologramPackets.v1_8_R3.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.v1_8_R3.EntityLiving;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class LineCacheManager {
    private static final Map<Entity, Map<Player, List<EntityLiving>>> cache = new HashMap<Entity, Map<Player, List<EntityLiving>>>();

    public static Map<Entity, Map<Player, List<EntityLiving>>> getCache() {
        return cache;
    }

    public static Map<Player, List<EntityLiving>> getCachedMapByEntity(Entity entity) {
        return cache.get(entity);
    }

    public static List<EntityLiving> getLines(Entity entity, Player player) {
        Map<Player, List<EntityLiving>> map = cache.get(entity);
        if (map == null) {
            return null;
        }
        if (!map.containsKey(player)) {
            return null;
        }
        return map.get(player);
    }

    public static Player getPlayerByLines(Entity entity, List<EntityLiving> list) {
        Map<Player, List<EntityLiving>> map = LineCacheManager.getCachedMapByEntity(entity);
        for (Player player : map.keySet()) {
            if (!map.get(player).equals(list)) continue;
            return player;
        }
        return null;
    }

    public static Set<Player> getPlayersByEntity(Entity entity) {
        return new HashSet<Player>(LineCacheManager.getCachedMapByEntity(entity).keySet());
    }

    public static List<List<EntityLiving>> getAllLinesByPlayer(Player player) {
        ArrayList<List<EntityLiving>> arrayList = new ArrayList<List<EntityLiving>>();
        cache.keySet().forEach(entity -> {
            Map<Player, List<EntityLiving>> map = LineCacheManager.getCachedMapByEntity(entity);
            if (map.containsKey(player)) {
                arrayList.add(map.get(player));
            }
        });
        return arrayList;
    }

    public static void removeEntityFromCache(Entity entity) {
        cache.remove(entity);
    }

    public static void addEntry(Player player, Entity entity, EntityLiving entityLiving) {
        List<EntityLiving> list;
        Map<Player, List<EntityLiving>> map = LineCacheManager.getCachedMapByEntity(entity);
        if (map == null) {
            map = new HashMap<Player, List<EntityLiving>>();
        }
        if ((list = map.get(player)) == null) {
            list = new ArrayList<EntityLiving>();
        }
        list.add(entityLiving);
        map.put(player, list);
        cache.put(entity, map);
    }

    public static void removePlayerFromCache(Player player) {
        HashMap<Entity, Map<Player, List<EntityLiving>>> hashMap = new HashMap<Entity, Map<Player, List<EntityLiving>>>(LineCacheManager.getCache());
        hashMap.keySet().forEach(entity -> {
            Map<Player, List<EntityLiving>> map = LineCacheManager.getCachedMapByEntity(entity);
            if (map == null) {
                return;
            }
            if (!map.containsKey(player)) {
                return;
            }
            map.remove(player);
            if (map.size() == 0) {
                LineCacheManager.removeEntityFromCache(entity);
                return;
            }
            cache.put((Entity)entity, map);
        });
    }

    public static void removeLine(Player player, Entity entity, int n) {
        Map<Player, List<EntityLiving>> map = LineCacheManager.getCachedMapByEntity(entity);
        if (!map.containsKey(player)) {
            return;
        }
        List<EntityLiving> list = map.get(player);
        if (list.size() < n) {
            return;
        }
        EntityLiving entityLiving = list.get(n);
        list.remove(entityLiving);
        map.put(player, list);
    }

    public static void removeLine(Player player, Entity entity, EntityLiving entityLiving) {
        List<EntityLiving> list = cache.get(entity).get(player);
        if (!list.contains(entityLiving)) {
            return;
        }
        int n = list.indexOf(entityLiving);
        LineCacheManager.removeLine(player, entity, n);
    }
}

