/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.HologramPackets.v1_8_R3.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.v1_8_R3.EntityLiving;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class CacheManager {
    private static final Map<Entity, Map<Player, EntityLiving>> cache = new HashMap<Entity, Map<Player, EntityLiving>>();

    public static Map<Entity, Map<Player, EntityLiving>> getCache() {
        return cache;
    }

    public static Map<Player, EntityLiving> getCachedMapByEntity(Entity entity) {
        return cache.get(entity);
    }

    public static EntityLiving getArmorStand(Player player, Entity entity) {
        Map<Player, EntityLiving> map = cache.get(entity);
        if (map == null) {
            return null;
        }
        if (!map.containsKey(player)) {
            return null;
        }
        return map.get(player);
    }

    public static Player getPlayerByArmorStand(Entity entity, EntityLiving entityLiving) {
        Map<Player, EntityLiving> map = CacheManager.getCachedMapByEntity(entity);
        for (Player player : map.keySet()) {
            if (!map.get(player).equals((Object)entityLiving)) continue;
            return player;
        }
        return null;
    }

    public static Set<Player> getPlayersByEntity(Entity entity) {
        return new HashSet<Player>(CacheManager.getCachedMapByEntity(entity).keySet());
    }

    public static Set<EntityLiving> getAllArmorStandsByPlayer(Player player) {
        HashSet<EntityLiving> hashSet = new HashSet<EntityLiving>();
        cache.keySet().forEach(entity -> {
            Map<Player, EntityLiving> map = CacheManager.getCachedMapByEntity(entity);
            if (map.containsKey(player)) {
                hashSet.add(map.get(player));
            }
        });
        return hashSet;
    }

    public static void removeEntityFromCache(Entity entity) {
        cache.remove(entity);
    }

    public static void addEntry(Player player, Entity entity, EntityLiving entityLiving) {
        Map<Player, EntityLiving> map = CacheManager.getCachedMapByEntity(entity);
        if (map == null) {
            map = new HashMap<Player, EntityLiving>();
        }
        map.put(player, entityLiving);
        cache.put(entity, map);
    }

    public static void removePlayerFromCache(Player player) {
        HashMap<Entity, Map<Player, EntityLiving>> hashMap = new HashMap<Entity, Map<Player, EntityLiving>>(CacheManager.getCache());
        hashMap.keySet().forEach(entity -> {
            Map<Player, EntityLiving> map = CacheManager.getCachedMapByEntity(entity);
            if (map == null) {
                return;
            }
            if (!map.containsKey(player)) {
                return;
            }
            map.remove(player);
            if (map.size() == 0) {
                CacheManager.removeEntityFromCache(entity);
                return;
            }
            cache.put((Entity)entity, map);
        });
    }

    public static void removeArmorStandFromCache(Entity entity, Player player) {
        Map<Player, EntityLiving> map = CacheManager.getCachedMapByEntity(entity);
        if (!map.containsKey(player)) {
            return;
        }
        map.remove(player);
        cache.put(entity, map);
    }
}

