/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.HologramPackets.v1_18_R2;

import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.utils.Common;
import me.PM2.HologramPackets.EntityHitbox;
import me.PM2.HologramPackets.INMSHandler;
import me.PM2.HologramPackets.Main.NameTagAPI;
import me.PM2.HologramPackets.Main.cache.CacheManager;
import me.PM2.HologramPackets.Main.cache.LineCacheManager;
import me.PM2.HologramPackets.Main.cache.PacketUpdateTaskManager;
import me.PM2.HologramPackets.Main.runnable.PacketUpdateTask;
import me.PM2.HologramPackets.v1_18_R2.Util;
import me.PM2.HologramPackets.v1_18_R2.connection.PacketReader;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Vector3f;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutBlockAction;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityLiving;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityGiantZombie;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityEnderChest;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftChatMessage;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class NMSHandler<T>
implements INMSHandler {
    HashMap<String, TileEntity> tileEntityStorage = new HashMap();

    @Override
    public void setNameTag(Player player, Entity entity, String string) {
        if (CacheManager.hasNameTag(entity)) {
            NameTagAPI.getInstance().logInfo("Entity #" + entity.getUniqueId() + " (TYPE: " + entity.getType() + ") already has a Name Tag, therefore a new one can't be set!");
            return;
        }
        string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        LivingEntity livingEntity = CacheManager.getArmorStand(player, entity);
        if (livingEntity != null) {
            Util.rename(player, entity, string);
            return;
        }
        Location location = entity.getLocation();
        EntityHitbox entityHitbox = EntityHitbox.getFromEntity(entity);
        double d = location.getY() + entityHitbox.getLocationModifier().getY();
        EntityArmorStand entityArmorStand = (EntityArmorStand)this.getEntityArmorStand(string, location, d);
        PacketPlayOutSpawnEntityLiving packetPlayOutSpawnEntityLiving = new PacketPlayOutSpawnEntityLiving((EntityLiving)entityArmorStand);
        Util.sendPacket(player, packetPlayOutSpawnEntityLiving);
        LivingEntity livingEntity2 = (LivingEntity)entityArmorStand.getBukkitEntity();
        CacheManager.addEntry(player, entity, livingEntity2);
        LineCacheManager.addEntry(player, entity, livingEntity2);
        new PacketUpdateTask(player, livingEntity2, entity);
    }

    @Override
    public void deleteNameTag(Player player, Entity entity) {
        LivingEntity livingEntity2 = CacheManager.getArmorStand(player, entity);
        if (livingEntity2 == null) {
            return;
        }
        PacketPlayOutEntityDestroy packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{livingEntity2.getEntityId()});
        Util.sendPacket(player, packetPlayOutEntityDestroy);
        Objects.requireNonNull(LineCacheManager.getLines(entity, player)).forEach(livingEntity -> {
            PacketPlayOutEntityDestroy packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{livingEntity.getEntityId()});
            Util.sendPacket(player, packetPlayOutEntityDestroy);
        });
        CacheManager.removeArmorStandFromCache(entity, player);
        LineCacheManager.removeEntityFromCache(entity);
    }

    @Override
    public void setNameTag(Collection<? extends Player> collection, Entity entity, String string) {
        collection.forEach(player -> this.setNameTag((Player)player, entity, string));
    }

    @Override
    public void deleteNameTag(Collection<? extends Player> collection, Entity entity) {
        collection.forEach(player -> this.deleteNameTag((Player)player, entity));
    }

    @Override
    public void addLine(Player player, Entity entity, String string) {
        List<LivingEntity> list = LineCacheManager.getLines(entity, player);
        if (list == null) {
            this.setNameTag(player, entity, string);
            return;
        }
        string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        int n = list.size();
        LivingEntity livingEntity = list.get(n - 1);
        Location location = livingEntity.getLocation();
        double d = (double)n * Util.GAP_BETWEEN_LINES;
        double d2 = location.getY();
        EntityArmorStand entityArmorStand = (EntityArmorStand)this.getEntityArmorStand(string, location, d2);
        PacketPlayOutSpawnEntityLiving packetPlayOutSpawnEntityLiving = new PacketPlayOutSpawnEntityLiving((EntityLiving)entityArmorStand);
        LivingEntity livingEntity2 = (LivingEntity)entityArmorStand.getBukkitEntity();
        Util.sendPacket(player, packetPlayOutSpawnEntityLiving);
        LineCacheManager.addEntry(player, entity, livingEntity2);
        new PacketUpdateTask(player, livingEntity2, entity, d);
    }

    @Override
    public void addLine(Collection<? extends Player> collection, Entity entity, String string) {
        collection.forEach(player -> this.addLine((Player)player, entity, string));
    }

    @Override
    public void removeLine(Player player, Entity entity, int n) {
        if (n == 0) {
            NameTagAPI.getInstance().logSevere("Line #0 can't be deleted! Use method by.thmihnea.nms.v1_16_R2.NMSHandler#deleteNameTag to fully get rid of the NameTag!");
            return;
        }
        LivingEntity livingEntity2 = Objects.requireNonNull(LineCacheManager.getLines(entity, player)).get(n);
        PacketPlayOutEntityDestroy packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{livingEntity2.getEntityId()});
        Util.sendPacket(player, packetPlayOutEntityDestroy);
        LineCacheManager.removeLine(player, entity, n);
        double d = entity.getLocation().getY() + EntityHitbox.getFromEntity(entity).getLocationModifier().getY();
        AtomicInteger atomicInteger = new AtomicInteger(0);
        LineCacheManager.getLines(entity, player).forEach(livingEntity -> {
            PacketUpdateTask packetUpdateTask = PacketUpdateTaskManager.getFromEntityLiving(livingEntity);
            PacketUpdateTaskManager.removeEntry(livingEntity);
            packetUpdateTask.clear();
            Location location = livingEntity.getLocation();
            EntityLiving entityLiving = (EntityLiving)((CraftEntity)livingEntity).getHandle();
            entityLiving.b(location.getX(), d, location.getZ(), location.getYaw(), location.getPitch());
            try {
                PacketPlayOutEntityTeleport packetPlayOutEntityTeleport = (PacketPlayOutEntityTeleport)PacketPlayOutEntityTeleport.class.getConstructor(net.minecraft.world.entity.Entity.class).newInstance(entityLiving);
                Util.sendPacket(player, packetPlayOutEntityTeleport);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            new PacketUpdateTask(player, (LivingEntity)livingEntity, entity, (double)atomicInteger.get() * Util.GAP_BETWEEN_LINES);
            atomicInteger.set(atomicInteger.get() + 1);
        });
    }

    @Override
    public void removeLine(Collection<? extends Player> collection, Entity entity, int n) {
        collection.forEach(player -> this.removeLine((Player)player, entity, n));
    }

    @Override
    public void startPipelineMonitoring(Player player) {
        PacketReader.startPipelineMonitoring(player);
    }

    @Override
    public void abortPipelineMonitoring(Player player) {
        PacketReader.abortPipelineMonitoring(player);
    }

    @Override
    public void sendPacket(Player player, Object object) {
        Util.sendPacket(player, object);
    }

    @Override
    public Object getDestroyPacket(LivingEntity livingEntity) {
        EntityLiving entityLiving = (EntityLiving)((CraftEntity)livingEntity).getHandle();
        try {
            return new PacketPlayOutEntityDestroy(new int[]{(Integer)Class.forName("net.minecraft.world.entity.Entity").getMethod("ae", new Class[0]).invoke((Object)entityLiving, new Object[0])});
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Object getSpawnPacket(LivingEntity livingEntity) {
        EntityLiving entityLiving = (EntityLiving)((CraftEntity)livingEntity).getHandle();
        try {
            return PacketPlayOutSpawnEntity.class.getConstructor(net.minecraft.world.entity.Entity.class).newInstance(entityLiving);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public Object getTeleportPacket(LivingEntity livingEntity) {
        EntityLiving entityLiving = (EntityLiving)((CraftEntity)livingEntity).getHandle();
        try {
            return PacketPlayOutEntityTeleport.class.getConstructor(net.minecraft.world.entity.Entity.class).newInstance(entityLiving);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public Object getTeleportPacket(Object object) {
        try {
            return PacketPlayOutEntityTeleport.class.getConstructor(net.minecraft.world.entity.Entity.class).newInstance(object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public Object getEntityArmorStand(String string, Location location, double d, boolean bl) {
        return this.getEntityArmorStand(string, location, d, bl, false);
    }

    @Override
    public Object getEntityArmorStand(String string, Location location, double d, boolean bl, boolean bl2) {
        EntityArmorStand entityArmorStand = new EntityArmorStand((World)((CraftWorld)location.getWorld()).getHandle(), location.getX(), d, location.getZ());
        entityArmorStand.a(location.getX(), d, location.getZ(), location.getYaw(), location.getPitch());
        entityArmorStand.j(bl);
        entityArmorStand.r(true);
        if (!string.equalsIgnoreCase("")) {
            try {
                entityArmorStand.getClass().getMethod("n", Boolean.TYPE).invoke((Object)entityArmorStand, true);
                entityArmorStand.getClass().getMethod("a", IChatBaseComponent.class).invoke((Object)entityArmorStand, CraftChatMessage.fromStringOrNull((String)Common.colorize(string)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        entityArmorStand.d(true);
        entityArmorStand.t(true);
        entityArmorStand.s(false);
        entityArmorStand.a(bl2);
        return entityArmorStand;
    }

    @Override
    public Object getEntityArmorStand(String string, Location location, double d) {
        return this.getEntityArmorStand(string, location, d, true);
    }

    @Override
    public void setInvisible(Object object, boolean bl) {
        ((EntityArmorStand)object).j(bl);
    }

    @Override
    public Object getEntityArmorStand(String string, Location location, boolean bl) {
        EntityArmorStand entityArmorStand = new EntityArmorStand((World)((CraftWorld)location.getWorld()).getHandle(), location.getX(), location.getY(), location.getZ());
        try {
            entityArmorStand.getClass().getMethod("a", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, Boolean.TYPE).invoke((Object)entityArmorStand, location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch()), 0, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        entityArmorStand.j(!bl);
        entityArmorStand.a(bl);
        if (!string.equalsIgnoreCase("")) {
            try {
                entityArmorStand.getClass().getMethod("n", Boolean.TYPE).invoke((Object)entityArmorStand, true);
                entityArmorStand.getClass().getMethod("a", IChatBaseComponent.class).invoke((Object)entityArmorStand, CraftChatMessage.fromStringOrNull((String)Common.colorize(string)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        entityArmorStand.d(true);
        entityArmorStand.t(true);
        entityArmorStand.r(true);
        entityArmorStand.s(false);
        return entityArmorStand;
    }

    @Override
    public LivingEntity getLivingEntity(Object object) {
        try {
            return (LivingEntity)((net.minecraft.world.entity.Entity)object).getClass().getMethod("getBukkitEntity", new Class[0]).invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public Object getPacketEntityEquipmentHand(Object object, ItemStack itemStack) {
        try {
            return new PacketPlayOutEntityEquipment(((Integer)Class.forName("net.minecraft.world.entity.Entity").getMethod("ae", new Class[0]).invoke(object, new Object[0])).intValue(), Arrays.asList(new Pair((Object)EnumItemSlot.a, (Object)CraftItemStack.asNMSCopy((ItemStack)itemStack))));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void setRightArmPose(Object object, float f, float f2, float f3) {
        ((EntityArmorStand)object).d(new Vector3f(f, f2, f3));
    }

    @Override
    public void setLeftArmPose(Object object, float f, float f2, float f3) {
        ((EntityArmorStand)object).c(new Vector3f(f, f2, f3));
    }

    @Override
    public void setRightLegPose(Object object, float f, float f2, float f3) {
        ((EntityArmorStand)object).f(new Vector3f(f, f2, f3));
    }

    @Override
    public void setLeftLegPose(Object object, float f, float f2, float f3) {
        ((EntityArmorStand)object).e(new Vector3f(f, f2, f3));
    }

    @Override
    public void setBodyPose(Object object, float f, float f2, float f3) {
        ((EntityArmorStand)object).b(new Vector3f(f, f2, f3));
    }

    @Override
    public void setHeadPose(Object object, float f, float f2, float f3) {
        ((EntityArmorStand)object).a(new Vector3f(f, f2, f3));
    }

    @Override
    public Object getPacketEntityMetadata(Object object) {
        try {
            return Class.forName("net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata").getConstructor(Integer.TYPE, DataWatcher.class, Boolean.TYPE).newInstance((Integer)Class.forName("net.minecraft.world.entity.Entity").getMethod("ae", new Class[0]).invoke(object, new Object[0]), Class.forName("net.minecraft.world.entity.Entity").getMethod("ai", new Class[0]).invoke(object, new Object[0]), false);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void setCustomName(Object object, String string) {
        try {
            object.getClass().getMethod("a", IChatBaseComponent.class).invoke(object, CraftChatMessage.fromStringOrNull((String)Common.colorize(string)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Object getPacketEntityEquipmentHead(Object object, ItemStack itemStack) {
        try {
            return new PacketPlayOutEntityEquipment(((Integer)Class.forName("net.minecraft.world.entity.Entity").getMethod("ae", new Class[0]).invoke(object, new Object[0])).intValue(), Arrays.asList(new Pair((Object)EnumItemSlot.f, (Object)CraftItemStack.asNMSCopy((ItemStack)itemStack))));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Object getPacketEntityEquipmentBody(Object object, ItemStack itemStack) {
        try {
            return new PacketPlayOutEntityEquipment(((Integer)Class.forName("net.minecraft.world.entity.Entity").getMethod("ae", new Class[0]).invoke(object, new Object[0])).intValue(), Arrays.asList(new Pair((Object)EnumItemSlot.e, (Object)CraftItemStack.asNMSCopy((ItemStack)itemStack))));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Object getPacketEntityEquipmentLegs(Object object, ItemStack itemStack) {
        try {
            return new PacketPlayOutEntityEquipment(((Integer)Class.forName("net.minecraft.world.entity.Entity").getMethod("ae", new Class[0]).invoke(object, new Object[0])).intValue(), Arrays.asList(new Pair((Object)EnumItemSlot.d, (Object)CraftItemStack.asNMSCopy((ItemStack)itemStack))));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Object getPacketEntityEquipmentBoots(Object object, ItemStack itemStack) {
        try {
            return new PacketPlayOutEntityEquipment(((Integer)Class.forName("net.minecraft.world.entity.Entity").getMethod("ae", new Class[0]).invoke(object, new Object[0])).intValue(), Arrays.asList(new Pair((Object)EnumItemSlot.c, (Object)CraftItemStack.asNMSCopy((ItemStack)itemStack))));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Object getLightningPacket(Location location) {
        try {
            EntityLightning entityLightning = new EntityLightning((EntityTypes)EntityTypes.a((String)EntityType.valueOf((String)"LIGHTNING").getKey().getKey()).get(), (World)((CraftWorld)location.getWorld()).getHandle());
            Field field = EntityLightning.class.getDeclaredField("isSilent");
            if (field != null) {
                field.setAccessible(true);
                field.set(entityLightning, MonthlyCrate.lightningSilent);
            }
            Constructor constructor = PacketPlayOutSpawnEntity.class.getDeclaredConstructor(Integer.TYPE, UUID.class, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE, EntityTypes.class, Integer.TYPE, Vec3D.class);
            constructor.setAccessible(true);
            return constructor.newInstance(entityLightning.getClass().getMethod("ae", new Class[0]).invoke((Object)entityLightning, new Object[0]), entityLightning.getClass().getMethod("cm", new Class[0]).invoke((Object)entityLightning, new Object[0]), location.getX(), location.getY(), location.getZ(), Float.valueOf(0.0f), Float.valueOf(0.0f), EntityTypes.a((String)"lightning_bolt").get(), 0, new Vec3D(0.0, 0.0, 0.0));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public Object getEntityGiant(Location location) {
        EntityGiantZombie entityGiantZombie = new EntityGiantZombie((EntityTypes)EntityTypes.a((String)EntityType.GIANT.getKey().getKey()).get(), (World)((CraftWorld)location.getWorld()).getHandle());
        entityGiantZombie.a(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        entityGiantZombie.j(true);
        entityGiantZombie.m(true);
        entityGiantZombie.s(true);
        entityGiantZombie.e(true);
        entityGiantZombie.d(true);
        entityGiantZombie.u(false);
        entityGiantZombie.t(false);
        return entityGiantZombie;
    }

    @Override
    public String getGiantUniqueID(Object object) {
        try {
            return (String)((EntityGiantZombie)object).getClass().getMethod("cn", new Class[0]).invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public void setCustomNameVisible(Object object, boolean bl) {
        try {
            ((EntityArmorStand)object).getClass().getMethod("n", Boolean.TYPE).invoke(object, bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Object getBlockTileEntity(Material material, Location location) {
        TileEntityChest tileEntityChest = null;
        if (material == Material.CHEST) {
            try {
                tileEntityChest = new TileEntityChest(new BlockPosition((int)location.getX(), (int)location.getY(), (int)location.getZ()), (IBlockData)Blocks.class.getDeclaredField("bX").getClass().getMethod("n", new Class[0]).invoke((Object)Blocks.class.getDeclaredField("bX"), new Object[0]));
            }
            catch (Exception exception) {}
        } else {
            try {
                tileEntityChest = new TileEntityEnderChest(new BlockPosition((int)location.getX(), (int)location.getY(), (int)location.getZ()), (IBlockData)Blocks.class.getDeclaredField("ex").getClass().getMethod("n", new Class[0]).invoke((Object)Blocks.class.getDeclaredField("ex"), new Object[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return tileEntityChest;
    }

    public Object getEnderChestPacket(Location location) {
        try {
            IBlockData iBlockData = (IBlockData)Blocks.class.getDeclaredField("ex").getClass().getMethod("n", new Class[0]).invoke((Object)Blocks.class.getDeclaredField("ex"), new Object[0]);
            return new PacketPlayOutBlockChange(new BlockPosition((int)location.getX(), (int)location.getY(), (int)location.getZ()), iBlockData);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object getChestPacket(Location location) {
        try {
            IBlockData iBlockData = (IBlockData)Blocks.class.getDeclaredField("bX").getClass().getMethod("n", new Class[0]).invoke((Object)Blocks.class.getDeclaredField("bX"), new Object[0]);
            return new PacketPlayOutBlockChange(new BlockPosition((int)location.getX(), (int)location.getY(), (int)location.getZ()), iBlockData);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Object getOpenEnderChestPacket(Location location) {
        return this.getOpenEnderChestPacket(location, true);
    }

    @Override
    public Object getOpenEnderChestPacket(Location location, boolean bl) {
        try {
            Block block = (Block)Block.class.getMethod("a", new Class[0]).invoke((Object)Blocks.ex.l(), new Object[0]);
            return new PacketPlayOutBlockAction(new BlockPosition((int)location.getX(), (int)location.getY(), (int)location.getZ()), block, 1, bl ? 1 : 0);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Object getOpenChestPacket(Location location) {
        return this.getOpenEnderChestPacket(location, true);
    }

    @Override
    public Object getOpenChestPacket(Location location, boolean bl) {
        try {
            Block block = (Block)Block.class.getMethod("a", new Class[0]).invoke((Object)Blocks.bX.l(), new Object[0]);
            return new PacketPlayOutBlockAction(new BlockPosition((int)location.getX(), (int)location.getY(), (int)location.getZ()), block, 1, bl ? 1 : 0);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void teleport(Location location, Object object) {
        if (object instanceof EntityArmorStand) {
            ((EntityArmorStand)object).a(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        } else {
            ((EntityGiantZombie)object).a(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        }
    }

    @Override
    public void sendPlayerHeadTexturePacket(final Player player, final Location location) {
        final CraftWorld craftWorld = (CraftWorld)location.getWorld();
        if (this.tileEntityStorage.containsKey(location.toString())) {
            TileEntity tileEntity = this.tileEntityStorage.get(location.toString());
            TileEntitySkull tileEntitySkull = (TileEntitySkull)tileEntity;
            player.sendBlockChange(location, location.getBlock().getBlockData());
            try {
                this.sendPacket(player, tileEntitySkull.getClass().getMethod("f", new Class[0]).invoke((Object)tileEntitySkull, new Object[0]));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        } else {
            new BukkitRunnable(){

                public void run() {
                    TileEntity tileEntity = craftWorld.getHandle().c_(new BlockPosition((int)location.getX(), (int)location.getY(), (int)location.getZ()));
                    NMSHandler.this.tileEntityStorage.put(location.toString(), tileEntity);
                    TileEntitySkull tileEntitySkull = (TileEntitySkull)tileEntity;
                    player.sendBlockChange(location, location.getBlock().getBlockData());
                    try {
                        NMSHandler.this.sendPacket(player, tileEntitySkull.getClass().getMethod("g", new Class[0]).invoke((Object)tileEntitySkull, new Object[0]));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }.runTask((Plugin)MonthlyCrate.getInstance());
        }
    }

    @Override
    public Object getEntityItem(Location location, ItemStack itemStack, boolean bl, boolean bl2) {
        EntityItem entityItem = new EntityItem((World)((CraftWorld)location.getWorld()).getHandle(), location.getX(), location.getY(), location.getZ(), CraftItemStack.asNMSCopy((ItemStack)itemStack));
        entityItem.a(2.147483647E9);
        entityItem.m(true);
        entityItem.c(true);
        try {
            entityItem.getClass().getMethod("n", Boolean.TYPE).invoke((Object)entityItem, bl2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bl2 && itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName()) {
            try {
                entityItem.getClass().getMethod("a", IChatBaseComponent.class).invoke((Object)entityItem, CraftChatMessage.fromStringOrNull((String)Common.colorize(itemStack.getItemMeta().getDisplayName())));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (bl) {
            entityItem.e(true);
        }
        return entityItem;
    }

    @Override
    public Object getItemSpawnPacket(Object object) {
        try {
            return PacketPlayOutSpawnEntity.class.getConstructor(net.minecraft.world.entity.Entity.class).newInstance((EntityItem)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public Object getItemDestroyPacket(Object object) {
        try {
            PacketPlayOutEntityDestroy packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{(Integer)Class.forName("net.minecraft.world.entity.Entity").getMethod("ae", new Class[0]).invoke(object, new Object[0])});
            return packetPlayOutEntityDestroy;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Object getItemVelocityPacket(Object object) {
        try {
            PacketPlayOutEntityVelocity packetPlayOutEntityVelocity = new PacketPlayOutEntityVelocity(((Integer)Class.forName("net.minecraft.world.entity.Entity").getMethod("ae", new Class[0]).invoke(object, new Object[0])).intValue(), new Vec3D(ThreadLocalRandom.current().nextDouble(-0.12, 0.12), ThreadLocalRandom.current().nextDouble(0.17, 0.37), ThreadLocalRandom.current().nextDouble(-0.12, 0.12)));
            return packetPlayOutEntityVelocity;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Object getItemMetaDataPacket(Object object) {
        EntityItem entityItem = (EntityItem)object;
        try {
            return Class.forName("net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata").getConstructor(Integer.TYPE, DataWatcher.class, Boolean.TYPE).newInstance((int)((Integer)entityItem.getClass().getMethod("ae", new Class[0]).invoke((Object)entityItem, new Object[0])), (DataWatcher)entityItem.getClass().getMethod("ai", new Class[0]).invoke((Object)entityItem, new Object[0]), true);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public void changeItemTypePacket(Object object, ItemStack itemStack) {
        ((EntityItem)object).a(CraftItemStack.asNMSCopy((ItemStack)itemStack));
    }

    @Override
    public void teleportItem(Location location, Object object) {
        ((EntityItem)object).a(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    @Override
    public void setShowHands(Object object, boolean bl) {
        ((EntityArmorStand)object).r(bl);
    }
}

