/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.HologramPackets.v1_15_R1;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.utils.Common;
import me.PM2.HologramPackets.EntityHitbox;
import me.PM2.HologramPackets.INMSHandler;
import me.PM2.HologramPackets.Main.NameTagAPI;
import me.PM2.HologramPackets.Main.cache.CacheManager;
import me.PM2.HologramPackets.Main.cache.LineCacheManager;
import me.PM2.HologramPackets.Main.cache.PacketUpdateTaskManager;
import me.PM2.HologramPackets.Main.runnable.PacketUpdateTask;
import me.PM2.HologramPackets.v1_15_R1.Util;
import me.PM2.HologramPackets.v1_15_R1.connection.PacketReader;
import net.minecraft.server.v1_15_R1.Block;
import net.minecraft.server.v1_15_R1.BlockPosition;
import net.minecraft.server.v1_15_R1.Blocks;
import net.minecraft.server.v1_15_R1.EntityArmorStand;
import net.minecraft.server.v1_15_R1.EntityGiantZombie;
import net.minecraft.server.v1_15_R1.EntityItem;
import net.minecraft.server.v1_15_R1.EntityLightning;
import net.minecraft.server.v1_15_R1.EntityLiving;
import net.minecraft.server.v1_15_R1.EntityTypes;
import net.minecraft.server.v1_15_R1.EnumItemSlot;
import net.minecraft.server.v1_15_R1.Item;
import net.minecraft.server.v1_15_R1.PacketPlayOutBlockAction;
import net.minecraft.server.v1_15_R1.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_15_R1.PacketPlayOutEntityEquipment;
import net.minecraft.server.v1_15_R1.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_15_R1.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_15_R1.PacketPlayOutEntityVelocity;
import net.minecraft.server.v1_15_R1.PacketPlayOutSpawnEntity;
import net.minecraft.server.v1_15_R1.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.v1_15_R1.TileEntity;
import net.minecraft.server.v1_15_R1.TileEntitySkull;
import net.minecraft.server.v1_15_R1.Vec3D;
import net.minecraft.server.v1_15_R1.Vector3f;
import net.minecraft.server.v1_15_R1.World;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_15_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_15_R1.util.CraftChatMessage;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class NMSHandler
implements INMSHandler {
    HashMap<String, TileEntity> tileEntityStorage = new HashMap();

    @Override
    public void setNameTag(Player player, Entity entity, String string) {
        if (CacheManager.hasNameTag(entity)) {
            NameTagAPI.getInstance().logInfo("Entity #" + entity.getUniqueId() + " (TYPE: " + entity.getType() + ") already has a Name Tag, therefore a new one can't be set!");
            return;
        }
        string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        LivingEntity livingEntity = CacheManager.getArmorStand(player, entity);
        if (livingEntity != null) {
            Util.rename(player, entity, string);
            return;
        }
        Location location = entity.getLocation();
        EntityHitbox entityHitbox = EntityHitbox.getFromEntity(entity);
        double d = location.getY() + entityHitbox.getLocationModifier().getY();
        EntityArmorStand entityArmorStand = (EntityArmorStand)this.getEntityArmorStand(string, location, d);
        PacketPlayOutSpawnEntityLiving packetPlayOutSpawnEntityLiving = new PacketPlayOutSpawnEntityLiving((EntityLiving)entityArmorStand);
        Util.sendPacket(player, packetPlayOutSpawnEntityLiving);
        LivingEntity livingEntity2 = (LivingEntity)entityArmorStand.getBukkitEntity();
        CacheManager.addEntry(player, entity, livingEntity2);
        LineCacheManager.addEntry(player, entity, livingEntity2);
        new PacketUpdateTask(player, livingEntity2, entity);
    }

    @Override
    public void deleteNameTag(Player player, Entity entity) {
        LivingEntity livingEntity2 = CacheManager.getArmorStand(player, entity);
        if (livingEntity2 == null) {
            return;
        }
        PacketPlayOutEntityDestroy packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{livingEntity2.getEntityId()});
        Util.sendPacket(player, packetPlayOutEntityDestroy);
        Objects.requireNonNull(LineCacheManager.getLines(entity, player)).forEach(livingEntity -> {
            PacketPlayOutEntityDestroy packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{livingEntity.getEntityId()});
            Util.sendPacket(player, packetPlayOutEntityDestroy);
        });
        CacheManager.removeArmorStandFromCache(entity, player);
        LineCacheManager.removeEntityFromCache(entity);
    }

    @Override
    public void setNameTag(Collection<? extends Player> collection, Entity entity, String string) {
        collection.forEach(player -> this.setNameTag((Player)player, entity, string));
    }

    @Override
    public void deleteNameTag(Collection<? extends Player> collection, Entity entity) {
        collection.forEach(player -> this.deleteNameTag((Player)player, entity));
    }

    @Override
    public void addLine(Player player, Entity entity, String string) {
        List<LivingEntity> list = LineCacheManager.getLines(entity, player);
        if (list == null) {
            this.setNameTag(player, entity, string);
            return;
        }
        string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        int n = list.size();
        LivingEntity livingEntity = list.get(n - 1);
        Location location = livingEntity.getLocation();
        double d = (double)n * Util.GAP_BETWEEN_LINES;
        double d2 = location.getY();
        EntityArmorStand entityArmorStand = (EntityArmorStand)this.getEntityArmorStand(string, location, d2);
        PacketPlayOutSpawnEntityLiving packetPlayOutSpawnEntityLiving = new PacketPlayOutSpawnEntityLiving((EntityLiving)entityArmorStand);
        LivingEntity livingEntity2 = (LivingEntity)entityArmorStand.getBukkitEntity();
        Util.sendPacket(player, packetPlayOutSpawnEntityLiving);
        LineCacheManager.addEntry(player, entity, livingEntity2);
        new PacketUpdateTask(player, livingEntity2, entity, d);
    }

    @Override
    public void addLine(Collection<? extends Player> collection, Entity entity, String string) {
        collection.forEach(player -> this.addLine((Player)player, entity, string));
    }

    @Override
    public void removeLine(Player player, Entity entity, int n) {
        if (n == 0) {
            NameTagAPI.getInstance().logSevere("Line #0 can't be deleted! Use method NMSHandler#deleteNameTag to fully get rid of the NameTag!");
            return;
        }
        LivingEntity livingEntity2 = Objects.requireNonNull(LineCacheManager.getLines(entity, player)).get(n);
        PacketPlayOutEntityDestroy packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{livingEntity2.getEntityId()});
        Util.sendPacket(player, packetPlayOutEntityDestroy);
        LineCacheManager.removeLine(player, entity, n);
        double d = entity.getLocation().getY() + EntityHitbox.getFromEntity(entity).getLocationModifier().getY();
        AtomicInteger atomicInteger = new AtomicInteger(0);
        LineCacheManager.getLines(entity, player).forEach(livingEntity -> {
            PacketUpdateTask packetUpdateTask = PacketUpdateTaskManager.getFromEntityLiving(livingEntity);
            PacketUpdateTaskManager.removeEntry(livingEntity);
            packetUpdateTask.clear();
            Location location = livingEntity.getLocation();
            EntityLiving entityLiving = (EntityLiving)((CraftEntity)livingEntity).getHandle();
            entityLiving.setLocation(location.getX(), d, location.getZ(), location.getYaw(), location.getPitch());
            try {
                PacketPlayOutEntityTeleport packetPlayOutEntityTeleport = (PacketPlayOutEntityTeleport)PacketPlayOutEntityTeleport.class.getConstructor(net.minecraft.world.entity.Entity.class).newInstance(entityLiving);
                Util.sendPacket(player, packetPlayOutEntityTeleport);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            new PacketUpdateTask(player, (LivingEntity)livingEntity, entity, (double)atomicInteger.get() * Util.GAP_BETWEEN_LINES);
            atomicInteger.set(atomicInteger.get() + 1);
        });
    }

    @Override
    public void removeLine(Collection<? extends Player> collection, Entity entity, int n) {
        collection.forEach(player -> this.removeLine((Player)player, entity, n));
    }

    @Override
    public void startPipelineMonitoring(Player player) {
        PacketReader.startPipelineMonitoring(player);
    }

    @Override
    public void abortPipelineMonitoring(Player player) {
        PacketReader.abortPipelineMonitoring(player);
    }

    @Override
    public void sendPacket(Player player, Object object) {
        Util.sendPacket(player, object);
    }

    @Override
    public Object getDestroyPacket(LivingEntity livingEntity) {
        EntityLiving entityLiving = (EntityLiving)((CraftEntity)livingEntity).getHandle();
        return new PacketPlayOutEntityDestroy(new int[]{entityLiving.getId()});
    }

    @Override
    public Object getSpawnPacket(LivingEntity livingEntity) {
        EntityLiving entityLiving = (EntityLiving)((CraftEntity)livingEntity).getHandle();
        return new PacketPlayOutSpawnEntityLiving(entityLiving);
    }

    @Override
    public Object getTeleportPacket(LivingEntity livingEntity) {
        EntityLiving entityLiving = (EntityLiving)((CraftEntity)livingEntity).getHandle();
        return new PacketPlayOutEntityTeleport((net.minecraft.server.v1_15_R1.Entity)entityLiving);
    }

    @Override
    public Object getTeleportPacket(Object object) {
        return new PacketPlayOutEntityTeleport((net.minecraft.server.v1_15_R1.Entity)object);
    }

    @Override
    public Object getEntityArmorStand(String string, Location location, double d, boolean bl) {
        return this.getEntityArmorStand(string, location, d, bl, false);
    }

    @Override
    public Object getEntityArmorStand(String string, Location location, double d, boolean bl, boolean bl2) {
        EntityArmorStand entityArmorStand = new EntityArmorStand((World)((CraftWorld)location.getWorld()).getHandle(), location.getX(), d, location.getZ());
        entityArmorStand.setLocation(location.getX(), d, location.getZ(), location.getYaw(), location.getPitch());
        entityArmorStand.setInvisible(bl);
        if (!string.equalsIgnoreCase("")) {
            entityArmorStand.setCustomNameVisible(true);
            try {
                entityArmorStand.setCustomName(CraftChatMessage.fromStringOrNull((String)Common.colorize(string)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        entityArmorStand.setNoGravity(true);
        entityArmorStand.setMarker(true);
        entityArmorStand.setArms(true);
        entityArmorStand.setBasePlate(false);
        entityArmorStand.setSmall(bl2);
        return entityArmorStand;
    }

    @Override
    public Object getEntityArmorStand(String string, Location location, double d) {
        return this.getEntityArmorStand(string, location, d, true);
    }

    @Override
    public void setInvisible(Object object, boolean bl) {
        ((EntityArmorStand)object).setInvisible(bl);
    }

    @Override
    public Object getEntityArmorStand(String string, Location location, boolean bl) {
        EntityArmorStand entityArmorStand = new EntityArmorStand((World)((CraftWorld)location.getWorld()).getHandle(), location.getX(), location.getY(), location.getZ());
        entityArmorStand.setLocation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        entityArmorStand.setInvisible(!bl);
        entityArmorStand.setSmall(bl);
        if (!string.equalsIgnoreCase("")) {
            entityArmorStand.setCustomNameVisible(true);
            try {
                entityArmorStand.setCustomName(CraftChatMessage.fromStringOrNull((String)Common.colorize(string)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        entityArmorStand.setNoGravity(true);
        entityArmorStand.setMarker(true);
        entityArmorStand.setArms(true);
        entityArmorStand.setBasePlate(false);
        return entityArmorStand;
    }

    @Override
    public LivingEntity getLivingEntity(Object object) {
        return (LivingEntity)((net.minecraft.server.v1_15_R1.Entity)object).getBukkitEntity();
    }

    @Override
    public Object getPacketEntityEquipmentHand(Object object, ItemStack itemStack) {
        return new PacketPlayOutEntityEquipment(((net.minecraft.server.v1_15_R1.Entity)object).getId(), EnumItemSlot.MAINHAND, CraftItemStack.asNMSCopy((ItemStack)itemStack));
    }

    @Override
    public void setRightArmPose(Object object, float f, float f2, float f3) {
        ((EntityArmorStand)object).setRightArmPose(new Vector3f(f, f2, f3));
    }

    @Override
    public void setLeftArmPose(Object object, float f, float f2, float f3) {
        ((EntityArmorStand)object).setLeftArmPose(new Vector3f(f, f2, f3));
    }

    @Override
    public void setRightLegPose(Object object, float f, float f2, float f3) {
        ((EntityArmorStand)object).setRightLegPose(new Vector3f(f, f2, f3));
    }

    @Override
    public void setLeftLegPose(Object object, float f, float f2, float f3) {
        ((EntityArmorStand)object).setLeftLegPose(new Vector3f(f, f2, f3));
    }

    @Override
    public void setBodyPose(Object object, float f, float f2, float f3) {
        ((EntityArmorStand)object).setBodyPose(new Vector3f(f, f2, f3));
    }

    @Override
    public void setHeadPose(Object object, float f, float f2, float f3) {
        ((EntityArmorStand)object).setHeadPose(new Vector3f(f, f2, f3));
    }

    @Override
    public Object getPacketEntityMetadata(Object object) {
        net.minecraft.server.v1_15_R1.Entity entity = (net.minecraft.server.v1_15_R1.Entity)object;
        return new PacketPlayOutEntityMetadata(entity.getId(), entity.getDataWatcher(), false);
    }

    @Override
    public void setCustomName(Object object, String string) {
        ((EntityArmorStand)object).setCustomName(CraftChatMessage.fromStringOrNull((String)Common.colorize(string)));
    }

    @Override
    public Object getLightningPacket(Location location) {
        EntityLightning entityLightning = new EntityLightning((World)((CraftWorld)location.getWorld()).getHandle(), location.getX(), location.getY(), location.getZ(), false, MonthlyCrate.isLightningSilent());
        return new PacketPlayOutSpawnEntity((net.minecraft.server.v1_15_R1.Entity)entityLightning, 1);
    }

    @Override
    public Object getPacketEntityEquipmentHead(Object object, ItemStack itemStack) {
        return new PacketPlayOutEntityEquipment(((EntityArmorStand)object).getId(), EnumItemSlot.HEAD, CraftItemStack.asNMSCopy((ItemStack)itemStack));
    }

    @Override
    public Object getPacketEntityEquipmentBody(Object object, ItemStack itemStack) {
        return new PacketPlayOutEntityEquipment(((EntityArmorStand)object).getId(), EnumItemSlot.CHEST, CraftItemStack.asNMSCopy((ItemStack)itemStack));
    }

    @Override
    public Object getPacketEntityEquipmentLegs(Object object, ItemStack itemStack) {
        return new PacketPlayOutEntityEquipment(((EntityArmorStand)object).getId(), EnumItemSlot.LEGS, CraftItemStack.asNMSCopy((ItemStack)itemStack));
    }

    @Override
    public Object getPacketEntityEquipmentBoots(Object object, ItemStack itemStack) {
        return new PacketPlayOutEntityEquipment(((EntityArmorStand)object).getId(), EnumItemSlot.FEET, CraftItemStack.asNMSCopy((ItemStack)itemStack));
    }

    @Override
    public Object getEntityGiant(Location location) {
        EntityGiantZombie entityGiantZombie = new EntityGiantZombie(EntityTypes.GIANT, (World)((CraftWorld)location.getWorld()).getHandle());
        entityGiantZombie.setLocation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        entityGiantZombie.setInvisible(true);
        entityGiantZombie.setInvulnerable(true);
        entityGiantZombie.setNoAI(true);
        entityGiantZombie.setNoGravity(true);
        entityGiantZombie.setSilent(true);
        return entityGiantZombie;
    }

    @Override
    public String getGiantUniqueID(Object object) {
        return ((EntityGiantZombie)object).getUniqueID().toString();
    }

    @Override
    public void setCustomNameVisible(Object object, boolean bl) {
        ((EntityArmorStand)object).setCustomNameVisible(bl);
    }

    @Override
    public Object getOpenEnderChestPacket(Location location) {
        return this.getOpenEnderChestPacket(location, true);
    }

    @Override
    public Object getOpenEnderChestPacket(Location location, boolean bl) {
        Block block = Block.asBlock((Item)Blocks.ENDER_CHEST.getItem());
        return new PacketPlayOutBlockAction(new BlockPosition(location.getX(), location.getY(), location.getZ()), block, 1, bl ? 1 : 0);
    }

    @Override
    public Object getOpenChestPacket(Location location) {
        return this.getOpenEnderChestPacket(location, true);
    }

    @Override
    public Object getOpenChestPacket(Location location, boolean bl) {
        Block block = Block.asBlock((Item)Blocks.CHEST.getItem());
        return new PacketPlayOutBlockAction(new BlockPosition(location.getX(), location.getY(), location.getZ()), block, 1, bl ? 1 : 0);
    }

    @Override
    public void teleport(Location location, Object object) {
        ((EntityArmorStand)object).setLocation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    @Override
    public void sendPlayerHeadTexturePacket(final Player player, final Location location) {
        final CraftWorld craftWorld = (CraftWorld)location.getWorld();
        if (this.tileEntityStorage.containsKey(location.toString())) {
            TileEntity tileEntity = this.tileEntityStorage.get(location.toString());
            TileEntitySkull tileEntitySkull = (TileEntitySkull)tileEntity;
            player.sendBlockChange(location, location.getBlock().getBlockData());
            this.sendPacket(player, tileEntitySkull.getUpdatePacket());
        } else {
            new BukkitRunnable(){

                public void run() {
                    TileEntity tileEntity = craftWorld.getHandle().getTileEntity(new BlockPosition(location.getX(), location.getY(), location.getZ()));
                    NMSHandler.this.tileEntityStorage.put(location.toString(), tileEntity);
                    TileEntitySkull tileEntitySkull = (TileEntitySkull)tileEntity;
                    player.sendBlockChange(location, location.getBlock().getBlockData());
                    NMSHandler.this.sendPacket(player, tileEntitySkull.getUpdatePacket());
                }
            }.runTask((Plugin)MonthlyCrate.getInstance());
        }
    }

    @Override
    public Object getEntityItem(Location location, ItemStack itemStack, boolean bl, boolean bl2) {
        EntityItem entityItem = new EntityItem((World)((CraftWorld)location.getWorld()).getHandle(), location.getX(), location.getY(), location.getZ());
        entityItem.setLocation(location.getX(), location.getY(), location.getZ(), 0.0f, 0.0f);
        entityItem.setItemStack(CraftItemStack.asNMSCopy((ItemStack)itemStack));
        if (bl2) {
            entityItem.setCustomNameVisible(true);
            entityItem.setCustomName(CraftChatMessage.fromStringOrNull((String)Common.colorize(itemStack.getItemMeta().getDisplayName())));
        }
        if (bl) {
            entityItem.setNoGravity(true);
        }
        return entityItem;
    }

    @Override
    public Object getItemSpawnPacket(Object object) {
        try {
            return new PacketPlayOutSpawnEntity((net.minecraft.server.v1_15_R1.Entity)((EntityItem)object));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public Object getItemDestroyPacket(Object object) {
        PacketPlayOutEntityDestroy packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{((EntityItem)object).getId()});
        return packetPlayOutEntityDestroy;
    }

    @Override
    public Object getItemVelocityPacket(Object object) {
        PacketPlayOutEntityVelocity packetPlayOutEntityVelocity = new PacketPlayOutEntityVelocity(((EntityItem)object).getId(), new Vec3D(ThreadLocalRandom.current().nextDouble(-0.12, 0.12), ThreadLocalRandom.current().nextDouble(0.17, 0.37), ThreadLocalRandom.current().nextDouble(-0.12, 0.12)));
        return packetPlayOutEntityVelocity;
    }

    @Override
    public Object getItemMetaDataPacket(Object object) {
        EntityItem entityItem = (EntityItem)object;
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = new PacketPlayOutEntityMetadata(entityItem.getId(), entityItem.getDataWatcher(), true);
        return packetPlayOutEntityMetadata;
    }

    @Override
    public void changeItemTypePacket(Object object, ItemStack itemStack) {
        ((EntityItem)object).setItemStack(CraftItemStack.asNMSCopy((ItemStack)itemStack));
    }

    @Override
    public void teleportItem(Location location, Object object) {
        ((EntityItem)object).setLocation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    @Override
    public void setShowHands(Object object, boolean bl) {
        ((EntityArmorStand)object).setArms(bl);
    }
}

