/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.HologramPackets.utils.reflect;

import me.PM2.HologramPackets.utils.reflect.ReflectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

public enum Version {
    v1_8_R1(8),
    v1_8_R2(8),
    v1_8_R3(8),
    v1_9_R1(9),
    v1_9_R2(9),
    v1_10_R1(10),
    v1_11_R1(11),
    v1_12_R1(12),
    v1_13_R1(13),
    v1_13_R2(13),
    v1_14_R1(14),
    v1_15_R1(15),
    v1_16_R1(16),
    v1_16_R2(16),
    v1_16_R3(16),
    v1_17_R1(17),
    v1_18_R1(18),
    v1_18_R2(18),
    v1_19_R1(19),
    v1_19_R2(19),
    v1_19_R3(19),
    v1_20_R1(20),
    v1_20_R2(20),
    v1_20_R3(20),
    v1_20_R4(20),
    v1_21_R1(21),
    v1_21_R2(21),
    v1_21_R3(21),
    v1_21_R4(21),
    v1_21_R5(21),
    v1_21_R6(21),
    v1_22_R1(22),
    v1_22_R2(22),
    v1_22_R3(22),
    v1_22_R4(22),
    v1_23_R1(23),
    v1_23_R2(23),
    v1_23_R3(23),
    v1_23_R4(23),
    v1_24_R1(24),
    v1_24_R2(24),
    v1_24_R3(24),
    v1_24_R4(24);

    public static final Version CURRENT;
    private final int minor;

    public static Version fromString(String string) {
        if (string == null) {
            return null;
        }
        for (Version version : Version.values()) {
            if (!version.name().equalsIgnoreCase(string)) continue;
            return version;
        }
        return null;
    }

    public static boolean is(int n) {
        return CURRENT.getMinor() == n;
    }

    public static boolean is(@NonNull Version version) {
        return CURRENT == version;
    }

    public static boolean after(int n) {
        return CURRENT.getMinor() > n;
    }

    public static boolean after(@NonNull Version version) {
        return CURRENT.ordinal() > version.ordinal();
    }

    public static boolean afterOrEqual(int n) {
        return CURRENT.getMinor() >= n;
    }

    public static boolean afterOrEqual(@NonNull Version version) {
        return CURRENT.ordinal() >= version.ordinal();
    }

    public static boolean before(int n) {
        return CURRENT.getMinor() < n;
    }

    public static boolean before(@NonNull Version version) {
        return CURRENT.ordinal() < version.ordinal();
    }

    public static boolean beforeOrEqual(int n) {
        return CURRENT.getMinor() <= n;
    }

    public static boolean beforeOrEqual(@NonNull Version version) {
        return CURRENT.ordinal() <= version.ordinal();
    }

    public static boolean supportsHex() {
        return Version.afterOrEqual(16);
    }

    private Version(int n2) {
        this.minor = n2;
    }

    public int getMinor() {
        return this.minor;
    }

    static {
        CURRENT = Version.fromString(ReflectionUtil.getVersion());
    }
}

