/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.HologramPackets.utils.reflect;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;

public class ReflectionUtil {
    private static final Map<Class<?>, Map<String, Field>> FIELD_CACHE = new ConcurrentHashMap();
    private static String version;

    public static <T> boolean setFieldValue(Object object, String string, T t) {
        Class<?> clazz = object.getClass();
        Field field = ReflectionUtil.getCachedField(clazz, string);
        if (field != null) {
            try {
                field.set(object, t);
                return true;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return false;
    }

    private static Field getCachedField(Class<?> clazz, String string) {
        Object object;
        Map<String, Field> map = FIELD_CACHE.get(clazz);
        if (map == null && (object = FIELD_CACHE.putIfAbsent(clazz, map = new ConcurrentHashMap<String, Field>())) != null) {
            map = object;
        }
        if ((object = map.get(string)) == null) {
            try {
                object = clazz.getDeclaredField(string);
                ((Field)object).setAccessible(true);
                map.put(string, (Field)object);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return object;
    }

    public static String getVersion() {
        if (version == null) {
            version = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        }
        return version;
    }

    public static Class<?> getClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
    }

    public static Class<?> getNMClass(String string) {
        try {
            return Class.forName("net.minecraft." + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
    }

    public static Class<?> getNMSClass(String string) {
        try {
            return Class.forName("net.minecraft.server." + ReflectionUtil.getVersion() + "." + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
    }

    public static Class<?> getObcClass(String string) {
        try {
            return Class.forName("org.bukkit.craftbukkit." + ReflectionUtil.getVersion() + "." + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
    }
}

