/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.HologramPackets.Main.runnable;

import java.util.concurrent.CompletableFuture;
import me.PM2.HologramPackets.EntityHitbox;
import me.PM2.HologramPackets.Main.NameTagAPI;
import me.PM2.HologramPackets.Main.cache.CacheManager;
import me.PM2.HologramPackets.Main.cache.LineCacheManager;
import me.PM2.HologramPackets.Main.cache.PacketUpdateTaskManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class PacketUpdateTask
implements Runnable {
    private final Player player;
    private final LivingEntity entityLiving;
    private final Entity entity;
    private BukkitTask task;
    private final double additionalY;
    private boolean active;

    public PacketUpdateTask(Player player, LivingEntity livingEntity, Entity entity) {
        this(player, livingEntity, entity, 0.0);
    }

    public PacketUpdateTask(Player player, LivingEntity livingEntity, Entity entity, double d) {
        this.player = player;
        this.entityLiving = livingEntity;
        this.entity = entity;
        this.additionalY = d;
        this.active = true;
        this.task = Bukkit.getScheduler().runTaskTimer((Plugin)NameTagAPI.getInstance(), (Runnable)this, 0L, 1L);
        PacketUpdateTaskManager.addEntry(livingEntity.getEntityId(), this);
    }

    @Override
    public void run() {
        if (this.entity.getLocation().getChunk().isLoaded()) {
            this.active = true;
        }
        if (!this.isActive()) {
            return;
        }
        if (!this.player.isOnline()) {
            CacheManager.removePlayerFromCache(this.player);
            LineCacheManager.removePlayerFromCache(this.player);
            this.clear();
            return;
        }
        if (this.entity.isDead() || this.entity == null) {
            this.removeEntityFromCache();
            this.clear();
            return;
        }
        if (!this.entity.getLocation().getChunk().isLoaded()) {
            this.removeEntityFromCache();
            this.clear();
            return;
        }
        Object object = NameTagAPI.getNMSHandler().getTeleportPacket(this.entityLiving);
        Location location = this.entity.getLocation();
        double d = location.getY() + EntityHitbox.getFromEntity(this.entity).getLocationModifier().getY() + this.additionalY;
        Location location2 = new Location(location.getWorld(), location.getX(), d, location.getZ(), location.getYaw(), location.getPitch());
        this.entityLiving.teleport(location2);
        NameTagAPI.getNMSHandler().sendPacket(this.player, object);
    }

    public void clear() {
        if (this.task != null) {
            Bukkit.getScheduler().cancelTask(this.task.getTaskId());
            this.task = null;
            this.active = false;
        }
    }

    public void removeEntityFromCache() {
        CompletableFuture.runAsync(() -> {
            Object object = NameTagAPI.getNMSHandler().getDestroyPacket(this.entityLiving);
            NameTagAPI.getNMSHandler().sendPacket(this.player, object);
        }).thenRun(() -> {
            CacheManager.removeEntityFromCache(this.entity);
            LineCacheManager.removeEntityFromCache(this.entity);
        });
    }

    public boolean isActive() {
        return this.active;
    }
}

