/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.HologramPackets.Main.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.PM2.HologramPackets.Main.cache.EntityIDCacheManager;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class LineCacheManager {
    private static final Map<Entity, Map<Player, List<LivingEntity>>> cache = new HashMap<Entity, Map<Player, List<LivingEntity>>>();

    public static Map<Entity, Map<Player, List<LivingEntity>>> getCache() {
        return cache;
    }

    public static Map<Player, List<LivingEntity>> getCachedMapByEntity(Entity entity) {
        return cache.get(entity);
    }

    public static List<LivingEntity> getLines(Entity entity, Player player) {
        Map<Player, List<LivingEntity>> map = cache.get(entity);
        if (map == null) {
            return null;
        }
        if (!map.containsKey(player)) {
            return null;
        }
        return map.get(player);
    }

    public static Player getPlayerByLines(Entity entity, List<LivingEntity> list) {
        Map<Player, List<LivingEntity>> map = LineCacheManager.getCachedMapByEntity(entity);
        for (Player player : map.keySet()) {
            if (!map.get(player).equals(list)) continue;
            return player;
        }
        return null;
    }

    public static Set<Player> getPlayersByEntity(Entity entity) {
        return new HashSet<Player>(LineCacheManager.getCachedMapByEntity(entity).keySet());
    }

    public static List<List<LivingEntity>> getAllLinesByPlayer(Player player) {
        ArrayList<List<LivingEntity>> arrayList = new ArrayList<List<LivingEntity>>();
        cache.keySet().forEach(entity -> {
            Map<Player, List<LivingEntity>> map = LineCacheManager.getCachedMapByEntity(entity);
            if (map.containsKey(player)) {
                arrayList.add(map.get(player));
            }
        });
        return arrayList;
    }

    public static void removeEntityFromCache(Entity entity) {
        if (EntityIDCacheManager.contains(entity.getEntityId())) {
            EntityIDCacheManager.removeEntry(entity.getEntityId());
        }
        cache.remove(entity);
    }

    public static void addEntry(Player player, Entity entity, LivingEntity livingEntity) {
        List<LivingEntity> list;
        Map<Player, List<LivingEntity>> map = LineCacheManager.getCachedMapByEntity(entity);
        if (map == null) {
            map = new HashMap<Player, List<LivingEntity>>();
        }
        if ((list = map.get(player)) == null) {
            list = new ArrayList<LivingEntity>();
        }
        if (!EntityIDCacheManager.contains(entity.getEntityId())) {
            EntityIDCacheManager.addEntry(entity.getEntityId());
        }
        list.add(livingEntity);
        map.put(player, list);
        cache.put(entity, map);
    }

    public static void removePlayerFromCache(Player player) {
        HashMap<Entity, Map<Player, List<LivingEntity>>> hashMap = new HashMap<Entity, Map<Player, List<LivingEntity>>>(LineCacheManager.getCache());
        hashMap.keySet().forEach(entity -> {
            Map<Player, List<LivingEntity>> map = LineCacheManager.getCachedMapByEntity(entity);
            if (map == null) {
                return;
            }
            if (!map.containsKey(player)) {
                return;
            }
            List<LivingEntity> list = map.get(player);
            list.forEach(livingEntity -> {
                if (EntityIDCacheManager.contains(livingEntity.getEntityId())) {
                    EntityIDCacheManager.removeEntry(livingEntity.getEntityId());
                }
            });
            map.remove(player);
            if (map.size() == 0) {
                LineCacheManager.removeEntityFromCache(entity);
                return;
            }
            cache.put((Entity)entity, map);
        });
    }

    public static void removeLine(Player player, Entity entity, int n) {
        Map<Player, List<LivingEntity>> map = LineCacheManager.getCachedMapByEntity(entity);
        if (!map.containsKey(player)) {
            return;
        }
        List<LivingEntity> list = map.get(player);
        if (list.size() < n) {
            return;
        }
        LivingEntity livingEntity = list.get(n);
        list.remove(livingEntity);
        map.put(player, list);
    }

    public static void removeLine(Player player, Entity entity, LivingEntity livingEntity) {
        Map<Player, List<LivingEntity>> map = cache.get(entity);
        if (map == null) {
            return;
        }
        List<LivingEntity> list = map.get(player);
        if (!list.contains(livingEntity)) {
            return;
        }
        int n = list.indexOf(livingEntity);
        LineCacheManager.removeLine(player, entity, n);
    }
}

