/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.HologramPackets.Main.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.PM2.HologramPackets.Main.cache.EntityIDCacheManager;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class CacheManager {
    private static final Map<Entity, Map<Player, LivingEntity>> cache = new HashMap<Entity, Map<Player, LivingEntity>>();

    public static Map<Entity, Map<Player, LivingEntity>> getCache() {
        return cache;
    }

    public static Map<Player, LivingEntity> getCachedMapByEntity(Entity entity) {
        return cache.get(entity);
    }

    public static LivingEntity getArmorStand(Player player, Entity entity) {
        Map<Player, LivingEntity> map = cache.get(entity);
        if (map == null) {
            return null;
        }
        if (!map.containsKey(player)) {
            return null;
        }
        return map.get(player);
    }

    public static Player getPlayerByArmorStand(Entity entity, LivingEntity livingEntity) {
        Map<Player, LivingEntity> map = CacheManager.getCachedMapByEntity(entity);
        for (Player player : map.keySet()) {
            if (!map.get(player).equals((Object)livingEntity)) continue;
            return player;
        }
        return null;
    }

    public static Set<Player> getPlayersByEntity(Entity entity) {
        return new HashSet<Player>(CacheManager.getCachedMapByEntity(entity).keySet());
    }

    public static Set<LivingEntity> getAllArmorStandsByPlayer(Player player) {
        HashSet<LivingEntity> hashSet = new HashSet<LivingEntity>();
        cache.keySet().forEach(entity -> {
            Map<Player, LivingEntity> map = CacheManager.getCachedMapByEntity(entity);
            if (map.containsKey(player)) {
                hashSet.add(map.get(player));
            }
        });
        return hashSet;
    }

    public static void removeEntityFromCache(Entity entity) {
        if (EntityIDCacheManager.contains(entity.getEntityId())) {
            EntityIDCacheManager.removeEntry(entity.getEntityId());
        }
        cache.remove(entity);
    }

    public static void addEntry(Player player, Entity entity, LivingEntity livingEntity) {
        Map<Player, LivingEntity> map = CacheManager.getCachedMapByEntity(entity);
        if (map == null) {
            map = new HashMap<Player, LivingEntity>();
        }
        if (!EntityIDCacheManager.contains(entity.getEntityId())) {
            EntityIDCacheManager.addEntry(entity.getEntityId());
        }
        map.put(player, livingEntity);
        cache.put(entity, map);
    }

    public static void removePlayerFromCache(Player player) {
        HashMap<Entity, Map<Player, LivingEntity>> hashMap = new HashMap<Entity, Map<Player, LivingEntity>>(CacheManager.getCache());
        hashMap.keySet().forEach(entity -> {
            Map<Player, LivingEntity> map = CacheManager.getCachedMapByEntity(entity);
            if (map == null) {
                return;
            }
            if (!map.containsKey(player)) {
                return;
            }
            map.remove(player);
            if (map.size() == 0) {
                CacheManager.removeEntityFromCache(entity);
                return;
            }
            cache.put((Entity)entity, map);
        });
    }

    public static void removeArmorStandFromCache(Entity entity, Player player) {
        Map<Player, LivingEntity> map = CacheManager.getCachedMapByEntity(entity);
        if (!map.containsKey(player)) {
            return;
        }
        map.remove(player);
        cache.put(entity, map);
    }

    public static boolean hasNameTag(Entity entity) {
        return cache.containsKey(entity);
    }
}

