/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.HologramPackets;

import de.tr7zw.advancedcrates.nbtapi.utils.MinecraftVersion;
import java.util.Arrays;
import java.util.Optional;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.util.Vector;

public enum EntityHitbox {
    ZOMBIE(EntityType.ZOMBIE, -0.1, 0.0, 0.0),
    CREEPER(EntityType.CREEPER, -0.5, 0.0, 0.0),
    SKELETON(EntityType.SKELETON, -0.15, 0.0, 0.0),
    SPIDER(EntityType.SPIDER, -1.25, 0.0, 0.0),
    SLIME(EntityType.SLIME, 0.0, 0.0, 0.0),
    GHAST(EntityType.GHAST, 2.5, 0.0, 0.0),
    ENDERMAN(EntityType.ENDERMAN, 0.6, 0.0, 0.0),
    CAVE_SPIDER(EntityType.CAVE_SPIDER, -1.5, 0.0, 0.0),
    SILVERFISH(EntityType.SILVERFISH, -1.875, 0.0, 0.0),
    BLAZE(EntityType.BLAZE, -0.35, 0.0, 0.0),
    MAGMA_CUBE(EntityType.MAGMA_CUBE, 0.0, 0.0, 0.0),
    BAT(EntityType.BAT, -1.65, 0.0, 0.0),
    WITCH(EntityType.WITCH, 0.25, 0.0, 0.0),
    ENDERMITE(EntityType.ENDERMITE, -1.875, 0.0, 0.0),
    GUARDIAN(EntityType.GUARDIAN, -1.1, 0.0, 0.0),
    PIG(EntityType.PIG, -1.25, 0.0, 0.0),
    SHEEP(EntityType.SHEEP, -0.85, 0.0, 0.0),
    COW(EntityType.COW, -0.75, 0.0, 0.0),
    CHICKEN(EntityType.CHICKEN, -1.3, 0.0, 0.0),
    SQUID(EntityType.SQUID, -1.25, 0.0, 0.0),
    WOLF(EntityType.WOLF, -1.25, 0.0, 0.0),
    OCELOT(EntityType.OCELOT, -1.4, 0.0, 0.0),
    HORSE(EntityType.HORSE, -0.5, 0.0, 0.0),
    RABBIT(EntityType.RABBIT, -1.25, 0.0, 0.0),
    VILLAGER(EntityType.VILLAGER, -0.15, 0.0, 0.0),
    WITHER_BOSS(EntityType.WITHER, 1.425, 0.0, 0.0),
    ENDER_DRAGON(EntityType.ENDER_DRAGON, 1.35, 0.0, 0.0),
    ENTITY_PLAYER(EntityType.PLAYER, 0.075, 0.0, 0.0),
    ENTITY_ITEM(MinecraftVersion.isOlderOrEqualThanVersion(MinecraftVersion.MC1_20_R3) ? EntityType.valueOf((String)"DROPPED_ITEM") : EntityType.valueOf((String)"ITEM"), -1.65, 0.0, 0.0);

    private EntityType entityType;
    private double height;
    private double offsetX;
    private double offsetZ;

    private EntityHitbox(EntityType entityType, double d, double d2, double d3) {
        this.entityType = entityType;
        this.height = d;
        this.offsetX = d2;
        this.offsetZ = d3;
    }

    public Vector getLocationModifier() {
        return new Vector(this.getOffsetX(), this.getHeight() + 1.9, this.getOffsetZ());
    }

    protected double getHeight() {
        return this.height;
    }

    protected double getOffsetX() {
        return this.offsetX;
    }

    protected double getOffsetZ() {
        return this.offsetZ;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public static EntityHitbox getFromEntity(Entity entity) {
        EntityType entityType = entity.getType();
        Optional<EntityHitbox> optional = Arrays.stream(EntityHitbox.values()).filter(entityHitbox -> entityHitbox.getEntityType().equals((Object)entityType)).findFirst();
        return optional.orElse(ZOMBIE);
    }

    public static boolean exists(Entity entity) {
        EntityType entityType = entity.getType();
        Optional<EntityHitbox> optional = Arrays.stream(EntityHitbox.values()).filter(entityHitbox -> entityHitbox.getEntityType().equals((Object)entityType)).findFirst();
        return optional.isPresent();
    }
}

