/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.utils;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.SkullType;
import org.bukkit.block.Block;
import org.bukkit.block.Skull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.Nullable;

public class SkullCreator {
    private static boolean warningPosted = false;
    private static Field blockProfileField;
    private static Method metaSetProfileMethod;
    private static Field metaProfileField;
    private static final boolean HAS_PLAYER_PROFILE_API;
    private static final boolean USES_RESOLVABLE_PROFILE;
    private static Method createPlayerProfileMethod;
    private static Method getTexturesMethod;
    private static Method setSkinMethod;
    private static Method setTexturesMethod;
    private static Method setOwnerProfileMethod;
    private static Class<?> playerProfileClass;
    private static Class<?> playerTexturesClass;

    private SkullCreator() {
    }

    public static ItemStack createSkull() {
        SkullCreator.checkLegacy();
        try {
            return new ItemStack(Material.valueOf((String)"PLAYER_HEAD"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new ItemStack(Material.valueOf((String)"SKULL_ITEM"), 1, 3);
        }
    }

    @Deprecated
    public static ItemStack itemFromName(String string) {
        return SkullCreator.itemWithName(SkullCreator.createSkull(), string);
    }

    public static ItemStack itemFromUuid(UUID uUID) {
        return SkullCreator.itemWithUuid(SkullCreator.createSkull(), uUID);
    }

    public static ItemStack itemFromUrl(String string) {
        return SkullCreator.itemWithUrl(SkullCreator.createSkull(), string);
    }

    public static ItemStack itemFromBase64(String string) {
        return SkullCreator.itemWithBase64(SkullCreator.createSkull(), string);
    }

    @Deprecated
    public static ItemStack itemWithName(ItemStack itemStack, String string) {
        SkullCreator.notNull(itemStack, "item");
        SkullCreator.notNull(string, "name");
        SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
        skullMeta.setOwner(string);
        itemStack.setItemMeta((ItemMeta)skullMeta);
        return itemStack;
    }

    public static ItemStack itemWithUuid(ItemStack itemStack, UUID uUID) {
        SkullCreator.notNull(itemStack, "item");
        SkullCreator.notNull(uUID, "id");
        SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
        skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)uUID));
        itemStack.setItemMeta((ItemMeta)skullMeta);
        return itemStack;
    }

    public static ItemStack itemWithUrl(ItemStack itemStack, String string) {
        SkullCreator.notNull(itemStack, "item");
        SkullCreator.notNull(string, "url");
        return SkullCreator.itemWithBase64(itemStack, SkullCreator.urlToBase64(string));
    }

    public static ItemStack itemWithBase64(ItemStack itemStack, String string) {
        SkullCreator.notNull(itemStack, "item");
        SkullCreator.notNull(string, "base64");
        if (!(itemStack.getItemMeta() instanceof SkullMeta)) {
            return null;
        }
        SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
        SkullCreator.mutateItemMeta(skullMeta, string);
        itemStack.setItemMeta((ItemMeta)skullMeta);
        return itemStack;
    }

    @Deprecated
    public static void blockWithName(Block block, String string) {
        SkullCreator.notNull(block, "block");
        SkullCreator.notNull(string, "name");
        Skull skull = (Skull)block.getState();
        skull.setOwningPlayer(Bukkit.getOfflinePlayer((String)string));
        skull.update(false, false);
    }

    public static void blockWithUuid(Block block, UUID uUID) {
        SkullCreator.notNull(block, "block");
        SkullCreator.notNull(uUID, "id");
        SkullCreator.setToSkull(block);
        Skull skull = (Skull)block.getState();
        skull.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)uUID));
        skull.update(false, false);
    }

    public static void blockWithUrl(Block block, String string) {
        SkullCreator.notNull(block, "block");
        SkullCreator.notNull(string, "url");
        SkullCreator.blockWithBase64(block, SkullCreator.urlToBase64(string));
    }

    public static void blockWithBase64(Block block, String string) {
        SkullCreator.notNull(block, "block");
        SkullCreator.notNull(string, "base64");
        SkullCreator.setToSkull(block);
        Skull skull = (Skull)block.getState();
        SkullCreator.mutateBlockState(skull, string);
        skull.update(false, false);
    }

    private static void setToSkull(Block block) {
        SkullCreator.checkLegacy();
        try {
            block.setType(Material.valueOf((String)"PLAYER_HEAD"), false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            block.setType(Material.valueOf((String)"SKULL"), false);
            Skull skull = (Skull)block.getState();
            skull.setSkullType(SkullType.PLAYER);
            skull.update(false, false);
        }
    }

    private static void notNull(Object object, String string) {
        if (object == null) {
            throw new NullPointerException(string + " should not be null!");
        }
    }

    private static String urlToBase64(String string) {
        URI uRI;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
        String string2 = "{\"textures\":{\"SKIN\":{\"url\":\"" + uRI + "\"}}}";
        return Base64.getEncoder().encodeToString(string2.getBytes(StandardCharsets.UTF_8));
    }

    private static GameProfile makeProfileSafe(String string) {
        UUID uUID = UUID.nameUUIDFromBytes(("skull:" + string).getBytes(StandardCharsets.UTF_8));
        GameProfile gameProfile = new GameProfile(uUID, "Player");
        try {
            Method method;
            Object object = null;
            try {
                method = GameProfile.class.getMethod("getProperties", new Class[0]);
                object = method.invoke((Object)gameProfile, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    Method[] methodArray = GameProfile.class.getMethod("properties", new Class[0]);
                    object = methodArray.invoke((Object)gameProfile, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    try {
                        Field field = GameProfile.class.getDeclaredField("properties");
                        field.setAccessible(true);
                        object = field.get(gameProfile);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        for (Field field : GameProfile.class.getDeclaredFields()) {
                            if (!Map.class.isAssignableFrom(field.getType())) continue;
                            field.setAccessible(true);
                            object = field.get(gameProfile);
                            break;
                        }
                    }
                }
            }
            if (object != null) {
                method = null;
                for (Method method2 : object.getClass().getMethods()) {
                    if (!method2.getName().equals("put") || method2.getParameterCount() != 2) continue;
                    method = method2;
                    break;
                }
                if (method != null) {
                    method.invoke(object, "textures", new Property("textures", string));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return gameProfile;
    }

    @Nullable
    private static URL skinUrlFromBase64(String string) {
        try {
            String string2 = new String(Base64.getDecoder().decode(string), StandardCharsets.UTF_8);
            int n = string2.indexOf("\"SKIN\"");
            if (n < 0) {
                return null;
            }
            int n2 = string2.indexOf("\"url\"", n);
            if (n2 < 0) {
                return null;
            }
            int n3 = string2.indexOf(58, n2);
            if (n3 < 0) {
                return null;
            }
            int n4 = string2.indexOf(34, n3 + 1);
            int n5 = string2.indexOf(34, n4 + 1);
            if (n4 < 0 || n5 < 0) {
                return null;
            }
            String string3 = string2.substring(n4 + 1, n5);
            if (string3.startsWith("http://textures.minecraft.net")) {
                string3 = string3.replace("http://", "https://");
            }
            return new URL(string3);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Nullable
    public static String getBase64(SkullMeta skullMeta) {
        try {
            Object object;
            AccessibleObject accessibleObject;
            if (HAS_PLAYER_PROFILE_API) {
                try {
                    Method method;
                    URL uRL;
                    Object object2;
                    accessibleObject = skullMeta.getClass().getMethod("getOwnerProfile", new Class[0]);
                    object = ((Method)accessibleObject).invoke(skullMeta, new Object[0]);
                    if (object != null && (object2 = getTexturesMethod.invoke(object, new Object[0])) != null && (uRL = (URL)(method = playerTexturesClass.getMethod("getSkin", new Class[0])).invoke(object2, new Object[0])) != null) {
                        String string = "{\"textures\":{\"SKIN\":{\"url\":\"" + uRL.toString() + "\"}}}";
                        return Base64.getEncoder().encodeToString(string.getBytes(StandardCharsets.UTF_8));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if ((accessibleObject = SkullCreator.findProfileField(skullMeta.getClass())) == null) {
                return null;
            }
            object = ((Field)accessibleObject).get(skullMeta);
            if (object == null) {
                return null;
            }
            if ((object = SkullCreator.unwrapResolvableProfile(object)) == null) {
                return null;
            }
            if (object instanceof GameProfile) {
                return SkullCreator.extractBase64FromGameProfile((GameProfile)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Field findProfileField(Class<?> clazz) {
        try {
            Field field = clazz.getDeclaredField("profile");
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            for (Field field : clazz.getDeclaredFields()) {
                String string = field.getType().getName();
                if (!string.equals("com.mojang.authlib.GameProfile") && !string.equals("net.minecraft.world.item.component.ResolvableProfile")) continue;
                field.setAccessible(true);
                return field;
            }
            return null;
        }
    }

    private static Object unwrapResolvableProfile(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof GameProfile) {
            return object;
        }
        String string = object.getClass().getName();
        if (!string.equals("net.minecraft.world.item.component.ResolvableProfile")) {
            return object;
        }
        try {
            try {
                Method method = object.getClass().getMethod("gameProfile", new Class[0]);
                return method.invoke(object, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                for (Field field : object.getClass().getDeclaredFields()) {
                    if (!field.getType().getName().equals("com.mojang.authlib.GameProfile")) continue;
                    field.setAccessible(true);
                    return field.get(object);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static String extractBase64FromGameProfile(GameProfile gameProfile) {
        try {
            Object object;
            Method method;
            Object object2 = null;
            try {
                method = GameProfile.class.getMethod("getProperties", new Class[0]);
                object2 = method.invoke((Object)gameProfile, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    object = GameProfile.class.getMethod("properties", new Class[0]);
                    object2 = ((Method)object).invoke((Object)gameProfile, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    try {
                        Field field = GameProfile.class.getDeclaredField("properties");
                        field.setAccessible(true);
                        object2 = field.get(gameProfile);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                }
            }
            if (object2 != null) {
                method = object2.getClass().getMethod("get", Object.class);
                object = method.invoke(object2, "textures");
                if (object instanceof Iterable) {
                    for (Object e : (Iterable)object) {
                        Object object3;
                        try {
                            Method method2 = e.getClass().getMethod("getValue", new Class[0]);
                            object3 = method2.invoke(e, new Object[0]);
                            if (!(object3 instanceof String)) continue;
                            return (String)object3;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            try {
                                object3 = e.getClass().getMethod("value", new Class[0]);
                                Object object4 = ((Method)object3).invoke(e, new Object[0]);
                                if (!(object4 instanceof String)) continue;
                                return (String)object4;
                            }
                            catch (Throwable throwable) {
                            }
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static void mutateBlockState(Skull skull, String string) {
        URL uRL;
        if (HAS_PLAYER_PROFILE_API) {
            try {
                uRL = SkullCreator.skinUrlFromBase64(string);
                if (uRL != null && SkullCreator.applyProfileViaApi(skull, string, uRL)) {
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            if (blockProfileField == null) {
                blockProfileField = SkullCreator.findProfileField(skull.getClass());
            }
            if (blockProfileField != null) {
                uRL = SkullCreator.makeProfileSafe(string);
                Object object = SkullCreator.wrapForField((GameProfile)uRL, blockProfileField);
                blockProfileField.set(skull, object);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static boolean applyProfileViaApi(Skull skull, String string, URL uRL) {
        try {
            UUID uUID = UUID.nameUUIDFromBytes(string.getBytes(StandardCharsets.UTF_8));
            Object object = createPlayerProfileMethod.invoke(null, uUID, "Player");
            Object object2 = getTexturesMethod.invoke(object, new Object[0]);
            setSkinMethod.invoke(object2, uRL);
            setTexturesMethod.invoke(object, object2);
            try {
                Method method = skull.getClass().getMethod("setOwnerProfile", playerProfileClass);
                method.invoke((Object)skull, object);
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    Method method = skull.getClass().getMethod("setPlayerProfile", playerProfileClass);
                    method.invoke((Object)skull, object);
                    return true;
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static void mutateItemMeta(SkullMeta skullMeta, String string) {
        GameProfile gameProfile;
        if (HAS_PLAYER_PROFILE_API) {
            try {
                gameProfile = SkullCreator.skinUrlFromBase64(string);
                if (gameProfile != null) {
                    UUID uUID = UUID.nameUUIDFromBytes(string.getBytes(StandardCharsets.UTF_8));
                    Object object = createPlayerProfileMethod.invoke(null, uUID, "Player");
                    Object object2 = getTexturesMethod.invoke(object, new Object[0]);
                    setSkinMethod.invoke(object2, gameProfile);
                    setTexturesMethod.invoke(object, object2);
                    setOwnerProfileMethod.invoke((Object)skullMeta, object);
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            if (metaSetProfileMethod == null) {
                for (GameProfile gameProfile2 : skullMeta.getClass().getDeclaredMethods()) {
                    if (!gameProfile2.getName().equals("setProfile") || gameProfile2.getParameterCount() != 1) continue;
                    gameProfile2.setAccessible(true);
                    metaSetProfileMethod = gameProfile2;
                    break;
                }
            }
            if (metaSetProfileMethod != null) {
                gameProfile = SkullCreator.makeProfileSafe(string);
                Class<?> clazz = metaSetProfileMethod.getParameterTypes()[0];
                Object object = SkullCreator.wrapGameProfileIfNeeded(gameProfile, clazz);
                metaSetProfileMethod.invoke((Object)skullMeta, object);
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (metaProfileField == null) {
                metaProfileField = SkullCreator.findProfileField(skullMeta.getClass());
            }
            if (metaProfileField != null) {
                gameProfile = SkullCreator.makeProfileSafe(string);
                Object object = SkullCreator.wrapForField(gameProfile, metaProfileField);
                metaProfileField.set(skullMeta, object);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Object wrapForField(GameProfile gameProfile, Field field) {
        String string = field.getType().getName();
        if (string.equals("net.minecraft.world.item.component.ResolvableProfile")) {
            return SkullCreator.makeResolvableProfile(gameProfile);
        }
        return gameProfile;
    }

    private static Object wrapGameProfileIfNeeded(GameProfile gameProfile, Class<?> clazz) {
        if (clazz.getName().equals("net.minecraft.world.item.component.ResolvableProfile")) {
            return SkullCreator.makeResolvableProfile(gameProfile);
        }
        return gameProfile;
    }

    private static Object makeResolvableProfile(GameProfile gameProfile) {
        Class<?>[] classArray;
        Class<?> clazz = Class.forName("net.minecraft.world.item.component.ResolvableProfile");
        for (Constructor<?> executable : clazz.getDeclaredConstructors()) {
            classArray = executable.getParameterTypes();
            if (classArray.length != 1 || !classArray[0].getName().equals("com.mojang.authlib.GameProfile")) continue;
            executable.setAccessible(true);
            return executable.newInstance(gameProfile);
        }
        for (Executable executable : clazz.getDeclaredMethods()) {
            if (!Modifier.isStatic(((Method)executable).getModifiers()) || (classArray = ((Method)executable).getParameterTypes()).length != 1 || !classArray[0].getName().equals("com.mojang.authlib.GameProfile")) continue;
            ((Method)executable).setAccessible(true);
            return ((Method)executable).invoke(null, gameProfile);
        }
        try {
            Method method = GameProfile.class.getMethod("getProperties", new Class[0]);
            Object object = method.invoke((Object)gameProfile, new Object[0]);
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                Class<?>[] classArray2 = constructor.getParameterTypes();
                if (classArray2.length != 3 || !classArray2[0].equals(Optional.class) || !classArray2[1].equals(Optional.class)) continue;
                constructor.setAccessible(true);
                return constructor.newInstance(Optional.ofNullable(gameProfile.getId()), Optional.ofNullable(gameProfile.getName()), object);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new IllegalStateException("Could not create ResolvableProfile for this server version");
    }

    private static void checkLegacy() {
        try {
            Material.class.getDeclaredField("PLAYER_HEAD");
            Material.valueOf((String)"SKULL");
            if (!warningPosted) {
                Bukkit.getLogger().warning("SKULLCREATOR API - Using the legacy bukkit API with 1.13+ bukkit versions is not supported!");
                warningPosted = true;
            }
        }
        catch (IllegalArgumentException | NoSuchFieldException exception) {
            // empty catch block
        }
    }

    public static SkullMeta mutateSkullMeta(SkullMeta skullMeta, String string) {
        if (skullMeta == null || string == null || string.isEmpty()) {
            return skullMeta;
        }
        SkullCreator.mutateItemMeta(skullMeta, string);
        return skullMeta;
    }

    static {
        boolean bl = false;
        try {
            Class.forName("net.minecraft.world.item.component.ResolvableProfile");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        USES_RESOLVABLE_PROFILE = bl;
        boolean bl2 = false;
        try {
            playerProfileClass = Class.forName("org.bukkit.profile.PlayerProfile");
            playerTexturesClass = Class.forName("org.bukkit.profile.PlayerTextures");
            createPlayerProfileMethod = Bukkit.class.getMethod("createPlayerProfile", UUID.class, String.class);
            getTexturesMethod = playerProfileClass.getMethod("getTextures", new Class[0]);
            setTexturesMethod = playerProfileClass.getMethod("setTextures", playerTexturesClass);
            setSkinMethod = playerTexturesClass.getMethod("setSkin", URL.class);
            try {
                setOwnerProfileMethod = SkullMeta.class.getMethod("setOwnerProfile", playerProfileClass);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    setOwnerProfileMethod = SkullMeta.class.getMethod("setPlayerProfile", playerProfileClass);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    // empty catch block
                }
            }
            bl2 = setOwnerProfileMethod != null;
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        HAS_PLAYER_PROFILE_API = bl2;
    }
}

