/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.utils;

import de.tr7zw.advancedcrates.nbtapi.utils.MinecraftVersion;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.bukkit.entity.Player;

public final class ReflectionUtils {
    public static final String VERSION = MinecraftVersion.getVersion().getPackageName();
    public static final int VER = Integer.parseInt(VERSION.substring(1).split("_")[1]);
    public static final String CRAFTBUKKIT = "org.bukkit.craftbukkit." + VERSION + '.';
    public static final String NMS = MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_17_R1) ? "net.minecraft." : "net.minecraft.server." + VERSION + '.';
    private static final MethodHandle PLAYER_CONNECTION;
    private static final MethodHandle GET_HANDLE;
    private static final MethodHandle SEND_PACKET;

    private ReflectionUtils() {
    }

    public static boolean supports(int n) {
        return VER >= n;
    }

    public static Class<?> getNMSClass(@Nonnull String string, @Nonnull String string2) {
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_17_R1)) {
            string2 = string + '.' + string2;
        }
        return ReflectionUtils.getNMSClass(string2);
    }

    public static Class<?> getNMSClass(@Nonnull String string) {
        try {
            return Class.forName(NMS + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
    }

    @Nonnull
    public static CompletableFuture<Void> sendPacket(@Nonnull Player player, Object ... objectArray) {
        return CompletableFuture.runAsync(() -> ReflectionUtils.sendPacketSync(player, objectArray)).exceptionally(throwable -> {
            throwable.printStackTrace();
            return null;
        });
    }

    public static void sendPacketSync(@Nonnull Player player, Object ... objectArray) {
        try {
            Object object = GET_HANDLE.invoke(player);
            Object object2 = PLAYER_CONNECTION.invoke(object);
            if (object2 != null) {
                for (Object object3 : objectArray) {
                    SEND_PACKET.invoke(object2, object3);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static Object getHandle(@Nonnull Player player) {
        Objects.requireNonNull(player, "Cannot get handle of null player");
        try {
            return GET_HANDLE.invoke(player);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static Object getConnection(@Nonnull Player player) {
        Objects.requireNonNull(player, "Cannot get connection of null player");
        try {
            Object object = GET_HANDLE.invoke(player);
            return PLAYER_CONNECTION.invoke(object);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static Class<?> getCraftClass(@Nonnull String string) {
        try {
            return Class.forName(CRAFTBUKKIT + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
    }

    static {
        Class<?> clazz = ReflectionUtils.getNMSClass("server.level", "EntityPlayer");
        Class<?> clazz2 = ReflectionUtils.getCraftClass("entity.CraftPlayer");
        Class<?> clazz3 = ReflectionUtils.getNMSClass("server.network", "PlayerConnection");
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        PLAYER_CONNECTION = var6_6;
        SEND_PACKET = var4_4;
        GET_HANDLE = var5_5;
    }
}

