/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.utils;

import java.util.Iterator;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.displayType.IdentifierTrait;
import me.PM2.AdvancedCrates.utils.LocationUtils;
import me.PM2.AdvancedCrates.utils.Utils;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.trait.TraitInfo;
import net.citizensnpcs.trait.LookClose;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public class NPCUtils {
    private static final boolean DISABLED_MOB_RELOAD = true;
    private static boolean failedLoad = false;

    private NPCUtils() {
    }

    public static void checkUncheckMobs(boolean bl) {
    }

    public static void checkUncheckMobs(MonthlyCrate monthlyCrate, boolean bl, long l) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)monthlyCrate, () -> NPCUtils.checkUncheckMobs(bl), l);
    }

    public static NPC getNpcForCrate(Location location) {
        if (!NPCUtils.isCitizensInstalled()) {
            return null;
        }
        for (NPCRegistry nPCRegistry : CitizensAPI.getNPCRegistries()) {
            Iterator iterator = nPCRegistry.iterator();
            for (NPC nPC : Utils.iteratorToList(iterator)) {
                if (!nPC.isSpawned() || !nPC.getName().equalsIgnoreCase("AdvancedCrates - Crate")) continue;
                Location location2 = nPC.getStoredLocation();
                Location location3 = LocationUtils.getLocationCentered(location);
                if (!(Math.abs(location2.getX() - location3.getX()) < 0.3) || !(Math.abs(location2.getY() - location3.getY()) < 2.0) || !(Math.abs(location2.getZ() - location3.getZ()) < 0.3) || location2.getWorld() != location3.getWorld()) continue;
                return nPC;
            }
        }
        return null;
    }

    public static boolean npcExists(Location location) {
        return NPCUtils.getNpcForCrate(location) != null;
    }

    public static void applyDefaultInfo(NPC nPC) {
        ((LookClose)nPC.getTrait(LookClose.class)).toggle();
        nPC.data().remove("ambient-sound");
        nPC.data().set("silent-sounds", (Object)true);
        nPC.data().set("protected", (Object)true);
        nPC.data().setPersistent("nameplate-visible", (Object)false);
    }

    public static boolean isCitizensInstalled() {
        return Utils.isPLInstalled("Citizens") && !failedLoad;
    }

    public static void load(boolean bl) {
        try {
            if (bl && NPCUtils.isCitizensInstalled()) {
                CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(IdentifierTrait.class).withName("isCrate"));
            }
        }
        catch (Exception exception) {
            failedLoad = true;
            System.out.println("ERROR: FAILED TO ESTABLISH LINK WITH CITIZENS, DISABLING CITIZENS FEATURES");
        }
    }
}

