/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.playerHandler.PlayerData;
import me.PM2.AdvancedCrates.utils.PlaceHolderAPIHandler;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.craftbukkit.libs.org.apache.commons.lang3.reflect.FieldUtils;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;

public class Common {
    public static final char COLOR_CHAR = '\u00a7';

    public static void tell(CommandSender commandSender, String string) {
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            PlayerData playerData = MonthlyCrate.getInstance().getPlayerDataManager().getPlayerData(player.getUniqueId().toString());
            if (playerData.isDisabledMessages()) {
                return;
            }
        }
        commandSender.sendMessage(Common.colorize(string));
    }

    public static String getPlayerDirection(Player player) {
        float f = player.getLocation().getYaw();
        if (f < 0.0f) {
            f += 360.0f;
        }
        if (f >= 315.0f || f < 45.0f) {
            return "SOUTH";
        }
        if (f < 135.0f) {
            return "WEST";
        }
        if (f < 225.0f) {
            return "NORTH";
        }
        if (f < 315.0f) {
            return "EAST";
        }
        return "NORTH";
    }

    public static String colorize(String string) {
        if (MonthlyCrate.isUsingPAPI) {
            try {
                string = PlaceHolderAPIHandler.setPlaceHolders(Bukkit.getOnlinePlayers().stream().findFirst().orElse(null), string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        string = Common.translateHexColorCodes("#", "", string);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public static String colorizePAPIPlayer(String string, Player player) {
        if (MonthlyCrate.isUsingPAPI) {
            try {
                string = PlaceHolderAPIHandler.setPlaceHolders(player, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        string = Common.translateHexColorCodes("#", "", string);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public static String translateHexColorCodes(String string, String string2, String string3) {
        if (string3 == null || string3.isEmpty()) {
            return "";
        }
        Pattern pattern = Pattern.compile(string + "([A-Fa-f0-9]{6})" + string2);
        Matcher matcher = pattern.matcher(string3);
        StringBuffer stringBuffer = new StringBuffer(string3.length() + 32);
        while (matcher.find()) {
            String string4 = matcher.group(1);
            matcher.appendReplacement(stringBuffer, "\u00a7x\u00a7" + string4.charAt(0) + '\u00a7' + string4.charAt(1) + '\u00a7' + string4.charAt(2) + '\u00a7' + string4.charAt(3) + '\u00a7' + string4.charAt(4) + '\u00a7' + string4.charAt(5));
        }
        return matcher.appendTail(stringBuffer).toString();
    }

    public static List<String> colorizeList(List<String> list) {
        int n = list.size();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(Common.colorize(list.get(i)));
        }
        return arrayList;
    }

    public static String removeColors(String string) {
        return ChatColor.stripColor((String)string);
    }

    public static void registerCommand(Command command) {
        try {
            Field field = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            field.setAccessible(true);
            CommandMap commandMap = (CommandMap)field.get(Bukkit.getServer());
            commandMap.register(command.getLabel(), command);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static PluginCommand createPluginCommand(@Nonnull String string) {
        try {
            Constructor constructor = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
            constructor.setAccessible(true);
            return (PluginCommand)constructor.newInstance(new Object[]{string, MonthlyCrate.getInstance()});
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
            return null;
        }
    }

    public static CommandMap getCommandMapInstance() {
        if (Bukkit.getPluginManager() instanceof SimplePluginManager) {
            SimplePluginManager simplePluginManager = (SimplePluginManager)Bukkit.getPluginManager();
            try {
                Field field = FieldUtils.getDeclaredField(simplePluginManager.getClass(), (String)"commandMap", (boolean)true);
                CommandMap commandMap = (CommandMap)field.get(simplePluginManager);
                return commandMap;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("Can't get the Bukkit CommandMap instance.");
            }
        }
        return null;
    }
}

