/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.utils;

import me.PM2.AdvancedCrates.utils.Utils;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;

public class ArmorStandBuilder {
    private Location location;
    private ItemStack helmet;
    ItemStack hand;
    boolean withhand;
    private ItemStack chestplate;
    private ItemStack leggings;
    private ItemStack boots;
    private boolean gravity;
    private boolean visible;
    private boolean arms;
    private ItemStack holding;
    private EulerAngle headPose;
    private EulerAngle bodyPose;
    private EulerAngle leftArmPose;
    private EulerAngle rightArmPose;
    private EulerAngle leftLegPose;
    private EulerAngle rightLegPose;
    private EulerAngle bodyPoseRotate;
    private boolean small;
    private boolean base;
    String CustomName;
    boolean withCustomName;
    private ArmorStand stand;

    public ArmorStandBuilder(Location location) {
        this.location = location;
        this.gravity = true;
        this.visible = true;
        this.arms = true;
        this.headPose = new EulerAngle(0.0, 0.0, 0.0);
        this.bodyPose = new EulerAngle(0.0, 0.0, 0.0);
        this.leftArmPose = new EulerAngle(0.0, 0.0, 0.0);
        this.rightArmPose = new EulerAngle(0.0, 0.0, 0.0);
        this.leftLegPose = new EulerAngle(0.0, 0.0, 0.0);
        this.rightLegPose = new EulerAngle(0.0, 0.0, 0.0);
        this.bodyPoseRotate = new EulerAngle(0.0, 0.0, 0.0);
        this.small = false;
        this.base = true;
        this.CustomName = null;
        this.withCustomName = false;
    }

    public ArmorStandBuilder withHelmet(ItemStack itemStack) {
        this.helmet = itemStack;
        return this;
    }

    public ArmorStandBuilder withHand(ItemStack itemStack) {
        this.hand = itemStack;
        return this;
    }

    public ArmorStandBuilder withCustomName(boolean bl, String string) {
        this.withCustomName = true;
        this.CustomName = string;
        return this;
    }

    public ArmorStandBuilder withChestplate(ItemStack itemStack) {
        this.chestplate = itemStack;
        return this;
    }

    public ArmorStandBuilder withLeggings(ItemStack itemStack) {
        this.leggings = itemStack;
        return this;
    }

    public ArmorStandBuilder withBoots(ItemStack itemStack) {
        this.boots = itemStack;
        return this;
    }

    public ArmorStandBuilder withNoGravity() {
        this.gravity = false;
        return this;
    }

    public ArmorStandBuilder withInvisible() {
        this.visible = false;
        return this;
    }

    public ArmorStandBuilder withoutInvisible() {
        this.visible = true;
        return this;
    }

    public ArmorStandBuilder withNoArms() {
        this.arms = false;
        return this;
    }

    public ArmorStandBuilder withLocation(Location location) {
        this.location = location;
        return this;
    }

    public ArmorStandBuilder withHeadPose(EulerAngle eulerAngle) {
        this.headPose = eulerAngle;
        return this;
    }

    public ArmorStandBuilder withBodyPose(EulerAngle eulerAngle) {
        this.bodyPose = eulerAngle;
        return this;
    }

    public ArmorStandBuilder withLeftArmPose(EulerAngle eulerAngle) {
        this.leftArmPose = eulerAngle;
        return this;
    }

    public ArmorStandBuilder withStandRotated(EulerAngle eulerAngle) {
        this.bodyPoseRotate = eulerAngle;
        return this;
    }

    public ArmorStandBuilder withRightArmPose(EulerAngle eulerAngle) {
        this.rightArmPose = eulerAngle;
        return this;
    }

    public ArmorStandBuilder withLeftLegPose(EulerAngle eulerAngle) {
        this.leftLegPose = eulerAngle;
        return this;
    }

    public ArmorStandBuilder withRightLegPose(EulerAngle eulerAngle) {
        this.rightLegPose = eulerAngle;
        return this;
    }

    public ArmorStandBuilder withNoBase() {
        this.base = false;
        return this;
    }

    public ArmorStandBuilder holding(ItemStack itemStack) {
        this.holding = itemStack;
        return this;
    }

    public ArmorStandBuilder withSmall() {
        this.small = true;
        return this;
    }

    public ArmorStand getStand() {
        return this.stand;
    }

    public void setStand(ArmorStand armorStand) {
        this.stand = armorStand;
    }

    public ArmorStand spawn() {
        ArmorStand armorStand = (ArmorStand)this.location.getWorld().spawnEntity(this.location, EntityType.ARMOR_STAND);
        if (Utils.isVersionHigh()) {
            armorStand.setSilent(true);
        }
        armorStand.setGravity(this.gravity);
        armorStand.setVisible(this.visible);
        if (this.CustomName == null) {
            armorStand.setCustomName("ba-stand");
        } else {
            armorStand.setCustomName(this.CustomName);
        }
        if (this.withCustomName) {
            armorStand.setCustomNameVisible(true);
        } else {
            armorStand.setCustomNameVisible(false);
        }
        armorStand.setHelmet(this.helmet);
        armorStand.setChestplate(this.chestplate);
        armorStand.setLeggings(this.leggings);
        armorStand.setBoots(this.boots);
        armorStand.setArms(this.arms);
        armorStand.setItemInHand(this.holding);
        armorStand.setHeadPose(this.headPose);
        armorStand.setBodyPose(this.bodyPose);
        armorStand.setItemInHand(this.hand);
        armorStand.setLeftArmPose(this.leftArmPose);
        armorStand.setBasePlate(this.base);
        armorStand.setRightArmPose(this.rightArmPose);
        armorStand.setLeftLegPose(this.leftLegPose);
        armorStand.setRightLegPose(this.rightLegPose);
        armorStand.setSmall(this.small);
        armorStand.setBodyPose(this.bodyPoseRotate);
        this.setStand(armorStand);
        return armorStand;
    }
}

