/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.rewards;

import com.cryptomorin.xseries.advancedcrates.XMaterial;
import com.cryptomorin.xseries.advancedcrates.XPotion;
import com.google.common.base.Enums;
import com.google.common.base.Strings;
import com.google.common.collect.Multimap;
import de.tr7zw.advancedcrates.nbtapi.NBT;
import de.tr7zw.advancedcrates.nbtapi.iface.ReadWriteNBT;
import de.tr7zw.advancedcrates.nbtapi.iface.ReadableNBT;
import de.tr7zw.advancedcrates.nbtapi.utils.MinecraftVersion;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import me.PM2.AdvancedCrates.config.SimpleConfig;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.rewards.CompressedEnchantment;
import me.PM2.AdvancedCrates.rewards.CompressedPotionEffect;
import me.PM2.AdvancedCrates.rewards.ItemBuilder;
import me.PM2.AdvancedCrates.rewards.RGBColor;
import me.PM2.AdvancedCrates.utils.SkullCreator;
import me.PM2.AdvancedCrates.utils.Utils;
import me.PM2.AdvancedCrates.utils.VersionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;

public class SaveableItemBuilder
extends ItemBuilder {
    public SaveableItemBuilder(ItemStack itemStack) {
        super(itemStack);
    }

    public SaveableItemBuilder(XMaterial xMaterial) {
        super(xMaterial);
    }

    public void saveItem(SimpleConfig simpleConfig, String string, boolean bl) {
        Object object5;
        Object object2;
        Object object3;
        Object object6;
        block45: {
            try {
                if (XMaterial.matchXMaterialExists(this.getItemStack())) {
                    object6 = XMaterial.matchXMaterial(this.getItemStack());
                    simpleConfig.set(string.equals("") ? "Material" : string + ".Material", ((Enum)object6).name());
                    simpleConfig.set(string.equals("") ? "Damage" : string + ".Damage", ((XMaterial)object6).getData() != 0 || VersionUtils.Version.v1_13.isServerVersionOrLater() ? ((((XMaterial)object6).getData() + "").contains("material.MaterialData") ? null : Byte.valueOf(((XMaterial)object6).getData())) : null);
                } else {
                    simpleConfig.set(string.equals("") ? "Material" : string + ".Material", this.getItemStack().getType().toString());
                    if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_13_R1) && this.getItemStack().getData() != null) {
                        simpleConfig.set(string.equals("") ? "Damage" : string + ".Damage", this.getItemStack().getItemMeta() == null ? (short)0 : ((((Damageable)this.getItemStack().getItemMeta()).getDamage() + "").contains("material.MaterialData") ? null : Short.valueOf((short)((Damageable)this.getItemStack().getItemMeta()).getDamage())));
                    }
                }
            }
            catch (Exception exception) {
                simpleConfig.set(string.equals("") ? "Material" : string + ".Material", this.getItemStack().getType().toString());
                if (!MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_13_R1) || this.getItemStack().getData() == null) break block45;
                simpleConfig.set(string.equals("") ? "Damage" : string + ".Damage", this.getItemStack().getItemMeta() == null ? (short)0 : ((((Damageable)this.getItemStack().getItemMeta()).getDamage() + "").contains("material.MaterialData") ? null : Short.valueOf((short)((Damageable)this.getItemStack().getItemMeta()).getDamage())));
            }
        }
        if (this.getBase64texture() != null && !this.getBase64texture().equals("")) {
            simpleConfig.set(string.equals("") ? "Base64Texture" : string + ".Base64Texture", this.getBase64texture());
        }
        simpleConfig.set(string.equals("") ? "Glow" : string + ".Glow", this.isGlowing());
        simpleConfig.set(string.equals("") ? "Amount" : string + ".Amount", this.getItemStack().getAmount());
        if (VersionUtils.Version.v1_13.isServerVersionOrLater() && this.getItemMeta() instanceof Damageable && this.getItemStack().getData() != null && this.getItemStack().getData().getData() != 0) {
            simpleConfig.set(string.equals("") ? "Damage" : string + ".Damage", (((Damageable)this.getItemMeta()).getDamage() + "").contains("material.MaterialData") ? null : Short.valueOf((short)((Damageable)this.getItemMeta()).getDamage()));
        }
        if (!this.hasDisplayName()) {
            simpleConfig.set(string.equals("") ? "Name" : string + ".Name", null);
        } else {
            simpleConfig.set(string.equals("") ? "Name" : string + ".Name", this.getDisplayNameFromChatColor());
        }
        if (!this.getEnchantments().isEmpty()) {
            object6 = new ArrayList();
            for (CompressedEnchantment object52 : this.getEnchantments()) {
                ((ArrayList)object6).add(object52.toString());
            }
            simpleConfig.set(string.equals("") ? "Enchantments" : string + ".Enchantments", object6);
        } else {
            simpleConfig.set(string.equals("") ? "Enchantments" : string + ".Enchantments", null);
        }
        if (!this.getPotionEffects().isEmpty()) {
            object6 = new ArrayList<String>();
            for (CompressedPotionEffect exception : this.getPotionEffects()) {
                ((ArrayList)object6).add(exception.toString());
            }
            simpleConfig.set(string.equals("") ? "PotionEffects" : string + ".PotionEffects", object6);
        } else {
            simpleConfig.set(string.equals("") ? "PotionEffects" : string + ".PotionEffects", null);
        }
        if (!this.getLores().isEmpty()) {
            simpleConfig.set(string.equals("") ? "Lores" : string + ".Lores", Utils.fromColor(this.getLores()));
        } else {
            simpleConfig.set(string.equals("") ? "Lores" : string + ".Lores", null);
        }
        object6 = NBT.itemStackToNBT(this.getItem());
        String string2 = object6 != null ? object6.toString() : null;
        simpleConfig.set(string + ".NBTtags", this.isEmptyNbt(string2) ? null : string2);
        if (!this.getItemFlags().isEmpty()) {
            ArrayList<String> n = new ArrayList<String>();
            for (ItemFlag itemFlag : this.getItemFlags()) {
                n.add(itemFlag.name());
            }
            simpleConfig.set(string.equals("") ? "ItemFlags" : string + ".ItemFlags", n);
        } else {
            simpleConfig.set(string.equals("") ? "ItemFlags" : string + ".ItemFlags", null);
        }
        if (this.isColorable() && this.getColor() != null) {
            simpleConfig.set(string.equals("") ? "ColorRed" : string + ".ColorRed", this.getColor().getR());
            simpleConfig.set(string.equals("") ? "ColorGreen" : string + ".ColorGreen", this.getColor().getG());
            simpleConfig.set(string.equals("") ? "ColorBlue" : string + ".ColorBlue", this.getColor().getB());
        }
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_13_R1)) {
            try {
                Multimap multimap;
                Class<?> clazz = Class.forName("org.bukkit.attribute.Attribute");
                Method method = clazz.getMethod("name", new Class[0]);
                if (XMaterial.supports(13) && (multimap = this.getItemMeta().getAttributeModifiers()) != null) {
                    for (Map.Entry entry : multimap.entries()) {
                        object3 = entry.getKey();
                        object2 = (AttributeModifier)entry.getValue();
                        if (object3 == null || object2 == null) continue;
                        object5 = (String)method.invoke(object3, new Object[0]);
                        String string3 = string.isEmpty() ? "Attributes." + (String)object5 + '.' : string + ".Attributes." + (String)object5 + '.';
                        try {
                            simpleConfig.set(string3 + "Id", object2.getUniqueId().toString());
                            simpleConfig.set(string3 + "Name", object2.getName());
                            simpleConfig.set(string3 + "Amount", object2.getAmount());
                            simpleConfig.set(string3 + "Operation", object2.getOperation().name());
                            if (object2.getSlot() == null) continue;
                            simpleConfig.set(string3 + "Slot", object2.getSlot().name());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            System.out.println("WARNING. Problem while saving attributes for item:");
                            System.out.println("Name: " + this.getName(false));
                            System.out.println("Material: " + this.getMaterial());
                            System.out.println("Path: " + string3);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.getItemMeta() instanceof FireworkMeta) {
            FireworkMeta fireworkMeta = (FireworkMeta)this.getItemMeta();
            simpleConfig.set(string + ".Power", fireworkMeta.getPower());
            int n = 0;
            for (Object object4 : fireworkMeta.getEffects()) {
                Map.Entry entry;
                simpleConfig.set(string + ".Firework." + n + ".Type", object4.getType().name());
                entry = simpleConfig.isConfigurationSection(string + ".Firework." + n) ? simpleConfig.getConfigurationSection(string + ".Firework." + n) : simpleConfig.createSection(string + ".Firework." + n);
                entry.set("Flicker", object4.hasFlicker());
                entry.set("Trail", object4.hasTrail());
                object3 = new ArrayList(object4.getColors().size());
                for (Object object5 : object4.getColors()) {
                    object3.add((String)(object5.getRed() + ", " + object5.getGreen() + ", " + object5.getBlue()));
                }
                object2 = new ArrayList(object4.getFadeColors().size());
                for (String string3 : object4.getFadeColors()) {
                    object2.add(string3.getRed() + ", " + string3.getGreen() + ", " + string3.getBlue());
                }
                object5 = entry.createSection("Colors");
                object5.set("Base", object3);
                object5.set("Fade", object2);
                ++n;
            }
        }
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_9_R1) && this.getItemMeta() instanceof PotionMeta && ((PotionMeta)this.getItemMeta()).getBasePotionData() != null) {
            if (XMaterial.supports(9)) {
                Object object4;
                PotionMeta potionMeta = (PotionMeta)this.getItemMeta();
                List list = potionMeta.getCustomEffects();
                ArrayList<String> arrayList = new ArrayList<String>(list.size());
                for (Map.Entry entry : list) {
                    arrayList.add(entry.getType().getName() + ", " + entry.getDuration() + ", " + entry.getAmplifier());
                }
                simpleConfig.set(string + ".CustomEffects", arrayList);
                object4 = potionMeta.getBasePotionData();
                if (object4 != null) {
                    simpleConfig.set(string + ".BaseEffect", object4.getType().name() + ", " + object4.isExtended() + ", " + object4.isUpgraded());
                }
                if (potionMeta.hasColor()) {
                    simpleConfig.set(string + ".Color", potionMeta.getColor().asRGB());
                }
            } else if (this.getItem().getDurability() != 0) {
                Potion potion = Potion.fromItemStack((ItemStack)this.getItem());
                simpleConfig.set(string + ".Level", potion.getLevel());
                simpleConfig.set(string + ".BaseEffect", potion.getType().name() + ", " + potion.hasExtendedDuration() + ", " + potion.isSplash());
            }
        }
        try {
            if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_13_R1) && this.getItemMeta().isUnbreakable()) {
                simpleConfig.set(string + ".Unbreakable", this.getItemMeta().isUnbreakable());
            } else {
                Object object7 = this.getItemMeta().getClass().getMethod("spigot", new Class[0]).invoke((Object)this.getItemMeta(), new Object[0]);
                Method method = object7.getClass().getMethod("isUnbreakable", new Class[0]);
                simpleConfig.set(string + ".Unbreakable", method.invoke(object7, new Object[0]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_14_R1) && this.getItemMeta().hasCustomModelData()) {
            String string4;
            int n = this.getItemMeta().getCustomModelData();
            String string5 = string4 = string.equals("") ? "CustomModelData" : string + ".CustomModelData";
            if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_11_R1) && n != 0) {
                simpleConfig.set(string4, n);
            }
        }
    }

    private boolean isEmptyNbt(String string) {
        if (string == null) {
            return true;
        }
        String string2 = string.trim();
        return string2.isEmpty() || "{}".equals(string2) || "null".equalsIgnoreCase(string2);
    }

    private static boolean isLikelyCompoundSNBT(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        if (string2.isEmpty()) {
            return false;
        }
        if ("{}".equals(string2) || "null".equalsIgnoreCase(string2)) {
            return false;
        }
        return string2.startsWith("{") && string2.endsWith("}") && string2.indexOf(58) > 0;
    }

    private static ReadWriteNBT tryParseCompoundSNBT(String string) {
        if (!SaveableItemBuilder.isLikelyCompoundSNBT(string)) {
            return null;
        }
        try {
            return NBT.parseNBT(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public boolean loadItem(SimpleConfig simpleConfig, String string) {
        return this.loadItem(simpleConfig, string, true);
    }

    public boolean loadItem(SimpleConfig simpleConfig, String string, boolean bl) {
        Object object;
        UUID uUID;
        String string2;
        Object object22;
        Object object32;
        int n;
        ItemFlag itemFlag;
        Object object42;
        Object object5;
        boolean bl2;
        boolean bl3;
        block100: {
            String string3;
            bl3 = false;
            if (!simpleConfig.contains(string.equals("") ? "Material" : string + ".Material")) {
                if (!simpleConfig.contains(string.equals("") ? "Item" : string + ".Item")) {
                    return false;
                }
                string3 = simpleConfig.getString(string.equals("") ? "Item" : string + ".Item");
                this.setItemStack(Utils.getItem(string3));
                this.defuseContainerMeta(string, "after-material");
            } else {
                string3 = simpleConfig.getString(string.equals("") ? "Material" : string + ".Material");
                this.setItemStack(Utils.getItem(string3));
                this.defuseContainerMeta(string, "after-material");
            }
            string3 = string.isEmpty() ? "NBTtags" : string + ".NBTtags";
            String string4 = simpleConfig.getString(string3);
            bl2 = false;
            if (string4 != null && !string4.trim().isEmpty()) {
                try {
                    object5 = SaveableItemBuilder.fixMalformedNBT(string4);
                    object42 = SaveableItemBuilder.tryParseCompoundSNBT((String)object5);
                    if (object42 == null && !string4.equals(object5)) {
                        object42 = SaveableItemBuilder.tryParseCompoundSNBT(string4);
                    }
                    if (object42 != null && !string4.equals(object5)) {
                        simpleConfig.set(string3, object5);
                    }
                    if (object42 == null) break block100;
                    if (object42.hasTag("BlockEntityTag")) {
                        object42.removeKey("BlockEntityTag");
                    }
                    try {
                        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_20_R4)) {
                            ReadWriteNBT readWriteNBT3;
                            if (object42.hasTag("id")) {
                                readWriteNBT3 = null;
                                try {
                                    if (object42.hasTag("components") && (itemFlag = object42.getCompound("components")) != null) {
                                        SaveableItemBuilder.stripDangerousComponents(string, (ReadWriteNBT)itemFlag, "pre-id");
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                try {
                                    readWriteNBT3 = NBT.itemStackFromNBT((ReadableNBT)object42);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                if (readWriteNBT3 != null) {
                                    NBT.modifyComponents((ItemStack)readWriteNBT3, readWriteNBT -> SaveableItemBuilder.stripDangerousComponents(string, readWriteNBT, "id"));
                                    this.setItem((ItemStack)readWriteNBT3);
                                    this.defuseContainerMeta(string, "after-nbt(id)");
                                    bl2 = true;
                                }
                                break block100;
                            }
                            if (!object42.hasTag("components") || (readWriteNBT3 = object42.getCompound("components")) == null) break block100;
                            SaveableItemBuilder.stripDangerousComponents(string, readWriteNBT3, "components");
                            try {
                                NBT.modifyComponents(this.getItem(), readWriteNBT2 -> readWriteNBT2.mergeCompound(readWriteNBT3));
                            }
                            catch (Throwable throwable) {
                                try {
                                    NBT.modifyComponents(this.getItem(), readWriteNBT2 -> {
                                        ReadWriteNBT readWriteNBT3;
                                        if (readWriteNBT3.hasTag("minecraft:custom_data") && (readWriteNBT3 = readWriteNBT3.getCompound("minecraft:custom_data")) != null) {
                                            ReadWriteNBT readWriteNBT4 = readWriteNBT2.getOrCreateCompound("minecraft:custom_data");
                                            readWriteNBT4.mergeCompound(readWriteNBT3);
                                        }
                                    });
                                }
                                catch (Throwable throwable2) {
                                    // empty catch block
                                }
                            }
                            this.defuseContainerMeta(string, "after-nbt(components)");
                            bl2 = true;
                            break block100;
                        }
                        this.setItem(Bukkit.getUnsafe().modifyItemStack(this.getItem(), object42.toString()));
                        bl2 = true;
                    }
                    catch (Throwable throwable) {
                        bl2 = false;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!bl2) {
            object5 = this.getItemMeta();
            this.logLoreState((ItemMeta)object5, string, "pre-apply(YAML)-noNBT");
            if (object5 != null) {
                SaveableItemBuilder.sanitizeLore(object5);
                this.setItemMeta((ItemMeta)object5);
            }
        } else {
            object5 = this.getItemMeta();
            this.logLoreState((ItemMeta)object5, string, "post-apply(NBT)-before-softreset");
            if (object5 != null) {
                object42 = string.equals("") ? "Lores" : string + ".Lores";
                boolean bl4 = simpleConfig.contains((String)object42);
                if (bl4 && object5.hasLore()) {
                    object5.setLore(new ArrayList());
                }
                if (object5.hasEnchants()) {
                    new HashSet(object5.getEnchants().keySet()).forEach(arg_0 -> ((ItemMeta)object5).removeEnchant(arg_0));
                }
                if (!object5.getItemFlags().isEmpty()) {
                    new HashSet(object5.getItemFlags()).forEach(arg_0 -> SaveableItemBuilder.lambda$loadItem$3((ItemMeta)object5, arg_0));
                }
                if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_13_R1) && object5.hasAttributeModifiers()) {
                    new HashSet(Objects.requireNonNull(object5.getAttributeModifiers()).keySet()).forEach(arg_0 -> ((ItemMeta)object5).removeAttributeModifier(arg_0));
                }
                if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_14_R1) && object5.hasCustomModelData()) {
                    object5.setCustomModelData(null);
                }
                if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_11_R1)) {
                    object5.setUnbreakable(false);
                }
                SaveableItemBuilder.sanitizeLore(object5);
                this.setItemMeta((ItemMeta)object5);
            }
        }
        if (simpleConfig.contains(string.equals("") ? "Damage" : string + ".Damage") && !bl3 && Utils.isInteger(simpleConfig.getString(string.equals("") ? "Damage" : string + ".Damage")) && (n = Integer.parseInt(simpleConfig.getString(string.equals("") ? "Damage" : string + ".Damage"))) != 0) {
            this.setDamage(n);
        }
        if (!simpleConfig.contains(string.equals("") ? "Name" : string + ".Name")) {
            this.setName(null);
        }
        this.setName(simpleConfig.getString(string.equals("") ? "Name" : string + ".Name"));
        if (simpleConfig.contains(string.equals("") ? "Lores" : string + ".Lores")) {
            for (Object object42 : simpleConfig.getStringList(string.equals("") ? "Lores" : string + ".Lores")) {
                this.addLoreLine((String)object42);
            }
        }
        ItemMeta itemMeta = this.getItemMeta();
        this.logLoreState(itemMeta, string, "after-apply(YAML)-lore");
        if (itemMeta != null) {
            SaveableItemBuilder.sanitizeLore(itemMeta);
            this.setItemMeta(itemMeta);
        }
        if (simpleConfig.contains(string.equals("") ? "Enchantments" : string + ".Enchantments")) {
            object42 = simpleConfig.getStringList(string.equals("") ? "Enchantments" : string + ".Enchantments").iterator();
            while (object42.hasNext()) {
                String string5 = (String)object42.next();
                try {
                    itemFlag = CompressedEnchantment.fromString(string5);
                    this.addEnchantment((CompressedEnchantment)itemFlag);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.out.println(string5 + " is not formatted enchant;level or invalid.");
                }
            }
        }
        if (simpleConfig.contains(string.equals("") ? "Glow" : string + ".Glow") && this.getEnchantments().isEmpty() || simpleConfig.contains(string.equals("") ? "Enchanted" : string + ".Enchanted") && this.getEnchantments().isEmpty()) {
            object42 = simpleConfig.getString(string.equals("") ? (simpleConfig.contains("Glow") ? "Glow" : "Enchanted") : string + (simpleConfig.contains(string + ".Glow") ? ".Glow" : ".Enchanted"));
            if (Utils.isBoolean((String)object42)) {
                this.setGlow(Boolean.parseBoolean((String)object42));
            }
        }
        try {
            if (simpleConfig.contains(string.equals("") ? "Unbreakable" : string + ".Unbreakable")) {
                this.setUnbreakable(simpleConfig.getBoolean(string.equals("") ? "Unbreakable" : string + ".Unbreakable"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (simpleConfig.contains(string.equals("") ? "ItemFlags" : string + ".ItemFlags")) {
            object42 = simpleConfig.getStringList(string.equals("") ? "ItemFlags" : string + ".ItemFlags").iterator();
            while (object42.hasNext()) {
                String string6 = (String)object42.next();
                if (string6.equalsIgnoreCase("HIDE_ATTRIBUTES") && MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_20_R4)) {
                    try {
                        ItemMeta.class.getMethod("setHideTooltip", Boolean.TYPE).invoke((Object)this.getItemMeta(), true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                try {
                    itemFlag = ItemFlag.valueOf((String)string6);
                    this.addItemFlag(itemFlag);
                }
                catch (Exception exception) {}
            }
        }
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_9_R1)) {
            object42 = simpleConfig.getConfigurationSection(string.equals("") ? "Attributes" : string + ".Attributes");
            ItemMeta itemMeta2 = this.getItemMeta();
            if (object42 != null && itemMeta2 != null) {
                for (Object object32 : object42.getKeys(false)) {
                    object22 = this.getAttributeSafely((String)object32);
                    if (object22 == null) {
                        Bukkit.getLogger().warning("Skipping unknown attribute: " + ((String)object32).toUpperCase(Locale.ENGLISH));
                        continue;
                    }
                    string2 = object42.getString((String)object32 + ".Id");
                    uUID = string2 != null ? UUID.fromString(string2) : UUID.randomUUID();
                    object = new AttributeModifier(uUID, object42.getString((String)object32 + ".Name"), object42.getDouble((String)object32 + ".Amount"), this.getOperation(object42.getString((String)object32 + ".Operation")), this.getEquipmentSlot(object42.getString((String)object32 + ".Slot")));
                    if (itemMeta2.hasAttributeModifiers() && itemMeta2.getAttributeModifiers().containsKey(object22)) continue;
                    itemMeta2.addAttributeModifier(object22, (AttributeModifier)object);
                }
                SaveableItemBuilder.sanitizeLore(itemMeta2);
                this.setItemMeta(itemMeta2);
            }
        }
        if (simpleConfig.contains(string.equals("") ? "Amount" : string + ".Amount") && Utils.isInteger((String)(object42 = simpleConfig.getString(string.equals("") ? "Amount" : string + ".Amount")))) {
            this.getItemStack().setAmount(Integer.parseInt((String)object42));
        }
        if (simpleConfig.contains(string.equals("") ? "ColorRed" : string + ".ColorRed") && this.isColorable()) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            object32 = simpleConfig.getString(string.equals("") ? "ColorRed" : string + ".ColorRed");
            object22 = simpleConfig.getString(string.equals("") ? "ColorGreen" : string + ".ColorGreen");
            string2 = simpleConfig.getString(string.equals("") ? "ColorBlue" : string + ".ColorBlue");
            if (Utils.isInteger((String)object32)) {
                n2 = Integer.parseInt((String)object32);
            }
            if (Utils.isInteger((String)object22)) {
                n3 = Integer.parseInt((String)object22);
            }
            if (Utils.isInteger(string2)) {
                n4 = Integer.parseInt(string2);
            }
            this.setColor(new RGBColor(n2, n3, n4));
        }
        if (this.getItemMeta() instanceof FireworkMeta) {
            FireworkMeta fireworkMeta = (FireworkMeta)this.getItemMeta();
            fireworkMeta.setPower(simpleConfig.getInt(string + ".Power"));
            ConfigurationSection configurationSection = simpleConfig.getConfigurationSection(string + ".Firework");
            if (configurationSection != null) {
                FireworkEffect.Builder builder = FireworkEffect.builder();
                for (Object object22 : configurationSection.getKeys(false)) {
                    string2 = simpleConfig.getConfigurationSection(string + ".Firework." + (String)object22);
                    builder.flicker(string2.getBoolean("Flicker"));
                    builder.trail(string2.getBoolean("Trail"));
                    builder.with((FireworkEffect.Type)Enums.getIfPresent(FireworkEffect.Type.class, (String)string2.getString("Type").toUpperCase(Locale.ENGLISH)).or((Object)FireworkEffect.Type.STAR));
                    uUID = string2.getConfigurationSection("Colors");
                    object = uUID.getStringList("Base");
                    List list = uUID.getStringList("Fade");
                    ArrayList<Color> arrayList = new ArrayList<Color>(object.size());
                    ArrayList<Color> arrayList2 = new ArrayList<Color>(list.size());
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        String string7 = (String)iterator.next();
                        arrayList.add(this.parseColor(string7));
                    }
                    for (String string7 : list) {
                        arrayList2.add(this.parseColor(string7));
                    }
                    builder.withColor(arrayList);
                    builder.withFade(arrayList2);
                    fireworkMeta.addEffect(builder.build());
                }
            }
            SaveableItemBuilder.sanitizeLore((ItemMeta)fireworkMeta);
            this.setItemMeta((ItemMeta)fireworkMeta);
        }
        if (this.getItemMeta() instanceof PotionMeta) {
            if (XMaterial.supports(9)) {
                PotionMeta potionMeta = (PotionMeta)this.getItemMeta();
                for (String string8 : simpleConfig.getStringList(string + ".CustomEffects")) {
                    object32 = XPotion.parseEffect(string8).getEffect();
                    potionMeta.addCustomEffect((PotionEffect)object32, true);
                }
                String string9 = simpleConfig.getString(string + ".BaseEffect");
                if (!Strings.isNullOrEmpty((String)string9)) {
                    String[] stringArray = StringUtils.split((String)string9, (char)',');
                    object32 = null;
                    try {
                        object32 = MinecraftVersion.isOlderOrEqualThanVersion(MinecraftVersion.MC1_20_R3) ? (PotionType)Enums.getIfPresent(PotionType.class, (String)stringArray[0].trim().toUpperCase(Locale.ENGLISH)).or((Object)PotionType.valueOf((String)"UNCRAFTABLE")) : (PotionType)Enums.getIfPresent(PotionType.class, (String)stringArray[0].trim().toUpperCase(Locale.ENGLISH)).get();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (object32 != null) {
                        boolean bl5 = stringArray.length > 1 && Boolean.parseBoolean(stringArray[1].trim());
                        boolean bl6 = stringArray.length > 2 && Boolean.parseBoolean(stringArray[2].trim());
                        potionMeta.setBasePotionData(new PotionData((PotionType)object32, bl5, bl6));
                    }
                }
                if (simpleConfig.contains(string + ".Color")) {
                    potionMeta.setColor(Color.fromRGB((int)simpleConfig.getInt(string + ".Color")));
                }
                SaveableItemBuilder.sanitizeLore((ItemMeta)potionMeta);
                this.setItemMeta((ItemMeta)potionMeta);
            } else if (simpleConfig.contains(string + ".Level")) {
                int n5 = simpleConfig.getInt(string + ".Level");
                String string10 = simpleConfig.getString(string + ".BaseEffect");
                if (!Strings.isNullOrEmpty((String)string10)) {
                    String[] stringArray = StringUtils.split((String)string10, (char)',');
                    object32 = (PotionType)Enums.getIfPresent(PotionType.class, (String)stringArray[0].trim().toUpperCase(Locale.ENGLISH)).or((Object)PotionType.SLOWNESS);
                    boolean bl7 = stringArray.length != 1 && Boolean.parseBoolean(stringArray[1].trim());
                    boolean bl8 = stringArray.length > 2 && Boolean.parseBoolean(stringArray[2].trim());
                    this.setItem(new Potion((PotionType)object32, n5, bl8, bl7).toItemStack(this.getItemStack().getAmount()));
                }
            }
        }
        if (simpleConfig.contains(string.equals("") ? "CustomModelData" : string + ".CustomModelData")) {
            int n6 = simpleConfig.getInt(string.equals("") ? "CustomModelData" : string + ".CustomModelData");
            if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_13_R1)) {
                if (n6 != 0) {
                    ItemMeta itemMeta3 = this.getItemMeta();
                    itemMeta3.setCustomModelData(Integer.valueOf(n6));
                    SaveableItemBuilder.sanitizeLore(itemMeta3);
                    this.setItemMeta(itemMeta3);
                }
            } else if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_11_R1) && n6 != 0) {
                this.getItemStack().setDurability((short)n6);
                ItemMeta itemMeta4 = this.getItemMeta();
                itemMeta4.setUnbreakable(true);
                SaveableItemBuilder.sanitizeLore(itemMeta4);
                this.setItemMeta(itemMeta4);
            }
        }
        if (simpleConfig.contains(string.equals("") ? "Base64Texture" : string + ".Base64Texture") && XMaterial.matchXMaterial(this.getItem()) == XMaterial.PLAYER_HEAD) {
            this.setBase64texture(simpleConfig.getString(string.equals("") ? "Base64Texture" : string + ".Base64Texture"));
            if (this.getItemMeta() instanceof SkullMeta && this.getBase64texture() != null && !this.getBase64texture().equals("")) {
                this.setItem(SkullCreator.itemWithBase64(this.getItem(), this.getBase64texture()));
            }
        }
        this.reapplyPotionEffects();
        this.reapplyColor();
        super.setGiveConfiguratedItemReward(this.getItem().clone());
        super.setItemToSave(this.getItem().clone());
        if (this.getItem().getType() != Material.AIR) {
            ItemStack itemStack = this.getItem().clone();
            NBT.modify(itemStack, readWriteItemNBT -> readWriteItemNBT.removeKey("AMC.Reward"));
            super.setGiveConfiguratedItemReward(itemStack);
            boolean bl9 = false;
            if (!string.isEmpty() && string.equalsIgnoreCase("KeyCrate") && simpleConfig.contains("KeyCrate.NBTEnabled") && !simpleConfig.getBoolean("KeyCrate.NBTEnabled")) {
                bl9 = true;
            }
            if (!bl9) {
                if (bl) {
                    boolean bl10 = false;
                    try {
                        bl10 = NBT.get(this.getItem(), readableItemNBT -> readableItemNBT.hasTag("AMC.Reward"));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (!bl10) {
                        object32 = this.getItem();
                        String string11 = ("" + string).replace("Prizes.", "").replace("BestPrizes.", "");
                        NBT.modify((ItemStack)object32, readWriteItemNBT -> readWriteItemNBT.setString("AMC.Reward", string11));
                        this.setItem((ItemStack)object32);
                    }
                } else {
                    boolean bl11 = false;
                    try {
                        bl11 = NBT.get(this.getItem(), readableItemNBT -> readableItemNBT.hasTag("AMC.MonthlyCrate"));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (!bl11) {
                        object32 = this.getItem();
                        NBT.modify((ItemStack)object32, readWriteItemNBT -> readWriteItemNBT.setString("AMC.MonthlyCrate", ""));
                        this.setItem((ItemStack)object32);
                    }
                }
            }
        }
        try {
            ItemMeta itemMeta5 = this.getItemMeta();
            this.logLoreState(itemMeta5, string, "final-before-set");
            if (itemMeta5 != null) {
                SaveableItemBuilder.sanitizeLore(itemMeta5);
                this.setItemMeta(itemMeta5);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.defuseContainerMeta(string, "final");
        return true;
    }

    private static void stripDangerousComponents(String string, ReadWriteNBT readWriteNBT, String string2) {
        try {
            if (readWriteNBT.hasTag("minecraft:lore")) {
                readWriteNBT.removeKey("minecraft:lore");
            }
            if (readWriteNBT.hasTag("minecraft:custom_name")) {
                readWriteNBT.removeKey("minecraft:custom_name");
            }
            if (readWriteNBT.hasTag("minecraft:block_entity_data")) {
                readWriteNBT.removeKey("minecraft:block_entity_data");
            }
            if (readWriteNBT.hasTag("minecraft:attribute_modifiers")) {
                readWriteNBT.removeKey("minecraft:attribute_modifiers");
            }
            if (readWriteNBT.hasTag("minecraft:tooltip_display")) {
                readWriteNBT.removeKey("minecraft:tooltip_display");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Color parseColor(String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return Color.BLACK;
        }
        String[] stringArray = StringUtils.split((String)StringUtils.deleteWhitespace((String)string), (char)',');
        if (stringArray.length < 3) {
            return Color.WHITE;
        }
        return Color.fromRGB((int)NumberUtils.toInt((String)stringArray[0], (int)0), (int)NumberUtils.toInt((String)stringArray[1], (int)0), (int)NumberUtils.toInt((String)stringArray[2], (int)0));
    }

    public boolean hasKeyInInventory(Player player, Crate crate, boolean bl) {
        if (!bl) {
            for (ItemStack itemStack : player.getInventory().getContents()) {
                if (!this.keyMatchesToStack(itemStack, crate.isKeyNeedsNameMatch(), crate.isKeyNeedsLoreMatch(), crate.isKeyNeedsEnchantsMatch(), crate.isKeyNeedsNBTMatch())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean keyMatchesToStack(ItemStack itemStack, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return false;
        }
        ItemStack itemStack2 = this.getItem();
        if (itemStack != null && itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName()) {
            boolean bl5 = itemStack2.getType() == itemStack.getType();
            boolean bl6 = !bl || this.keyNameMatches(itemStack);
            boolean bl7 = !bl2 || this.keyLoreMatches(itemStack);
            boolean bl8 = !bl3 || this.keyEnchantsMatch(itemStack);
            boolean bl9 = !bl4 || this.keyNBTMatch(itemStack);
            return bl5 && bl6 && bl7 && bl8 && bl9;
        }
        return false;
    }

    private boolean keyNameMatches(ItemStack itemStack) {
        if (this.getItem().hasItemMeta() && !itemStack.hasItemMeta() || !this.getItem().hasItemMeta() && itemStack.hasItemMeta()) {
            return false;
        }
        if (!this.getItem().hasItemMeta() || !this.getItem().getItemMeta().hasDisplayName()) {
            return true;
        }
        if (!itemStack.hasItemMeta() || !itemStack.getItemMeta().hasDisplayName()) {
            return false;
        }
        return this.getItem().getItemMeta().getDisplayName().equals(itemStack.getItemMeta().getDisplayName());
    }

    private static String normalizeLoreToken(String string) {
        return string == null ? "" : string.trim();
    }

    private boolean keyLoreMatches(ItemStack itemStack) {
        if (this.getItem().hasItemMeta() && !itemStack.hasItemMeta() || !this.getItem().hasItemMeta() && itemStack.hasItemMeta()) {
            return false;
        }
        if (!this.getItem().hasItemMeta() || this.getItem().getItemMeta() == null || !this.getItem().getItemMeta().hasLore()) {
            return true;
        }
        if (!itemStack.hasItemMeta() || this.getItem().getItemMeta() == null || !itemStack.getItemMeta().hasLore()) {
            return false;
        }
        List list = this.getItem().getItemMeta().getLore();
        List list2 = itemStack.getItemMeta().getLore();
        for (int i = 0; i < list.size(); ++i) {
            try {
                String string = list2.size() > i ? (String)list2.get(i) : null;
                String string2 = (String)list.get(i);
                if (SaveableItemBuilder.normalizeLoreToken(string).equalsIgnoreCase(SaveableItemBuilder.normalizeLoreToken(string2))) continue;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    private boolean keyNBTMatch(ItemStack itemStack) {
        String string = NBT.get(itemStack, readableItemNBT -> readableItemNBT.getString("AC.Crate"));
        String string2 = NBT.get(this.getItem(), readableItemNBT -> readableItemNBT.getString("AC.Crate"));
        return string != null && string.equals(string2);
    }

    private boolean keyEnchantsMatch(ItemStack itemStack) {
        if (!this.getItem().hasItemMeta() || !this.getItem().getItemMeta().hasEnchants()) {
            return true;
        }
        if (!itemStack.hasItemMeta() || !itemStack.getItemMeta().hasEnchants()) {
            return false;
        }
        boolean bl = true;
        for (Enchantment enchantment : this.getItem().getEnchantments().keySet()) {
            if (itemStack.getEnchantments().containsKey(enchantment) && this.getItem().getEnchantments().get(enchantment) == itemStack.getEnchantments().get(enchantment)) continue;
            bl = false;
        }
        return bl;
    }

    private Attribute getAttributeSafely(String string) {
        try {
            Class<?> clazz = Class.forName("org.bukkit.attribute.Attribute");
            return (Attribute)Enum.valueOf(clazz, string.toUpperCase(Locale.ENGLISH));
        }
        catch (ClassNotFoundException | IllegalArgumentException | NoClassDefFoundError throwable) {
            return null;
        }
    }

    private AttributeModifier.Operation getOperation(String string) {
        try {
            return AttributeModifier.Operation.valueOf((String)string.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return AttributeModifier.Operation.ADD_NUMBER;
        }
    }

    private EquipmentSlot getEquipmentSlot(String string) {
        if (string == null) {
            return EquipmentSlot.HAND;
        }
        try {
            return EquipmentSlot.valueOf((String)string.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return EquipmentSlot.HAND;
        }
    }

    private static String jsonEscape(String string) {
        return string.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private static String jsonUnescape(String string) {
        return string.replace("\\\"", "\"").replace("\\\\", "\\");
    }

    private static String fixJSONComponent(String string) {
        string = string.replaceAll("\"bold\"\\s*:\\s*\"1b\"", "\"bold\":true");
        string = string.replaceAll("\"bold\"\\s*:\\s*\"0b\"", "\"bold\":false");
        string = string.replaceAll("\"italic\"\\s*:\\s*\"1b\"", "\"italic\":true");
        string = string.replaceAll("\"italic\"\\s*:\\s*\"0b\"", "\"italic\":false");
        string = string.replaceAll("\"obfuscated\"\\s*:\\s*\"1b\"", "\"obfuscated\":true");
        string = string.replaceAll("\"obfuscated\"\\s*:\\s*\"0b\"", "\"obfuscated\":false");
        string = string.replaceAll("\"strikethrough\"\\s*:\\s*\"1b\"", "\"strikethrough\":true");
        string = string.replaceAll("\"strikethrough\"\\s*:\\s*\"0b\"", "\"strikethrough\":false");
        string = string.replaceAll("\"underlined\"\\s*:\\s*\"1b\"", "\"underlined\":true");
        string = string.replaceAll("\\bbold\\s*:\\s*1b\\b", "\"bold\":true");
        string = string.replaceAll("\\bbold\\s*:\\s*0b\\b", "\"bold\":false");
        string = string.replaceAll("\\bitalic\\s*:\\s*1b\\b", "\"italic\":true");
        string = string.replaceAll("\\bitalic\\s*:\\s*0b\\b", "\"italic\":false");
        string = string.replaceAll("\\bobfuscated\\s*:\\s*1b\\b", "\"obfuscated\":true");
        string = string.replaceAll("\\bobfuscated\\s*:\\s*0b\\b", "\"obfuscated\":false");
        string = string.replaceAll("\\bstrikethrough\\s*:\\s*1b\\b", "\"strikethrough\":true");
        string = string.replaceAll("\\bstrikethrough\\s*:\\s*0b\\b", "\"strikethrough\":false");
        string = string.replaceAll("\\bunderlined\\s*:\\s*1b\\b", "\"underlined\":true");
        string = string.replaceAll("\"italic\"\\s*:\\s*1\\b", "\"italic\":true");
        string = string.replaceAll("\"italic\"\\s*:\\s*0\\b", "\"italic\":false");
        string = string.replaceAll("\"bold\"\\s*:\\s*1\\b", "\"bold\":true");
        string = string.replaceAll("\"bold\"\\s*:\\s*0\\b", "\"bold\":false");
        string = string.replaceAll("\"obfuscated\"\\s*:\\s*1\\b", "\"obfuscated\":true");
        string = string.replaceAll("\"obfuscated\"\\s*:\\s*0\\b", "\"obfuscated\":false");
        string = string.replaceAll("\"strikethrough\"\\s*:\\s*1\\b", "\"strikethrough\":true");
        string = string.replaceAll("\"strikethrough\"\\s*:\\s*0\\b", "\"strikethrough\":false");
        string = string.replaceAll("\"underlined\"\\s*:\\s*1\\b", "\"underlined\":true");
        string = string.replaceAll("\"underlined\"\\s*:\\s*0\\b", "\"underlined\":false");
        return string;
    }

    private static String normalizeComponentValue(String string) {
        if (string == null) {
            return "\" \"";
        }
        String string2 = string.trim();
        if (string2.equals("null")) {
            return "\" \"";
        }
        if (string2.startsWith("'") && string2.endsWith("'")) {
            String string3 = string2.substring(1, string2.length() - 1);
            if ((string3 = SaveableItemBuilder.fixJSONComponent(string3)).isEmpty()) {
                string3 = " ";
            }
            return "\"" + SaveableItemBuilder.jsonEscape(string3) + "\"";
        }
        if (string2.startsWith("\"")) {
            String string4 = SaveableItemBuilder.jsonUnescape(string2.substring(1, string2.length() - 1));
            if ((string4 = SaveableItemBuilder.fixJSONComponent(string4)).isEmpty()) {
                string4 = " ";
            }
            return "\"" + SaveableItemBuilder.jsonEscape(string4) + "\"";
        }
        if (string2.startsWith("{") && string2.endsWith("}")) {
            String string5 = SaveableItemBuilder.fixJSONComponent(string2);
            if (string5.equals("{}")) {
                string5 = " ";
            }
            return "\"" + SaveableItemBuilder.jsonEscape(string5) + "\"";
        }
        return string2;
    }

    private static int findClosingQuote(String string, int n) {
        boolean bl = false;
        for (int i = n; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl) {
                bl = false;
                continue;
            }
            if (c == '\\') {
                bl = true;
                continue;
            }
            if (c != '\"') continue;
            return i;
        }
        return -1;
    }

    private static int findMatchingBrace(String string, int n) {
        if (n >= string.length() || string.charAt(n) != '{') {
            return -1;
        }
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        char c = '\u0000';
        for (int i = n; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (bl2) {
                bl2 = false;
                continue;
            }
            if (c2 == '\\') {
                bl2 = true;
                continue;
            }
            if (c2 == '\"' || c2 == '\'') {
                if (!bl) {
                    bl = true;
                    c = c2;
                } else if (c == c2) {
                    bl = false;
                }
            }
            if (bl) continue;
            if (c2 == '{') {
                ++n2;
                continue;
            }
            if (c2 != '}' || --n2 != 0) continue;
            return i;
        }
        return -1;
    }

    private static String fixLoreArray(String string) {
        String string2;
        String string3 = string.trim();
        if (!string3.startsWith("[") || !string3.endsWith("]")) {
            return string;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 1;
        int n2 = string3.length() - 1;
        boolean bl = false;
        boolean bl2 = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        for (int i = n; i < n2; ++i) {
            char c = string3.charAt(i);
            if (bl2) {
                bl2 = false;
                continue;
            }
            if (c == '\\') {
                bl2 = true;
                continue;
            }
            if (c == '\"' || c == '\'') {
                boolean bl3 = bl = !bl;
            }
            if (bl) continue;
            if (c == '{') {
                ++n3;
                continue;
            }
            if (c == '}') {
                --n3;
                continue;
            }
            if (c == '[') {
                ++n4;
                continue;
            }
            if (c == ']') {
                --n4;
                continue;
            }
            if (c != ',' || n3 != 0 || n4 != 0) continue;
            String string4 = string3.substring(n5, i).trim();
            if (!string4.isEmpty()) {
                String string5 = SaveableItemBuilder.normalizeComponentValue(string4);
                if ("\"\"".equals(string5)) {
                    string5 = "\" \"";
                }
                arrayList.add(string5);
            }
            n5 = i + 1;
        }
        if (n5 < n2 && !(string2 = string3.substring(n5, n2).trim()).isEmpty()) {
            String string6 = SaveableItemBuilder.normalizeComponentValue(string2);
            if ("\"\"".equals(string6)) {
                string6 = "\" \"";
            }
            arrayList.add(string6);
        }
        return "[" + String.join((CharSequence)",", arrayList) + "]";
    }

    private static String fixTextComponentField(String string, String string2) {
        int n;
        String string3 = "\"" + string2 + "\":";
        int n2 = string.indexOf(string3);
        if (n2 == -1) {
            return string;
        }
        for (n = n2 + string3.length(); n < string.length() && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        if ("minecraft:lore".equals(string2)) {
            int n3 = n;
            if (n3 >= string.length() || string.charAt(n3) != '[') {
                return string;
            }
            int n4 = 0;
            boolean bl = false;
            boolean bl2 = false;
            int n5 = -1;
            for (int i = n3; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (bl2) {
                    bl2 = false;
                    continue;
                }
                if (c == '\\') {
                    bl2 = true;
                    continue;
                }
                if (c == '\"' || c == '\'') {
                    boolean bl3 = bl = !bl;
                }
                if (bl) continue;
                if (c == '[') {
                    ++n4;
                    continue;
                }
                if (c != ']' || --n4 != 0) continue;
                n5 = i;
                break;
            }
            if (n5 == -1) {
                return string;
            }
            String string4 = string.substring(n3, n5 + 1);
            String string5 = SaveableItemBuilder.fixLoreArray(SaveableItemBuilder.fixJSONComponent(string4));
            return string.substring(0, n3) + string5 + string.substring(n5 + 1);
        }
        char c = string.charAt(n);
        if (c == '\"') {
            int n6 = SaveableItemBuilder.findClosingQuote(string, n + 1);
            if (n6 == -1) {
                return string;
            }
            String string6 = string.substring(n, n6 + 1);
            String string7 = SaveableItemBuilder.normalizeComponentValue(string6);
            return string.substring(0, n) + string7 + string.substring(n6 + 1);
        }
        if (c == '\'') {
            int n7 = string.indexOf(39, n + 1);
            if (n7 == -1) {
                return string;
            }
            String string8 = string.substring(n, n7 + 1);
            String string9 = SaveableItemBuilder.normalizeComponentValue(string8);
            return string.substring(0, n) + string9 + string.substring(n7 + 1);
        }
        if (c == '{') {
            int n8 = SaveableItemBuilder.findMatchingBrace(string, n);
            if (n8 == -1) {
                return string;
            }
            String string10 = string.substring(n, n8 + 1);
            String string11 = SaveableItemBuilder.normalizeComponentValue(string10);
            return string.substring(0, n) + string11 + string.substring(n8 + 1);
        }
        return string;
    }

    private static String preStripComponentsInSNBT(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        String string2 = string;
        string2 = SaveableItemBuilder.removeComponentFieldFromSNBT(string2, "minecraft:custom_name");
        string2 = SaveableItemBuilder.removeComponentFieldFromSNBT(string2, "minecraft:lore");
        string2 = SaveableItemBuilder.removeComponentFieldFromSNBT(string2, "minecraft:tooltip_display");
        string2 = SaveableItemBuilder.removeComponentFieldFromSNBT(string2, "minecraft:block_entity_data");
        string2 = SaveableItemBuilder.removeComponentFieldFromSNBT(string2, "minecraft:attribute_modifiers");
        string2 = string2.replace("\"1b\"", "true").replace("\"0b\"", "false").replace(":1b", ":true").replace(":0b", ":false");
        return string2;
    }

    private static String removeComponentFieldFromSNBT(String string, String string2) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        String string3 = "\"" + string2 + "\":";
        int n = string.indexOf(string3);
        while (n != -1) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            for (n6 = n + string3.length(); n6 < string.length() && Character.isWhitespace(string.charAt(n6)); ++n6) {
            }
            if (n6 >= string.length()) break;
            char c = string.charAt(n6);
            if (c == '\"' || c == '\'') {
                n5 = c == '\"' ? SaveableItemBuilder.findClosingQuote(string, n6 + 1) : string.indexOf(39, n6 + 1);
                n4 = n5 == -1 ? n6 + 1 : n5 + 1;
            } else if (c == '{') {
                n5 = SaveableItemBuilder.findMatchingBrace(string, n6);
                n4 = n5 == -1 ? n6 + 1 : n5 + 1;
            } else if (c == '[') {
                n5 = 0;
                n3 = 0;
                n2 = 0;
                char c2 = '\u0000';
                int n7 = -1;
                for (int i = n6; i < string.length(); ++i) {
                    char c3 = string.charAt(i);
                    if (n2 != 0) {
                        n2 = 0;
                        continue;
                    }
                    if (c3 == '\\') {
                        n2 = 1;
                        continue;
                    }
                    if (c3 == '\"' || c3 == '\'') {
                        if (n3 == 0) {
                            n3 = 1;
                            c2 = c3;
                        } else if (c2 == c3) {
                            n3 = 0;
                        }
                    }
                    if (n3 != 0) continue;
                    if (c3 == '[') {
                        ++n5;
                        continue;
                    }
                    if (c3 != ']' || --n5 != 0) continue;
                    n7 = i;
                    break;
                }
                n4 = n7 == -1 ? n6 + 1 : n7 + 1;
            } else {
                for (n4 = n6; n4 < string.length() && ",}]".indexOf(string.charAt(n4)) == -1; ++n4) {
                }
            }
            n5 = n;
            n3 = Math.min(n4, string.length());
            if (n3 < string.length() && string.charAt(n3) == ',') {
                ++n3;
            } else {
                for (n2 = n5 - 1; n2 >= 0 && Character.isWhitespace(string.charAt(n2)); --n2) {
                }
                if (n2 >= 0 && string.charAt(n2) == ',') {
                    n5 = n2;
                }
            }
            string = string.substring(0, n5) + string.substring(n3);
            n = string.indexOf(string3);
        }
        return string;
    }

    private static String fixMalformedNBT(String string) {
        if (string == null || string.trim().isEmpty()) {
            return string;
        }
        String string2 = SaveableItemBuilder.preStripComponentsInSNBT(string);
        string2 = SaveableItemBuilder.fixJSONComponent(string2);
        return string2;
    }

    private static void sanitizeLore(ItemMeta itemMeta) {
        if (itemMeta == null) {
            return;
        }
        try {
            List list = itemMeta.getLore();
            if (list == null) {
                return;
            }
            boolean bl = false;
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                if (string != null && !string.isEmpty()) continue;
                list.set(i, " ");
                bl = true;
            }
            if (bl) {
                itemMeta.setLore(list);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static boolean isContainerType(Material material) {
        if (material == null) {
            return false;
        }
        if (material.name().endsWith("_SHULKER_BOX")) {
            return true;
        }
        switch (material) {
            case CHEST: 
            case TRAPPED_CHEST: 
            case BARREL: 
            case HOPPER: 
            case DISPENSER: 
            case DROPPER: 
            case FURNACE: 
            case BLAST_FURNACE: 
            case SMOKER: 
            case BREWING_STAND: 
            case JUKEBOX: {
                return true;
            }
        }
        return false;
    }

    private void logLoreState(ItemMeta itemMeta, String string, String string2) {
        try {
            List list = itemMeta.getLore();
            int n = 0;
            int n2 = 0;
            for (String string3 : list) {
                if (string3 == null) {
                    ++n;
                    continue;
                }
                if (!string3.isEmpty()) continue;
                ++n2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void defuseShulkerMeta(String string, String string2) {
        this.defuseContainerMeta(string, string2);
    }

    private void defuseContainerMeta(String string, String string2) {
        try {
            if (this.getItem() == null) {
                return;
            }
            Material material = this.getItem().getType();
            if (!SaveableItemBuilder.isContainerType(material)) {
                try {
                    NBT.modifyComponents(this.getItem(), readWriteNBT -> {
                        if (readWriteNBT.hasTag("minecraft:block_entity_data")) {
                            readWriteNBT.removeKey("minecraft:block_entity_data");
                        }
                    });
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
            try {
                NBT.modifyComponents(this.getItem(), readWriteNBT -> {
                    if (readWriteNBT.hasTag("minecraft:block_entity_data")) {
                        readWriteNBT.removeKey("minecraft:block_entity_data");
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                BlockStateMeta blockStateMeta;
                BlockState blockState;
                ItemMeta itemMeta = this.getItemMeta();
                if (itemMeta instanceof BlockStateMeta && (blockState = (blockStateMeta = (BlockStateMeta)itemMeta).getBlockState()) instanceof Container) {
                    Container container = (Container)blockState;
                    container.getInventory().clear();
                    blockStateMeta.setBlockState((BlockState)container);
                    this.setItemMeta((ItemMeta)blockStateMeta);
                }
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static /* synthetic */ void lambda$loadItem$3(ItemMeta itemMeta, ItemFlag itemFlag) {
        itemMeta.removeItemFlags(new ItemFlag[]{itemFlag});
    }
}

