/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.rewards;

import de.tr7zw.advancedcrates.nbtapi.NBT;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.config.SimpleConfig;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.rewards.ItemBuilder;
import me.PM2.AdvancedCrates.rewards.SaveableItemBuilder;
import me.PM2.AdvancedCrates.utils.Common;
import me.PM2.AdvancedCrates.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Reward
implements Comparable<Reward> {
    private final MonthlyCrate amc;
    private double chance = 1.0;
    private ItemStack reward;
    private ItemBuilder displayBuilder;
    private final SaveableItemBuilder builder;
    private List<Reward> linkedRewards = new ArrayList<Reward>();
    private List<String> linkedRewardsPaths = new ArrayList<String>();
    private String rewardPreviewName = "";
    private List<String> rewardPreviewLores = new ArrayList<String>();
    private boolean giveConfiguratedItem = false;
    private List<String> commands = new ArrayList<String>();
    private final String path;
    private final SimpleConfig config;
    private final String pathWithoutCrate;
    private final ItemBuilder itemBuilder;
    private boolean guaranteedReward = false;
    private double randomNumberMin = 0.0;
    private double randomNumberMax = 0.0;
    private double randomNumberValue = 0.0;
    private boolean randomNumberDoubleValue = false;
    private List<String> messagesToPlayer;

    public Reward(MonthlyCrate monthlyCrate, SimpleConfig simpleConfig, String string) {
        this.amc = monthlyCrate;
        this.builder = new SaveableItemBuilder(new ItemStack(Material.STONE));
        this.builder.loadItem(simpleConfig, string);
        if (simpleConfig.isSet(string + ".RandomNumberMin")) {
            this.randomNumberMin = simpleConfig.getDouble(string + ".RandomNumberMin");
        }
        if (simpleConfig.isSet(string + ".RandomNumberMax")) {
            this.randomNumberMax = simpleConfig.getDouble(string + ".RandomNumberMax");
        }
        if (simpleConfig.isSet(string + ".RandomNumberDecimals")) {
            this.randomNumberDoubleValue = simpleConfig.getBoolean(string + ".RandomNumberDecimals");
        }
        this.itemBuilder = this.builder.getItemBuilder();
        this.reward = this.builder.getItemStack();
        this.path = string;
        this.config = simpleConfig;
        this.pathWithoutCrate = string.substring(!string.contains(".") ? 0 : string.indexOf(".") + 1);
        if (simpleConfig.isSet(string + ".MessagesToPlayer")) {
            this.messagesToPlayer = simpleConfig.getStringList(string + ".MessagesToPlayer");
        }
        this.displayBuilder = this.itemBuilder.clone();
        ItemStack itemStack = this.displayBuilder.getItem();
        NBT.modify(itemStack, readWriteItemNBT -> readWriteItemNBT.setString("AMC", "Preview"));
        this.displayBuilder.setItem(itemStack);
        if (this.rewardPreviewName != null && !this.rewardPreviewName.isEmpty()) {
            this.displayBuilder.setName(this.getRewardPreviewName());
        }
        if (this.rewardPreviewLores != null && !this.rewardPreviewLores.isEmpty()) {
            this.displayBuilder.setLore(this.rewardPreviewLores);
        }
        if (simpleConfig.contains(this.getPath() + ".LinkedRewards")) {
            this.setLinkedRewardsPaths(simpleConfig.getStringList(this.getPath() + ".LinkedRewards"));
        }
    }

    public Reward(MonthlyCrate monthlyCrate, SimpleConfig simpleConfig, String string, boolean bl) {
        this.amc = monthlyCrate;
        this.builder = new SaveableItemBuilder(new ItemStack(Material.STONE));
        if (!bl) {
            this.builder.loadItem(simpleConfig, string);
        }
        this.itemBuilder = this.builder.getItemBuilder();
        this.reward = this.builder.getItemStack();
        this.path = string;
        this.config = simpleConfig;
        this.pathWithoutCrate = string.substring(!string.contains(".") ? 0 : string.indexOf(".") + 1);
    }

    public MonthlyCrate getAmc() {
        return this.amc;
    }

    public double getChance() {
        return this.chance;
    }

    public void setChance(double d) {
        this.chance = d;
    }

    public ItemStack getReward() {
        return this.reward;
    }

    public void updateRewardFromBuilder() {
        this.reward = this.builder.getItemStack();
    }

    public SaveableItemBuilder getSaveableItemBuilder() {
        return this.builder;
    }

    public void loadDisplayBuilderData() {
        if (this.displayBuilder != null) {
            if (this.getRewardPreviewName() != null && !this.getRewardPreviewName().isEmpty()) {
                this.displayBuilder.setName(Common.colorize(this.getRewardPreviewName()));
            } else {
                this.displayBuilder.setName(this.getItemBuilder().getDisplayName() != null ? this.getItemBuilder().getDisplayName() : "Set a custom name for this reward");
            }
            if (this.getRewardPreviewLores() != null && !this.getRewardPreviewLores().isEmpty()) {
                this.displayBuilder.setLore(Common.colorizeList(this.getRewardPreviewLores()));
            } else if (this.getItemBuilder().getLores() != null && !this.getItemBuilder().getLores().isEmpty()) {
                this.displayBuilder.setLore(Common.colorizeList(this.getItemBuilder().getLores()));
            }
        }
    }

    public String getRewardPreviewName() {
        return this.rewardPreviewName;
    }

    public void setRewardPreviewName(String string) {
        this.rewardPreviewName = string;
    }

    public List<String> getRewardPreviewLores() {
        return this.rewardPreviewLores;
    }

    public void setRewardPreviewLores(List<String> list) {
        this.rewardPreviewLores = list;
    }

    public boolean isGiveConfiguratedItem() {
        return this.giveConfiguratedItem;
    }

    public void setGiveConfiguratedItem(boolean bl) {
        this.giveConfiguratedItem = bl;
    }

    public ItemBuilder getDisplayBuilder() {
        return this.displayBuilder;
    }

    public void setDisplayBuilder(ItemBuilder itemBuilder) {
        this.displayBuilder = itemBuilder;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public List<String> getMessagesToPlayer() {
        return this.messagesToPlayer;
    }

    public void setCommands(List<String> list) {
        this.commands = list;
    }

    public String getPath() {
        return this.path;
    }

    public void writeToFile() {
        this.getSaveableItemBuilder().saveItem(this.config, this.getPath(), false);
        this.config.set(this.getPath() + ".GiveConfiguratedItem", this.isGiveConfiguratedItem());
        this.config.set(this.getPath() + ".LinkedRewards", this.getLinkedRewardsPaths());
        this.config.set(this.getPath() + ".Commands", this.getCommands());
        this.config.set(this.getPath() + ".Chance", this.getChance());
    }

    public String delete(boolean bl) {
        block0: for (Crate crate : MonthlyCrate.getCratesHandler().getCratesSet()) {
            for (Reward reward : crate.getLowRewards()) {
                if (!reward.equals(this)) continue;
                crate.getConfig().set(this.path, null);
                crate.getConfig().saveConfig();
                crate.getLowRewards().remove(reward);
                continue block0;
            }
        }
        return "";
    }

    public String getPathWithoutCrate() {
        return this.pathWithoutCrate;
    }

    public ItemBuilder getItemBuilder() {
        return this.itemBuilder;
    }

    public ItemStack giveConfiguratedItem() {
        return this.itemBuilder.getGiveConfiguratedItemReward();
    }

    public ItemStack getConfiguratedItem() {
        return this.itemBuilder.getGiveConfiguratedItemReward();
    }

    public boolean isGuaranteedReward() {
        return this.guaranteedReward;
    }

    public void setGuaranteedReward(boolean bl) {
        this.guaranteedReward = bl;
    }

    public double getRandomNumberMin() {
        return this.randomNumberMin;
    }

    public void setRandomNumberMin(double d) {
        this.randomNumberMin = d;
    }

    public double getRandomNumberMax() {
        return this.randomNumberMax;
    }

    public void setRandomNumberMax(double d) {
        this.randomNumberMax = d;
    }

    public boolean isRandomNumberDoubleValue() {
        return this.randomNumberDoubleValue;
    }

    public void setRandomNumberDoubleValue(boolean bl) {
        this.randomNumberDoubleValue = bl;
    }

    public List<Reward> getLinkedRewards() {
        return this.linkedRewards;
    }

    public void addLinkedReward(Reward reward) {
        this.linkedRewards.add(reward);
    }

    public void setLinkedRewards(List<Reward> list) {
        this.linkedRewards = list;
    }

    public List<String> getLinkedRewardsPaths() {
        return this.linkedRewardsPaths;
    }

    public void setLinkedRewardsPaths(List<String> list) {
        this.linkedRewardsPaths = list;
    }

    public void giveReward(final Player player, final Crate crate, final double d) {
        if (MonthlyCrate.defaultConfig.containsKey("Console_Opened_Crate_Rewards") && ((Boolean)MonthlyCrate.defaultConfig.get("Console_Opened_Crate_Rewards")).booleanValue() && this.itemBuilder != null && this.itemBuilder.hasDisplayName()) {
            Utils.log("[AdvancedCrates] " + player + " opened a " + this.itemBuilder.getDisplayName() + ". Reward path - " + this.getPath());
        }
        final String string = this.getPath();
        final List<String> list = this.getCommands();
        if (this.isGiveConfiguratedItem()) {
            if (player.getInventory().firstEmpty() == -1) {
                player.getWorld().dropItem(player.getLocation(), this.getConfiguratedItem());
            } else {
                Utils.addItemAndDropRest(player, this.getConfiguratedItem(), true);
            }
        }
        new BukkitRunnable(){

            public void run() {
                double d6 = d;
                for (String string5 : list) {
                    String string2;
                    if (string5.contains("%amount")) {
                        String[] stringArray = string5.split("%amount");
                        for (int i = 1; i < stringArray.length; ++i) {
                            boolean bl = true;
                            StringBuilder stringBuilder = new StringBuilder();
                            StringBuilder stringBuilder2 = new StringBuilder();
                            for (String string3 : stringArray[i].split("")) {
                                if (string3.equalsIgnoreCase("-")) {
                                    bl = false;
                                    continue;
                                }
                                if (string3.equalsIgnoreCase("%")) break;
                                if (!Utils.isInt(string3)) continue;
                                if (bl) {
                                    stringBuilder.append(string3);
                                    continue;
                                }
                                stringBuilder2.append(string3);
                            }
                            int n = Integer.parseInt(stringBuilder.toString());
                            int n2 = Integer.parseInt(stringBuilder2.toString());
                            try {
                                int n3;
                                String string3;
                                if (n2 - n == 0) {
                                    ++n2;
                                } else if (n2 - n < 0) {
                                    n3 = n2;
                                    n2 = n;
                                    n = n3;
                                }
                                n3 = ThreadLocalRandom.current().nextInt(n2 - n) + n;
                                string3 = "%amount" + stringBuilder + "-" + stringBuilder2 + "%";
                                string5 = string5.replaceAll(string3, n3 + "");
                                continue;
                            }
                            catch (Exception exception) {
                                System.out.println("The %amountX-X% placeholder is improperly formatted. Please use %amountX-Y where X is the starting value and Y is the ending (X is LESS THAN Y)");
                            }
                        }
                    }
                    if (string5.contains("%new_random_number%") || string5.contains("{new_random_number}") || d6 == 0.0) {
                        double d2;
                        block18: {
                            double d3;
                            double d4 = Reward.this.getRandomNumberMax();
                            d2 = d3 = Reward.this.getRandomNumberMin();
                            if (d4 < d3) {
                                MonthlyCrate.Errors.add("A Reward which path is ''" + Reward.this.getPath() + "'' RandomNumberMin is bigger than RandomNumberMax, please fix this, otherwise randomNumber will always be RandomNumberMin.");
                            }
                            if (d4 > 0.0 && d4 != d3) {
                                try {
                                    d2 = Reward.this.isRandomNumberDoubleValue() ? ThreadLocalRandom.current().nextDouble(d3, d4 + 0.01) : (double)ThreadLocalRandom.current().nextLong((long)d3, (long)d4 + 1L);
                                }
                                catch (Exception exception) {
                                    if (MonthlyCrate.debug) {
                                        System.out.println("AMC: " + exception.getStackTrace()[0].getLineNumber());
                                    }
                                    if (!MonthlyCrate.debug) break block18;
                                    System.out.println(exception);
                                }
                            }
                        }
                        d6 = d2;
                    }
                    double d5 = d6;
                    String string4 = string2 = crate != null ? crate.getPathPermissions().get(string) : "";
                    if (string2 == null || string2.isEmpty()) {
                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)string5.replace("%player_name%", player.getName()).replace("%player%", player.getName()).replaceAll("\\{player_name\\}", player.getName()).replaceAll("\\{new_random_number\\}", Reward.this.isRandomNumberDoubleValue() ? Double.toString(d5) : Long.toString((long)d5)).replaceAll("%new_random_number%", Reward.this.isRandomNumberDoubleValue() ? Double.toString(d5) : Long.toString((long)d5)).replaceAll("\\{random_number\\}", Reward.this.isRandomNumberDoubleValue() ? Double.toString(d != 0.0 ? d : d5) : Long.toString((long)((long)d != 0L ? d : d5))));
                        continue;
                    }
                    if (!player.hasPermission(string2)) continue;
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)string5.replace("%player_name%", player.getName()).replace("%player%", player.getName()).replaceAll("\\{player_name\\}", player.getName()).replaceAll("\\{random_number\\}", Reward.this.isRandomNumberDoubleValue() ? Double.toString(d != 0.0 ? d : d5) : Long.toString((long)((long)d != 0L ? d : d5))));
                }
            }
        }.runTask((Plugin)MonthlyCrate.getInstance());
        if (crate != null) {
            Object object;
            List<String> list2 = crate.getPathMessagesToPlayer().get(string);
            if (list2 != null) {
                object = list2.iterator();
                while (object.hasNext()) {
                    String string2 = (String)object.next();
                    Common.tell((CommandSender)player, string2.replace("%player_name%", player.getName()).replace("%player%", player.getName()).replaceAll("\\{player_name\\}", player.getName()));
                }
            }
            if ((object = crate.getPathBroadcastMessagesToPlayers().get(string)) != null) {
                for (Player player2 : Bukkit.getOnlinePlayers()) {
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        String string3 = (String)iterator.next();
                        Common.tell((CommandSender)player2, string3.replace("%player_name%", player.getName()).replace("%player%", player.getName()).replaceAll("\\{player_name\\}", player.getName()));
                    }
                }
            }
        }
        if (!this.getLinkedRewards().isEmpty()) {
            this.getLinkedRewards().forEach(reward -> reward.giveReward(player, crate, 0.0));
        }
    }

    @Override
    public int compareTo(Reward reward) {
        return (int)(this.getChance() * 10000.0 - reward.getChance() * 10000.0);
    }

    public double getRandomNumberValue() {
        return this.randomNumberValue;
    }

    public void setRandomNumberValue(double d) {
        this.randomNumberValue = d;
    }
}

