/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.rewards;

import com.cryptomorin.xseries.advancedcrates.SkullUtils;
import com.cryptomorin.xseries.advancedcrates.XMaterial;
import de.tr7zw.advancedcrates.nbtapi.NBT;
import de.tr7zw.advancedcrates.nbtapi.NBTCompound;
import de.tr7zw.advancedcrates.nbtapi.NBTItem;
import de.tr7zw.advancedcrates.nbtapi.utils.MinecraftVersion;
import de.tr7zw.advancedcrates.nbtapi.utils.nmsmappings.ReflectionMethod;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.PM2.AdvancedCrates.config.SimpleConfig;
import me.PM2.AdvancedCrates.rewards.CompressedEnchantment;
import me.PM2.AdvancedCrates.rewards.CompressedFireworkData;
import me.PM2.AdvancedCrates.rewards.CompressedPotionEffect;
import me.PM2.AdvancedCrates.rewards.DynamicMaterial;
import me.PM2.AdvancedCrates.rewards.EditableItem;
import me.PM2.AdvancedCrates.rewards.RGBColor;
import me.PM2.AdvancedCrates.rewards.SaveableItemBuilder;
import me.PM2.AdvancedCrates.utils.Common;
import me.PM2.AdvancedCrates.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class ItemBuilder
implements EditableItem {
    private ItemStack item;
    private String nbtTags = "";
    List<String> blacklistedPerms = new ArrayList<String>();
    boolean giveDisplayItem = false;
    private List<CompressedPotionEffect> potionEffects = new ArrayList<CompressedPotionEffect>();
    private RGBColor rgbColor;
    private List<String> lores = new ArrayList<String>();
    private List<CompressedEnchantment> enchantments = null;
    private ItemStack giveConfiguratedItemReward;
    private String base64texture = null;
    private CompressedFireworkData fireworkData = null;
    private boolean needsToBeSaved = false;
    private int amount = 1;
    private boolean unbreakable = false;
    private SaveableItemBuilder itemToSave = null;

    public ItemBuilder(Material material) {
        this.item = new ItemStack(material);
    }

    public ItemBuilder(String string) {
        this.item = Utils.getItem(string);
    }

    public ItemBuilder getItemBuilder() {
        return this;
    }

    public ItemBuilder(ItemBuilder itemBuilder) {
        this.item = new ItemStack(itemBuilder.getItemStack());
        if (itemBuilder.getBase64texture() != null && !itemBuilder.getBase64texture().equalsIgnoreCase("")) {
            this.setBase64texture(itemBuilder.getBase64texture());
        }
        this.updateFromItem(this.item);
        this.potionEffects.addAll(itemBuilder.getPotionEffects());
        this.reapplyPotionEffects();
    }

    public ItemBuilder(SaveableItemBuilder saveableItemBuilder) {
        this.item = new ItemStack(saveableItemBuilder.getItemStack());
        if (saveableItemBuilder.getBase64texture() != null && !saveableItemBuilder.getBase64texture().equalsIgnoreCase("")) {
            this.setBase64texture(saveableItemBuilder.getBase64texture());
        }
        this.updateFromItem(this.item);
        this.potionEffects.addAll(saveableItemBuilder.getPotionEffects());
        this.reapplyPotionEffects();
    }

    public ItemBuilder(ItemStack itemStack) {
        this.item = itemStack.clone();
    }

    @Override
    public List<CompressedPotionEffect> getPotionEffects() {
        if (this.potionEffects == null) {
            this.potionEffects = new ArrayList<CompressedPotionEffect>();
        }
        return this.potionEffects;
    }

    public void setItemStack(ItemStack itemStack) {
        this.item = itemStack;
    }

    @Override
    public List<ItemFlag> getItemFlags() {
        return new ArrayList<ItemFlag>(this.item.getItemMeta().getItemFlags());
    }

    public void setNBTTags(String string) {
        this.nbtTags = string;
    }

    @Override
    public String getNBTTags() {
        if (this.nbtTags == null) {
            this.nbtTags = "";
        }
        return this.nbtTags;
    }

    @Override
    public void reapplyNBTTags() {
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_14_R1)) {
            if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_16_R1)) {
                Iterator iterator = this.getItemMeta().getPersistentDataContainer().getKeys().iterator();
                while (iterator.hasNext()) {
                    this.getItemMeta().getPersistentDataContainer().remove((NamespacedKey)iterator.next());
                }
            } else {
                Map map = (Map)ReflectionMethod.CRAFT_PERSISTENT_DATA_CONTAINER_GET_MAP.run(this.getItemMeta().getPersistentDataContainer(), new Object[0]);
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    this.getItemMeta().getPersistentDataContainer().remove((NamespacedKey)iterator.next());
                }
            }
        }
        if (this.nbtTags != null && !this.nbtTags.isEmpty()) {
            this.setItem(Bukkit.getUnsafe().modifyItemStack(this.getItem(), this.nbtTags));
        }
    }

    public void reset() {
        this.getEnchantments().clear();
        this.nbtTags = null;
        this.lores.clear();
        this.rgbColor = null;
        this.fireworkData = null;
    }

    @Override
    public void updateFromItem() {
        Object object4;
        Object object2;
        Object object3;
        this.reset();
        ItemStack itemStack = new ItemStack(this.getItem().getType());
        if (MinecraftVersion.isOlderOrEqualThanVersion(MinecraftVersion.MC1_20_R3)) {
            object3 = new NBTItem(this.getItem());
            ((NBTItem)object3).mergeCustomNBT(itemStack);
            try {
                if (((NBTCompound)object3).hasKey("display").booleanValue()) {
                    ((NBTCompound)object3).removeKey("display");
                }
                if (((NBTCompound)object3).hasKey("SkullOwner").booleanValue()) {
                    object2 = new NBTItem(this.getItem()).getCompound("SkullOwner");
                    if (((NBTCompound)object2).hasKey("Name").booleanValue()) {
                        ((NBTCompound)object2).removeKey("Name");
                    }
                    ((NBTCompound)object3).mergeCompound((NBTCompound)object2);
                }
                itemStack = ((NBTItem)object3).getItem();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (new NBTItem(itemStack).getCompound() != null) {
                this.setNBTTags(new NBTItem(itemStack).getCompound().toString());
            }
        } else {
            this.setNBTTags(NBT.itemStackToNBT(itemStack).toString());
        }
        if (this.item.getItemMeta() instanceof FireworkMeta) {
            object3 = (FireworkMeta)this.item.getItemMeta();
            this.fireworkData = new CompressedFireworkData(object3.getEffects(), object3.getPower());
            object3.clearEffects();
            this.setItemMeta((ItemMeta)object3);
            this.setItem(this.fireworkData.applyTo(this.getItemStack()));
        }
        if (this.getItemMeta() instanceof EnchantmentStorageMeta) {
            object2 = (EnchantmentStorageMeta)this.getItemMeta();
            object3 = object2.getStoredEnchants();
        } else {
            object3 = this.item.getEnchantments();
        }
        object3.forEach(this::addEnchantment);
        for (Object object4 : object3.keySet()) {
            if (object4 == null || !Arrays.asList(Enchantment.values()).contains(object4)) continue;
            this.item.addEnchantment(object4, ((Integer)object3.get(object4)).intValue());
        }
        if (this.item.hasItemMeta() && this.getItemMeta() instanceof PotionMeta) {
            object2 = (PotionMeta)this.getItemMeta();
            if (!MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_9_R1)) {
                Object object5;
                object4 = Potion.fromItemStack((ItemStack)this.item);
                try {
                    object5 = Potion.fromItemStack((ItemStack)this.item);
                    object5.getEffects().clear();
                    object5.apply(this.item);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (object4 != null && object4.getType() != null) {
                    this.addPotionEffect(new CompressedPotionEffect(object4.getType().getEffectType(), 1, 1));
                    object5 = new ArrayList();
                    for (PotionEffect potionEffect : object4.getEffects()) {
                        ((ArrayList)object5).add(new CompressedPotionEffect(potionEffect.getType(), potionEffect.getDuration(), potionEffect.getAmplifier()));
                    }
                    Iterator iterator = ((ArrayList)object5).iterator();
                    while (iterator.hasNext()) {
                        PotionEffect potionEffect;
                        potionEffect = (CompressedPotionEffect)((Object)iterator.next());
                        this.addPotionEffect((CompressedPotionEffect)potionEffect);
                    }
                }
            }
        }
        if (this.item.hasItemMeta() && this.item.getItemMeta().hasLore()) {
            for (Object object4 : this.item.getItemMeta().getLore()) {
                this.addLore((String)object4);
            }
        }
        if (this.item.hasItemMeta() && this.item.getItemMeta().getItemFlags() != null) {
            for (Object object4 : this.item.getItemMeta().getItemFlags()) {
                this.addItemFlag((ItemFlag)object4);
            }
        }
        if (this.getItemMeta() instanceof LeatherArmorMeta) {
            object2 = (LeatherArmorMeta)this.getItemMeta();
            object4 = new RGBColor(object2.getColor().getRed(), object2.getColor().getGreen(), object2.getColor().getBlue());
            this.setColor((RGBColor)object4);
        }
        if (this.getItemMeta() instanceof PotionMeta && MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_9_R1)) {
            object2 = (PotionMeta)this.getItemMeta();
            object4 = new RGBColor(object2.getColor().getRed(), object2.getColor().getGreen(), object2.getColor().getBlue());
            this.setColor((RGBColor)object4);
        }
        if (this.getItemMeta() instanceof SkullMeta && this.getBase64texture() != null && !this.getBase64texture().equals("")) {
            this.item.setItemMeta((ItemMeta)SkullUtils.applySkin(this.item.getItemMeta(), this.getBase64texture()));
        }
        if (this.item.getItemMeta() instanceof FireworkMeta) {
            this.setItem(this.fireworkData.applyTo(this.getItem()));
        }
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_20_R4)) {
            this.setItemStack(NBT.itemStackFromNBT(NBT.parseNBT(this.getNBTTags())));
        }
    }

    public void updateFromItem(ItemStack itemStack) {
        Object object;
        Object object2;
        Object object3;
        this.item = itemStack;
        this.reset();
        ItemStack itemStack2 = new ItemStack(itemStack.getType());
        if (MinecraftVersion.isOlderOrEqualThanVersion(MinecraftVersion.MC1_20_R3)) {
            object3 = new NBTItem(itemStack);
            ((NBTItem)object3).mergeCustomNBT(itemStack2);
            try {
                if (((NBTCompound)object3).hasKey("display").booleanValue()) {
                    ((NBTCompound)object3).removeKey("display");
                }
                if (((NBTCompound)object3).hasKey("SkullOwner").booleanValue() && ((NBTCompound)(object2 = new NBTItem(itemStack))).getCompound("SkullOwner") != null) {
                    object = new NBTItem(itemStack).getCompound("SkullOwner");
                    if (((NBTCompound)object).hasKey("Name").booleanValue()) {
                        ((NBTCompound)object).removeKey("Name");
                    }
                    ((NBTCompound)object3).mergeCompound((NBTCompound)object);
                }
                itemStack2 = ((NBTItem)object3).getItem();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (new NBTItem(itemStack2).getCompound() != null) {
                this.setNBTTags(new NBTItem(itemStack2).getCompound().toString());
            }
        } else {
            this.setNBTTags(NBT.itemStackToNBT(itemStack2).toString());
        }
        if (this.item.getItemMeta() instanceof FireworkMeta) {
            object3 = (FireworkMeta)this.item.getItemMeta();
            this.fireworkData = new CompressedFireworkData(object3.getEffects(), object3.getPower());
            object3.clearEffects();
            this.setItemMeta((ItemMeta)object3);
            this.setItem(this.fireworkData.applyTo(this.getItemStack()));
        }
        if (this.getItemMeta() instanceof EnchantmentStorageMeta) {
            object2 = (EnchantmentStorageMeta)this.getItemMeta();
            object3 = object2.getStoredEnchants();
        } else {
            object3 = this.item.getEnchantments();
        }
        object3.keySet().forEach(enchantment -> System.out.println(enchantment.toString()));
        object3.forEach(this::addEnchantment);
        object2 = object3.keySet().iterator();
        while (object2.hasNext()) {
            object = (Enchantment)object2.next();
            if (object == null || !Arrays.asList(Enchantment.values()).contains(object)) continue;
            this.item.addUnsafeEnchantment((Enchantment)object, ((Integer)object3.get(object)).intValue());
        }
        if (this.item.hasItemMeta() && this.getItemMeta() instanceof PotionMeta) {
            object2 = (PotionMeta)this.getItemMeta();
            if (!MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_9_R1)) {
                Object object4;
                object = Potion.fromItemStack((ItemStack)this.item);
                try {
                    object4 = Potion.fromItemStack((ItemStack)this.item);
                    object4.getEffects().clear();
                    object4.apply(this.item);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (object != null && object.getType() != null) {
                    this.addPotionEffect(new CompressedPotionEffect(object.getType().getEffectType(), 1, 1));
                    object4 = new ArrayList();
                    for (PotionEffect potionEffect : object.getEffects()) {
                        ((ArrayList)object4).add(new CompressedPotionEffect(potionEffect.getType(), potionEffect.getDuration(), potionEffect.getAmplifier()));
                    }
                    Iterator iterator = ((ArrayList)object4).iterator();
                    while (iterator.hasNext()) {
                        PotionEffect potionEffect;
                        potionEffect = (CompressedPotionEffect)((Object)iterator.next());
                        this.addPotionEffect((CompressedPotionEffect)potionEffect);
                    }
                }
            }
        }
        if (this.item.hasItemMeta() && this.item.getItemMeta().hasLore()) {
            object2 = this.item.getItemMeta().getLore().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                this.addLore((String)object);
            }
        }
        if (this.item.hasItemMeta() && this.item.getItemMeta().getItemFlags() != null) {
            object2 = this.item.getItemMeta().getItemFlags().iterator();
            while (object2.hasNext()) {
                object = (ItemFlag)object2.next();
                this.addItemFlag((ItemFlag)object);
            }
        }
        if (this.getItemMeta() instanceof LeatherArmorMeta) {
            object2 = (LeatherArmorMeta)this.getItemMeta();
            object = new RGBColor(object2.getColor().getRed(), object2.getColor().getGreen(), object2.getColor().getBlue());
            this.setColor((RGBColor)object);
        }
        if (this.getItemMeta() instanceof PotionMeta && MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_9_R1) && (object2 = (PotionMeta)this.getItemMeta()).hasColor()) {
            object = new RGBColor(object2.getColor().getRed(), object2.getColor().getGreen(), object2.getColor().getBlue());
            this.setColor((RGBColor)object);
        }
        if (this.getItemMeta() instanceof SkullMeta && this.getBase64texture() != null && !this.getBase64texture().equals("")) {
            this.item.setItemMeta((ItemMeta)SkullUtils.applySkin(this.item.getItemMeta(), this.getBase64texture()));
        }
        if (this.item.getItemMeta() instanceof FireworkMeta) {
            this.setItem(this.fireworkData.applyTo(itemStack));
        }
        if ((itemStack.getItemMeta() != null && MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_11_R1) && itemStack.getDurability() != 0 && itemStack.getItemMeta().isUnbreakable() || itemStack.getItemMeta() != null && MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_14_R1) && itemStack.getItemMeta().hasCustomModelData()) && itemStack.getItemMeta() != null && itemStack.getItemMeta().hasCustomModelData()) {
            this.setCustomModelData(itemStack.getItemMeta().getCustomModelData());
        }
    }

    public void setGiveDisplayItem(boolean bl) {
        this.giveDisplayItem = bl;
    }

    public boolean getGiveDisplayItem() {
        return this.giveDisplayItem;
    }

    public String getDisplayName() {
        if (this.item.hasItemMeta() && this.item.getItemMeta().hasDisplayName() && !this.item.getItemMeta().getDisplayName().isEmpty()) {
            return this.item.getItemMeta().getDisplayName();
        }
        return Utils.getDefaultItemName(this.item);
    }

    public boolean hasDisplayName() {
        return this.item.getItemMeta().hasDisplayName();
    }

    public ItemBuilder(Material material, int n, byte by) {
        this.item = new ItemStack(material, n, (short)by);
    }

    public ItemBuilder(XMaterial xMaterial) {
        this.item = xMaterial.parseItem();
    }

    public ItemStack getItemStack() {
        return this.item;
    }

    public ItemBuilder clone() {
        return new ItemBuilder(this.item);
    }

    public ItemBuilder setDurability(int n) {
        this.item.setDurability((short)((byte)n));
        return this;
    }

    public ItemBuilder setUnbreakable(boolean bl) {
        ItemMeta itemMeta = this.getItemMeta();
        try {
            if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_13_R1)) {
                itemMeta.setUnbreakable(bl);
            } else {
                Object object = itemMeta.getClass().getMethod("spigot", new Class[0]).invoke((Object)itemMeta, new Object[0]);
                Method method = object.getClass().getMethod("setUnbreakable", Boolean.TYPE);
                method.invoke(object, true);
            }
            this.setItemMeta(itemMeta);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this;
    }

    @Override
    public ItemBuilder setName(String string) {
        if (string == null || this.item == null || this.item.getItemMeta() == null) {
            return this;
        }
        ItemMeta itemMeta = this.item.getItemMeta();
        itemMeta.setDisplayName(this.colorize(string));
        this.item.setItemMeta(itemMeta);
        return this;
    }

    public void loadEnchants(SimpleConfig simpleConfig, String string) {
        if (simpleConfig.contains(string.equals("") ? "Enchantments" : string + ".Enchantments")) {
            for (String string2 : simpleConfig.getStringList(string.equals("") ? "Enchantments" : string + ".Enchantments")) {
                try {
                    CompressedEnchantment compressedEnchantment = CompressedEnchantment.fromString(string2);
                    this.addEnchantment(compressedEnchantment);
                }
                catch (Exception exception) {
                    System.out.println(string2 + " is not formatted enchant;level or either the enchant is not a valid enchantment or the level is not a number.");
                }
            }
        }
    }

    public ItemBuilder addUnsafeEnchantment(Enchantment enchantment, int n) {
        this.item.addUnsafeEnchantment(enchantment, n);
        return this;
    }

    public ItemBuilder hideEnchants() {
        ItemMeta itemMeta = this.item.getItemMeta();
        assert (itemMeta != null);
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        this.item.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder removeEnchantment(Enchantment enchantment) {
        this.item.removeEnchantment(enchantment);
        return this;
    }

    public ItemBuilder addAutomaticLore(String string, int n, String string2) {
        return this.addAutomaticLore(string, n, false, string2);
    }

    public ItemBuilder addAutomaticLore(String string, int n, boolean bl, String string2) {
        String[] stringArray = string2.split(" ");
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = "";
        for (String string4 : stringArray) {
            int n3 = string4.length();
            if (n2 + n3 <= n) {
                n2 += n3 + 1;
                stringBuilder.append(string4).append(" ");
                continue;
            }
            if (bl) {
                string = this.lastChatColor(string3);
            }
            String string5 = string + stringBuilder.substring(0, stringBuilder.length() - 1);
            this.addLoreLine(string5);
            stringBuilder = new StringBuilder(string4 + " ");
            n2 = n3;
            string3 = string5;
        }
        if (bl) {
            string = this.lastChatColor(string3);
        }
        if (n2 != 0) {
            this.addLoreLine(string + stringBuilder.substring(0, stringBuilder.length() - 1));
        }
        return this;
    }

    public String lastChatColor(String string) {
        String string2 = this.fromChatColor(string);
        int n = string2.lastIndexOf(38);
        if (n < 0 || n == string2.length() - 1) {
            return ItemBuilder.toChatColor("&f");
        }
        return ItemBuilder.toChatColor(string2.substring(n, n + 2));
    }

    public static String toChatColor(String string) {
        string = string.replace("<!!special_chat_encoding!!>", "\ufffd");
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public void setBlacklistedPermissions(List<String> list) {
        this.blacklistedPerms = list;
    }

    public List<String> getBlacklistedPermissions() {
        return this.blacklistedPerms;
    }

    public ItemBuilder setSkullOwner(String string) {
        try {
            SkullMeta skullMeta = (SkullMeta)this.item.getItemMeta();
            skullMeta.setOwner(string);
            this.item.setItemMeta((ItemMeta)skullMeta);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return this;
    }

    public void addPotionEffect(CompressedPotionEffect compressedPotionEffect) {
        this.getPotionEffects().add(compressedPotionEffect);
        this.reapplyPotionEffects();
    }

    @Override
    public void reapplyPotionEffects() {
        if (!(this.getItemMeta() instanceof PotionMeta)) {
            return;
        }
        PotionMeta potionMeta = (PotionMeta)this.getItemMeta();
        potionMeta.clearCustomEffects();
        if (!this.getPotionEffects().isEmpty() && !MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_9_R1)) {
            boolean bl = true;
            CompressedPotionEffect compressedPotionEffect = this.getPotionEffects().get(0);
            Potion potion = new Potion(PotionType.getByEffect((PotionEffectType)compressedPotionEffect.getType()), compressedPotionEffect.getAmplifier() == 0 ? 1 : 2, DynamicMaterial.fromItemStack(this.item) == DynamicMaterial.SPLASH_POTION);
            potion.apply(this.item);
            for (CompressedPotionEffect compressedPotionEffect2 : this.getPotionEffects()) {
                if (!bl) {
                    this.item = compressedPotionEffect2.applyTo(this.item);
                }
                bl = false;
            }
        }
        this.setItemMeta((ItemMeta)potionMeta);
    }

    public void addEnchantment(Enchantment enchantment, int n) {
        this.addEnchantment(new CompressedEnchantment(enchantment, n));
        this.reapplyEnchantments();
    }

    public void addEnchantment(CompressedEnchantment compressedEnchantment) {
        this.getEnchantments().add(compressedEnchantment);
        this.reapplyEnchantments();
    }

    public ItemBuilder setInfinityDurability() {
        this.item.setDurability((short)Short.MAX_VALUE);
        return this;
    }

    @Override
    public void addItemFlag(ItemFlag itemFlag) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.addItemFlags(new ItemFlag[]{itemFlag});
        this.setItemMeta(itemMeta);
    }

    @Override
    public void removeItemFlag(ItemFlag itemFlag) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.removeItemFlags(new ItemFlag[]{itemFlag});
        this.setItemMeta(itemMeta);
    }

    @Override
    public void reapplyItemFlags() {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.getItemFlags().clear();
        for (ItemFlag itemFlag : this.getItemFlags()) {
            itemMeta.addItemFlags(new ItemFlag[]{itemFlag});
        }
        this.setItemMeta(itemMeta);
    }

    @Override
    public boolean isColorable() {
        return this.getItemMeta() instanceof LeatherArmorMeta || this.getItemMeta() instanceof PotionMeta && MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_9_R1);
    }

    @Override
    public void setColor(RGBColor rGBColor) {
        this.rgbColor = rGBColor;
        this.reapplyColor();
    }

    @Override
    public void reapplyColor() {
        if (this.isColorable() && this.getColor() != null) {
            if (this.getItemMeta() instanceof LeatherArmorMeta) {
                LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)this.getItemMeta();
                leatherArmorMeta.setColor(Color.fromRGB((int)this.getColor().getR(), (int)this.getColor().getG(), (int)this.getColor().getB()));
                this.setItemMeta((ItemMeta)leatherArmorMeta);
            } else {
                PotionMeta potionMeta = (PotionMeta)this.getItemMeta();
                potionMeta.setColor(Color.fromRGB((int)this.getColor().getR(), (int)this.getColor().getG(), (int)this.getColor().getB()));
                this.setItemMeta((ItemMeta)potionMeta);
            }
        }
    }

    @Override
    public RGBColor getColor() {
        if (this.isColorable()) {
            if (this.rgbColor == null) {
                RGBColor rGBColor = new RGBColor(160, 101, 64);
                this.setColor(rGBColor);
            }
            return this.rgbColor;
        }
        return null;
    }

    public ItemBuilder setLore(String ... stringArray) {
        ItemMeta itemMeta = this.item.getItemMeta();
        itemMeta.setLore(this.colorizeList(Arrays.asList(stringArray)));
        this.item.setItemMeta(itemMeta);
        this.lores = Arrays.asList(stringArray);
        return this;
    }

    public ItemBuilder setLore(List<String> list) {
        ItemMeta itemMeta = this.item.getItemMeta();
        itemMeta.setLore(this.colorizeList(list));
        this.item.setItemMeta(itemMeta);
        return this;
    }

    @Override
    public List<String> getLores() {
        if (this.item.getItemMeta().getLore() != null) {
            return this.item.getItemMeta().getLore();
        }
        return new ArrayList<String>();
    }

    public List<String> getLoresToSave() {
        if (this.item.getItemMeta().getLore() != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : this.item.getItemMeta().getLore()) {
                arrayList.add(string.replace("\ufffd", "&"));
            }
            return arrayList;
        }
        return new ArrayList<String>();
    }

    public ItemBuilder addLore(String string) {
        this.getLore().add(string);
        this.reapplyLore();
        return this;
    }

    public List<String> getLore() {
        if (this.lores == null) {
            this.lores = new ArrayList<String>();
        }
        return this.lores;
    }

    public ItemBuilder clearLore() {
        this.getLore().clear();
        this.reapplyLore();
        return this;
    }

    public void reapplyLore() {
        ItemMeta itemMeta = this.getItemMeta();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.getLore()) {
            arrayList.add(Common.colorize(string));
        }
        itemMeta.setLore(arrayList);
        this.setItemMeta(itemMeta);
    }

    public ItemBuilder removeLoreLine(String string) {
        ItemMeta itemMeta = this.item.getItemMeta();
        ArrayList<String> arrayList = new ArrayList<String>(itemMeta.getLore());
        if (!arrayList.contains(string)) {
            return this;
        }
        arrayList.remove(string);
        itemMeta.setLore(this.colorizeList(arrayList));
        this.item.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder removeLoreLine(int n) {
        ItemMeta itemMeta = this.item.getItemMeta();
        ArrayList<String> arrayList = new ArrayList<String>(itemMeta.getLore());
        if (n >= 0 && n <= arrayList.size()) {
            arrayList.remove(n);
            itemMeta.setLore(this.colorizeList(arrayList));
            this.item.setItemMeta(itemMeta);
            return this;
        }
        return this;
    }

    public ItemBuilder addLoreLine(String string) {
        ItemMeta itemMeta = this.item.getItemMeta();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (itemMeta.hasLore()) {
            arrayList = new ArrayList(itemMeta.getLore());
        }
        arrayList.add(string);
        itemMeta.setLore(this.colorizeList(arrayList));
        this.item.setItemMeta(itemMeta);
        this.lores = arrayList;
        return this;
    }

    public ItemBuilder addLoreLine(String string, int n) {
        ItemMeta itemMeta = this.item.getItemMeta();
        ArrayList<String> arrayList = new ArrayList<String>(itemMeta.getLore());
        arrayList.set(n, string);
        itemMeta.setLore(this.colorizeList(arrayList));
        this.item.setItemMeta(itemMeta);
        this.lores = arrayList;
        return this;
    }

    public ItemBuilder setLeatherArmorColor(Color color) {
        try {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)this.item.getItemMeta();
            leatherArmorMeta.setColor(color);
            this.item.setItemMeta((ItemMeta)leatherArmorMeta);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return this;
    }

    public ItemMeta getItemMeta() {
        return this.item.getItemMeta();
    }

    public void setItemMeta(ItemMeta itemMeta) {
        this.item.setItemMeta(itemMeta);
    }

    public void addNBT(String string, String string2) {
        NBTItem nBTItem = new NBTItem(this.getItem());
        nBTItem.setString(string, string2);
        this.setItemStack(nBTItem.getItem());
    }

    public ItemStack toItemStack() {
        return this.item;
    }

    @Override
    public ItemBuilder setGlow(boolean bl) {
        ItemMeta itemMeta;
        if (this.item == null && this.getMaterial() != null) {
            this.item = new ItemStack(this.getMaterial());
        }
        if ((itemMeta = this.item.getItemMeta()) == null) {
            this.item.setItemMeta(Bukkit.getItemFactory().getItemMeta(this.item.getType()));
        }
        if (bl) {
            assert (itemMeta != null);
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            this.item.setItemMeta(itemMeta);
            this.item.addUnsafeEnchantment(Enchantment.THORNS, 1);
        } else if (itemMeta != null) {
            if (itemMeta.getItemFlags().contains(ItemFlag.HIDE_ENCHANTS)) {
                itemMeta.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            this.item.setItemMeta(itemMeta);
            if (this.item.getItemMeta().hasEnchant(Enchantment.THORNS)) {
                this.item.removeEnchantment(Enchantment.THORNS);
            }
        }
        return this;
    }

    @Override
    public boolean isGlowing() {
        return !this.item.getEnchantments().isEmpty();
    }

    public String getDisplayNameFromChatColor() {
        return this.fromChatColor(this.getDisplayName());
    }

    public String fromChatColor(String string) {
        return string.replace("\u00a7", "&");
    }

    public static String fromChatColorStatic(String string) {
        return string.replace("\u00a7", "&");
    }

    @Override
    public List<CompressedEnchantment> getEnchantments() {
        if (this.enchantments == null) {
            this.enchantments = new ArrayList<CompressedEnchantment>();
        }
        return this.enchantments;
    }

    private String colorize(String string) {
        if (string == null) {
            return "";
        }
        return Common.colorize(string);
    }

    private List<String> colorizeList(List<String> list) {
        int n = list.size();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.colorize(list.get(i)));
        }
        return arrayList;
    }

    public void setCustomModelData(int n) {
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_14_R1)) {
            ItemMeta itemMeta = this.getItemMeta();
            itemMeta.setCustomModelData(Integer.valueOf(n));
            itemMeta.setUnbreakable(true);
            this.item.setItemMeta(itemMeta);
        } else if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_11_R1)) {
            this.item.setDurability((short)n);
            ItemMeta itemMeta = this.getItemMeta();
            itemMeta.setUnbreakable(true);
            this.item.setItemMeta(itemMeta);
        }
    }

    public Material getMaterial() {
        return this.item.getType();
    }

    public void setMaterial(Material material) {
        this.item.setType(material);
    }

    @Override
    public int getDamage() {
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_13_R1) && this.getItemMeta() instanceof Damageable) {
            Damageable damageable = (Damageable)this.getItemMeta();
            return damageable.getDamage();
        }
        return this.getItemStack().getDurability();
    }

    public boolean hasNBTTagKey(String string) {
        if (MinecraftVersion.isOlderOrEqualThanVersion(MinecraftVersion.MC1_20_R3)) {
            return new NBTItem(this.getItem()).getKeys().contains(string);
        }
        return NBT.hasTrueTag(this.getItem(), string);
    }

    public void setPlayerHeadName(String string) {
        if (XMaterial.PLAYER_HEAD.isSimilar(this.getItemStack()) && Character.isLetterOrDigit(string.charAt(0))) {
            SkullMeta skullMeta = (SkullMeta)this.getItemMeta();
            try {
                UUID uUID = UUID.fromString(string);
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uUID);
                skullMeta.setOwningPlayer(offlinePlayer);
            }
            catch (Exception exception) {
                skullMeta.setOwner(string);
            }
            this.setItemMeta((ItemMeta)skullMeta);
        }
    }

    @Override
    public void setDamage(int n) {
        if (n == 0 && this.getDamage() == 0) {
            return;
        }
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_13_R1) && this.getItemMeta() instanceof Damageable) {
            Damageable damageable = (Damageable)this.getItemMeta();
            damageable.setDamage(n);
            this.setItemMeta((ItemMeta)damageable);
        } else {
            this.getItemStack().setDurability((short)n);
        }
    }

    @Override
    public String getName(boolean bl) {
        return bl ? Utils.removeColor(this.getItemMeta().getDisplayName()) : this.getItemMeta().getDisplayName();
    }

    @Override
    public ItemStack getItem() {
        return this.item;
    }

    @Override
    public void setItem(ItemStack itemStack) {
        this.item = itemStack;
    }

    @Override
    public void reapplyLores() {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.setLore(this.lores);
        this.getItem().setItemMeta(itemMeta);
    }

    @Override
    public void reapplyEnchantments() {
        for (Enchantment object : this.item.getEnchantments().keySet()) {
            this.getItemMeta().removeEnchant(object);
        }
        for (CompressedEnchantment compressedEnchantment : this.getEnchantments()) {
            compressedEnchantment.applyTo(this);
        }
    }

    public ItemStack getGiveConfiguratedItemReward() {
        return this.giveConfiguratedItemReward;
    }

    public void setGiveConfiguratedItemReward(ItemStack itemStack) {
        this.giveConfiguratedItemReward = itemStack;
    }

    public void setItemToSave(ItemStack itemStack) {
        this.itemToSave = new SaveableItemBuilder(itemStack);
    }

    public SaveableItemBuilder getItemToSave() {
        return this.itemToSave;
    }

    public String getBase64texture() {
        return this.base64texture;
    }

    public void setBase64texture(String string) {
        this.base64texture = string;
    }

    public boolean isNeedsToBeSaved() {
        return this.needsToBeSaved;
    }

    public void setNeedsToBeSaved(boolean bl) {
        this.needsToBeSaved = bl;
    }

    public void setAmount(int n) {
        this.amount = n;
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean isUnbreakable() {
        return this.unbreakable;
    }
}

