/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.rewards;

import java.util.Collections;
import java.util.List;
import org.bukkit.FireworkEffect;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class CompressedFireworkData {
    int power;
    List<FireworkEffect> effectList;
    boolean isStar = false;

    public CompressedFireworkData(List<FireworkEffect> list, int n) {
        this.effectList = list;
        this.power = n;
    }

    public CompressedFireworkData(List<FireworkEffect> list, int n, boolean bl) {
        this.effectList = list;
        this.power = n;
        this.isStar = bl;
    }

    public CompressedFireworkData(FireworkEffect fireworkEffect) {
        this.effectList = Collections.singletonList(fireworkEffect);
    }

    public CompressedFireworkData(FireworkEffect fireworkEffect, boolean bl) {
        this.effectList = Collections.singletonList(fireworkEffect);
        this.isStar = bl;
    }

    public int getPower() {
        return this.power;
    }

    public List<FireworkEffect> getEffectList() {
        return this.effectList;
    }

    public void setPower(int n) {
        this.power = n;
    }

    public void setEffectList(List<FireworkEffect> list) {
        this.effectList = list;
    }

    public void setEffectList(FireworkEffect fireworkEffect) {
        this.effectList = Collections.singletonList(fireworkEffect);
    }

    ItemStack applyTo(ItemStack itemStack) {
        if (itemStack.getItemMeta() instanceof FireworkMeta) {
            FireworkMeta fireworkMeta = (FireworkMeta)itemStack.getItemMeta();
            fireworkMeta.setPower(this.power);
            fireworkMeta.addEffects(this.effectList);
            itemStack.setItemMeta((ItemMeta)fireworkMeta);
        } else if (itemStack.getItemMeta() instanceof FireworkEffectMeta) {
            FireworkEffectMeta fireworkEffectMeta = (FireworkEffectMeta)itemStack.getItemMeta();
            fireworkEffectMeta.setEffect(this.effectList.get(0));
            itemStack.setItemMeta((ItemMeta)fireworkEffectMeta);
        }
        return itemStack;
    }
}

