/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.rewards;

import com.cryptomorin.xseries.advancedcrates.XEnchantment;
import de.tr7zw.advancedcrates.nbtapi.utils.MinecraftVersion;
import java.util.Arrays;
import java.util.Optional;
import me.PM2.AdvancedCrates.rewards.ItemBuilder;
import me.PM2.AdvancedCrates.utils.VersionUtils;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class CompressedEnchantment {
    private final Enchantment enchantment;
    private final int level;

    public CompressedEnchantment(Enchantment enchantment, int n) {
        this.enchantment = enchantment;
        this.level = n;
    }

    public static CompressedEnchantment fromString(String string) {
        String[] stringArray = string.split(";");
        Optional<XEnchantment> optional = XEnchantment.matchXEnchantment(stringArray[0].toUpperCase());
        Enchantment enchantment2 = null;
        int n = Integer.parseInt(stringArray[1]);
        if (optional.isPresent()) {
            XEnchantment xEnchantment = optional.get();
            if (xEnchantment.toString().equalsIgnoreCase("Quick Charge")) {
                if (VersionUtils.Version.v1_14.isServerVersionOrLater()) {
                    enchantment2 = Enchantment.QUICK_CHARGE;
                }
            } else {
                enchantment2 = xEnchantment.getEnchant();
            }
        } else {
            enchantment2 = Arrays.stream(Enchantment.values()).filter(enchantment -> enchantment.getName().equalsIgnoreCase(stringArray[0])).findFirst().orElse(null);
        }
        if (enchantment2 == null) {
            throw new Exception();
        }
        return new CompressedEnchantment(enchantment2, n);
    }

    public void applyTo(ItemBuilder itemBuilder) {
        if (itemBuilder.getItemMeta() instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)itemBuilder.getItemMeta();
            enchantmentStorageMeta.addStoredEnchant(this.enchantment, this.level, true);
            itemBuilder.setItemMeta((ItemMeta)enchantmentStorageMeta);
            return;
        }
        itemBuilder.getItem().addUnsafeEnchantment(this.enchantment, this.level);
    }

    public String toString() {
        if (MinecraftVersion.isOlderOrEqualThanVersion(MinecraftVersion.MC1_20_R3)) {
            return this.enchantment.getName() + ";" + this.level;
        }
        return this.enchantment.getKey().getKey() + ";" + this.level;
    }

    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    public int getLevel() {
        return this.level;
    }
}

