/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.previeweditor;

import de.tr7zw.advancedcrates.nbtapi.utils.MinecraftVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.utils.Common;
import me.PM2.HologramPackets.INMSHandler;
import me.PM2.HologramPackets.Main.NameTagAPI;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class RewardPreviewDroppedItem {
    private final Map<Player, List<Map<Location, Object>>> hologram = new HashMap<Player, List<Map<Location, Object>>>();
    private final Map<Object, LivingEntity> livingHologram = new HashMap<Object, LivingEntity>();
    private final Map<Location, ItemStack> item = new HashMap<Location, ItemStack>();
    private HashMap<Location, Object> entityItems = new HashMap();
    private HashMap<Location, List<Object>> droppedItemsSpawnPackets = new HashMap();
    private HashMap<Location, List<Object>> droppedItemsDestroyPackets = new HashMap();
    private HashMap<Location, Object> droppedItemsNewMetaDataPackets = new HashMap();
    private final Map<Location, List<Player>> hiddenPlayers = new HashMap<Location, List<Player>>();
    private final Map<Location, List<Player>> noLongerHiddenPlayers = new HashMap<Location, List<Player>>();
    private final Map<Location, List<Player>> shownToPlayers = new HashMap<Location, List<Player>>();
    private final Set<Location> crateLocations = new HashSet<Location>();
    private final List<ItemStack> previewItems = new ArrayList<ItemStack>();
    private final INMSHandler handler = NameTagAPI.getNMSHandler();
    private int index = 0;

    public RewardPreviewDroppedItem(Crate crate) {
        this.crateLocations.addAll(crate.getPlacedLocations());
        crate.getLowRewards().forEach(reward -> {
            if (reward.getChance() > 0.0) {
                ItemStack itemStack = reward.getReward().clone();
                ItemMeta itemMeta = itemStack.getItemMeta();
                itemMeta.setDisplayName(Common.colorize(reward.getRewardPreviewName() != null ? reward.getRewardPreviewName() : reward.getItemBuilder().getDisplayName()));
                itemStack.setItemMeta(itemMeta);
                this.previewItems.add(itemStack);
            }
        });
        this.crateLocations.forEach(location -> {
            this.hiddenPlayers.put((Location)location, new ArrayList());
            this.noLongerHiddenPlayers.put((Location)location, new ArrayList());
            this.shownToPlayers.put((Location)location, new ArrayList());
        });
    }

    public void hideFromPlayer(Player player, Location location) {
        if (!this.hiddenPlayers.containsKey(location)) {
            return;
        }
        if (!this.hiddenPlayers.get(location).contains(player)) {
            this.hiddenPlayers.get(location).add(player);
        }
    }

    public void unhideFromPlayer(Player player, Location location) {
        if (!this.hiddenPlayers.get(location).contains(player)) {
            this.noLongerHiddenPlayers.get(location).add(player);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public void increment() {
        if (this.index + 2 > this.previewItems.size()) {
            this.setIndex(0);
        } else {
            ++this.index;
        }
    }

    public void updateItem(Location location) {
        if (this.item.containsKey(location)) {
            this.item.put(location, this.previewItems.get(this.index));
            this.handler.changeItemTypePacket(this.entityItems.get(location), this.previewItems.get(this.index));
            this.droppedItemsNewMetaDataPackets.put(location, this.handler.getItemMetaDataPacket(this.entityItems.get(location)));
        }
    }

    public void updateHologram(Location location, Player player) {
        this.handler.setCustomName(((Map)this.hologram.get(player).stream().filter(map -> map.containsKey(location)).findFirst().orElse(null)).get(location), this.previewItems.get(this.index).getItemMeta().getDisplayName());
    }

    public Object getHologramHidePacket(Location location, Player player) {
        if (this.hologram.containsKey(player)) {
            Optional<Map> optional = this.hologram.get(player).stream().filter(map -> map.containsKey(location)).findFirst();
            if (optional.isPresent() && optional.get().containsKey(location)) {
                return this.handler.getDestroyPacket(this.livingHologram.get(optional.get().get(location)));
            }
        } else {
            for (LivingEntity livingEntity : this.livingHologram.values()) {
                if (!(livingEntity.getLocation().distanceSquared(location) < 1.0)) continue;
                return this.handler.getDestroyPacket(livingEntity);
            }
        }
        return null;
    }

    public List<Object> getHologramShowPacket(Location location, Player player) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object v = ((Map)this.hologram.get(player).stream().filter(map -> map.containsKey(location)).findFirst().orElse(null)).get(location);
        arrayList.add(this.handler.getSpawnPacket(this.handler.getLivingEntity(v)));
        arrayList.add(this.handler.getPacketEntityMetadata(v));
        this.livingHologram.put(v, this.handler.getLivingEntity(v));
        return arrayList;
    }

    public Object getHologramUpdatePacket(Location location, Player player) {
        return this.handler.getPacketEntityMetadata(((Map)this.hologram.get(player).stream().filter(map -> map.containsKey(location)).findFirst().orElse(null)).get(location));
    }

    public void createHologram(Location location, Player player) {
        Object object = this.handler.getEntityItem(location.clone().add(0.5, 1.0, 0.5), this.previewItems.get(0), false, false);
        this.entityItems.put(location, object);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.handler.getItemSpawnPacket(object));
        arrayList.add(this.handler.getItemMetaDataPacket(object));
        this.droppedItemsSpawnPackets.put(location, arrayList);
        this.droppedItemsDestroyPackets.put(location, Collections.singletonList(this.handler.getItemDestroyPacket(object)));
        this.item.put(location, this.previewItems.get(0));
        HashMap<Location, Object> hashMap = new HashMap<Location, Object>();
        hashMap.put(location, this.handler.getEntityArmorStand(this.item.get(location) != null ? Objects.requireNonNull(this.item.get(location).getItemMeta()).getDisplayName() : " ", location.clone().add(0.5, 0.0, 0.5), MinecraftVersion.isOlderOrEqualThanVersion(MinecraftVersion.MC1_19_R3) ? location.getY() + 1.5 : location.getY() + 0.5));
        if (this.hologram.containsKey(player)) {
            this.hologram.get(player).add(hashMap);
        } else {
            this.hologram.put(player, new LinkedList(Collections.singletonList(hashMap)));
        }
    }

    public Map<Location, List<Player>> getShownToPlayers() {
        return this.shownToPlayers;
    }

    public void addShownToPlayer(Location location, Player player) {
        if (this.shownToPlayers.containsKey(location)) {
            this.shownToPlayers.get(location).add(player);
        } else {
            this.shownToPlayers.put(location, new ArrayList());
            this.shownToPlayers.get(location).add(player);
        }
    }

    public INMSHandler getHandler() {
        return this.handler;
    }

    public HashMap<Location, List<Object>> getDroppedItemsDestroyPackets() {
        return this.droppedItemsDestroyPackets;
    }

    public HashMap<Location, List<Object>> getDroppedItemsSpawnPackets() {
        return this.droppedItemsSpawnPackets;
    }

    public HashMap<Location, Object> getDroppedItems() {
        return this.entityItems;
    }

    public HashMap<Location, Object> getDroppedItemsNewMetaDataPackets() {
        return this.droppedItemsNewMetaDataPackets;
    }
}

