/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.particles.effects;

import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.particles.ParticleData;
import me.PM2.AdvancedCrates.particles.effects.CirclePA;
import me.PM2.AdvancedCrates.particles.effects.DoubleSpiralPA;
import me.PM2.AdvancedCrates.particles.effects.GrowingSpiralPA;
import me.PM2.AdvancedCrates.particles.effects.OffsetTiltedRingsPA;
import me.PM2.AdvancedCrates.particles.effects.ParticleAnimationEffect;
import me.PM2.AdvancedCrates.particles.effects.SpiralPA;
import me.PM2.AdvancedCrates.particles.effects.TiltedRingsPA;

public enum PEAnimationType {
    CIRCLE(CirclePA.class),
    SPIRAL(SpiralPA.class),
    DOUBLE_SPIRAL(DoubleSpiralPA.class),
    GROWING_SPIRAL(GrowingSpiralPA.class),
    TILTED_RINGS(TiltedRingsPA.class),
    OFFSET_TILTED_RINGS(OffsetTiltedRingsPA.class),
    NONE(null);

    private final Class<? extends ParticleAnimationEffect> particleAnimationEffect;

    private PEAnimationType(Class<? extends ParticleAnimationEffect> clazz) {
        this.particleAnimationEffect = clazz;
    }

    public static PEAnimationType getFromParticleAnimationEffect(ParticleAnimationEffect particleAnimationEffect) {
        for (PEAnimationType pEAnimationType : PEAnimationType.values()) {
            if (particleAnimationEffect.getClass() != pEAnimationType.particleAnimationEffect) continue;
            return pEAnimationType;
        }
        return null;
    }

    public ParticleAnimationEffect getAnimationEffectInstance(MonthlyCrate monthlyCrate, ParticleData particleData) {
        switch (this.ordinal()) {
            case 0: {
                return new CirclePA(monthlyCrate, particleData);
            }
            case 1: {
                return new SpiralPA(monthlyCrate, particleData);
            }
            case 2: {
                return new DoubleSpiralPA(monthlyCrate, particleData);
            }
            case 3: {
                return new GrowingSpiralPA(monthlyCrate, particleData);
            }
            case 4: {
                return new TiltedRingsPA(monthlyCrate, particleData);
            }
            case 5: {
                return new OffsetTiltedRingsPA(monthlyCrate, particleData);
            }
        }
        return null;
    }
}

