/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.particles;

import java.util.ArrayList;
import java.util.List;
import me.PM2.AdvancedCrates.config.SimpleConfig;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.particles.BukkitParticleEffect;
import me.PM2.AdvancedCrates.particles.NMSParticleEffect;
import me.PM2.AdvancedCrates.particles.ParticleData;
import me.PM2.AdvancedCrates.particles.ParticleEffect;
import me.PM2.AdvancedCrates.particles.effects.PEAnimationType;
import me.PM2.AdvancedCrates.utils.VersionUtils;
import org.bukkit.Color;
import org.bukkit.Particle;

public class CParticle {
    private List<ParticleData> particles = new ArrayList<ParticleData>();
    private final Crate crate;
    private final List<String> particlePaths = new ArrayList<String>();

    public CParticle(Crate crate) {
        this.crate = crate;
    }

    public void loadFor(Crate crate) {
        if (!crate.getConfig().contains("ParticleAnimations")) {
            return;
        }
        for (String string : crate.getConfig().getConfigurationSection("ParticleAnimations").getKeys(false)) {
            if (("" + string.charAt(string.length() - 1)).equals(".")) break;
            this.particlePaths.add("ParticleAnimations." + string);
        }
        for (String string : this.particlePaths) {
            this.parseAndAddParticles(string);
        }
    }

    public void saveToFile() {
        if (!this.particles.isEmpty()) {
            for (ParticleData particleData : this.particles) {
                particleData.save(this.crate.getConfig(), this.getPath(particleData.getName()));
            }
        }
    }

    public void deleteParticle(String string, ParticleData particleData) {
    }

    public void addParticle(ParticleData particleData) {
        this.getParticles().add(particleData);
    }

    public void parseAndAddParticles(String string) {
        SimpleConfig simpleConfig = this.crate.getConfig();
        try {
            String string2 = simpleConfig.getString(string + ".type");
            String string3 = simpleConfig.getString(string + ".range-x");
            String string4 = simpleConfig.getString(string + ".range-y");
            String string5 = simpleConfig.getString(string + ".range-z");
            String string6 = simpleConfig.getString(string + ".center-x");
            String string7 = simpleConfig.getString(string + ".center-y");
            String string8 = simpleConfig.getString(string + ".center-z");
            String string9 = simpleConfig.getString(string + ".speed");
            String string10 = simpleConfig.getString(string + ".amount");
            String string11 = simpleConfig.getString(string + ".animation");
            String string12 = simpleConfig.getString(string + ".color.red");
            String string13 = simpleConfig.getString(string + ".color.green");
            String string14 = simpleConfig.getString(string + ".color.blue");
            String string15 = simpleConfig.getString(string + ".color.enabled");
            String string16 = simpleConfig.getString(string + ".redstone-size");
            try {
                PEAnimationType pEAnimationType;
                float f;
                ParticleData particleData;
                if (VersionUtils.Version.v1_9.isServerVersionOrEarlier()) {
                    ParticleEffect particleEffect;
                    try {
                        particleEffect = ParticleEffect.valueOf(string2);
                    }
                    catch (Exception exception) {
                        return;
                    }
                    particleData = new NMSParticleEffect(this.crate.getInstance(), particleEffect, string, false, this.crate);
                } else {
                    try {
                        particleData = new BukkitParticleEffect(this.crate.getInstance(), string2, string, false, this.crate);
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
                particleData.setRangeX(Float.parseFloat(string3));
                particleData.setRangeY(Float.parseFloat(string4));
                particleData.setRangeZ(Float.parseFloat(string5));
                particleData.setSpeed(Float.parseFloat(string9));
                particleData.setAmount(Integer.parseInt(string10));
                try {
                    particleData.setCenterX(Float.parseFloat(string6));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    particleData.setCenterY(Float.parseFloat(string7));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    particleData.setCenterZ(Float.parseFloat(string8));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    particleData.setColorRed(Integer.parseInt(string12));
                }
                catch (Exception exception) {
                    particleData.setColorRed(255);
                }
                try {
                    particleData.setColorBlue(Integer.parseInt(string14));
                }
                catch (Exception exception) {
                    particleData.setColorBlue(0);
                }
                try {
                    particleData.setColorGreen(Integer.parseInt(string13));
                }
                catch (Exception exception) {
                    particleData.setColorGreen(0);
                }
                try {
                    particleData.setColorEnabled(Boolean.parseBoolean(string15));
                }
                catch (Exception exception) {
                    particleData.setColorEnabled(false);
                }
                try {
                    f = Float.parseFloat(string16);
                    if (f <= 0.0f) {
                        f = 1.0f;
                    }
                }
                catch (Exception exception) {
                    f = 1.0f;
                }
                try {
                    if (VersionUtils.Version.v1_13.isServerVersionOrLater() && string2.equalsIgnoreCase("REDSTONE")) {
                        particleData.setHasColor(true);
                        particleData.setColorEnabled(true);
                        particleData.setSize(f);
                        pEAnimationType = Color.fromBGR((int)particleData.getColorBlue(), (int)particleData.getColorGreen(), (int)particleData.getColorRed());
                        Particle.DustOptions dustOptions = new Particle.DustOptions((Color)pEAnimationType, f);
                        particleData.setDustOptions(dustOptions);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    pEAnimationType = PEAnimationType.valueOf(string11);
                    if (!pEAnimationType.equals((Object)PEAnimationType.NONE)) {
                        if (particleData.getSpeed() < 3.0f) {
                            particleData.setSpeed(20.0f);
                        }
                        if (particleData.getAmount() == 0) {
                            particleData.setAmount(1);
                        }
                        particleData.setParticleAnimationEffect(pEAnimationType.getAnimationEffectInstance(this.crate.getInstance(), particleData));
                        particleData.setHasAnimation(true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.addParticle(particleData);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getPath(String string) {
        return (string.equalsIgnoreCase("PLAY") ? "play." : "open.") + (string.equalsIgnoreCase("open") || string.equalsIgnoreCase("play") ? "" : "crate-tiers." + string + ".") + "particles";
    }

    public List<ParticleData> getParticles() {
        return this.particles;
    }

    public void setParticles(List<ParticleData> list) {
        this.particles = list;
    }
}

