/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.nbt;

import de.tr7zw.advancedcrates.nbtapi.NBTItem;
import de.tr7zw.advancedcrates.nbtapi.utils.MinecraftVersion;
import de.tr7zw.advancedcrates.nbtapi.utils.nmsmappings.ReflectionMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import me.PM2.AdvancedCrates.utils.Utils;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class NBTapi {
    private static String[] excludedTags = new String[]{"display", "Enchantments", "ench", "HideFlags", "Potion", "StoredEnchantments", "PublicBukkitValues"};
    private static String[] booleanTags = new String[]{"Unbreakable"};

    public static String getEntity(ItemStack itemStack) {
        return NBTapi.get("spawnerType", itemStack);
    }

    public static ItemStack addNBTTag(String string, String string2, ItemStack itemStack) {
        NBTItem nBTItem = new NBTItem(itemStack);
        nBTItem.setString(string, string2);
        return nBTItem.getItem();
    }

    public static boolean contains(String string, ItemStack itemStack) {
        if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
            return false;
        }
        try {
            NBTItem nBTItem = new NBTItem(itemStack);
            return nBTItem.hasKey(string);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public static String get(String string, ItemStack itemStack) {
        NBTItem nBTItem = new NBTItem(itemStack);
        return nBTItem.getString(string);
    }

    public static boolean hasNBT(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        if (itemStack.getType().equals((Object)Material.AIR)) {
            return false;
        }
        NBTItem nBTItem = new NBTItem(itemStack);
        return nBTItem.getKeys().size() != 0;
    }

    public static Class<?> getCraftItemStack() {
        try {
            return Class.forName("org.bukkit.craftbukkit." + MinecraftVersion.getVersionRaw() + ".inventory.CraftItemStack");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object getNMSItemStack(ItemStack itemStack) {
        try {
            return NBTapi.getCraftItemStack().getMethod("asNMSCopy", ItemStack.class).invoke(NBTapi.getCraftItemStack(), itemStack);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object getNewNBTTagCompound() {
        try {
            return Class.forName("net.minecraft.server." + MinecraftVersion.getVersionRaw() + ".NBTTagCompound").newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object getNBTTagCompound(Object object) {
        try {
            return object.getClass().getMethod("getTag", new Class[0]).invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ItemStack applyTo(ItemStack itemStack, String string2) {
        NBTItem nBTItem = new NBTItem(itemStack);
        String[] stringArray = string2.split(" ");
        String string3 = null;
        String string4 = null;
        try {
            string3 = stringArray[0];
            if (Arrays.stream(excludedTags).filter(string -> stringArray[0].equalsIgnoreCase((String)string)).findAny().isPresent()) {
                return itemStack;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuilder.append(stringArray[i]).append(" ");
            }
            stringBuilder = new StringBuilder(stringBuilder.substring(0, stringBuilder.length() - 1));
            string4 = stringBuilder.toString().replace(",Properties:\\{textures:\\[0:\\{Value:", ",Properties:{textures:[{Value:");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            if (string4.startsWith("[") && string4.endsWith("]")) {
                nBTItem.setObject(string3, string4);
            } else if (string4.startsWith("{") && string4.endsWith("}")) {
                nBTItem.setObject(string3, string4);
            } else if (string4.startsWith("'") && string4.endsWith("'") || string4.startsWith("\"") && string4.endsWith("\"")) {
                if ((string4 = Utils.stripQuotes(string4)).equalsIgnoreCase("1b")) {
                    nBTItem.setInteger(string3, 1);
                } else {
                    nBTItem.setString(string3, string4);
                }
            } else if (Utils.isInt(string4)) {
                nBTItem.setInteger(string3, Integer.parseInt(string4));
            } else if (Utils.isDouble(string4)) {
                nBTItem.setDouble(string3, Double.valueOf(string4));
            } else {
                nBTItem.setString(string3, string4);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            return nBTItem.getItem();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static ItemStack applyTo2(ItemStack itemStack, String string) {
        NBTItem nBTItem = new NBTItem(itemStack);
        String[] stringArray = string.split(" ");
        String string2 = null;
        String string3 = null;
        try {
            string2 = stringArray[0];
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuilder.append(stringArray[i]).append(" ");
            }
            stringBuilder = new StringBuilder(stringBuilder.substring(0, stringBuilder.length() - 1));
            string3 = stringBuilder.toString().replace(",Properties:\\{textures:\\[0:\\{Value:", ",Properties:{textures:[{Value:");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            if (string3.startsWith("[") && string3.endsWith("]")) {
                nBTItem.setObject(string2, string3);
            } else if (string3.startsWith("{") && string3.endsWith("}")) {
                nBTItem.setObject(string2, string3);
            } else if (string3.startsWith("'") && string3.endsWith("'") || string3.startsWith("\"") && string3.endsWith("\"")) {
                if ((string3 = Utils.stripQuotes(string3)).equalsIgnoreCase("1b")) {
                    nBTItem.setInteger(string2, 1);
                } else {
                    nBTItem.setString(string2, string3);
                }
            } else if (Utils.isInteger(string3, 10)) {
                nBTItem.setInteger(string2, Integer.parseInt(string3));
            } else if (Utils.isDouble(string3)) {
                nBTItem.setDouble(string2, Double.valueOf(string3));
            } else {
                nBTItem.setString(string2, string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            return nBTItem.getItem();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static List<String> getFrom(ItemStack itemStack, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (itemStack == null) {
            return arrayList;
        }
        NBTItem nBTItem = new NBTItem(itemStack);
        Object object = nBTItem.getCompound();
        try {
            Set set = (Set)ReflectionMethod.COMPOUND_GET_KEYS.run(object, new Object[0]);
            for (String string : set) {
                Object object2;
                boolean bl2 = false;
                for (String string2 : excludedTags) {
                    if (!string.equalsIgnoreCase(string2)) continue;
                    bl2 = true;
                    break;
                }
                if (bl2 && !bl) continue;
                if (Arrays.asList(booleanTags).contains(string)) {
                    object2 = ReflectionMethod.COMPOUND_GET_BOOLEAN.run(object, string);
                    if (((Boolean)object2).booleanValue()) {
                        arrayList.add(string + " " + 1);
                        continue;
                    }
                    arrayList.add(string + " " + 0);
                    continue;
                }
                object2 = ReflectionMethod.COMPOUND_GET.run(object, string);
                String string3 = object2.toString();
                arrayList.add(string + " " + string3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public static ArrayList<String> getNBTTags(ItemStack itemStack) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = NBTapi.getNMSItemStack(itemStack);
        Object object2 = NBTapi.getNBTTagCompound(object);
        try {
            Set set = (Set)object2.getClass().getMethod(MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_13_R1) ? "getKeys" : "c", new Class[0]).invoke(object2, new Object[0]);
            for (String string : set) {
                boolean bl = false;
                String[] stringArray = excludedTags;
                for (int i = 0; i < excludedTags.length; ++i) {
                    String string2 = stringArray[i];
                    if (!string.equalsIgnoreCase(string2)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                if (Arrays.asList(booleanTags).contains(string)) {
                    Object object3 = object2.getClass().getMethod("getBoolean", String.class).invoke(object2, string);
                    if (((Boolean)object3).booleanValue()) {
                        arrayList.add(string + " " + 1);
                        continue;
                    }
                    arrayList.add(string + " " + 0);
                    continue;
                }
                Object object4 = object2.getClass().getMethod("get", String.class).invoke(object2, string);
                arrayList.add(string + " " + object4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }
}

