/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.nbt;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class NBTEditor {
    private static final Map<String, Class<?>> classCache;
    private static final Map<String, Method> methodCache;
    private static final Map<Class<?>, Constructor<?>> constructorCache;
    private static final Map<Class<?>, Class<?>> NBTClasses;
    private static final Map<Class<?>, Field> NBTTagFieldCache;
    private static Field NBTListData;
    private static Field NBTCompoundMap;
    private static final String VERSION;
    private static final MinecraftVersion LOCAL_VERSION;

    private static Class<?> getNBTTag(Class<?> clazz) {
        if (NBTClasses.containsKey(clazz)) {
            return NBTClasses.get(clazz);
        }
        return clazz;
    }

    private static Object getNBTVar(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        try {
            if (NBTTagFieldCache.containsKey(clazz)) {
                return NBTTagFieldCache.get(clazz).get(object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private static Method getMethod(String string) {
        return methodCache.containsKey(string) ? methodCache.get(string) : null;
    }

    private static Constructor<?> getConstructor(Class<?> clazz) {
        return constructorCache.containsKey(clazz) ? constructorCache.get(clazz) : null;
    }

    private static Class<?> getNMSClass(String string) {
        if (classCache.containsKey(string)) {
            return classCache.get(string);
        }
        try {
            return Class.forName("net.minecraft.server." + VERSION + "." + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
    }

    private static String getMatch(String string, String string2) {
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static Object createItemStack(Object object) {
        if (LOCAL_VERSION == MinecraftVersion.v1_11 || LOCAL_VERSION == MinecraftVersion.v1_12) {
            return NBTEditor.getConstructor(NBTEditor.getNMSClass("ItemStack")).newInstance(object);
        }
        return NBTEditor.getMethod("createStack").invoke(null, object);
    }

    public static String getVersion() {
        return VERSION;
    }

    public static MinecraftVersion getMinecraftVersion() {
        return LOCAL_VERSION;
    }

    public static ItemStack getHead(String string) {
        Object object;
        Material material = Material.getMaterial((String)"SKULL_ITEM");
        if (material == null) {
            material = Material.getMaterial((String)"PLAYER_HEAD");
        }
        ItemStack itemStack = new ItemStack(material, 1, 3);
        if (string == null || string.isEmpty()) {
            return itemStack;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        Object var4_4 = null;
        try {
            var4_4 = NBTEditor.getConstructor(NBTEditor.getNMSClass("GameProfile")).newInstance(UUID.randomUUID(), null);
            object = NBTEditor.getMethod("getProperties").invoke(var4_4, new Object[0]);
            Object obj = NBTEditor.getConstructor(NBTEditor.getNMSClass("Property")).newInstance("textures", new String(Base64.getEncoder().encode(String.format("{textures:{SKIN:{\"url\":\"%s\"}}}", string).getBytes())));
            NBTEditor.getMethod("put").invoke(object, "textures", obj);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
            exception.printStackTrace();
        }
        if (methodCache.containsKey("setProfile")) {
            try {
                NBTEditor.getMethod("setProfile").invoke((Object)itemMeta, var4_4);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                exception.printStackTrace();
            }
        } else {
            object = null;
            try {
                object = itemMeta.getClass().getDeclaredField("profile");
            }
            catch (NoSuchFieldException | SecurityException exception) {
                exception.printStackTrace();
            }
            ((Field)object).setAccessible(true);
            try {
                ((Field)object).set(itemMeta, var4_4);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                exception.printStackTrace();
            }
        }
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static String getTexture(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        Field field = null;
        try {
            field = itemMeta.getClass().getDeclaredField("profile");
        }
        catch (NoSuchFieldException | SecurityException exception) {
            exception.printStackTrace();
            throw new IllegalArgumentException("Item is not a player skull!");
        }
        field.setAccessible(true);
        try {
            Object object = field.get(itemMeta);
            if (object == null) {
                return null;
            }
            Collection collection = (Collection)NBTEditor.getMethod("values").invoke(NBTEditor.getMethod("getProperties").invoke(object, new Object[0]), new Object[0]);
            for (Object e : collection) {
                if (!"textures".equals(NBTEditor.getMethod("getName").invoke(e, new Object[0]))) continue;
                String string = new String(Base64.getDecoder().decode((String)NBTEditor.getMethod("getValue").invoke(e, new Object[0])));
                return NBTEditor.getMatch(string, "\\{\"url\":\"(.*?)\"\\}");
            }
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static Object getItemTag(ItemStack itemStack, Object ... objectArray) {
        try {
            return NBTEditor.getTag(NBTEditor.getCompound(itemStack), objectArray);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static Object getCompound(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        try {
            Object object = null;
            object = NBTEditor.getMethod("asNMSCopy").invoke(null, itemStack);
            Object object2 = null;
            object2 = NBTEditor.getMethod("hasTag").invoke(object, new Object[0]).equals(true) ? NBTEditor.getMethod("getTag").invoke(object, new Object[0]) : (Object)NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            return object2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static NBTCompound getItemNBTTag(ItemStack itemStack, Object ... objectArray) {
        if (itemStack == null) {
            return null;
        }
        try {
            Object object = null;
            object = NBTEditor.getMethod("asNMSCopy").invoke(null, itemStack);
            Object object2 = NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            object2 = NBTEditor.getMethod("save").invoke(object, object2);
            return NBTEditor.getNBTTag(object2, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static ItemStack setItemTag(ItemStack itemStack, Object object, Object ... objectArray) {
        if (itemStack == null) {
            return null;
        }
        try {
            Object object2 = NBTEditor.getMethod("asNMSCopy").invoke(null, itemStack);
            Object object3 = null;
            object3 = NBTEditor.getMethod("hasTag").invoke(object2, new Object[0]).equals(true) ? NBTEditor.getMethod("getTag").invoke(object2, new Object[0]) : (Object)NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            if (objectArray.length == 0 && object instanceof NBTCompound) {
                object3 = ((NBTCompound)object).tag;
            } else {
                NBTEditor.setTag(object3, object, objectArray);
            }
            NBTEditor.getMethod("setTag").invoke(object2, object3);
            return (ItemStack)NBTEditor.getMethod("asBukkitCopy").invoke(null, object2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static ItemStack getItemFromTag(NBTCompound nBTCompound) {
        if (nBTCompound == null) {
            return null;
        }
        try {
            Object object = nBTCompound.tag;
            Object object2 = NBTEditor.getTag(object, "Count");
            Object object3 = NBTEditor.getTag(object, "id");
            if (object2 == null || object3 == null) {
                return null;
            }
            if (object2 instanceof Byte && object3 instanceof String) {
                return (ItemStack)NBTEditor.getMethod("asBukkitCopy").invoke(null, NBTEditor.createItemStack(object));
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static Object getEntityTag(Entity entity, Object ... objectArray) {
        try {
            return NBTEditor.getTag(NBTEditor.getCompound(entity), objectArray);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static Object getCompound(Entity entity) {
        if (entity == null) {
            return entity;
        }
        try {
            Object object = NBTEditor.getMethod("getEntityHandle").invoke((Object)entity, new Object[0]);
            Object obj = NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            NBTEditor.getMethod("getEntityTag").invoke(object, obj);
            return obj;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static NBTCompound getEntityNBTTag(Entity entity, Object ... objectArray) {
        if (entity == null) {
            return null;
        }
        try {
            Object object = NBTEditor.getMethod("getEntityHandle").invoke((Object)entity, new Object[0]);
            Object obj = NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            NBTEditor.getMethod("getEntityTag").invoke(object, obj);
            return NBTEditor.getNBTTag(obj, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static void setEntityTag(Entity entity, Object object, Object ... objectArray) {
        if (entity == null) {
            return;
        }
        try {
            Object object2 = NBTEditor.getMethod("getEntityHandle").invoke((Object)entity, new Object[0]);
            Object object3 = NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            NBTEditor.getMethod("getEntityTag").invoke(object2, object3);
            if (objectArray.length == 0 && object instanceof NBTCompound) {
                object3 = ((NBTCompound)object).tag;
            } else {
                NBTEditor.setTag(object3, object, objectArray);
            }
            NBTEditor.getMethod("setEntityTag").invoke(object2, object3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private static Object getBlockTag(Block block, Object ... objectArray) {
        try {
            return NBTEditor.getTag(NBTEditor.getCompound(block), objectArray);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static Object getCompound(Block block) {
        try {
            if (block == null || !NBTEditor.getNMSClass("CraftBlockState").isInstance(block.getState())) {
                return null;
            }
            Location location = block.getLocation();
            Object obj = NBTEditor.getConstructor(NBTEditor.getNMSClass("BlockPosition")).newInstance(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            Object object = NBTEditor.getMethod("getWorldHandle").invoke((Object)location.getWorld(), new Object[0]);
            Object object2 = NBTEditor.getMethod("getTileEntity").invoke(object, obj);
            Object obj2 = NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            NBTEditor.getMethod("getTileTag").invoke(object2, obj2);
            return obj2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static NBTCompound getBlockNBTTag(Block block, Object ... objectArray) {
        try {
            if (block == null || !NBTEditor.getNMSClass("CraftBlockState").isInstance(block.getState())) {
                return null;
            }
            Location location = block.getLocation();
            Object obj = NBTEditor.getConstructor(NBTEditor.getNMSClass("BlockPosition")).newInstance(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            Object object = NBTEditor.getMethod("getWorldHandle").invoke((Object)location.getWorld(), new Object[0]);
            Object object2 = NBTEditor.getMethod("getTileEntity").invoke(object, obj);
            Object obj2 = NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            NBTEditor.getMethod("getTileTag").invoke(object2, obj2);
            return NBTEditor.getNBTTag(obj2, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static void setBlockTag(Block block, Object object, Object ... objectArray) {
        try {
            if (block == null || !NBTEditor.getNMSClass("CraftBlockState").isInstance(block.getState())) {
                return;
            }
            Location location = block.getLocation();
            Object obj = NBTEditor.getConstructor(NBTEditor.getNMSClass("BlockPosition")).newInstance(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            Object object2 = NBTEditor.getMethod("getWorldHandle").invoke((Object)location.getWorld(), new Object[0]);
            Object object3 = NBTEditor.getMethod("getTileEntity").invoke(object2, obj);
            Object object4 = NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            NBTEditor.getMethod("getTileTag").invoke(object3, object4);
            if (objectArray.length == 0 && object instanceof NBTCompound) {
                object4 = ((NBTCompound)object).tag;
            } else {
                NBTEditor.setTag(object4, object, objectArray);
            }
            if (LOCAL_VERSION == MinecraftVersion.v1_16) {
                NBTEditor.getMethod("setTileTag").invoke(object3, NBTEditor.getMethod("getType").invoke(object2, obj), object4);
            } else {
                NBTEditor.getMethod("setTileTag").invoke(object3, object4);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static void setSkullTexture(Block block, String string) {
        try {
            Object obj = NBTEditor.getConstructor(NBTEditor.getNMSClass("GameProfile")).newInstance(UUID.randomUUID(), null);
            Object object = NBTEditor.getMethod("getProperties").invoke(obj, new Object[0]);
            Object obj2 = NBTEditor.getConstructor(NBTEditor.getNMSClass("Property")).newInstance("textures", new String(Base64.getEncoder().encode(String.format("{textures:{SKIN:{\"url\":\"%s\"}}}", string).getBytes())));
            NBTEditor.getMethod("put").invoke(object, "textures", obj2);
            Location location = block.getLocation();
            Object obj3 = NBTEditor.getConstructor(NBTEditor.getNMSClass("BlockPosition")).newInstance(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            Object object2 = NBTEditor.getMethod("getWorldHandle").invoke((Object)location.getWorld(), new Object[0]);
            Object object3 = NBTEditor.getMethod("getTileEntity").invoke(object2, obj3);
            NBTEditor.getMethod("setGameProfile").invoke(object3, obj);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static Object getValue(Object object, Object ... objectArray) {
        if (object instanceof ItemStack) {
            return NBTEditor.getItemTag((ItemStack)object, objectArray);
        }
        if (object instanceof Entity) {
            return NBTEditor.getEntityTag((Entity)object, objectArray);
        }
        if (object instanceof Block) {
            return NBTEditor.getBlockTag((Block)object, objectArray);
        }
        if (object instanceof NBTCompound) {
            try {
                return NBTEditor.getTag(((NBTCompound)object).tag, objectArray);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                exception.printStackTrace();
                return null;
            }
        }
        throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, Block, or NBTCompound!");
    }

    public static NBTCompound getNBTCompound(Object object, Object ... objectArray) {
        if (object instanceof ItemStack) {
            return NBTEditor.getItemNBTTag((ItemStack)object, objectArray);
        }
        if (object instanceof Entity) {
            return NBTEditor.getEntityNBTTag((Entity)object, objectArray);
        }
        if (object instanceof Block) {
            return NBTEditor.getBlockNBTTag((Block)object, objectArray);
        }
        if (object instanceof NBTCompound) {
            try {
                return NBTEditor.getNBTTag(((NBTCompound)object).tag, objectArray);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                exception.printStackTrace();
                return null;
            }
        }
        if (NBTEditor.getNMSClass("NBTTagCompound").isInstance(object)) {
            try {
                return NBTEditor.getNBTTag(object, objectArray);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                exception.printStackTrace();
                return null;
            }
        }
        throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, Block, or NBTCompound!");
    }

    public static String getString(Object object, Object ... objectArray) {
        Object object2 = NBTEditor.getValue(object, objectArray);
        return object2 instanceof String ? (String)object2 : null;
    }

    public static int getInt(Object object, Object ... objectArray) {
        Object object2 = NBTEditor.getValue(object, objectArray);
        return object2 instanceof Integer ? (Integer)object2 : 0;
    }

    public static double getDouble(Object object, Object ... objectArray) {
        Object object2 = NBTEditor.getValue(object, objectArray);
        return object2 instanceof Double ? (Double)object2 : 0.0;
    }

    public static long getLong(Object object, Object ... objectArray) {
        Object object2 = NBTEditor.getValue(object, objectArray);
        return object2 instanceof Long ? (Long)object2 : 0L;
    }

    public static float getFloat(Object object, Object ... objectArray) {
        Object object2 = NBTEditor.getValue(object, objectArray);
        return object2 instanceof Float ? ((Float)object2).floatValue() : 0.0f;
    }

    public static short getShort(Object object, Object ... objectArray) {
        Object object2 = NBTEditor.getValue(object, objectArray);
        return object2 instanceof Short ? (Short)object2 : (short)0;
    }

    public static byte getByte(Object object, Object ... objectArray) {
        Object object2 = NBTEditor.getValue(object, objectArray);
        return object2 instanceof Byte ? (Byte)object2 : (byte)0;
    }

    public static boolean getBoolean(Object object, Object ... objectArray) {
        return NBTEditor.getByte(object, objectArray) == 1;
    }

    public static byte[] getByteArray(Object object, Object ... objectArray) {
        Object object2 = NBTEditor.getValue(object, objectArray);
        return object2 instanceof byte[] ? (byte[])object2 : null;
    }

    public static int[] getIntArray(Object object, Object ... objectArray) {
        Object object2 = NBTEditor.getValue(object, objectArray);
        return object2 instanceof int[] ? (int[])object2 : null;
    }

    public static boolean contains(Object object, Object ... objectArray) {
        Object object2 = NBTEditor.getValue(object, objectArray);
        return object2 != null;
    }

    public static Collection<String> getKeys(Object object, Object ... objectArray) {
        Object object2;
        if (object instanceof ItemStack) {
            object2 = NBTEditor.getCompound((ItemStack)object);
        } else if (object instanceof Entity) {
            object2 = NBTEditor.getCompound((Entity)object);
        } else if (object instanceof Block) {
            object2 = NBTEditor.getCompound((Block)object);
        } else if (object instanceof NBTCompound) {
            object2 = ((NBTCompound)object).tag;
        } else {
            throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, Block, or NBTCompound!");
        }
        try {
            NBTCompound nBTCompound = NBTEditor.getNBTTag(object2, objectArray);
            Object object3 = nBTCompound.tag;
            if (NBTEditor.getNMSClass("NBTTagCompound").isInstance(object3)) {
                return (Collection)NBTEditor.getMethod("getKeys").invoke(object3, new Object[0]);
            }
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static int getSize(Object object, Object ... objectArray) {
        Object object2;
        if (object instanceof ItemStack) {
            object2 = NBTEditor.getCompound((ItemStack)object);
        } else if (object instanceof Entity) {
            object2 = NBTEditor.getCompound((Entity)object);
        } else if (object instanceof Block) {
            object2 = NBTEditor.getCompound((Block)object);
        } else if (object instanceof NBTCompound) {
            object2 = ((NBTCompound)object).tag;
        } else {
            throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, Block, or NBTCompound!");
        }
        try {
            NBTCompound nBTCompound = NBTEditor.getNBTTag(object2, objectArray);
            if (NBTEditor.getNMSClass("NBTTagCompound").isInstance(nBTCompound.tag)) {
                return NBTEditor.getKeys(nBTCompound, new Object[0]).size();
            }
            if (NBTEditor.getNMSClass("NBTTagList").isInstance(nBTCompound.tag)) {
                return (Integer)NBTEditor.getMethod("size").invoke(nBTCompound.tag, new Object[0]);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            exception.printStackTrace();
            return 0;
        }
        throw new IllegalArgumentException("Value is not a compound or list!");
    }

    public static <T> T set(T t, Object object, Object ... objectArray) {
        if (t instanceof ItemStack) {
            return (T)NBTEditor.setItemTag((ItemStack)t, object, objectArray);
        }
        if (t instanceof Entity) {
            NBTEditor.setEntityTag((Entity)t, object, objectArray);
        } else if (t instanceof Block) {
            NBTEditor.setBlockTag((Block)t, object, objectArray);
        } else if (t instanceof NBTCompound) {
            try {
                NBTEditor.setTag(((NBTCompound)t).tag, object, objectArray);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
                exception.printStackTrace();
            }
        } else {
            throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, Block, or NBTCompound!");
        }
        return t;
    }

    public static NBTCompound getNBTCompound(String string) {
        return NBTCompound.fromJson(string);
    }

    public static NBTCompound getEmptyNBTCompound() {
        try {
            return new NBTCompound(NBTEditor.getNMSClass("NBTTagCompound").newInstance());
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
            return null;
        }
    }

    private static void setTag(Object object, Object object2, Object ... objectArray) {
        Object object3;
        if (object2 != null) {
            if (object2 instanceof NBTCompound) {
                object3 = ((NBTCompound)object2).tag;
            } else if (NBTEditor.getNMSClass("NBTTagList").isInstance(object2) || NBTEditor.getNMSClass("NBTTagCompound").isInstance(object2)) {
                object3 = object2;
            } else {
                if (object2 instanceof Boolean) {
                    object2 = (byte)((Boolean)object2 == true ? 1 : 0);
                }
                object3 = NBTEditor.getConstructor(NBTEditor.getNBTTag(object2.getClass())).newInstance(object2);
            }
        } else {
            object3 = null;
        }
        Object object4 = object;
        for (int i = 0; i < objectArray.length - 1; ++i) {
            Object object5 = objectArray[i];
            Object object6 = object4;
            if (object5 instanceof Integer) {
                object4 = ((List)NBTListData.get(object4)).get((Integer)object5);
            } else if (object5 != null) {
                object4 = NBTEditor.getMethod("get").invoke(object4, (String)object5);
            }
            if (object4 != null && object5 != null) continue;
            object4 = objectArray[i + 1] == null || objectArray[i + 1] instanceof Integer ? NBTEditor.getNMSClass("NBTTagList").newInstance() : NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            if (object6.getClass().getSimpleName().equals("NBTTagList")) {
                if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_14)) {
                    NBTEditor.getMethod("add").invoke(object6, NBTEditor.getMethod("size").invoke(object6, new Object[0]), object4);
                    continue;
                }
                NBTEditor.getMethod("add").invoke(object6, object4);
                continue;
            }
            NBTEditor.getMethod("set").invoke(object6, object5, object4);
        }
        if (objectArray.length > 0) {
            Object object7 = objectArray[objectArray.length - 1];
            if (object7 == null) {
                if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_14)) {
                    NBTEditor.getMethod("add").invoke(object4, NBTEditor.getMethod("size").invoke(object4, new Object[0]), object3);
                } else {
                    NBTEditor.getMethod("add").invoke(object4, object3);
                }
            } else if (object7 instanceof Integer) {
                if (object3 == null) {
                    NBTEditor.getMethod("listRemove").invoke(object4, (int)((Integer)object7));
                } else {
                    NBTEditor.getMethod("setIndex").invoke(object4, (int)((Integer)object7), object3);
                }
            } else if (object3 == null) {
                NBTEditor.getMethod("remove").invoke(object4, (String)object7);
            } else {
                NBTEditor.getMethod("set").invoke(object4, object7, object3);
            }
        } else if (object3 != null && NBTEditor.getNMSClass("NBTTagCompound").isInstance(object3) && NBTEditor.getNMSClass("NBTTagCompound").isInstance(object4)) {
            for (String string : NBTEditor.getKeys(object3, new Object[0])) {
                NBTEditor.getMethod("set").invoke(object4, string, NBTEditor.getMethod("get").invoke(object3, string));
            }
        }
    }

    private static NBTCompound getNBTTag(Object object, Object ... objectArray) {
        Object object2 = object;
        for (Object object3 : objectArray) {
            if (object2 == null) {
                return null;
            }
            if (NBTEditor.getNMSClass("NBTTagCompound").isInstance(object2)) {
                try {
                    object2 = NBTEditor.getMethod("get").invoke(object2, (String)object3);
                }
                catch (Exception exception) {}
                continue;
            }
            if (!NBTEditor.getNMSClass("NBTTagList").isInstance(object2)) continue;
            object2 = ((List)NBTListData.get(object2)).get((Integer)object3);
        }
        return new NBTCompound(object2);
    }

    private static Object getTag(Object object, Object ... objectArray) {
        if (objectArray.length == 0) {
            return NBTEditor.getTags(object);
        }
        Object object2 = object;
        for (Object object3 : objectArray) {
            if (object2 == null) {
                return null;
            }
            if (NBTEditor.getNMSClass("NBTTagCompound").isInstance(object2)) {
                object2 = NBTEditor.getMethod("get").invoke(object2, (String)object3);
                continue;
            }
            if (NBTEditor.getNMSClass("NBTTagList").isInstance(object2)) {
                object2 = ((List)NBTListData.get(object2)).get((Integer)object3);
                continue;
            }
            return NBTEditor.getNBTVar(object2);
        }
        if (object2 == null) {
            return null;
        }
        if (NBTEditor.getNMSClass("NBTTagList").isInstance(object2)) {
            return NBTEditor.getTags(object2);
        }
        if (NBTEditor.getNMSClass("NBTTagCompound").isInstance(object2)) {
            return NBTEditor.getTags(object2);
        }
        return NBTEditor.getNBTVar(object2);
    }

    private static Object getTags(Object object) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        try {
            if (NBTEditor.getNMSClass("NBTTagCompound").isInstance(object)) {
                Map map = (Map)NBTCompoundMap.get(object);
                for (String string : map.keySet()) {
                    Object v = map.get(string);
                    if (NBTEditor.getNMSClass("NBTTagEnd").isInstance(v)) continue;
                    hashMap.put(string, NBTEditor.getTag(v, new Object[0]));
                }
            } else if (NBTEditor.getNMSClass("NBTTagList").isInstance(object)) {
                List list = (List)NBTListData.get(object);
                for (int i = 0; i < list.size(); ++i) {
                    Object e = list.get(i);
                    if (NBTEditor.getNMSClass("NBTTagEnd").isInstance(e)) continue;
                    hashMap.put(i, NBTEditor.getTag(e, new Object[0]));
                }
            } else {
                return NBTEditor.getNBTVar(object);
            }
            return hashMap;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return hashMap;
        }
    }

    static {
        VERSION = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        LOCAL_VERSION = MinecraftVersion.get(VERSION);
        classCache = new HashMap();
        try {
            if (LOCAL_VERSION.lessThanOrEqualTo(MinecraftVersion.v1_16)) {
                classCache.put("NBTBase", Class.forName("net.minecraft.server." + VERSION + ".NBTBase"));
                classCache.put("NBTTagCompound", Class.forName("net.minecraft.server." + VERSION + ".NBTTagCompound"));
                classCache.put("NBTTagList", Class.forName("net.minecraft.server." + VERSION + ".NBTTagList"));
                classCache.put("NBTTagEnd", Class.forName("net.minecraft.server." + VERSION + ".NBTTagEnd"));
                classCache.put("MojangsonParser", Class.forName("net.minecraft.server." + VERSION + ".MojangsonParser"));
                classCache.put("ItemStack", Class.forName("net.minecraft.server." + VERSION + ".ItemStack"));
                classCache.put("Entity", Class.forName("net.minecraft.server." + VERSION + ".Entity"));
                classCache.put("EntityLiving", Class.forName("net.minecraft.server." + VERSION + ".EntityLiving"));
                classCache.put("BlockPosition", Class.forName("net.minecraft.server." + VERSION + ".BlockPosition"));
                classCache.put("TileEntity", Class.forName("net.minecraft.server." + VERSION + ".TileEntity"));
                classCache.put("World", Class.forName("net.minecraft.server." + VERSION + ".World"));
                classCache.put("IBlockData", Class.forName("net.minecraft.server." + VERSION + ".IBlockData"));
                classCache.put("TileEntitySkull", Class.forName("net.minecraft.server." + VERSION + ".TileEntitySkull"));
            } else {
                classCache.put("BlockPosition", Class.forName("net.minecraft.core.BlockPosition"));
                classCache.put("NBTBase", Class.forName("net.minecraft.nbt.NBTBase"));
                classCache.put("NBTTagCompound", Class.forName("net.minecraft.nbt.NBTTagCompound"));
                classCache.put("NBTTagList", Class.forName("net.minecraft.nbt.NBTTagList"));
                classCache.put("NBTTagEnd", Class.forName("net.minecraft.nbt.NBTTagEnd"));
                classCache.put("MojangsonParser", Class.forName("net.minecraft.nbt.MojangsonParser"));
                classCache.put("ItemStack", Class.forName("net.minecraft.world.item.ItemStack"));
                classCache.put("Entity", Class.forName("net.minecraft.world.entity.Entity"));
                classCache.put("EntityLiving", Class.forName("net.minecraft.world.entity.EntityLiving"));
                classCache.put("World", Class.forName("net.minecraft.world.level.World"));
                classCache.put("IBlockData", Class.forName("net.minecraft.world.level.block.state.IBlockData"));
                classCache.put("TileEntity", Class.forName("net.minecraft.world.level.block.entity.TileEntity"));
                classCache.put("TileEntitySkull", Class.forName("net.minecraft.world.level.block.entity.TileEntitySkull"));
            }
            classCache.put("CraftItemStack", Class.forName("org.bukkit.craftbukkit." + VERSION + ".inventory.CraftItemStack"));
            classCache.put("CraftMetaSkull", Class.forName("org.bukkit.craftbukkit." + VERSION + ".inventory.CraftMetaSkull"));
            classCache.put("CraftEntity", Class.forName("org.bukkit.craftbukkit." + VERSION + ".entity.CraftEntity"));
            classCache.put("CraftWorld", Class.forName("org.bukkit.craftbukkit." + VERSION + ".CraftWorld"));
            classCache.put("CraftBlockState", Class.forName("org.bukkit.craftbukkit." + VERSION + ".block.CraftBlockState"));
            classCache.put("GameProfile", Class.forName("com.mojang.authlib.GameProfile"));
            classCache.put("Property", Class.forName("com.mojang.authlib.properties.Property"));
            classCache.put("PropertyMap", Class.forName("com.mojang.authlib.properties.PropertyMap"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        NBTClasses = new HashMap();
        try {
            if (LOCAL_VERSION.lessThanOrEqualTo(MinecraftVersion.v1_16)) {
                NBTClasses.put(Byte.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagByte"));
                NBTClasses.put(Boolean.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagByte"));
                NBTClasses.put(String.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagString"));
                NBTClasses.put(Double.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagDouble"));
                NBTClasses.put(Integer.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagInt"));
                NBTClasses.put(Long.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagLong"));
                NBTClasses.put(Short.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagShort"));
                NBTClasses.put(Float.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagFloat"));
                NBTClasses.put(Class.forName("[B"), Class.forName("net.minecraft.server." + VERSION + ".NBTTagByteArray"));
                NBTClasses.put(Class.forName("[I"), Class.forName("net.minecraft.server." + VERSION + ".NBTTagIntArray"));
            } else {
                NBTClasses.put(Byte.class, Class.forName("net.minecraft.nbt.NBTTagByte"));
                NBTClasses.put(Boolean.class, Class.forName("net.minecraft.nbt.NBTTagByte"));
                NBTClasses.put(String.class, Class.forName("net.minecraft.nbt.NBTTagString"));
                NBTClasses.put(Double.class, Class.forName("net.minecraft.nbt.NBTTagDouble"));
                NBTClasses.put(Integer.class, Class.forName("net.minecraft.nbt.NBTTagInt"));
                NBTClasses.put(Long.class, Class.forName("net.minecraft.nbt.NBTTagLong"));
                NBTClasses.put(Short.class, Class.forName("net.minecraft.nbt.NBTTagShort"));
                NBTClasses.put(Float.class, Class.forName("net.minecraft.nbt.NBTTagFloat"));
                NBTClasses.put(Class.forName("[B"), Class.forName("net.minecraft.nbt.NBTTagByteArray"));
                NBTClasses.put(Class.forName("[I"), Class.forName("net.minecraft.nbt.NBTTagIntArray"));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        methodCache = new HashMap<String, Method>();
        try {
            methodCache.put("get", NBTEditor.getNMSClass("NBTTagCompound").getMethod("get", String.class));
            methodCache.put("set", NBTEditor.getNMSClass("NBTTagCompound").getMethod("set", String.class, NBTEditor.getNMSClass("NBTBase")));
            methodCache.put("hasKey", NBTEditor.getNMSClass("NBTTagCompound").getMethod("hasKey", String.class));
            if (LOCAL_VERSION.lessThanOrEqualTo(MinecraftVersion.v1_16)) {
                methodCache.put("setIndex", NBTEditor.getNMSClass("NBTTagList").getMethod("a", Integer.TYPE, NBTEditor.getNMSClass("NBTBase")));
            } else {
                methodCache.put("setIndex", NBTEditor.getNMSClass("NBTTagList").getMethod("set", Integer.TYPE, NBTEditor.getNMSClass("NBTBase")));
            }
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_14)) {
                methodCache.put("getTypeId", NBTEditor.getNMSClass("NBTBase").getMethod("getTypeId", new Class[0]));
                methodCache.put("add", NBTEditor.getNMSClass("NBTTagList").getMethod("add", Integer.TYPE, NBTEditor.getNMSClass("NBTBase")));
            } else {
                methodCache.put("add", NBTEditor.getNMSClass("NBTTagList").getMethod("add", NBTEditor.getNMSClass("NBTBase")));
            }
            methodCache.put("size", NBTEditor.getNMSClass("NBTTagList").getMethod("size", new Class[0]));
            if (LOCAL_VERSION == MinecraftVersion.v1_8) {
                methodCache.put("listRemove", NBTEditor.getNMSClass("NBTTagList").getMethod("a", Integer.TYPE));
            } else {
                methodCache.put("listRemove", NBTEditor.getNMSClass("NBTTagList").getMethod("remove", Integer.TYPE));
            }
            methodCache.put("remove", NBTEditor.getNMSClass("NBTTagCompound").getMethod("remove", String.class));
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_13)) {
                methodCache.put("getKeys", NBTEditor.getNMSClass("NBTTagCompound").getMethod("getKeys", new Class[0]));
            } else {
                methodCache.put("getKeys", NBTEditor.getNMSClass("NBTTagCompound").getMethod("c", new Class[0]));
            }
            methodCache.put("hasTag", NBTEditor.getNMSClass("ItemStack").getMethod("hasTag", new Class[0]));
            methodCache.put("getTag", NBTEditor.getNMSClass("ItemStack").getMethod("getTag", new Class[0]));
            methodCache.put("setTag", NBTEditor.getNMSClass("ItemStack").getMethod("setTag", NBTEditor.getNMSClass("NBTTagCompound")));
            methodCache.put("asNMSCopy", NBTEditor.getNMSClass("CraftItemStack").getMethod("asNMSCopy", ItemStack.class));
            methodCache.put("asBukkitCopy", NBTEditor.getNMSClass("CraftItemStack").getMethod("asBukkitCopy", NBTEditor.getNMSClass("ItemStack")));
            methodCache.put("getEntityHandle", NBTEditor.getNMSClass("CraftEntity").getMethod("getHandle", new Class[0]));
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_16)) {
                methodCache.put("getEntityTag", NBTEditor.getNMSClass("Entity").getMethod("save", NBTEditor.getNMSClass("NBTTagCompound")));
                methodCache.put("setEntityTag", NBTEditor.getNMSClass("Entity").getMethod("load", NBTEditor.getNMSClass("NBTTagCompound")));
            } else {
                methodCache.put("getEntityTag", NBTEditor.getNMSClass("Entity").getMethod("c", NBTEditor.getNMSClass("NBTTagCompound")));
                methodCache.put("setEntityTag", NBTEditor.getNMSClass("Entity").getMethod("f", NBTEditor.getNMSClass("NBTTagCompound")));
            }
            methodCache.put("save", NBTEditor.getNMSClass("ItemStack").getMethod("save", NBTEditor.getNMSClass("NBTTagCompound")));
            if (LOCAL_VERSION.lessThanOrEqualTo(MinecraftVersion.v1_10)) {
                methodCache.put("createStack", NBTEditor.getNMSClass("ItemStack").getMethod("createStack", NBTEditor.getNMSClass("NBTTagCompound")));
            } else if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_13)) {
                methodCache.put("createStack", NBTEditor.getNMSClass("ItemStack").getMethod("a", NBTEditor.getNMSClass("NBTTagCompound")));
            }
            if (LOCAL_VERSION == MinecraftVersion.v1_16) {
                methodCache.put("setTileTag", NBTEditor.getNMSClass("TileEntity").getMethod("load", NBTEditor.getNMSClass("IBlockData"), NBTEditor.getNMSClass("NBTTagCompound")));
                methodCache.put("getType", NBTEditor.getNMSClass("World").getMethod("getType", NBTEditor.getNMSClass("BlockPosition")));
            } else if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_12)) {
                methodCache.put("setTileTag", NBTEditor.getNMSClass("TileEntity").getMethod("load", NBTEditor.getNMSClass("NBTTagCompound")));
            } else {
                methodCache.put("setTileTag", NBTEditor.getNMSClass("TileEntity").getMethod("a", NBTEditor.getNMSClass("NBTTagCompound")));
            }
            if (LOCAL_VERSION == MinecraftVersion.v1_8) {
                methodCache.put("getTileTag", NBTEditor.getNMSClass("TileEntity").getMethod("b", NBTEditor.getNMSClass("NBTTagCompound")));
            } else {
                methodCache.put("getTileTag", NBTEditor.getNMSClass("TileEntity").getMethod("save", NBTEditor.getNMSClass("NBTTagCompound")));
            }
            methodCache.put("getTileEntity", NBTEditor.getNMSClass("World").getMethod("getTileEntity", NBTEditor.getNMSClass("BlockPosition")));
            methodCache.put("getWorldHandle", NBTEditor.getNMSClass("CraftWorld").getMethod("getHandle", new Class[0]));
            methodCache.put("setGameProfile", NBTEditor.getNMSClass("TileEntitySkull").getMethod("setGameProfile", NBTEditor.getNMSClass("GameProfile")));
            methodCache.put("getProperties", NBTEditor.getNMSClass("GameProfile").getMethod("getProperties", new Class[0]));
            methodCache.put("getName", NBTEditor.getNMSClass("Property").getMethod("getName", new Class[0]));
            methodCache.put("getValue", NBTEditor.getNMSClass("Property").getMethod("getValue", new Class[0]));
            methodCache.put("values", NBTEditor.getNMSClass("PropertyMap").getMethod("values", new Class[0]));
            methodCache.put("put", NBTEditor.getNMSClass("PropertyMap").getMethod("put", Object.class, Object.class));
            methodCache.put("loadNBTTagCompound", NBTEditor.getNMSClass("MojangsonParser").getMethod("parse", String.class));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            methodCache.put("setProfile", NBTEditor.getNMSClass("CraftMetaSkull").getDeclaredMethod("setProfile", NBTEditor.getNMSClass("GameProfile")));
            methodCache.get("setProfile").setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        constructorCache = new HashMap();
        try {
            constructorCache.put(NBTEditor.getNBTTag(Byte.class), NBTEditor.getNBTTag(Byte.class).getDeclaredConstructor(Byte.TYPE));
            constructorCache.put(NBTEditor.getNBTTag(Boolean.class), NBTEditor.getNBTTag(Boolean.class).getDeclaredConstructor(Byte.TYPE));
            constructorCache.put(NBTEditor.getNBTTag(String.class), NBTEditor.getNBTTag(String.class).getDeclaredConstructor(String.class));
            constructorCache.put(NBTEditor.getNBTTag(Double.class), NBTEditor.getNBTTag(Double.class).getDeclaredConstructor(Double.TYPE));
            constructorCache.put(NBTEditor.getNBTTag(Integer.class), NBTEditor.getNBTTag(Integer.class).getDeclaredConstructor(Integer.TYPE));
            constructorCache.put(NBTEditor.getNBTTag(Long.class), NBTEditor.getNBTTag(Long.class).getDeclaredConstructor(Long.TYPE));
            constructorCache.put(NBTEditor.getNBTTag(Float.class), NBTEditor.getNBTTag(Float.class).getDeclaredConstructor(Float.TYPE));
            constructorCache.put(NBTEditor.getNBTTag(Short.class), NBTEditor.getNBTTag(Short.class).getDeclaredConstructor(Short.TYPE));
            constructorCache.put(NBTEditor.getNBTTag(Class.forName("[B")), NBTEditor.getNBTTag(Class.forName("[B")).getDeclaredConstructor(Class.forName("[B")));
            constructorCache.put(NBTEditor.getNBTTag(Class.forName("[I")), NBTEditor.getNBTTag(Class.forName("[I")).getDeclaredConstructor(Class.forName("[I")));
            for (Constructor annotatedElement : constructorCache.values()) {
                annotatedElement.setAccessible(true);
            }
            constructorCache.put(NBTEditor.getNMSClass("BlockPosition"), NBTEditor.getNMSClass("BlockPosition").getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE));
            constructorCache.put(NBTEditor.getNMSClass("GameProfile"), NBTEditor.getNMSClass("GameProfile").getConstructor(UUID.class, String.class));
            constructorCache.put(NBTEditor.getNMSClass("Property"), NBTEditor.getNMSClass("Property").getConstructor(String.class, String.class));
            if (LOCAL_VERSION == MinecraftVersion.v1_11 || LOCAL_VERSION == MinecraftVersion.v1_12) {
                constructorCache.put(NBTEditor.getNMSClass("ItemStack"), NBTEditor.getNMSClass("ItemStack").getConstructor(NBTEditor.getNMSClass("NBTTagCompound")));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        NBTTagFieldCache = new HashMap();
        try {
            if (LOCAL_VERSION.lessThanOrEqualTo(MinecraftVersion.v1_16)) {
                for (Class<?> clazz : NBTClasses.values()) {
                    Field field = clazz.getDeclaredField("data");
                    field.setAccessible(true);
                    NBTTagFieldCache.put(clazz, field);
                }
            } else {
                NBTTagFieldCache.put(NBTClasses.get(Byte.class), NBTClasses.get(Byte.class).getDeclaredField("x"));
                NBTTagFieldCache.put(NBTClasses.get(Boolean.class), NBTClasses.get(Boolean.class).getDeclaredField("x"));
                NBTTagFieldCache.put(NBTClasses.get(String.class), NBTClasses.get(String.class).getDeclaredField("A"));
                NBTTagFieldCache.put(NBTClasses.get(Double.class), NBTClasses.get(Double.class).getDeclaredField("w"));
                NBTTagFieldCache.put(NBTClasses.get(Integer.class), NBTClasses.get(Integer.class).getDeclaredField("c"));
                NBTTagFieldCache.put(NBTClasses.get(Long.class), NBTClasses.get(Long.class).getDeclaredField("c"));
                NBTTagFieldCache.put(NBTClasses.get(Float.class), NBTClasses.get(Float.class).getDeclaredField("w"));
                NBTTagFieldCache.put(NBTClasses.get(Short.class), NBTClasses.get(Short.class).getDeclaredField("c"));
                NBTTagFieldCache.put(NBTClasses.get(Class.forName("[B")), NBTClasses.get(Class.forName("[B")).getDeclaredField("c"));
                NBTTagFieldCache.put(NBTClasses.get(Class.forName("[I")), NBTClasses.get(Class.forName("[I")).getDeclaredField("c"));
                for (Field field : NBTTagFieldCache.values()) {
                    field.setAccessible(true);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            if (LOCAL_VERSION.lessThanOrEqualTo(MinecraftVersion.v1_16)) {
                NBTListData = NBTEditor.getNMSClass("NBTTagList").getDeclaredField("list");
                NBTCompoundMap = NBTEditor.getNMSClass("NBTTagCompound").getDeclaredField("map");
            } else {
                NBTListData = NBTEditor.getNMSClass("NBTTagList").getDeclaredField("c");
                NBTCompoundMap = NBTEditor.getNMSClass("NBTTagCompound").getDeclaredField("x");
            }
            NBTListData.setAccessible(true);
            NBTCompoundMap.setAccessible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static enum MinecraftVersion {
        v1_8("1_8", 0),
        v1_9("1_9", 1),
        v1_10("1_10", 2),
        v1_11("1_11", 3),
        v1_12("1_12", 4),
        v1_13("1_13", 5),
        v1_14("1_14", 6),
        v1_15("1_15", 7),
        v1_16("1_16", 8),
        v1_17("1_17", 9),
        v1_18("1_18", 10),
        v1_19("1_19", 11);

        private final int order;
        private final String key;

        private MinecraftVersion(String string2, int n2) {
            this.key = string2;
            this.order = n2;
        }

        public boolean greaterThanOrEqualTo(MinecraftVersion minecraftVersion) {
            return this.order >= minecraftVersion.order;
        }

        public boolean lessThanOrEqualTo(MinecraftVersion minecraftVersion) {
            return this.order <= minecraftVersion.order;
        }

        public static MinecraftVersion get(String string) {
            for (MinecraftVersion minecraftVersion : MinecraftVersion.values()) {
                if (!string.contains(minecraftVersion.key)) continue;
                return minecraftVersion;
            }
            return null;
        }
    }

    public static final class NBTCompound {
        protected final Object tag;

        protected NBTCompound(Object object) {
            this.tag = object;
        }

        public void set(Object object, Object ... objectArray) {
            try {
                NBTEditor.setTag(this.tag, object, objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public String toJson() {
            return this.tag.toString();
        }

        public static NBTCompound fromJson(String string) {
            try {
                return new NBTCompound(NBTEditor.getMethod("loadNBTTagCompound").invoke(null, string));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                exception.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return this.tag.toString();
        }

        public int hashCode() {
            return this.tag.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            NBTCompound nBTCompound = (NBTCompound)object;
            return !(this.tag == null ? nBTCompound.tag != null : !this.tag.equals(nBTCompound.tag));
        }
    }
}

