/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.listeners;

import de.tr7zw.advancedcrates.nbtapi.NBT;
import de.tr7zw.advancedcrates.nbtapi.NBTItem;
import de.tr7zw.advancedcrates.nbtapi.utils.MinecraftVersion;
import java.util.Iterator;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.gui.DragAndDrop;
import me.PM2.AdvancedCrates.gui.previeweditor.CratePreviewEditor;
import me.PM2.AdvancedCrates.playerHandler.PlayerData;
import me.PM2.AdvancedCrates.utils.InventoryCompatibilityUtils;
import me.PM2.AdvancedCrates.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class InventoryActionListener
implements Listener {
    MonthlyCrate amc;

    public InventoryActionListener(MonthlyCrate monthlyCrate) {
        this.amc = monthlyCrate;
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent inventoryDragEvent) {
        Player player = (Player)inventoryDragEvent.getWhoClicked();
        PlayerData playerData = this.amc.getPlayerDataManager().getPlayerData(player.getUniqueId().toString());
        if (playerData.isInRewardMenu()) {
            inventoryDragEvent.setCancelled(true);
        } else if (playerData.isInOpenMenu() && !(playerData.getOpenMenu() instanceof DragAndDrop)) {
            if (InventoryCompatibilityUtils.getTopInventory(player) != null && inventoryDragEvent.getInventory() == InventoryCompatibilityUtils.getTopInventory(player)) {
                inventoryDragEvent.setCancelled(true);
            }
        } else if (playerData.isInOpenMenu() && InventoryCompatibilityUtils.getTopInventory(player) != null && playerData.getOpenMenu() instanceof CratePreviewEditor && inventoryDragEvent.getRawSlots().equals(inventoryDragEvent.getInventorySlots())) {
            try {
                Iterator iterator = inventoryDragEvent.getInventorySlots().iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    ((CratePreviewEditor)playerData.getOpenMenu()).manageClick(n, true, (ItemStack)inventoryDragEvent.getNewItems().values().iterator().next());
                }
                inventoryDragEvent.setCancelled(true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onCratesClaimClose(InventoryCloseEvent inventoryCloseEvent) {
        if (inventoryCloseEvent.getPlayer() instanceof Player) {
            Player player = (Player)inventoryCloseEvent.getPlayer();
            PlayerData playerData = this.amc.getPlayerDataManager().getPlayerData(player.getUniqueId().toString());
            if (playerData.isInCratesClaimMenu() && !playerData.isInCratesClaimMenuRewardList()) {
                this.preventDupeReopen(player, inventoryCloseEvent.getInventory(), false);
                playerData.setInCratesClaimMenu(false);
                Crate crate = playerData.getOpenCrate();
                if (crate == null) {
                    return;
                }
                playerData.getCratesClaimRewardList().forEach(reward -> reward.giveReward(player, crate, 0.0));
                Utils.sendFinalMessages(crate, playerData.getCratesClaimRewardList(), player);
                playerData.setInCratesClaimMenu(false);
                playerData.setInCratesClaimMenuRewardList(false);
                player.closeInventory();
                playerData.setRerolledAmount(0);
                playerData.closeCrate();
            } else if (playerData.isInCratesClaimMenu() && playerData.isInCratesClaimMenuRewardList()) {
                playerData.setInCratesClaimMenu(false);
                playerData.setInCratesClaimMenuRewardList(false);
                if (playerData.getOpenMenu().getLastMenu() != null) {
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.amc, () -> playerData.getOpenMenu().up(), 1L);
                }
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent inventoryCloseEvent) {
        Player player = (Player)inventoryCloseEvent.getPlayer();
        PlayerData playerData = this.amc.getPlayerDataManager().getPlayerData(player.getUniqueId().toString());
        playerData.setLastPage(null);
        if (playerData.getOpenMenu() instanceof CratePreviewEditor) {
            ((CratePreviewEditor)playerData.getOpenMenu()).getCustomRewardDisplayer().saveAllPages();
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.amc, () -> {
                if (playerData.getOpenMenu() instanceof CratePreviewEditor) {
                    playerData.getOpenMenu().up();
                }
            }, 1L);
        } else if (playerData.isInRewardMenu()) {
            playerData.setInRewardMenu(false);
        } else if (playerData.isInOpenMenu() && !playerData.getOpenMenu().isInInputMenu() && !playerData.isInCratesClaimMenu() && !playerData.isInCratesClaimMenuRewardList()) {
            playerData.setOpenMenu(null);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onInventoryClickPreviewItems(final InventoryClickEvent inventoryClickEvent) {
        final ItemStack itemStack = inventoryClickEvent.getCurrentItem();
        if (itemStack == null || itemStack.getType() == Material.AIR || itemStack.getAmount() <= 0) {
            return;
        }
        if (MinecraftVersion.isOlderOrEqualThanVersion(MinecraftVersion.MC1_20_R3)) {
            final NBTItem nBTItem = new NBTItem(itemStack);
            if (nBTItem.hasKey("AMC.Reward").booleanValue() && nBTItem.hasKey("AMC").booleanValue()) {
                if (itemStack != null && nBTItem.getItem().isSimilar(itemStack)) {
                    itemStack.setType(Material.AIR);
                }
                inventoryClickEvent.setCancelled(true);
                new BukkitRunnable(){

                    public void run() {
                        inventoryClickEvent.getWhoClicked().getInventory().forEach(itemStack -> {
                            if (itemStack != null && itemStack.getType() != Material.AIR && itemStack.isSimilar(nBTItem.getItem())) {
                                inventoryClickEvent.getWhoClicked().getInventory().remove(itemStack);
                            }
                        });
                    }
                }.runTaskLater((Plugin)MonthlyCrate.getInstance(), 1L);
            }
        } else if (NBT.hasTrueTag(itemStack, "AMC.Reward") && NBT.hasTrueTag(itemStack, "AMC")) {
            if (itemStack != null) {
                itemStack.setType(Material.AIR);
            }
            inventoryClickEvent.setCancelled(true);
            new BukkitRunnable(){

                public void run() {
                    inventoryClickEvent.getWhoClicked().getInventory().forEach(itemStack2 -> {
                        if (itemStack2 != null && itemStack2.getType() != Material.AIR && itemStack2.isSimilar(itemStack)) {
                            inventoryClickEvent.getWhoClicked().getInventory().remove(itemStack2);
                        }
                    });
                }
            }.runTaskLater((Plugin)MonthlyCrate.getInstance(), 1L);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        PlayerData playerData = this.amc.getPlayerDataManager().getPlayerData(player.getUniqueId().toString());
        int n = inventoryClickEvent.getSlot();
        if (playerData.isInRewardMenu()) {
            inventoryClickEvent.setCancelled(true);
            if (this.isntPlayerInventory(inventoryClickEvent, playerData) && playerData.isInRewardMenu() && playerData.getLastPage() != null) {
                playerData.getLastPage().handleInput(player, inventoryClickEvent.getSlot());
            }
        }
    }

    @EventHandler
    public void onIGCClick(InventoryClickEvent inventoryClickEvent) {
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        PlayerData playerData = this.amc.getPlayerDataManager().getPlayerData(player.getUniqueId().toString());
        if (playerData.isInOpenMenu() && inventoryClickEvent.getClickedInventory() != null && InventoryCompatibilityUtils.getTopInventory(player) != null) {
            if (inventoryClickEvent.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY && !(playerData.getOpenMenu() instanceof DragAndDrop)) {
                inventoryClickEvent.setCancelled(true);
            }
            try {
                if (playerData.getOpenMenu() instanceof DragAndDrop) {
                    if (inventoryClickEvent.getSlot() == 52 || inventoryClickEvent.getSlot() == 53) {
                        playerData.getOpenMenu().manageClick(inventoryClickEvent.getSlot());
                        inventoryClickEvent.setCancelled(true);
                        return;
                    }
                    return;
                }
                playerData.getOpenMenu().manageClick(inventoryClickEvent.getSlot());
                inventoryClickEvent.setCancelled(true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void preventDupeReopen(Player player, Inventory inventory, boolean bl) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.amc, () -> {
            if (bl && this.amc.getPlayerDataManager().getPlayerData(player.getUniqueId().toString()).isInRewardMenu()) {
                return;
            }
            if (inventory.getType().equals((Object)InventoryType.CRAFTING)) {
                return;
            }
            player.openInventory(inventory);
            player.closeInventory();
        }, 1L);
    }

    public boolean isntPlayerInventory(InventoryClickEvent inventoryClickEvent, PlayerData playerData) {
        if (inventoryClickEvent.getClickedInventory() != null && inventoryClickEvent.getWhoClicked().getInventory() != null) {
            return !inventoryClickEvent.getClickedInventory().equals((Object)inventoryClickEvent.getWhoClicked().getInventory());
        }
        return false;
    }
}

