/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.inventory;

import com.cryptomorin.xseries.advancedcrates.XMaterial;
import me.PM2.AdvancedCrates.rewards.ItemBuilder;
import me.PM2.AdvancedCrates.utils.VersionUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class InventoryBuilder {
    protected final int minimumSlots;
    private final String invName;
    private Inventory inv;
    private Player player;

    public InventoryBuilder(Player player, int n, String string) {
        this(player, n, string, 0);
    }

    public InventoryBuilder(Player player, int n, String string, int n2) {
        this.invName = string;
        this.minimumSlots = n2;
        this.player = player;
        String string2 = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        if (VersionUtils.Version.v1_12.isServerVersionOrEarlier() && string2.length() > 31) {
            string2 = string2.substring(0, 32);
        }
        this.setInv(Bukkit.createInventory((InventoryHolder)player, (int)Math.min(54, Math.max(n2, n)), (String)string2));
    }

    public void clear() {
        for (int i = 0; i < this.inv.getSize(); ++i) {
            this.setItem(i, new ItemBuilder(XMaterial.AIR));
        }
    }

    public int getSize() {
        return this.getInv().getSize();
    }

    public String getName() {
        return this.invName;
    }

    public void setItem(int n, ItemStack itemStack) {
        this.getInv().setItem(n, itemStack);
    }

    public void setItem(int n, ItemBuilder itemBuilder) {
        this.getInv().setItem(n, itemBuilder.getItemStack());
    }

    public void open() {
        this.getPlayer().openInventory(this.getInv());
    }

    public Inventory getInv() {
        return this.inv;
    }

    public void setInv(Inventory inventory) {
        this.inv = inventory;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }
}

