/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.gui.reroll;

import com.cryptomorin.xseries.advancedcrates.XMaterial;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.gui.Menu;
import me.PM2.AdvancedCrates.gui.reroll.RerollRewardList;
import me.PM2.AdvancedCrates.hologramHandler.PacketHologram;
import me.PM2.AdvancedCrates.inventory.InventoryBuilder;
import me.PM2.AdvancedCrates.playerHandler.PlayerData;
import me.PM2.AdvancedCrates.rewards.CompressedRerollPermission;
import me.PM2.AdvancedCrates.rewards.ItemBuilder;
import me.PM2.AdvancedCrates.rewards.Reward;
import me.PM2.AdvancedCrates.utils.Common;
import me.PM2.AdvancedCrates.utils.Utils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class RerollReward
extends Menu {
    Crate crate;
    List<Reward> rewards;
    Player pl;
    List<ItemStack> prizes;
    PlayerData pData;
    boolean canReroll = false;
    boolean decided = false;

    public RerollReward(Player player, Menu menu, String string, Crate crate, List<Reward> list, List<ItemStack> list2) {
        super(MonthlyCrate.getInstance(), player, menu, "&a&lCollect prize?");
        PlayerData playerData;
        this.pData = playerData = MonthlyCrate.getInstance().getPlayerDataManager().getPlayerData(player.getUniqueId().toString());
        this.rewards = list;
        this.pl = player;
        this.prizes = list2;
        playerData.setOpenMenu(this);
        playerData.setInCratesClaimMenu(true);
        this.crate = crate;
        this.pData.setCratesClaimRewardList(list);
        new BukkitRunnable(){

            public void run() {
                RerollReward.this.checkIfDecided();
            }
        }.runTaskLater((Plugin)MonthlyCrate.getInstance(), 1800L);
    }

    @Override
    public void openMenu() {
        InventoryBuilder inventoryBuilder = this.createDefault(9);
        ItemStack itemStack = new ItemBuilder(XMaterial.GREEN_STAINED_GLASS_PANE).setName(Common.colorize("&aCollect prize")).setLore("&7Click to collect prize").setGlow(true).toItemStack();
        ItemStack itemStack2 = new ItemBuilder(XMaterial.ENDER_CHEST).setName(Common.colorize("&aPreview won prizes")).setLore("&7Click to preview all won rewards").setGlow(true).toItemStack();
        ItemBuilder itemBuilder = new ItemBuilder(XMaterial.RED_STAINED_GLASS_PANE).setName(Common.colorize("&cReroll prize")).setLore("&7Click to roll again for a").addLoreLine("&7chance of a different prize");
        int n = 0;
        CompressedRerollPermission compressedRerollPermission2 = null;
        for (CompressedRerollPermission compressedRerollPermission3 : this.crate.getRerollPermissions()) {
            if (!this.pl.hasPermission(compressedRerollPermission3.getPermission()) || compressedRerollPermission3.getAmount() <= n) continue;
            n = compressedRerollPermission3.getAmount();
            compressedRerollPermission2 = compressedRerollPermission3;
        }
        int n2 = n;
        if (n2 <= this.pData.getRerolledAmount()) {
            compressedRerollPermission2 = this.crate.getRerollPermissions().stream().filter(compressedRerollPermission -> compressedRerollPermission.getAmount() > n2).findFirst().orElse(compressedRerollPermission2);
            for (CompressedRerollPermission compressedRerollPermission3 : this.crate.getRerollPermissions()) {
                if (compressedRerollPermission3.getAmount() <= n2 || compressedRerollPermission3.getAmount() >= compressedRerollPermission2.getAmount()) continue;
                compressedRerollPermission2 = compressedRerollPermission3;
            }
            if (compressedRerollPermission2.getAmount() == n2) {
                itemBuilder.addLoreLine("").addLoreLine("&7Not available");
            } else if (!compressedRerollPermission2.getAdditionalNoPermMessage().equals("")) {
                itemBuilder.addLoreLine("").addAutomaticLore("&7", 50, compressedRerollPermission2.getAdditionalNoPermMessage());
            }
            this.canReroll = false;
        } else {
            itemBuilder.setGlow(true);
            this.canReroll = true;
        }
        ItemStack itemStack3 = itemBuilder.toItemStack();
        inventoryBuilder.setItem(2, itemStack);
        inventoryBuilder.setItem(4, itemStack2);
        inventoryBuilder.setItem(6, itemStack3);
        inventoryBuilder.open();
        this.putInMenu();
        this.pData.setInCratesClaimMenu(true);
        this.pData.setInCratesClaimMenuRewardList(false);
    }

    @Override
    public void manageClick(int n) {
        if (n == 2) {
            for (Reward reward : this.rewards) {
                reward.giveReward(this.pl, this.crate, 0.0);
            }
            Utils.sendFinalMessages(this.crate, this.rewards, this.pl);
            MonthlyCrate.CratesLocationsWithoutPackets.remove(this.pData.getLatestOpenCrateLocation());
            this.pData.setOpeningCrate(false, this.pData.getLatestOpenCrateLocation());
            this.pData.setInCratesClaimMenu(false);
            this.pData.closeCrate();
            this.pl.closeInventory();
            this.pData.setRerolledAmount(0);
            this.decided = true;
        } else if (n == 4) {
            this.pData.setInCratesClaimMenu(false);
            new RerollRewardList(this.pl, this, "&f&lWon Rewards Preview", this.crate, this.rewards, this.pData).openMenu();
        } else if (n == 6 && this.canReroll) {
            Object object;
            if (this.crate.getPlacedLocations().contains(this.pData.getLatestOpenCrateLocation())) {
                if (this.crate.getHiddenHologramsLocations().containsKey(this.pl.getUniqueId())) {
                    this.crate.getHiddenHologramsLocations().get(this.pl.getUniqueId()).add(this.pData.getLatestOpenCrateLocation());
                } else {
                    object = new HashSet();
                    object.add(this.pData.getLatestOpenCrateLocation());
                    this.crate.getHiddenHologramsLocations().put(this.pl.getUniqueId(), (Set<Location>)object);
                }
                new BukkitRunnable(){

                    public void run() {
                        List<PacketHologram> list = RerollReward.this.crate.getHolograms(RerollReward.this.pl.getUniqueId(), RerollReward.this.pData.getLatestOpenCrateLocation());
                        list.forEach(packetHologram -> RerollReward.this.crate.getHandler().sendPacket(RerollReward.this.pl, packetHologram.getDestroyPacket()));
                        if (RerollReward.this.pData.getLatestOpenCrateLocation().getBlock().getType() == Material.AIR || RerollReward.this.crate.getAnimation().equalsIgnoreCase("Display")) {
                            RerollReward.this.pl.sendBlockChange(RerollReward.this.pData.getLatestOpenCrateLocation(), Material.AIR, (byte)0);
                        }
                    }
                }.runTaskLater((Plugin)MonthlyCrate.getInstance(), 1L);
            }
            try {
                object = this.pData.getLatestOpenCrateLocation();
                if (object != null) {
                    MonthlyCrate.CratesLocationsWithoutPackets.remove(object);
                    if (this.pData.getOpenCrate() == null) {
                        this.pData.setOpenCrate(this.crate);
                    }
                    this.pData.setOpeningCrate(true, (Location)object);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.pData.setInCratesClaimMenu(false);
            this.pl.closeInventory();
            MonthlyCrate.openCrate(this.pData.getLatestOpenCrateLocation(), this.pl, this.crate.getName());
            this.pData.setRerolledAmount(this.pData.getRerolledAmount() + 1);
            this.decided = true;
        }
    }

    @Override
    public void handleClick(int n) {
    }

    @Override
    public boolean handleInput(String string, String string2) {
        return false;
    }

    public void checkIfDecided() {
        if (this.decided || !this.pData.isInCratesClaimMenu()) {
            return;
        }
        for (Reward reward : this.rewards) {
            reward.giveReward(this.pl, this.crate, 0.0);
        }
        Utils.sendFinalMessages(this.crate, this.rewards, this.pl);
        if (MonthlyCrate.getInstance().getMessages().get("Took_Too_Long_To_Reroll") != null && !MonthlyCrate.getInstance().getMessages().get("Took_Too_Long_To_Reroll").equals("")) {
            Common.tell((CommandSender)this.pl, MonthlyCrate.getInstance().getMessages().get("Took_Too_Long_To_Reroll"));
        }
        MonthlyCrate.CratesLocationsWithoutPackets.remove(this.pData.getLatestOpenCrateLocation());
        this.pData.setOpeningCrate(false, this.pData.getLatestOpenCrateLocation());
        this.pData.setInCratesClaimMenu(false);
        this.pData.closeCrate();
        this.pl.closeInventory();
        this.pData.setRerolledAmount(0);
        this.decided = true;
    }
}

