/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.gui.previeweditor;

import com.cryptomorin.xseries.advancedcrates.SkullUtils;
import com.cryptomorin.xseries.advancedcrates.XMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.config.SimpleConfig;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.gui.InputMenu;
import me.PM2.AdvancedCrates.gui.ListSelector;
import me.PM2.AdvancedCrates.gui.MainMenu;
import me.PM2.AdvancedCrates.gui.Menu;
import me.PM2.AdvancedCrates.gui.displaymenu.RewardDisplayType;
import me.PM2.AdvancedCrates.gui.displaymenu.custom.CustomRewardDisplayer;
import me.PM2.AdvancedCrates.gui.previeweditor.CratePreviewPageChooser;
import me.PM2.AdvancedCrates.inventory.InventoryBuilder;
import me.PM2.AdvancedCrates.rewards.ItemBuilder;
import me.PM2.AdvancedCrates.utils.Common;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CratePreviewMenu
extends MainMenu {
    boolean isCustom;
    private Crate crate;

    public CratePreviewMenu(MonthlyCrate monthlyCrate, Player player, Crate crate, Menu menu) {
        super(monthlyCrate, player, menu, "&7&l> &6&lReward Preview Menu");
        this.crate = crate;
        this.isCustom = crate.getRewardDisplayType().equals((Object)RewardDisplayType.CUSTOM) || crate.getRewardDisplayType().equals((Object)RewardDisplayType.IN_ORDER_MULTIPAGE);
    }

    @Override
    public void openMenu() {
        InventoryBuilder inventoryBuilder = this.createDefault(18);
        ItemBuilder itemBuilder = new ItemBuilder(XMaterial.PAPER);
        itemBuilder.setName("&aInventory Name");
        itemBuilder.addLore("&7Current Value:").addLore("&f" + this.crate.getDisplayer().getInvName());
        itemBuilder.addLore("").addAutomaticLore("&7", 30, "Edit the name of the reward preview menu.");
        ItemBuilder itemBuilder2 = new ItemBuilder(XMaterial.BEACON);
        itemBuilder2.setName("&aPreview Menu Type");
        itemBuilder2.addLore("&7Current Value:").addLore("&f" + this.crate.getRewardDisplayType().name());
        itemBuilder2.addLore("").addAutomaticLore("&7", 30, "Edit the type of display the reward preview menu will be: from sorted to completely custom made!");
        ItemBuilder itemBuilder3 = new ItemBuilder(XMaterial.BOOK);
        itemBuilder3.setName("&aRequire Permission");
        itemBuilder3.addLore("&7Current Value:");
        itemBuilder3.addLore("&f" + this.crate.getDisplayer().isRequirePermForPreview());
        itemBuilder3.addLore("").addAutomaticLore("&7", 30, "Should the permission that is required to open the crate ALSO be required to open the reward preview menu? You would set this to 'true' if you want players who don't have the correct permission for the crate also to not be able to preview the rewards in the crate.");
        ItemBuilder itemBuilder4 = new ItemBuilder(XMaterial.ARROW);
        ItemBuilder itemBuilder5 = new ItemBuilder(XMaterial.ARROW);
        ItemBuilder itemBuilder6 = new ItemBuilder(this.isCustom ? XMaterial.LADDER : XMaterial.RED_DYE);
        itemBuilder6.setName((this.isCustom ? "&a" : "&4") + "Edit the Reward Preview");
        if (this.isCustom) {
            itemBuilder6.addAutomaticLore("&7", 30, "Edit the reward preview menu to be exactly how you want!");
            itemBuilder6.addLore("").addAutomaticLore("&e", 30, "PLEASE READ THE 'HELP' MESSAGE THAT APPEARS TO LEARN HOW TO CONFIGURE IT.");
            itemBuilder5.setName("&aSelect the backward page button");
            itemBuilder5.addAutomaticLore("&7", 30, "Put an item in preview-menu editor that will be the backward button. Select that exact item here to assign it to be the 'backward page' button.");
            itemBuilder4.setName("&aSelect the forward page button");
            itemBuilder4.addAutomaticLore("&7", 30, "Put an item in preview-menu editor that will be the forward button. Select that item exact here to assign it to be the 'forward page' button.");
        } else {
            itemBuilder6.addAutomaticLore("&c", 30, "To edit the preview menu manually, please set the Preview Menu Type to CUSTOM.");
            itemBuilder4.setName("&cSelect the forward page button");
            itemBuilder4.addAutomaticLore("&c", 30, "To edit the forward button manually, please set the Preview Menu Type to CUSTOM.");
            itemBuilder5.setName("&cSelect the backward page button");
            itemBuilder5.addAutomaticLore("&c", 30, "To edit the backward button manually, please set the Preview Menu Type to CUSTOM.");
        }
        ItemStack itemStack = new ItemBuilder(XMaterial.PLAYER_HEAD).setName("&cExit").setLore("&4&oNOTE: THIS DOES NOT SAVE CHANGES").addLoreLine("").addLoreLine("&7Exit or return to the previous menu.").toItemStack();
        itemStack.setItemMeta((ItemMeta)SkullUtils.applySkin(itemStack.getItemMeta(), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMWQxYTNjOTY1NjIzNDg1MjdkNTc5OGYyOTE2MDkyODFmNzJlMTZkNjExZjFhNzZjMGZhN2FiZTA0MzY2NSJ9fX0="));
        inventoryBuilder.setItem(9, itemStack);
        ItemStack itemStack2 = new ItemBuilder(XMaterial.PLAYER_HEAD).setLore("&7Note: click reload to").addLoreLine("&7see the changes.").setName("&fSave all settings").toItemStack();
        itemStack2.setItemMeta((ItemMeta)SkullUtils.applySkin(itemStack2.getItemMeta(), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZWUyOGJlYTlkMzkzNzNkMzZlZThmYTQwZWM4M2Y5YzNmY2RkOTMxNzUyMjc3NDNmOWRkMWY3ZTc4ODZiN2VlNSJ9fX0="));
        inventoryBuilder.setItem(0, itemStack2);
        inventoryBuilder.setItem(2, itemBuilder);
        inventoryBuilder.setItem(3, itemBuilder3);
        inventoryBuilder.setItem(4, itemBuilder2);
        inventoryBuilder.setItem(6, itemBuilder6);
        inventoryBuilder.setItem(15, itemBuilder4);
        inventoryBuilder.setItem(16, itemBuilder5);
        inventoryBuilder.open();
        this.putInMenu();
    }

    @Override
    public void handleClick(int n) {
        switch (n) {
            case 9: {
                this.up();
                break;
            }
            case 0: {
                this.crate.getConfig().saveConfig();
                Common.tell((CommandSender)this.getP(), "Saved!");
                break;
            }
            case 2: {
                new InputMenu(this.getAMC(), this.getP(), "inventory name", this.crate.getDisplayer().getInvName(), String.class, this, false);
                break;
            }
            case 3: {
                this.crate.getDisplayer().setRequirePermForPreview(!this.crate.getDisplayer().isRequirePermForPreview());
                this.open();
                break;
            }
            case 4: {
                new ListSelector(this.getAMC(), this.getP(), this, "preview menu type", Arrays.asList(RewardDisplayType.values()), XMaterial.PAPER, 1, RewardDisplayType.descriptions()).open();
                break;
            }
            case 6: 
            case 15: 
            case 16: {
                if (this.isCustom) {
                    CustomRewardDisplayer customRewardDisplayer;
                    try {
                        customRewardDisplayer = (CustomRewardDisplayer)this.crate.getDisplayer();
                    }
                    catch (Exception exception) {
                        Common.tell((CommandSender)this.getP(), "Please SAVE and RELOAD before editing.");
                        break;
                    }
                    if (n == 6) {
                        new CratePreviewPageChooser(this.getAMC(), this.getP(), this.crate, this, 1).open();
                        for (int i = 0; i < 30; ++i) {
                            Common.tell((CommandSender)this.getP(), "");
                        }
                        Common.tell((CommandSender)this.getP(), "&4&lHow to configure the CUSTOM preview menu.");
                        Common.tell((CommandSender)this.getP(), "");
                        Common.tell((CommandSender)this.getP(), "&6&lCreating the menu.");
                        Common.tell((CommandSender)this.getP(), "&eIt's very similar to just drag and drop but not exactly the same. Click any blank space with nothing in hand to bring up a reward selector to add a reward to that spot. This is just a convenience so that if you edit a rewards chance, name, lore, etc. in the future it will automatically update. You can also add any normal items you want! To do this, hold an item in your hand and click or click and drag it into the slots. It does not get placed into the inventory, it simply sets the slot you clicked to that item. So if you only want one item at a slot, make sure the stack you're holding in your cursor is only 1 item, not a stack. To remove items OR rewards, just click them with a blank cursor and they'll disappear. All of the items support any customizations that rewards do (names, lores, enchants, etc.)! Just make sure you customize the items before you put them in the inventory!");
                        Common.tell((CommandSender)this.getP(), "&6&lMultiple page support");
                        Common.tell((CommandSender)this.getP(), "&eIn this menu, click the 'paper' to add more pages to the preview menu. This is if you have more than 54 rewards or if you want to make it really fancy!");
                        Common.tell((CommandSender)this.getP(), "&6&lForward / Backwards Buttons");
                        Common.tell((CommandSender)this.getP(), "&eIf you only have one page, you can ignore all of this: these buttons are optional. To navigate between these pages, you can add forward and backwards buttons! FIRST, make sure that you create the preview menu and add some item that will be the 'forward' and some item that will be the 'backwards' button (THIS MEANS DESIGN IT ALL FIRST). Then, on the previous menu, click the arrow, and choose the item that will be the forward button and click the other arrow to choose the item that will be the backwards button. This assigns that specific item to be the forward or backward button - you can move it around wherever you want or have as many of them as you want!");
                        Common.tell((CommandSender)this.getP(), "&c&l!! &6&lPLEASE READ THE MESSAGE ABOVE. &c&l!!");
                        Common.tell((CommandSender)this.getP(), "&c&l!! &6&lPLEASE READ THE MESSAGE ABOVE. &c&l!!");
                        break;
                    }
                    if (n == 15) {
                        new ListSelector(this.getAMC(), this.getP(), (Menu)this, "Forward Button", new ArrayList<String>(customRewardDisplayer.getItems().keySet()), XMaterial.PAPER, 1, customRewardDisplayer.getDescriptors(), new ArrayList<ItemBuilder>(customRewardDisplayer.getItems().values())).open();
                        break;
                    }
                    if (n != 16) break;
                    new ListSelector(this.getAMC(), this.getP(), (Menu)this, "Backwards Button", new ArrayList<String>(customRewardDisplayer.getItems().keySet()), XMaterial.PAPER, 1, customRewardDisplayer.getDescriptors(), new ArrayList<ItemBuilder>(customRewardDisplayer.getItems().values())).open();
                    break;
                }
                Common.tell((CommandSender)this.getP(), "The preview menu type is not CUSTOM. If you just changed it, you need to save and reload the plugin.");
            }
        }
    }

    @Override
    public boolean handleInput(String string, String string2) {
        SimpleConfig simpleConfig = this.crate.getConfig();
        if (string.equalsIgnoreCase("preview menu type")) {
            RewardDisplayType rewardDisplayType = RewardDisplayType.valueOf(string2);
            this.crate.setRewardDisplayType(rewardDisplayType);
            simpleConfig.set("PreviewMenu.Type", string2);
            Common.tell((CommandSender)this.getP(), "PLEASE RELOAD NOW. Set the preview menu type to '" + string2 + "'.");
        } else {
            if (string.equalsIgnoreCase("inventory name")) {
                this.crate.getDisplayer().setName(string2);
                simpleConfig.set("PreviewMenu.Name", ItemBuilder.fromChatColorStatic(string2));
                Common.tell((CommandSender)this.getP(), "Set the inventory name to '" + string2 + "'");
                return true;
            }
            if (string.equalsIgnoreCase("Forward Button")) {
                CustomRewardDisplayer customRewardDisplayer = (CustomRewardDisplayer)this.crate.getDisplayer();
                simpleConfig.set("PreviewMenu.CustomDisplay.NextPageItem", string2);
                customRewardDisplayer.setNextPageItem(string2);
                Common.tell((CommandSender)this.getP(), "Set the forward button to " + string2);
            } else if (string.equalsIgnoreCase("Backwards Button")) {
                CustomRewardDisplayer customRewardDisplayer = (CustomRewardDisplayer)this.crate.getDisplayer();
                simpleConfig.set("PreviewMenu.CustomDisplay.LastPageItem", string2);
                customRewardDisplayer.setPrevPageItem(string2);
                Common.tell((CommandSender)this.getP(), "Set the backwards button to " + string2);
            }
        }
        return false;
    }
}

