/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.gui.displaymenu.custom;

import com.cryptomorin.xseries.advancedcrates.XMaterial;
import java.util.ArrayList;
import java.util.List;
import me.PM2.AdvancedCrates.config.SimpleConfig;
import me.PM2.AdvancedCrates.gui.displaymenu.custom.CustomDefaultRewardDisplayer;
import me.PM2.AdvancedCrates.gui.displaymenu.custom.CustomRewardDisplayer;
import me.PM2.AdvancedCrates.inventory.InventoryBuilder;
import me.PM2.AdvancedCrates.playerHandler.PlayerData;
import me.PM2.AdvancedCrates.rewards.ItemBuilder;
import me.PM2.AdvancedCrates.rewards.Reward;
import me.PM2.AdvancedCrates.rewards.SaveableItemBuilder;
import me.PM2.AdvancedCrates.utils.Common;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;

public class DisplayPage {
    public static final String PREFIX = "PreviewMenu.CustomDisplay.Pages";
    private CustomRewardDisplayer customRewardDisplayer;
    private CustomDefaultRewardDisplayer customDefaultRewardDisplayer;
    private final int pageNum;
    private int slots;
    private String[][] unformattedInv;
    private Reward[][] rewards;
    private SaveableItemBuilder[][] builders;

    public DisplayPage(CustomRewardDisplayer customRewardDisplayer, int n) {
        this.customRewardDisplayer = customRewardDisplayer;
        this.pageNum = n;
    }

    public DisplayPage(CustomDefaultRewardDisplayer customDefaultRewardDisplayer, int n) {
        this.customDefaultRewardDisplayer = customDefaultRewardDisplayer;
        this.pageNum = n;
    }

    public void save() {
        int n;
        if (this.builders == null) {
            this.buildFormat();
        }
        SimpleConfig simpleConfig = this.customRewardDisplayer != null ? this.customRewardDisplayer.getCrate().getConfig() : this.customDefaultRewardDisplayer.getCrate().getConfig();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < 6; ++n) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < 9; ++i) {
                Object object;
                if (this.builders[n][i] == null) {
                    object = this.rewards[n][i];
                    if (object == null) {
                        stringBuilder.append(",");
                        continue;
                    }
                    stringBuilder.append(((Reward)object).getPathWithoutCrate()).append(",");
                    continue;
                }
                object = this.builders[n][i];
                boolean bl = false;
                Object object2 = (this.customRewardDisplayer != null ? this.customRewardDisplayer.getItems().keySet() : this.customDefaultRewardDisplayer.getItems().keySet()).iterator();
                while (object2.hasNext()) {
                    String string = object2.next();
                    SaveableItemBuilder saveableItemBuilder = this.customRewardDisplayer != null ? this.customRewardDisplayer.getItems().get(string) : this.customDefaultRewardDisplayer.getItems().get(string);
                    if (!saveableItemBuilder.getItemStack().isSimilar(((ItemBuilder)object).getItemStack())) continue;
                    stringBuilder.append(string).append(",");
                    bl = true;
                    break;
                }
                if (bl) continue;
                Object object3 = object2 = this.customRewardDisplayer != null ? this.customRewardDisplayer.getNextSymbol() : this.customDefaultRewardDisplayer.getNextSymbol();
                if (this.customRewardDisplayer != null) {
                    this.customRewardDisplayer.getItems().put((String)object2, (SaveableItemBuilder)object);
                } else {
                    this.customDefaultRewardDisplayer.getItems().put((String)object2, (SaveableItemBuilder)object);
                }
                stringBuilder.append((String)object2).append(",");
            }
            arrayList.add(stringBuilder.substring(0, stringBuilder.length() - 1));
        }
        for (n = 5; n >= 0 && ((String)arrayList.get(n)).equals(",,,,,,,,"); --n) {
            arrayList.remove(n);
        }
        simpleConfig.set("PreviewMenu.CustomDisplay.Pages." + this.pageNum, arrayList);
    }

    public boolean load() {
        SimpleConfig simpleConfig;
        SimpleConfig simpleConfig2 = simpleConfig = this.customRewardDisplayer != null ? this.customRewardDisplayer.getCrate().getConfig() : this.customDefaultRewardDisplayer.getCrate().getConfig();
        if (!simpleConfig.contains("PreviewMenu.CustomDisplay.Pages." + this.pageNum)) {
            this.unformattedInv = new String[6][9];
            return false;
        }
        List list = simpleConfig.getStringList("PreviewMenu.CustomDisplay.Pages." + this.pageNum);
        this.slots = list.size() * 9;
        this.unformattedInv = new String[list.size()][9];
        for (int i = 0; i < list.size(); ++i) {
            String string = ((String)list.get(i)).replace(", ", ",");
            String[] stringArray = string.split(",");
            for (int j = 0; j < 9; ++j) {
                this.unformattedInv[i][j] = stringArray.length <= j ? null : stringArray[j];
            }
        }
        return true;
    }

    public void buildUnformattedInv(String string, int n, int n2, String string2, int n3, int n4) {
        if (this.unformattedInv == null) {
            this.unformattedInv = new String[6][9];
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 9; ++j) {
                    if (this.rewards[i][j] == null) continue;
                    this.unformattedInv[i][j] = this.rewards[i][j].getPathWithoutCrate();
                }
            }
            if (string != null) {
                this.unformattedInv[n][n2] = string;
            }
            if (string2 != null) {
                this.unformattedInv[n3][n4] = string2;
            }
        }
    }

    public InventoryBuilder buildInventoryBuilder(Player player) {
        return this.buildInventoryBuilder(player, false);
    }

    public InventoryBuilder buildInventoryBuilder(Player player, boolean bl) {
        return this.buildInventoryBuilder(player, bl, "", null, true);
    }

    public InventoryBuilder buildInventoryBuilder(Player player, boolean bl, String string, InventoryBuilder inventoryBuilder, boolean bl2) {
        int n;
        int n2;
        int n3;
        if (this.slots % 9 > 0) {
            this.slots *= 9;
        }
        InventoryBuilder inventoryBuilder2 = inventoryBuilder == null ? new InventoryBuilder(player, bl ? 54 : this.slots, string.equals("") ? (this.customRewardDisplayer != null ? this.customRewardDisplayer.getInvName() : this.customDefaultRewardDisplayer.getInvName()) : string) : inventoryBuilder;
        if (this.rewards == null || this.builders == null) {
            this.buildFormat();
            return this.buildInventoryBuilder(player, bl, string, inventoryBuilder, bl2);
        }
        if (this.unformattedInv == null) {
            this.unformattedInv = new String[6][9];
            for (n3 = 0; n3 < 6; ++n3) {
                for (n2 = 0; n2 < 9; ++n2) {
                    if (this.rewards[n3][n2] == null) continue;
                    this.unformattedInv[n3][n2] = this.rewards[n3][n2].getPathWithoutCrate();
                }
            }
        }
        if (this.unformattedInv == null && this.rewards.length > 0) {
            for (n3 = 0; n3 < (bl ? 6 : this.rewards.length); ++n3) {
                for (n2 = 0; n2 < (bl ? 9 : this.rewards[0].length); ++n2) {
                    n = n3 * 9 + n2;
                    if (this.builders[n3][n2] == null) {
                        if (this.rewards[n3][n2] == null) continue;
                        inventoryBuilder2.setItem(n, this.rewards[n3][n2].getDisplayBuilder());
                        continue;
                    }
                    inventoryBuilder2.setItem(n, this.builders[n3][n2]);
                }
            }
        } else {
            if (this.rewards[0][0] == null) {
                this.load();
            }
            for (n3 = 0; n3 < (bl ? 6 : this.unformattedInv.length); ++n3) {
                for (n2 = 0; n2 < (bl ? 9 : this.unformattedInv[0].length); ++n2) {
                    if (n3 != 0 || n2 == 0) {
                        // empty if block
                    }
                    n = n3 * 9 + n2;
                    if (this.builders[n3][n2] == null) {
                        if (this.rewards[n3][n2] == null) continue;
                        inventoryBuilder2.setItem(n, this.rewards[n3][n2].getDisplayBuilder());
                        continue;
                    }
                    inventoryBuilder2.setItem(n, this.builders[n3][n2]);
                }
            }
        }
        if (inventoryBuilder == null && bl2) {
            PlayerData playerData = this.customRewardDisplayer != null ? this.customRewardDisplayer.getCrate().getInstance().getPlayerDataManager().getPlayerData(player.getUniqueId().toString()) : this.customDefaultRewardDisplayer.getCrate().getInstance().getPlayerDataManager().getPlayerData(player.getUniqueId().toString());
            Inventory inventory = inventoryBuilder2.getInv();
            DisplayPage displayPage = this;
            Bukkit.getScheduler().runTaskLater((Plugin)playerData.getInstance(), () -> {
                player.openInventory(inventory);
                playerData.setLastPage(displayPage);
                playerData.setInRewardMenu(true);
            }, 2L);
        }
        return inventoryBuilder2;
    }

    public void buildFormat() {
        this.rewards = new Reward[6][9];
        this.builders = new SaveableItemBuilder[6][9];
        SaveableItemBuilder saveableItemBuilder = new SaveableItemBuilder(XMaterial.AIR);
        for (int i = 0; i < this.unformattedInv.length; ++i) {
            for (int j = 0; j < this.unformattedInv[0].length; ++j) {
                Reward reward;
                if (this.unformattedInv[i][j] == null) continue;
                String string = this.unformattedInv[i][j];
                if (string.isEmpty()) {
                    this.builders[i][j] = saveableItemBuilder;
                    continue;
                }
                if (this.customRewardDisplayer != null ? this.customRewardDisplayer.getItems().containsKey(string) : this.customDefaultRewardDisplayer.getItems().containsKey(string)) {
                    this.builders[i][j] = this.customRewardDisplayer != null ? this.customRewardDisplayer.getItems().get(string) : this.customDefaultRewardDisplayer.getItems().get(string);
                    continue;
                }
                Reward reward2 = reward = this.customRewardDisplayer != null ? this.customRewardDisplayer.getCrate().getRewardByName(string) : this.customDefaultRewardDisplayer.getCrate().getRewardByName(string);
                if (reward == null) continue;
                this.rewards[i][j] = reward;
            }
        }
    }

    public void handleInput(Player player, int n) {
        int n2 = n / 9;
        int n3 = n % 9;
        String string = this.unformattedInv[n2][n3];
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase(this.customRewardDisplayer != null ? this.customRewardDisplayer.getNextPageItem() : this.customDefaultRewardDisplayer.getNextPageItem())) {
            if (this.customRewardDisplayer != null ? this.customRewardDisplayer.getPages().containsKey(this.pageNum + 1) : this.customDefaultRewardDisplayer.getPages().containsKey(this.pageNum + 1)) {
                if (this.customRewardDisplayer != null) {
                    this.customRewardDisplayer.getPages().get(this.pageNum + 1).buildInventoryBuilder(player);
                } else {
                    this.customDefaultRewardDisplayer.getPages().get(this.pageNum + 1).buildInventoryBuilder(player);
                }
            } else {
                Common.tell((CommandSender)player, "Page " + (this.pageNum + 1) + " does not exist. Please contact an administratorto create the next page of the reward-preview menu OR remove this 'next page arrow' because thereis no next page.");
            }
        } else if (string.equalsIgnoreCase(this.customRewardDisplayer != null ? this.customRewardDisplayer.getPrevPageItem() : this.customDefaultRewardDisplayer.getPrevPageItem())) {
            if (this.customRewardDisplayer != null ? this.customRewardDisplayer.getPages().containsKey(this.pageNum - 1) : this.customDefaultRewardDisplayer.getPages().containsKey(this.pageNum - 1)) {
                if (this.customRewardDisplayer != null) {
                    this.customRewardDisplayer.getPages().get(this.pageNum - 1).buildInventoryBuilder(player);
                } else {
                    this.customDefaultRewardDisplayer.getPages().get(this.pageNum - 1).buildInventoryBuilder(player);
                }
            } else {
                Common.tell((CommandSender)player, "Page " + (this.pageNum - 1) + " does not exist. Please contact an administratorto create the previous page of the reward-preview menu OR remove this 'previous page arrow' because thereis no previous page.");
            }
        } else if (string.equalsIgnoreCase(this.customRewardDisplayer != null ? this.customRewardDisplayer.getExitPreviewItem() : this.customDefaultRewardDisplayer.getExitPreviewItem())) {
            player.closeInventory();
        }
    }

    public List<Reward> rewardsAsList() {
        ArrayList<Reward> arrayList = new ArrayList<Reward>();
        if (this.rewards == null) {
            this.buildFormat();
        }
        for (Reward[] rewardArray : this.rewards) {
            for (int i = 0; i < 9; ++i) {
                if (rewardArray[i] == null) continue;
                arrayList.add(rewardArray[i]);
            }
        }
        return arrayList;
    }

    public int getSlots() {
        return this.slots;
    }

    public void setSlots(int n) {
        this.slots = n;
    }

    public Reward[][] getRewards() {
        return this.rewards;
    }

    public void setRewards(Reward[][] rewardArray) {
        this.rewards = rewardArray;
    }

    public String[][] getUnformattedInv() {
        return this.unformattedInv;
    }

    public void setUnformattedInv(String[][] stringArray) {
        this.unformattedInv = stringArray;
    }

    public ItemBuilder[][] getBuilders() {
        return this.builders;
    }

    public void setBuilders(SaveableItemBuilder[][] saveableItemBuilderArray) {
        this.builders = saveableItemBuilderArray;
    }
}

