/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.gui.displaymenu.custom;

import com.cryptomorin.xseries.advancedcrates.XMaterial;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.PM2.AdvancedCrates.config.SimpleConfig;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.gui.displaymenu.RewardDisplayer;
import me.PM2.AdvancedCrates.gui.displaymenu.custom.DisplayPage;
import me.PM2.AdvancedCrates.inventory.InventoryBuilder;
import me.PM2.AdvancedCrates.rewards.SaveableItemBuilder;
import me.PM2.AdvancedCrates.utils.Utils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class CustomRewardDisplayer
extends RewardDisplayer {
    public static final String PREFIX = "PreviewMenu.CustomDisplay.Items";
    private final HashMap<Integer, DisplayPage> pages = new HashMap();
    private final HashMap<String, SaveableItemBuilder> items = new HashMap();
    private String nextPageItem;
    private String prevPageItem;
    private String exitPreviewItem;

    public CustomRewardDisplayer(Crate crate) {
        super(crate);
    }

    @Override
    public void open(Player player) {
        player.openInventory(this.createInventory(player).getInv());
        this.getCrate().getInstance().getPlayerDataManager().getPlayerData(player.getUniqueId().toString()).setInRewardMenu(true);
    }

    @Override
    public InventoryBuilder createInventory(Player player) {
        if (this.pages.containsKey(1)) {
            return this.pages.get(1).buildInventoryBuilder(player);
        }
        return null;
    }

    @Override
    public void load() {
        ConfigurationSection configurationSection;
        this.loadDefaults();
        SimpleConfig simpleConfig = this.getCrate().getConfig();
        if (simpleConfig.isConfigurationSection(PREFIX)) {
            configurationSection = simpleConfig.getConfigurationSection(PREFIX);
            for (String string : configurationSection.getKeys(false)) {
                SaveableItemBuilder saveableItemBuilder = new SaveableItemBuilder(XMaterial.STONE);
                boolean bl = saveableItemBuilder.loadItem(this.getCrate().getConfig(), "PreviewMenu.CustomDisplay.Items." + string);
                if (!bl) continue;
                this.items.put(string, saveableItemBuilder);
            }
        }
        if (simpleConfig.isConfigurationSection("PreviewMenu.CustomDisplay")) {
            configurationSection = simpleConfig.getConfigurationSection("PreviewMenu.CustomDisplay");
            if (configurationSection.contains("NextPageItem")) {
                this.nextPageItem = configurationSection.getString("NextPageItem");
            }
            if (configurationSection.contains("LastPageItem")) {
                this.prevPageItem = configurationSection.getString("LastPageItem");
            }
            if (configurationSection.contains("ExitPreviewItem")) {
                this.exitPreviewItem = configurationSection.getString("ExitPreviewItem");
            }
        }
        if (simpleConfig.isConfigurationSection("PreviewMenu.CustomDisplay.Pages")) {
            configurationSection = simpleConfig.getConfigurationSection("PreviewMenu.CustomDisplay.Pages");
            for (String string : configurationSection.getKeys(false)) {
                int n;
                DisplayPage displayPage;
                boolean bl;
                if (!Utils.isInt(string) || !(bl = (displayPage = new DisplayPage(this, n = Integer.parseInt(string))).load())) continue;
                this.pages.put(n, displayPage);
            }
        }
    }

    public void saveAllPages() {
        for (DisplayPage object : this.getPages().values()) {
            object.save();
        }
        SimpleConfig simpleConfig = this.getCrate().getConfig();
        simpleConfig.set(PREFIX, null);
        for (String string : this.getItems().keySet()) {
            SaveableItemBuilder saveableItemBuilder = this.getItems().get(string);
            String string2 = "PreviewMenu.CustomDisplay.Items." + string;
            saveableItemBuilder.saveItem(simpleConfig, string2, true);
        }
    }

    public String getNextSymbol() {
        for (int i = 0; i < 1000; ++i) {
            if (this.getItems().containsKey("e" + i + "")) continue;
            return "e" + i + "";
        }
        return "-1";
    }

    public List<String> getDescriptors() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SaveableItemBuilder saveableItemBuilder : this.getItems().values()) {
            arrayList.add("&fItem Name: " + saveableItemBuilder.getDisplayName());
        }
        return arrayList;
    }

    public Map<String, SaveableItemBuilder> getItems() {
        return this.items;
    }

    public String getNextPageItem() {
        return this.nextPageItem;
    }

    public void setNextPageItem(String string) {
        this.nextPageItem = string;
    }

    public String getPrevPageItem() {
        return this.prevPageItem;
    }

    public void setPrevPageItem(String string) {
        this.prevPageItem = string;
    }

    public String getExitPreviewItem() {
        return this.exitPreviewItem;
    }

    public void setExitPreviewItem(String string) {
        this.exitPreviewItem = string;
    }

    public Map<Integer, DisplayPage> getPages() {
        return this.pages;
    }
}

