/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.gui.displaymenu.custom;

import com.cryptomorin.xseries.advancedcrates.XMaterial;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.PM2.AdvancedCrates.config.SimpleConfig;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.gui.displaymenu.RewardDisplayer;
import me.PM2.AdvancedCrates.gui.displaymenu.custom.DisplayPage;
import me.PM2.AdvancedCrates.inventory.InventoryBuilder;
import me.PM2.AdvancedCrates.rewards.ItemBuilder;
import me.PM2.AdvancedCrates.rewards.Reward;
import me.PM2.AdvancedCrates.rewards.SaveableItemBuilder;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class CustomDefaultRewardDisplayer
extends RewardDisplayer {
    public static final String PREFIX = "PreviewMenu.CustomDisplay.Items";
    private final HashMap<Integer, DisplayPage> pages = new HashMap();
    private final HashMap<String, SaveableItemBuilder> items = new HashMap();
    private String nextPageItem;
    private String prevPageItem;
    private String exitPreviewItem;

    public CustomDefaultRewardDisplayer(Crate crate) {
        super(crate);
    }

    @Override
    public void open(Player player) {
        this.createInventory(player);
        this.getCrate().getInstance().getPlayerDataManager().getPlayerData(player.getUniqueId().toString()).setInRewardMenu(true);
    }

    @Override
    public InventoryBuilder createInventory(Player player) {
        if (this.pages.containsKey(1)) {
            return this.pages.get(1).buildInventoryBuilder(player);
        }
        return null;
    }

    @Override
    public void load() {
        this.loadDefaults();
        Reward[] rewardArray = this.getCrate().getAllRewards().toArray(new Reward[0]);
        SimpleConfig simpleConfig = this.getCrate().getConfig();
        if (simpleConfig.contains("PreviewMenu.Type") && simpleConfig.getString("PreviewMenu.Type").equalsIgnoreCase("IN_ORDER_MULTIPAGE") || simpleConfig.isConfigurationSection("PreviewMenu.CustomDisplay")) {
            ConfigurationSection configurationSection = simpleConfig.getConfigurationSection("PreviewMenu.CustomDisplay");
            if (configurationSection == null) {
                this.setNextPageItem(this.getNextSymbol());
                this.items.put(this.nextPageItem, new SaveableItemBuilder(new ItemBuilder(XMaterial.ARROW).setName("&b&lNext &bPage").getItemStack()));
                simpleConfig.set("PreviewMenu.CustomDisplay.NextPageItem", this.nextPageItem);
                this.items.get(this.nextPageItem).saveItem(simpleConfig, "PreviewMenu.CustomDisplay.Items." + this.getNextPageItem(), true);
                this.setPrevPageItem(this.getNextSymbol());
                this.items.put(this.getPrevPageItem(), new SaveableItemBuilder(new ItemBuilder(XMaterial.ARROW).setName("&b&lPrevious &bPage").getItemStack()));
                simpleConfig.set("PreviewMenu.CustomDisplay.LastPageItem", this.getPrevPageItem());
                this.items.get(this.prevPageItem).saveItem(simpleConfig, "PreviewMenu.CustomDisplay.Items." + this.getPrevPageItem(), true);
            } else {
                String string2;
                SaveableItemBuilder saveableItemBuilder = new SaveableItemBuilder(XMaterial.ARROW);
                if (configurationSection.contains("NextPageItem")) {
                    this.nextPageItem = configurationSection.getString("NextPageItem");
                    saveableItemBuilder.loadItem(simpleConfig, "PreviewMenu.CustomDisplay.NextPageItem." + this.nextPageItem);
                    this.items.put(this.nextPageItem, new SaveableItemBuilder(new ItemBuilder(XMaterial.ARROW).setName("&b&lNext &bPage").getItemStack()));
                } else {
                    string2 = this.getNextSymbol();
                    this.items.put(string2, new SaveableItemBuilder(new ItemBuilder(XMaterial.ARROW).setName("&b&lNext &bPage").getItemStack()));
                    configurationSection.set("NextPageItem", (Object)string2);
                }
                if (configurationSection.contains("LastPageItem")) {
                    this.prevPageItem = configurationSection.getString("LastPageItem");
                    saveableItemBuilder.loadItem(simpleConfig, "PreviewMenu.CustomDisplay.LastPageItem." + this.prevPageItem);
                    this.items.put(this.prevPageItem, new SaveableItemBuilder(new ItemBuilder(XMaterial.ARROW).setName("&b&lNext &bPage").getItemStack()));
                } else {
                    string2 = this.getNextSymbol();
                    this.items.put(string2, new SaveableItemBuilder(new ItemBuilder(XMaterial.ARROW).setName("&b&lPrevious &bPage").getItemStack()));
                    configurationSection.set("LastPageItem", (Object)string2);
                }
                if (configurationSection.contains("ExitPreviewItem")) {
                    this.exitPreviewItem = configurationSection.getString("ExitPreviewItem");
                }
            }
        }
        for (int i = 1; i < rewardArray.length / 45 + 2; ++i) {
            int n = i;
            DisplayPage displayPage = new DisplayPage(this, n);
            Reward[][] rewardArray2 = new Reward[6][9];
            SaveableItemBuilder[][] saveableItemBuilderArray = new SaveableItemBuilder[6][9];
            int n2 = (rewardArray.length - (i - 1) * 45) / 9;
            if ((rewardArray.length - (i - 1) * 45) % 9 > 0) {
                ++n2;
            }
            if (n2 > 5) {
                n2 = 5;
            }
            displayPage.setSlots(n2 + 1);
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < 9 && rewardArray.length > (i - 1) * 45 + k + j * 9; ++k) {
                    rewardArray2[j][k] = rewardArray[(i - 1) * 45 + k + j * 9];
                    SaveableItemBuilder saveableItemBuilder = rewardArray[(i - 1) * 45 + k + j * 9].getSaveableItemBuilder();
                    List<String> list = saveableItemBuilder.getLores();
                    saveableItemBuilder.clearLore();
                    Reward reward = rewardArray2[j][k];
                    list.forEach(string -> saveableItemBuilder.addLore(string.replace("%percentage%", Double.toString(this.getCrate().getRewardPercentage(reward))).replace("%chance%", Double.toString(reward.getChance()))));
                    saveableItemBuilderArray[j][k] = saveableItemBuilder;
                }
            }
            displayPage.setRewards(rewardArray2);
            displayPage.setBuilders(saveableItemBuilderArray);
            if (((double)rewardArray.length + 0.0) / 45.0 > (double)i && i > 1) {
                saveableItemBuilderArray[n2][8] = this.items.get(this.nextPageItem);
                saveableItemBuilderArray[n2][0] = this.items.get(this.prevPageItem);
                displayPage.buildUnformattedInv(this.nextPageItem, n2, 8, this.prevPageItem, n2, 0);
            } else if (((double)rewardArray.length + 0.0) / 45.0 > (double)i) {
                saveableItemBuilderArray[n2][8] = this.items.get(this.nextPageItem);
                displayPage.buildUnformattedInv(this.nextPageItem, n2, 8, null, n2, 0);
            } else if (i > 1) {
                saveableItemBuilderArray[n2][0] = this.items.get(this.prevPageItem);
                displayPage.buildUnformattedInv(null, n2, 8, this.prevPageItem, n2, 0);
            }
            this.pages.put(n, displayPage);
        }
    }

    public void saveAllPages() {
        for (DisplayPage object : this.getPages().values()) {
            object.save();
        }
        SimpleConfig simpleConfig = this.getCrate().getConfig();
        simpleConfig.set(PREFIX, null);
        for (String string : this.getItems().keySet()) {
            SaveableItemBuilder saveableItemBuilder = this.getItems().get(string);
            String string2 = "PreviewMenu.CustomDisplay.Items." + string;
            saveableItemBuilder.saveItem(simpleConfig, string2, true);
        }
    }

    public String getNextSymbol() {
        for (int i = 0; i < 1000; ++i) {
            if (this.getItems().containsKey("e" + i + "")) continue;
            return "e" + i + "";
        }
        return "-1";
    }

    public List<String> getDescriptors() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SaveableItemBuilder saveableItemBuilder : this.getItems().values()) {
            arrayList.add("&fItem Name: " + saveableItemBuilder.getDisplayName());
        }
        return arrayList;
    }

    public Map<String, SaveableItemBuilder> getItems() {
        return this.items;
    }

    public String getNextPageItem() {
        return this.nextPageItem;
    }

    public void setNextPageItem(String string) {
        this.nextPageItem = string;
    }

    public String getPrevPageItem() {
        return this.prevPageItem;
    }

    public void setPrevPageItem(String string) {
        this.prevPageItem = string;
    }

    public String getExitPreviewItem() {
        return this.exitPreviewItem;
    }

    public void setExitPreviewItem(String string) {
        this.exitPreviewItem = string;
    }

    public Map<Integer, DisplayPage> getPages() {
        return this.pages;
    }
}

