/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.gui.displaymenu;

import me.PM2.AdvancedCrates.config.SimpleConfig;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.inventory.InventoryBuilder;
import me.PM2.AdvancedCrates.utils.Utils;
import org.bukkit.entity.Player;

public abstract class RewardDisplayer {
    private final Crate crate;
    private final SimpleConfig config;
    private String name = null;
    private boolean requirePermForPreview = false;

    public RewardDisplayer(Crate crate) {
        this.crate = crate;
        this.config = crate.getConfig();
    }

    public abstract void open(Player var1);

    public abstract InventoryBuilder createInventory(Player var1);

    public abstract void load();

    public void openFor(Player player) {
        this.open(player);
    }

    public String getInvName() {
        if (this.name == null) {
            return Utils.toChatColor(this.getCrate().getPreviewTitle().replace("%crate%", this.getCrate().getDisplayName()));
        }
        return Utils.toChatColor(this.name);
    }

    public void loadDefaults() {
        if (this.config.contains("PreviewMenu.Name")) {
            this.name = this.config.getString("PreviewMenu.Name");
        }
    }

    public void saveToFile() {
        this.crate.getConfig().set("PreviewMenu.Type", this.getCrate().getRewardDisplayType().name());
        this.crate.getConfig().set("PreviewMenu.Name", this.name);
    }

    public Crate getCrate() {
        return this.crate;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isRequirePermForPreview() {
        return this.requirePermForPreview;
    }

    public void setRequirePermForPreview(boolean bl) {
        this.requirePermForPreview = bl;
    }
}

