/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.gui;

import com.cryptomorin.xseries.advancedcrates.SkullUtils;
import com.cryptomorin.xseries.advancedcrates.XMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.gui.ColoredArmour;
import me.PM2.AdvancedCrates.gui.InputMenu;
import me.PM2.AdvancedCrates.gui.ListEditor;
import me.PM2.AdvancedCrates.gui.ListSelector;
import me.PM2.AdvancedCrates.gui.Menu;
import me.PM2.AdvancedCrates.inventory.InventoryBuilder;
import me.PM2.AdvancedCrates.rewards.CompressedEnchantment;
import me.PM2.AdvancedCrates.rewards.CompressedPotionEffect;
import me.PM2.AdvancedCrates.rewards.ItemBuilder;
import me.PM2.AdvancedCrates.rewards.Reward;
import me.PM2.AdvancedCrates.utils.Common;
import me.PM2.AdvancedCrates.utils.Utils;
import me.PM2.AdvancedCrates.utils.VersionUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemEditor
extends Menu {
    ItemBuilder newItem;
    ItemBuilder oldItem;
    Reward reward;

    public ItemEditor(MonthlyCrate monthlyCrate, Player player, Menu menu, Reward reward) {
        super(monthlyCrate, player, menu, "&7&l> &6&lItem Editor");
        this.newItem = reward.getSaveableItemBuilder();
        this.reward = reward;
    }

    public ItemEditor(MonthlyCrate monthlyCrate, Player player, Menu menu, ItemBuilder itemBuilder) {
        super(monthlyCrate, player, menu, "&7&l> &6&lItem Editor");
        this.newItem = itemBuilder;
        if (this.newItem == null) {
            this.newItem = new ItemBuilder(XMaterial.STONE);
        }
    }

    @Override
    public void openMenu() {
        InventoryBuilder inventoryBuilder = this.createDefault(45);
        ItemStack itemStack = new ItemBuilder(XMaterial.PLAYER_HEAD).setName("&cExit").setLore("&4&oNOTE: THIS DOES NOT SAVE CHANGES").addLoreLine("").addLoreLine("&7Exit or return to the previous menu.").toItemStack();
        itemStack.setItemMeta((ItemMeta)SkullUtils.applySkin(itemStack.getItemMeta(), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMWQxYTNjOTY1NjIzNDg1MjdkNTc5OGYyOTE2MDkyODFmNzJlMTZkNjExZjFhNzZjMGZhN2FiZTA0MzY2NSJ9fX0="));
        inventoryBuilder.setItem(0, itemStack);
        ItemBuilder itemBuilder = new ItemBuilder(XMaterial.WRITABLE_BOOK);
        itemBuilder.setName("&aEdit the lore");
        itemBuilder.addLoreLine("&7Current value:");
        for (String object32 : this.newItem.getLores()) {
            itemBuilder.addLoreLine("&7- " + object32);
        }
        itemBuilder.addLoreLine("").addAutomaticLore("&f", 30, "Edit the lore of the display item. Remove all lines and leave the lore blank to use the default lore in the config.yml");
        ItemBuilder itemBuilder2 = new ItemBuilder(XMaterial.PAPER);
        itemBuilder2.setName("&aEdit the display name");
        itemBuilder2.addLoreLine("&7Current value:").addLoreLine("&7" + this.newItem.getName(false));
        itemBuilder2.addLoreLine("").addAutomaticLore("&f", 30, "Set the display name of the display item.");
        ItemBuilder itemBuilder3 = new ItemBuilder(XMaterial.ENCHANTING_TABLE);
        itemBuilder3.setName("&aEdit the enchantments");
        itemBuilder3.addLoreLine("&7Current value:");
        for (CompressedEnchantment compressedEnchantment : this.newItem.getEnchantments()) {
            itemBuilder3.addLoreLine("&7- " + compressedEnchantment.toString());
        }
        itemBuilder3.addLoreLine("").addAutomaticLore("&f", 30, "Edit the enchantments of the display item. FORMATTED: enchantment;level");
        ItemBuilder itemBuilder4 = new ItemBuilder(XMaterial.NAME_TAG);
        itemBuilder4.setName("&aEdit the nbt-tags  &rTemporarily unavailable");
        itemBuilder4.addLoreLine("&7Current value:");
        itemBuilder4.addLoreLine("&7- " + this.newItem.getNBTTags());
        itemBuilder4.addLoreLine("").addAutomaticLore("&f", 30, "Edit the NBT Tags of an item.");
        ItemBuilder itemBuilder5 = new ItemBuilder(this.newItem.isGlowing() ? XMaterial.NETHER_STAR : XMaterial.QUARTZ);
        itemBuilder5.setName("&aEdit if the item is glowing");
        itemBuilder5.addLoreLine("&7Current value:").addLoreLine("&7" + this.newItem.isGlowing());
        itemBuilder5.addLoreLine("").addAutomaticLore("&f", 30, "This will toggle whether or not the display item will have a glowing effect. For enchanted items, if this value is true, the enchantments will be hidden.");
        itemBuilder5.addLoreLine("").addAutomaticLore("&e&l", 30, "Same as HIDE ENCHANTS");
        ItemBuilder itemBuilder6 = new ItemBuilder(XMaterial.POTION);
        if (this.newItem.getItem().getType().toString().contains("POTION")) {
            itemBuilder6.setName("&aEdit the potion effects");
            itemBuilder6.addLoreLine("&7Current value:");
            for (CompressedPotionEffect compressedPotionEffect : this.newItem.getPotionEffects()) {
                itemBuilder6.addLoreLine("&7- " + compressedPotionEffect.toString());
            }
            itemBuilder6.addLoreLine("").addAutomaticLore("&f", 30, "Edit the potion effects of the display item. FORMATTED: potioneffect;duration;amplifier");
        } else {
            itemBuilder6.setName("&cEdit the potion effects");
            itemBuilder6.addLoreLine("").addLoreLine("&cCurrent item is not a potion.");
        }
        ItemBuilder itemBuilder7 = new ItemBuilder(XMaterial.STONE_BUTTON);
        itemBuilder7.setName("&aEdit the amount.");
        itemBuilder7.addLoreLine("&7Current value:");
        itemBuilder7.addLoreLine("&7" + this.newItem.getItem().getAmount());
        itemBuilder7.addLoreLine("").addAutomaticLore("&f", 30, "Edit the amount of in the stack of items.");
        ItemBuilder itemBuilder8 = new ItemBuilder(this.newItem);
        itemBuilder8.setLore(new ArrayList<String>());
        itemBuilder8.setName("&aEdit the item material");
        itemBuilder8.addLoreLine("&7Current value:").addLoreLine("&7" + this.newItem.getItem().getType().toString());
        itemBuilder8.addLoreLine("").addAutomaticLore("&f", 30, "Edit ONLY the material of this item, none of the other values will be changed.");
        ItemBuilder itemBuilder9 = new ItemBuilder(this.newItem);
        itemBuilder8.setLore(new ArrayList<String>());
        itemBuilder9.setName("&aEdit EVERYTHING");
        itemBuilder9.addLoreLine("").addAutomaticLore("&f", 30, "Edit EVERYTHING AT ONCE. This will update all of these values to the item you are HOLDING IN HAND. The only value it will not effect is the 'glowing' effect, everything else will be updated: name, lore, enchants, etc. Therefore, everything will be overwritten!");
        ItemBuilder itemBuilder10 = new ItemBuilder(XMaterial.REDSTONE);
        itemBuilder10.setName("&aEdit the Item Flags");
        itemBuilder10.addLoreLine("").addAutomaticLore("&f", 30, "Edit the attributes of the item such as HIDE_ENCHANTS, HIDE_ATTRIBUTES, etc.");
        itemBuilder10.addLoreLine("").addAutomaticLore("&c", 30, "Note: If glow is set to true, HIDE_ENCHANTS will ALWAYS be true unless glow: false.");
        ItemBuilder itemBuilder11 = new ItemBuilder(XMaterial.LIGHT_BLUE_DYE);
        if (itemBuilder8.isColorable()) {
            itemBuilder11.setName("&aEdit the armour Color");
            itemBuilder11.addLoreLine("&7Current Value:").addLoreLine("&7" + itemBuilder8.getColor().getR() + ", " + itemBuilder8.getColor().getG() + ", " + itemBuilder8.getColor().getB());
            itemBuilder11.addLoreLine("").addAutomaticLore("&f", 30, "Edit the red, green, and blue values of the colored armour.");
        } else {
            itemBuilder11.setName("&cEdit the armour Color");
            itemBuilder11.addLoreLine("").addLoreLine("&cThis item is not colorable.");
        }
        ItemBuilder itemBuilder12 = new ItemBuilder(XMaterial.GOLDEN_AXE);
        itemBuilder12.setDamage(20);
        itemBuilder12.setName("&aEdit the item damage");
        itemBuilder12.addLoreLine("&7Current Value: ");
        itemBuilder12.addLoreLine("&7" + itemBuilder8.getDamage());
        itemBuilder12.addLoreLine("");
        itemBuilder12.addAutomaticLore("&f", 30, "This is to set the damage of an item, NOT TO SET THE DATA VALUE. If you want a 'damaged' item like red wool or acacia log (for example), use RED_WOOL or ACACIA_LOG - EVEN ON 1.8-1.12. This value is ONLY to damage things like swords.");
        inventoryBuilder.setItem(10, itemBuilder9);
        inventoryBuilder.setItem(11, itemBuilder8);
        inventoryBuilder.setItem(13, itemBuilder2);
        inventoryBuilder.setItem(14, itemBuilder);
        inventoryBuilder.setItem(15, itemBuilder3);
        inventoryBuilder.setItem(16, itemBuilder5);
        inventoryBuilder.setItem(22, itemBuilder4);
        inventoryBuilder.setItem(23, itemBuilder7);
        inventoryBuilder.setItem(24, itemBuilder6);
        inventoryBuilder.setItem(25, itemBuilder10);
        inventoryBuilder.setItem(32, itemBuilder11);
        inventoryBuilder.setItem(33, itemBuilder12);
        inventoryBuilder.open();
        this.putInMenu();
    }

    @Override
    public void handleClick(int n) {
        switch (n) {
            case 0: {
                this.up();
                break;
            }
            case 10: {
                ItemStack itemStack = VersionUtils.Version.v1_9.isServerVersionOrLater() ? this.getP().getInventory().getItemInMainHand() : this.getP().getItemInHand();
                if (itemStack != null && !itemStack.getType().equals((Object)Material.AIR)) {
                    this.newItem.setItem(itemStack.clone());
                    if (this.newItem.getItem().getType() == XMaterial.PLAYER_HEAD.parseMaterial()) {
                        this.newItem.setBase64texture(SkullUtils.getSkinValue(this.newItem.getItemMeta()));
                    }
                    this.open();
                    break;
                }
                Common.tell((CommandSender)this.getP(), "&cYou are not holding anything in your hand!");
                break;
            }
            case 11: {
                new InputMenu(this.amc, this.getP(), "item material", this.newItem.getItem().getType().toString(), String.class, this);
                break;
            }
            case 13: {
                new InputMenu(this.amc, this.getP(), "displayname", this.newItem.getName(false), String.class, this);
                break;
            }
            case 14: {
                new ListEditor(this.amc, this.getP(), (Menu)this, "Lore", "Line", this.newItem.getLores(), XMaterial.PAPER, 1, this.newItem).open();
                break;
            }
            case 15: {
                new ListEditor(this.amc, this.getP(), this, "Enchantments", "Enchantment", this.newItem.getEnchantments(), XMaterial.ENCHANTED_BOOK, 1, CompressedEnchantment.class, "fromString", "That is not formatted ENCHANTMENT;LEVEL or either the enchantment name is wrong or the level is not a number.").open();
                break;
            }
            case 16: {
                this.newItem.setGlow(!this.newItem.isGlowing());
                this.open();
                break;
            }
            case 22: {
                break;
            }
            case 23: {
                new InputMenu(this.amc, this.getP(), "amount", this.newItem.getItem().getAmount() + "", Integer.class, this);
                break;
            }
            case 24: {
                if (this.newItem.getItem().getType().toString().contains("POTION")) {
                    new ListEditor(this.amc, this.getP(), this, "Potion Effects", "Potion", this.newItem.getPotionEffects(), XMaterial.GLASS_BOTTLE, 1, CompressedPotionEffect.class, "fromString", "That is not formatted POTIONTYPE;DURATION;AMPLIFIER or either the potion effect name is incorrect, or either the duration or amplifier aren't numbers.").open();
                    break;
                }
                Common.tell((CommandSender)this.getP(), "&cThe current item is not a potion.");
                break;
            }
            case 25: {
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<ItemBuilder> arrayList2 = new ArrayList<ItemBuilder>();
                for (ItemFlag itemFlag : ItemFlag.values()) {
                    if (this.newItem.getItemFlags().contains(itemFlag)) {
                        arrayList2.add(new ItemBuilder(XMaterial.LIME_WOOL).setName("&a").setLore("&cClick to remove this item flag"));
                        continue;
                    }
                    arrayList2.add(new ItemBuilder(XMaterial.RED_WOOL).setName("&c").setLore("&aClick to add this item flag"));
                }
                new ListSelector(this.amc, this.getP(), (Menu)this, "Item Flags", Arrays.asList(ItemFlag.values()), XMaterial.PAPER, 1, arrayList, arrayList2).open();
                break;
            }
            case 32: {
                if (this.newItem.isColorable()) {
                    new ColoredArmour(this.amc, this.getP(), (Menu)this, this.newItem).open();
                    break;
                }
                Common.tell((CommandSender)this.getP(), "&cThe current item is not a colorable piece of armor");
                break;
            }
            case 33: {
                new InputMenu(this.amc, this.getP(), "damage", this.newItem.getDamage() + "", Integer.class, this);
            }
        }
    }

    @Override
    public boolean handleInput(String string, String string2) {
        if (string.equalsIgnoreCase("item material")) {
            if (Utils.getItem(string2) != null) {
                this.newItem.setItem(Utils.getItem(string2));
                Common.tell((CommandSender)this.getP(), "&aSet the " + string + " to " + string2);
                return true;
            }
            Common.tell((CommandSender)this.getP(), "&c" + string2 + " is not a valid material name.");
        } else {
            if (string.equalsIgnoreCase("displayname")) {
                this.newItem.setName(Common.colorize(string2));
                if (this.reward != null) {
                    this.reward.getItemBuilder().setName(Common.colorize(string2));
                }
                Common.tell((CommandSender)this.getP(), "&aSet the " + string + " to " + string2);
                return true;
            }
            if (string.equalsIgnoreCase("amount")) {
                if (Utils.isInteger(string2)) {
                    this.newItem.getItem().setAmount(Integer.parseInt(string2));
                    Common.tell((CommandSender)this.getP(), "&aSet the amount to " + string2);
                    return true;
                }
                Common.tell((CommandSender)this.getP(), "&c" + string2 + " is not a valid number.");
            } else if (string.equalsIgnoreCase("damage")) {
                if (Utils.isInteger(string2)) {
                    this.newItem.setDamage(Integer.parseInt(string2));
                    Common.tell((CommandSender)this.getP(), "&aSet the damage to " + string2);
                    return true;
                }
                Common.tell((CommandSender)this.getP(), "&c" + string2 + " is not a valid number.");
            } else if (string.equalsIgnoreCase("Item Flags")) {
                ItemFlag itemFlag = ItemFlag.valueOf((String)string2);
                if (this.newItem.getItemFlags().contains(itemFlag)) {
                    this.newItem.removeItemFlag(itemFlag);
                    Common.tell((CommandSender)this.getP(), "&aRemoved flag: " + itemFlag.name());
                } else {
                    this.newItem.addItemFlag(itemFlag);
                    Common.tell((CommandSender)this.getP(), "&aAdded flag: " + itemFlag.name());
                }
            }
        }
        this.oldItem = this.newItem;
        return false;
    }
}

