/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.files;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.files.FileDataLoader;
import me.PM2.AdvancedCrates.utils.Utils;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class FileHandler {
    private static Map<String, FileHandler> map = new HashMap<String, FileHandler>();
    private final MonthlyCrate instance;
    private final FileDataLoader fileDataLoader;
    private String name;
    private String directory = "";
    private String loaded;
    private boolean canBeEdited;
    private boolean saveWithCustomSave;
    private boolean properLoad = false;
    private boolean newFile;
    private FileConfiguration data = null;
    private File dataFile = null;

    public FileHandler(MonthlyCrate monthlyCrate, String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        this.name = string;
        this.instance = monthlyCrate;
        this.directory = string2;
        this.canBeEdited = bl;
        this.saveWithCustomSave = bl2;
        this.newFile = bl3;
        this.fileDataLoader = new FileDataLoader(this);
        map.put(string, this);
    }

    public FileHandler(MonthlyCrate monthlyCrate, String string, boolean bl, boolean bl2) {
        this.name = string;
        this.canBeEdited = bl;
        this.instance = monthlyCrate;
        this.saveWithCustomSave = bl2;
        this.fileDataLoader = new FileDataLoader(this);
        map.put(string, this);
    }

    public FileHandler(MonthlyCrate monthlyCrate, File file, boolean bl, boolean bl2) {
        this.name = file.getName();
        this.canBeEdited = bl;
        this.instance = monthlyCrate;
        this.saveWithCustomSave = bl2;
        this.fileDataLoader = new FileDataLoader(this);
        map.put(this.name, this);
    }

    public static void clearLoaded() {
        map.clear();
        map = new HashMap<String, FileHandler>();
    }

    public static Map<String, FileHandler> getMap() {
        return map;
    }

    public static void setMap(Map<String, FileHandler> map) {
        FileHandler.map = map;
    }

    public void loadFile() {
        if (this.getDataFile() == null) {
            this.setDataFile(new File(new File(this.instance.getDataFolder().getPath() + this.getDirectory()), this.getName()));
            if (this.getName().equalsIgnoreCase("Messages.yml") && !this.folderExists("Crates")) {
                new File(this.instance.getDataFolder().getPath() + this.getDirectory()).mkdir();
                try {
                    this.instance.firstLoadFiles();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void reload() {
        this.loadFile();
        try {
            this.data = YamlConfiguration.loadConfiguration((File)this.getDataFile());
            if (this.canBeEdited) {
                this.data.saveToString();
                if (this.name.equalsIgnoreCase("Rewards.YML") || !this.data.saveToString().equalsIgnoreCase("")) {
                    File file = new File(this.instance.getDataFolder(), this.getName());
                    if (file.exists()) {
                        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
                        this.getData().setDefaults((Configuration)yamlConfiguration);
                    }
                    if (this.isCanBeEdited()) {
                        this.loadByByte();
                    }
                    this.properLoad = true;
                } else if (!this.newFile) {
                    throw new NullPointerException("Failed to load the file " + this.getName());
                }
            } else {
                this.properLoad = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Utils.log(new String[]{"Failed to load the " + this.name + " file due to a critical error. Please fix the file and restart your server.", "Oftentimes, if this is your first time loading the server, a simple reload or restart fixes the issue!"});
            this.properLoad = false;
        }
    }

    private void loadByByte() {
        if (this.saveWithCustomSave) {
            try {
                this.getData().load(this.getDataFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getString(String string) {
        return this.get().getString(string);
    }

    public int getInt(String string) {
        return this.get().getInt(string);
    }

    public double getDouble(String string) {
        return this.get().getDouble(string);
    }

    public boolean getBoolean(String string) {
        return this.get().getBoolean(string);
    }

    public long getLong(String string) {
        return this.get().getLong(string);
    }

    public List<String> getStringList(String string) {
        return this.get().getStringList(string);
    }

    public ConfigurationSection getConfigurationSection(String string) {
        return this.get().getConfigurationSection(string);
    }

    public boolean isSet(String string) {
        return this.get().isSet(string);
    }

    public boolean contains(String string) {
        return this.get().contains(string);
    }

    public void set(String string, Object object) {
        this.get().set(string, object);
    }

    public boolean folderExists(String string) {
        try {
            for (File file : this.instance.getDataFolder().listFiles()) {
                if (!file.isDirectory() || !file.getName().equalsIgnoreCase(string.replace("/", ""))) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void save() {
        if (this.getData() == null || this.getDataFile() == null) {
            return;
        }
        try {
            if (this.properLoad || this.newFile) {
                if (!this.isSaveWithCustomSave() || this.newFile) {
                    this.get().save(this.getDataFile());
                } else {
                    this.get().save(this.getDataFile());
                }
            } else {
                Utils.log(this.name + " file not saving to prevent it from further damage.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.instance.getLogger().log(Level.SEVERE, exception, () -> "Could not save config to " + this.getDataFile());
        }
    }

    private void saveByByte() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object2 : this.getData().saveToString().split("\n")) {
            if (this.isCommentLine(object2)) continue;
            arrayList.add(object2);
        }
        ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(this.getLoaded().split("\n")));
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (String string : arrayList) {
            StringBuilder stringBuilder2 = new StringBuilder();
            String string2 = Utils.stripFromWhitespace(string);
            if (!this.isCommentLine(string)) {
                String string3;
                String[] stringArray = string2.split(":");
                int n = 0;
                int n2 = 0;
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    string3 = (String)iterator.next();
                    if (Utils.stripFromWhitespace(string3).split(":")[0].equals(stringArray[0])) {
                        if (!hashMap.containsKey(stringArray[0]) || (Integer)hashMap.get(stringArray[0]) < n2) {
                            hashMap.put(stringArray[0], n2);
                            break;
                        }
                        ++n2;
                    }
                    ++n;
                }
                for (int i = n - 1; i > -1; --i) {
                    string3 = (String)arrayList2.get(i);
                    if (this.isCommentLine(string3)) {
                        stringBuilder2.insert(0, string3 + "\n");
                        continue;
                    }
                    if (!string3.equalsIgnoreCase(string)) break;
                }
            }
            stringBuilder.append((CharSequence)stringBuilder2).append(string).append("\n");
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.getDataFile());
            byte[] byArray = stringBuilder.toString().getBytes(StandardCharsets.UTF_8);
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void copy(FileHandler fileHandler) {
        int n;
        FileInputStream fileInputStream = new FileInputStream(this.getDataFile());
        FileOutputStream fileOutputStream = new FileOutputStream(fileHandler.getDataFile());
        byte[] byArray = new byte[1024];
        while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        ((InputStream)fileInputStream).close();
        ((OutputStream)fileOutputStream).close();
    }

    public FileConfiguration get() {
        if (this.getData() == null) {
            this.reload();
        }
        return this.getData();
    }

    public void saveDefaults() {
        this.loadFile();
        if (!this.dataFile.exists()) {
            this.instance.saveResource(this.directory + this.name, false);
        }
        if (this.dataFile == null) {
            this.reload();
        }
    }

    public boolean isCommentLine(String string) {
        return string.trim().length() == 0 || string.equalsIgnoreCase("\n") || Utils.stripFromWhitespace(string).startsWith("#");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String string) {
        this.directory = string;
    }

    public String getLoaded() {
        return this.loaded;
    }

    public void setLoaded(String string) {
        this.loaded = string;
    }

    public FileConfiguration getData() {
        return this.data;
    }

    public void setData(FileConfiguration fileConfiguration) {
        this.data = fileConfiguration;
    }

    public File getDataFile() {
        return this.dataFile;
    }

    public void setDataFile(File file) {
        this.dataFile = file;
    }

    public boolean isCanBeEdited() {
        return this.canBeEdited;
    }

    public void setCanBeEdited(boolean bl) {
        this.canBeEdited = bl;
    }

    public boolean isProperLoad() {
        return this.properLoad;
    }

    public void setProperLoad(boolean bl) {
        this.properLoad = bl;
    }

    public boolean isSaveWithCustomSave() {
        return this.saveWithCustomSave;
    }

    public void setSaveWithCustomSave(boolean bl) {
        this.saveWithCustomSave = bl;
    }

    public FileDataLoader getFileDataLoader() {
        return this.fileDataLoader;
    }
}

