/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.files;

import com.cryptomorin.xseries.advancedcrates.XMaterial;
import com.cryptomorin.xseries.advancedcrates.XSound;
import java.util.Optional;
import me.PM2.AdvancedCrates.files.FileHandler;
import me.PM2.AdvancedCrates.rewards.ItemBuilder;
import me.PM2.AdvancedCrates.utils.SoundData;
import me.PM2.AdvancedCrates.utils.Utils;
import org.apache.logging.log4j.status.StatusLogger;

public class FileDataLoader {
    private final FileHandler fileHandler;

    public FileDataLoader(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
    }

    public String loadString(String string, StatusLogger statusLogger) {
        if (!this.fileHandler.get().contains(string)) {
            return "";
        }
        return this.fileHandler.get().getString(string);
    }

    public ItemBuilder loadItem(String string, ItemBuilder itemBuilder) {
        if (!this.fileHandler.get().contains(string)) {
            return itemBuilder;
        }
        String string2 = this.fileHandler.get().getString(string);
        Optional<XMaterial> optional = XMaterial.matchXMaterial(string2.replace(";", ":"));
        if (optional.isPresent()) {
            return new ItemBuilder(optional.get());
        }
        return itemBuilder;
    }

    public SoundData loadSound(String string) {
        if (!this.fileHandler.get().contains(string)) {
            return new SoundData(XSound.values()[0], 0.0f, 0.0f);
        }
        String string2 = this.fileHandler.get().getString(string);
        String[] stringArray = string2.replaceAll("\\s+", "").split(",");
        Optional<XSound> optional = XSound.matchXSound(stringArray[0]);
        if (optional.isPresent()) {
            SoundData soundData = new SoundData(optional.get());
            if (stringArray.length >= 2) {
                if (Utils.isInt(stringArray[1])) {
                    soundData.setVolume(Integer.parseInt(stringArray[1]));
                } else {
                    soundData.setVolume(5);
                }
                if (stringArray.length >= 3) {
                    if (Utils.isInt(stringArray[2])) {
                        soundData.setPitch(Integer.parseInt(stringArray[2]));
                    } else {
                        soundData.setPitch(1.0f);
                    }
                } else {
                    soundData.setPitch(1.0f);
                }
            } else {
                soundData.setVolume(5);
                soundData.setPitch(1.0f);
            }
            return soundData;
        }
        return new SoundData(XSound.values()[0], 0.0f, 0.0f);
    }

    public int loadInt(String string, int n) {
        if (!this.fileHandler.get().contains(string)) {
            return n;
        }
        String string2 = this.fileHandler.get().getString(string);
        if (Utils.isInt(string2)) {
            return Integer.parseInt(string2);
        }
        return n;
    }

    public double loadDouble(String string, double d) {
        if (!this.fileHandler.get().contains(string)) {
            return d;
        }
        String string2 = this.fileHandler.get().getString(string);
        if (Utils.isDouble(string2)) {
            return Double.parseDouble(string2);
        }
        return d;
    }

    public long loadLong(String string, long l) {
        if (!this.fileHandler.get().contains(string)) {
            return l;
        }
        String string2 = this.fileHandler.get().getString(string);
        if (Utils.isLong(string2)) {
            return Long.parseLong(string2);
        }
        return l;
    }

    public boolean loadBoolean(String string, boolean bl) {
        if (!this.fileHandler.get().contains(string)) {
            return bl;
        }
        String string2 = this.fileHandler.get().getString(string);
        if (Utils.isBoolean(string2)) {
            return Boolean.parseBoolean(string2);
        }
        return bl;
    }
}

