/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.displayType;

import java.util.HashMap;
import java.util.Map;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.displayType.DynamicCratePlaceholder;
import me.PM2.AdvancedCrates.displayType.EntityType;
import me.PM2.AdvancedCrates.utils.LocationUtils;
import me.PM2.AdvancedCrates.utils.NPCUtils;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public class MobPlaceholder
extends DynamicCratePlaceholder {
    private static Map<Location, NPC> npcMap = new HashMap<Location, NPC>();
    private EntityType entityType;

    public MobPlaceholder(MonthlyCrate monthlyCrate) {
        super(monthlyCrate);
    }

    public static Map<Location, NPC> getNpcMap() {
        return npcMap;
    }

    public static void setNpcMap(Map<Location, NPC> map) {
        npcMap = map;
    }

    @Override
    public void place(Location location) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.instance, () -> {
            NPC nPC;
            LocationUtils.removeDubBlocks(location);
            NPCRegistry nPCRegistry = CitizensAPI.getNPCRegistry();
            if (NPCUtils.npcExists(location)) {
                nPC = NPCUtils.getNpcForCrate(location);
                if (nPC.getEntity().getType().equals((Object)this.getEntityType().getBukkitEntityType())) {
                    MobPlaceholder.getNpcMap().put(location, nPC);
                    return;
                }
                nPC.destroy();
            }
            nPC = nPCRegistry.createNPC(this.entityType.getBukkitEntityType(), "AdvancedCrates - Crate");
            NPCUtils.applyDefaultInfo(nPC);
            nPC.spawn(LocationUtils.getLocationCentered(location).add(0.0, -1.0, 0.0));
            MobPlaceholder.getNpcMap().put(location, nPC);
        }, 20L);
    }

    @Override
    public void remove(Location location) {
        MobPlaceholder.getNpcMap().remove(location).destroy();
    }

    public boolean existsAt(Location location) {
        return true;
    }

    @Override
    public String getType() {
        return this.entityType == null ? "null" : this.entityType.name();
    }

    @Override
    public void setType(Object object) {
        this.setEntityType(EntityType.getEnum(object.toString()));
    }

    @Override
    public void fixHologram(Location location) {
        Location location2 = location.clone();
        location2.setY(location2.getY() + this.getEntityType().getHeight() - 0.5);
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    @Override
    public String toString() {
        return "Mob";
    }
}

