/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.displayType;

import java.util.HashMap;
import java.util.Map;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.displayType.DynamicCratePlaceholder;
import me.PM2.AdvancedCrates.displayType.EntityType;
import me.PM2.AdvancedCrates.utils.LocationUtils;
import me.PM2.AdvancedCrates.utils.NPCUtils;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public class Citizens2NPCPlaceHolder
extends DynamicCratePlaceholder {
    private static Map<Location, NPC> npcMap = new HashMap<Location, NPC>();
    private String name;

    public Citizens2NPCPlaceHolder(MonthlyCrate monthlyCrate) {
        super(monthlyCrate);
    }

    public static Map<Location, NPC> getNpcMap() {
        return npcMap;
    }

    public static void setNpcMap(Map<Location, NPC> map) {
        npcMap = map;
    }

    @Override
    public void place(Location location) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.instance, () -> {
            NPC nPC;
            LocationUtils.removeDubBlocks(location);
            NPCRegistry nPCRegistry = CitizensAPI.getNPCRegistry();
            if (NPCUtils.npcExists(location)) {
                nPC = NPCUtils.getNpcForCrate(location);
                if (nPC.getEntity().getType().equals((Object)org.bukkit.entity.EntityType.PLAYER)) {
                    Citizens2NPCPlaceHolder.getNpcMap().put(location, nPC);
                    return;
                }
                nPC.destroy();
            }
            nPC = nPCRegistry.createNPC(org.bukkit.entity.EntityType.PLAYER, "AdvancedCrates - Crate");
            nPC.data().setPersistent("player-skin-name", (Object)this.name);
            nPC.spawn(LocationUtils.getLocationCentered(location));
            NPCUtils.applyDefaultInfo(nPC);
            Citizens2NPCPlaceHolder.getNpcMap().put(location, nPC);
        }, 20L);
    }

    @Override
    public void remove(Location location) {
        NPC nPC = Citizens2NPCPlaceHolder.getNpcMap().get(location);
        if (nPC != null) {
            nPC.destroy();
        }
    }

    @Override
    public String getType() {
        return this.getName();
    }

    @Override
    public void setType(Object object) {
        this.setName(object.toString());
    }

    @Override
    public void fixHologram(Location location) {
        Location location2 = location.clone();
        location2.setY(location2.getY() + EntityType.PLAYER.getHeight() - 0.8);
    }

    public void applySkin(NPC nPC, String string) {
        SkinnableEntity skinnableEntity;
        if (nPC.isSpawned() && (skinnableEntity = (SkinnableEntity)nPC.getEntity()) != null) {
            skinnableEntity.setSkinName(string);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String toString() {
        return "NPC";
    }
}

