/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.files.FileHandler;
import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.file.YamlConfiguration;

public class SimpleConfig
extends YamlConfiguration {
    public File file;
    private YamlConfiguration defaults;
    private String[] editHeader;
    private String pathPrefix;

    public SimpleConfig(String string) {
        this(string, true);
    }

    public SimpleConfig(File file) {
        this.file = file;
        this.defaults = new YamlConfiguration();
        this.loadConfig();
    }

    public SimpleConfig(String string, boolean bl) {
        this.defaults = new YamlConfiguration();
        try {
            if (bl) {
                this.defaults = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(SimpleConfig.class.getResourceAsStream("/" + string), StandardCharsets.UTF_8));
                Objects.requireNonNull(this.defaults, "Could not get the default " + string + " inside of your plugin, make sure you created the file and that you did not replace the jar on a running server!");
            } else {
                this.defaults = null;
            }
        }
        catch (Exception exception) {
            this.file = this.extractFromFolder(string);
            this.loadConfig();
            return;
        }
        this.file = this.extract(string);
        this.loadConfig();
    }

    public SimpleConfig(String string, boolean bl, boolean bl2) {
        this.defaults = null;
        try {
            this.file = this.extract(string);
        }
        catch (Exception exception) {
            this.file = new File(string);
        }
        this.loadConfig();
    }

    public void setHeader(String[] stringArray) {
        this.editHeader = stringArray;
    }

    public String[] getEditHeader() {
        return this.editHeader;
    }

    public void setPathPrefix(String string) {
        this.pathPrefix = string;
    }

    public void reloadConfig() {
        this.saveConfig();
        this.loadConfig();
    }

    public void write(String string, Object object) {
        this.set(string, object);
        this.reloadConfig();
    }

    public void saveConfig() {
        try {
            if (this.editHeader != null) {
                this.options().header(StringUtils.join((Object[])this.editHeader, (String)System.lineSeparator()));
                this.options().copyHeader(true);
            }
            super.save(this.file);
        }
        catch (IOException iOException) {
            System.out.println("Failed to save configuration from " + this.file);
            iOException.printStackTrace();
        }
    }

    public void loadConfig() {
        try {
            super.load(this.file);
        }
        catch (Throwable throwable) {
            System.out.println("Failed to load configuration from " + this.file);
            throwable.printStackTrace();
        }
    }

    public Object get(String string, Object object) {
        Object object2;
        if (this.defaults != null) {
            if (object != null && !object.getClass().isPrimitive() && !PrimitiveWrapper.isWrapperType(object.getClass())) {
                throw new IllegalArgumentException("The default value must be null since we use defaults from file inside of the plugin! Path: " + string + ", default called: " + object);
            }
            if (super.get(string, null) == null) {
                object2 = this.defaults.get(string);
                Objects.requireNonNull(object2, "Default " + this.file.getName() + " in your .jar lacks a key at '" + string + "' path");
                this.write(string, object2);
            }
        }
        object2 = new Throwable().getStackTrace()[1].getMethodName();
        if (this.defaults == null && this.pathPrefix != null && !((String)object2).equals("getConfigurationSection") && !((String)object2).equals("get")) {
            string = this.pathPrefix + "." + string;
        }
        return super.get(string, null);
    }

    public void set(String string, Object object) {
        String string2 = new Throwable().getStackTrace()[1].getMethodName();
        if (this.defaults == null && this.pathPrefix != null && !string2.equals("getConfigurationSection") && !string2.equals("get")) {
            string = this.pathPrefix + "." + string;
        }
        super.set(string, object);
    }

    private File extract(String string) {
        MonthlyCrate monthlyCrate = MonthlyCrate.getInstance();
        File file = new File(monthlyCrate.getDataFolder(), string);
        if (file.exists()) {
            return file;
        }
        this.createFileAndDirectory(string);
        if (this.defaults != null) {
            try (InputStream inputStream = monthlyCrate.getResource(string);){
                Objects.requireNonNull(inputStream, "Inbuilt file not found: " + string);
                Files.copy(inputStream, Paths.get(file.toURI()), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file;
    }

    private File extractFromFolder(String string) {
        MonthlyCrate monthlyCrate;
        File file;
        if (string.contains("/Crates")) {
            string = string.replace("/Crates", "");
        }
        if ((file = new File((monthlyCrate = MonthlyCrate.getInstance()).getDataFolder() + "/Crates/" + string)).exists()) {
            return file;
        }
        this.createFileAndDirectoryFromFolder(string);
        if (this.defaults != null) {
            try (InputStream inputStream = monthlyCrate.getResource("Crates/" + string);){
                Objects.requireNonNull(inputStream, "Inbuilt file not found: " + string);
                Files.copy(inputStream, Paths.get(file.toURI()), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file;
    }

    private File createFileAndDirectory(String string) {
        File file = MonthlyCrate.getInstance().getDataFolder();
        int n = string.lastIndexOf(47);
        File file2 = new File(file, string.substring(0, n >= 0 ? n : 0));
        file2.mkdirs();
        File file3 = new File(file, string);
        try {
            file3.createNewFile();
        }
        catch (IOException iOException) {
            System.out.println("Failed to create file " + string);
            iOException.printStackTrace();
        }
        return file3;
    }

    private File createFileAndDirectoryFromFolder(String string) {
        int n = string.lastIndexOf(47);
        File file = new File(MonthlyCrate.getInstance().getDataFolder() + "/Crates", string.substring(0, n >= 0 ? n : 0));
        file.mkdirs();
        File file2 = new File(MonthlyCrate.getInstance().getDataFolder() + "/Crates", string);
        try {
            file2.createNewFile();
        }
        catch (IOException iOException) {
            System.out.println("Failed to create file " + string);
            iOException.printStackTrace();
        }
        return file2;
    }

    public void copy(FileHandler fileHandler) {
        int n;
        FileInputStream fileInputStream = new FileInputStream(this.file);
        FileOutputStream fileOutputStream = new FileOutputStream(fileHandler.getDataFile());
        byte[] byArray = new byte[1024];
        while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        ((InputStream)fileInputStream).close();
        ((OutputStream)fileOutputStream).close();
    }

    public boolean isSet(String string) {
        return super.get(string, null) != null;
    }

    public boolean contains(String string) {
        return super.get(string) != null;
    }

    private static final class PrimitiveWrapper {
        private static final Set<Class<?>> WRAPPER_TYPES = PrimitiveWrapper.getWrapperTypes();

        private PrimitiveWrapper() {
        }

        private static boolean isWrapperType(Class<?> clazz) {
            return WRAPPER_TYPES.contains(clazz);
        }

        private static Set<Class<?>> getWrapperTypes() {
            HashSet hashSet = new HashSet();
            hashSet.add(Boolean.class);
            hashSet.add(Character.class);
            hashSet.add(Byte.class);
            hashSet.add(Short.class);
            hashSet.add(Integer.class);
            hashSet.add(Long.class);
            hashSet.add(Float.class);
            hashSet.add(Double.class);
            hashSet.add(Void.class);
            return hashSet;
        }
    }
}

