/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.animations.vortex;

import java.util.ArrayList;
import java.util.List;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.animations.utils.AnimationHandler;
import me.PM2.AdvancedCrates.animations.utils.AnimationSound;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.hologramHandler.PacketHologram;
import me.PM2.AdvancedCrates.rewards.Reward;
import me.PM2.AdvancedCrates.utils.RepeatingTaskHelper;
import me.PM2.AdvancedCrates.utils.Utils;
import me.PM2.HologramPackets.INMSHandler;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class VortexAnimationV2
extends AnimationHandler {
    private List<PacketHologram> vortexParticles = new ArrayList<PacketHologram>();
    private List<PacketHologram> rewardHolograms = new ArrayList<PacketHologram>();
    private double vortexRadius = 0.1;
    private double vortexHeight = 0.0;
    private int vortexSpeed = 1;
    private boolean rewardsRevealed = false;

    public VortexAnimationV2(RepeatingTaskHelper repeatingTaskHelper, Block block, Player player, Crate crate, INMSHandler iNMSHandler) {
        super(crate, iNMSHandler, player, repeatingTaskHelper);
        this.setBlock(block);
        this.setTargetLocation(block.getLocation().clone().add(0.5, 1.0, 0.5));
        this.setSize(crate.getSize());
        for (int i = 0; i < 20; ++i) {
            PacketHologram packetHologram = new PacketHologram("", this.getTargetLocation(), this.getTargetLocation().getY(), iNMSHandler);
            packetHologram.createEquipmentPacketHelmet(new ItemStack(Material.ENDER_PEARL));
            this.vortexParticles.add(packetHologram);
            this.getAnimationHolograms().add(packetHologram);
            this.getPackets().addAll(packetHologram.getAllPackets(true));
            this.getPackets().addAll(packetHologram.getEquipmentPacket());
        }
        this.getRewards().addAll(this.getRandomRewards(crate.getSize()));
        AnimationSound.COSMIC_BREAKING.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), this.getTargetLocation());
        this.runTaskTimerAsynchronously((Plugin)MonthlyCrate.getInstance(), 0L, 1L);
        this.getTaskHelper().setTaskID(super.getTaskId());
        this.sendPackets();
        this.clearPackets();
    }

    @Override
    public void run() {
        if (this.getCounter() < 100) {
            this.vortexRadius = Math.min(this.vortexRadius + 0.03, 3.0);
            this.vortexHeight = Math.min(this.vortexHeight + 0.05, 4.0);
            for (int i = 0; i < this.vortexParticles.size(); ++i) {
                double d = Math.PI * 2 / (double)this.vortexParticles.size() * (double)i + (double)this.getCounter() * 0.2;
                double d2 = Math.cos(d) * this.vortexRadius;
                double d3 = Math.sin(d) * this.vortexRadius;
                double d4 = this.vortexHeight + Math.sin((double)this.getCounter() * 0.1 + (double)i) * 0.3;
                Location location = this.getTargetLocation().clone().add(d2, d4, d3);
                this.vortexParticles.get(i).teleport(location);
                this.vortexParticles.get(i).createTeleportPacket();
                this.getPackets().add(this.vortexParticles.get(i).getTeleportPacket());
            }
            if (this.getCounter() % 20 == 0) {
                this.getLightningPackets().add(this.getHandler().getLightningPacket(this.getTargetLocation()));
            }
            if (this.getCounter() % 3 == 0) {
                this.sendParticlesAndEffects(this.getTargetLocation().clone().add(0.0, this.vortexHeight / 2.0, 0.0), Utils.isVersionOld() ? "PORTAL" : null, Utils.isVersionOld() ? null : "PORTAL", 20);
            }
        } else if (this.getCounter() < 200) {
            this.vortexSpeed = Math.min(this.vortexSpeed + 1, 10);
            for (int i = 0; i < this.vortexParticles.size(); ++i) {
                double d = Math.PI * 2 / (double)this.vortexParticles.size() * (double)i + (double)(this.getCounter() * this.vortexSpeed) * 0.05;
                double d5 = Math.cos(d) * this.vortexRadius * (1.0 + Math.sin((double)this.getCounter() * 0.1) * 0.2);
                double d6 = Math.sin(d) * this.vortexRadius * (1.0 + Math.sin((double)this.getCounter() * 0.1) * 0.2);
                double d7 = this.vortexHeight + Math.sin((double)this.getCounter() * 0.2 + (double)i) * 0.5;
                Location location = this.getTargetLocation().clone().add(d5, d7, d6);
                this.vortexParticles.get(i).teleport(location);
                this.vortexParticles.get(i).createTeleportPacket();
                this.getPackets().add(this.vortexParticles.get(i).getTeleportPacket());
            }
            if (this.getCounter() % 5 == 0) {
                AnimationSound.COSMIC_GIANT_CHEST_SPINNING.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), this.getTargetLocation());
            }
        } else if (this.getCounter() == 200) {
            this.sendParticlesAndEffects(this.getTargetLocation(), Utils.isVersionOld() ? "EXPLOSION_HUGE" : null, Utils.isVersionOld() ? null : "EXPLOSION_HUGE", 1);
            AnimationSound.GIANT_CRATE_DISAPPEAR.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), this.getTargetLocation());
            this.vortexParticles.forEach(packetHologram -> {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
                this.getPackets().add(packetHologram.getDestroyPacket());
            });
            double d = Math.PI * 2 / (double)this.getRewards().size();
            for (int i = 0; i < this.getRewards().size(); ++i) {
                PacketHologram packetHologram2;
                Reward reward = this.getRewards().get(i);
                double d8 = d * (double)i;
                Location location = this.getTargetLocation().clone().add(Math.cos(d8) * 2.0, 2.0, Math.sin(d8) * 2.0);
                String string = reward.getItemBuilder().getDisplayName().equals("") ? Utils.getDefaultItemName(reward.getReward()) : reward.getItemBuilder().getDisplayName();
                PacketHologram packetHologram3 = new PacketHologram(string, location, location.getY() + 0.8, this.getHandler());
                if (Utils.checkIfContainsTools(reward.getReward().getType())) {
                    packetHologram2 = new PacketHologram("", location, location.getY(), this.getHandler(), 260.0f, 315.0f, 0.0f);
                    packetHologram2.setRightArmPose(260.0f, 315.0f, 0.0f);
                } else if (Utils.checkIfContainsItems(reward.getReward().getType())) {
                    packetHologram2 = new PacketHologram("", location, location.getY(), this.getHandler(), 275.0f, 320.0f, 0.0f);
                    packetHologram2.setRightLegPose(275.0f, 320.0f, 0.0f);
                } else {
                    packetHologram2 = new PacketHologram("", location, location.getY(), this.getHandler(), 350.0f, 325.0f, 345.0f);
                    packetHologram2.setRightArmPose(350.0f, 325.0f, 345.0f);
                }
                packetHologram2.createEquipmentPacket(reward.getReward());
                this.rewardHolograms.add(packetHologram3);
                this.rewardHolograms.add(packetHologram2);
                this.getAnimationHolograms().add(packetHologram3);
                this.getAnimationHolograms().add(packetHologram2);
                this.getPackets().addAll(packetHologram3.getAllPackets(true));
                this.getPackets().addAll(packetHologram2.getAllPackets(true));
                this.getPackets().addAll(packetHologram2.getEquipmentPacket());
            }
            this.rewardsRevealed = true;
            Utils.sendFinalMessages(this.getCrate(), this.getRewards(), this.getPlayer());
        } else if (this.getCounter() < 300 && this.rewardsRevealed) {
            for (int i = 0; i < this.rewardHolograms.size(); i += 2) {
                PacketHologram packetHologram4 = this.rewardHolograms.get(i);
                PacketHologram packetHologram5 = this.rewardHolograms.get(i + 1);
                int n = i / 2;
                double d = Math.PI * 2 / (double)this.getRewards().size() * (double)n + (double)this.getCounter() * 0.05;
                double d9 = 2.0 - (double)(this.getCounter() - 200) * 0.01;
                Location location = this.getTargetLocation().clone().add(Math.cos(d) * d9, 2.0 + Math.sin((double)(this.getCounter() - 200) * 0.1) * 0.3, Math.sin(d) * d9);
                packetHologram4.teleport(location.clone().add(0.0, 0.8, 0.0));
                packetHologram4.createTeleportPacket();
                this.getPackets().add(packetHologram4.getTeleportPacket());
                packetHologram5.teleport(location);
                packetHologram5.createTeleportPacket();
                this.getPackets().add(packetHologram5.getTeleportPacket());
            }
        } else if (this.getCounter() >= 300) {
            this.cleanup();
        }
        this.counterIncrement();
        this.getAllHolograms().forEach(packetHologram -> this.getPackets().addAll(packetHologram.getAllPackets(false)));
        this.sendPackets();
        this.clearPackets();
    }

    private void cleanup() {
        this.getAnimationHolograms().forEach(packetHologram -> {
            packetHologram.setTimeToDestroy(true);
            packetHologram.createDestroyPacket();
            packetHologram.removeEntity();
        });
        --MonthlyCrate.GlobalCratesOpening;
        if (MonthlyCrate.PlayersOpeningCrate.contains(this.getPlayer())) {
            MonthlyCrate.PlayersOpeningCrate.remove(this.getPlayer());
        }
        MonthlyCrate.CratesLocationsWithoutPackets.remove(this.getTargetLocation());
        this.cancel();
    }
}

