/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.animations.volcanic;

import java.util.ArrayList;
import java.util.List;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.animations.utils.AnimationHandler;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.hologramHandler.PacketHologram;
import me.PM2.AdvancedCrates.rewards.Reward;
import me.PM2.AdvancedCrates.utils.RepeatingTaskHelper;
import me.PM2.AdvancedCrates.utils.Utils;
import me.PM2.HologramPackets.INMSHandler;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class VolcanicEruptionAnimationV2
extends AnimationHandler {
    private PacketHologram volcanoCore;
    private List<PacketHologram> volcanoBase = new ArrayList<PacketHologram>();
    private List<PacketHologram> volcanoSlopes = new ArrayList<PacketHologram>();
    private List<PacketHologram> lavaBubbles = new ArrayList<PacketHologram>();
    private List<PacketHologram> volcanicRocks = new ArrayList<PacketHologram>();
    private List<PacketHologram> lavaFlow = new ArrayList<PacketHologram>();
    private List<PacketHologram> ash = new ArrayList<PacketHologram>();
    private double pressure = 0.0;
    private boolean erupting = false;

    public VolcanicEruptionAnimationV2(RepeatingTaskHelper repeatingTaskHelper, Block block, Player player, Crate crate, INMSHandler iNMSHandler) {
        super(crate, iNMSHandler, player, repeatingTaskHelper);
        PacketHologram packetHologram;
        Location location;
        int n;
        this.setBlock(block);
        this.setTargetLocation(block.getLocation().clone().add(0.5, 0.0, 0.5));
        this.buildVolcanoMountain();
        for (n = 0; n < 5; ++n) {
            location = this.getTargetLocation().clone().add((Math.random() - 0.5) * 0.3, 2.0 + Math.random() * 0.3, (Math.random() - 0.5) * 0.3);
            packetHologram = new PacketHologram("", location, location.getY(), iNMSHandler);
            packetHologram.createEquipmentPacketHelmet(new ItemStack(Material.ORANGE_STAINED_GLASS));
            this.lavaBubbles.add(packetHologram);
            this.getAnimationHolograms().add(packetHologram);
            this.getPackets().addAll(packetHologram.getAllPackets(true));
        }
        for (n = 0; n < 8; ++n) {
            location = this.getTargetLocation().clone().add((Math.random() - 0.5) * 0.5, 2.5 + Math.random(), (Math.random() - 0.5) * 0.5);
            packetHologram = new PacketHologram("\u00a78\u25cb", location, location.getY(), iNMSHandler);
            this.ash.add(packetHologram);
            this.getAnimationHolograms().add(packetHologram);
            this.getPackets().addAll(packetHologram.getAllPackets(true));
        }
        this.getRewards().addAll(this.getRandomRewards(crate.getSize()));
        this.runTaskTimerAsynchronously((Plugin)MonthlyCrate.getInstance(), 0L, 1L);
        this.getTaskHelper().setTaskID(super.getTaskId());
        this.sendPackets();
        this.clearPackets();
    }

    private void buildVolcanoMountain() {
        PacketHologram packetHologram;
        Location location;
        int n;
        int n2;
        for (n2 = -3; n2 <= 3; ++n2) {
            for (n = -3; n <= 3; ++n) {
                if (Math.abs(n2) != 3 && Math.abs(n) != 3) continue;
                location = this.getTargetLocation().clone().add((double)n2 * 0.5, 0.0, (double)n * 0.5);
                packetHologram = new PacketHologram("", location, location.getY(), this.getHandler());
                packetHologram.createEquipmentPacketHelmet(new ItemStack(Material.BLACKSTONE));
                this.volcanoBase.add(packetHologram);
                this.getAnimationHolograms().add(packetHologram);
                this.getPackets().addAll(packetHologram.getAllPackets(true));
            }
        }
        for (n2 = -2; n2 <= 2; ++n2) {
            for (n = -2; n <= 2; ++n) {
                if (Math.abs(n2) != 2 && Math.abs(n) != 2) continue;
                location = this.getTargetLocation().clone().add((double)n2 * 0.5, 0.5, (double)n * 0.5);
                packetHologram = new PacketHologram("", location, location.getY(), this.getHandler());
                packetHologram.createEquipmentPacketHelmet(new ItemStack(Material.BASALT));
                this.volcanoSlopes.add(packetHologram);
                this.getAnimationHolograms().add(packetHologram);
                this.getPackets().addAll(packetHologram.getAllPackets(true));
            }
        }
        for (n2 = -1; n2 <= 1; ++n2) {
            for (n = -1; n <= 1; ++n) {
                if (Math.abs(n2) != 1 && Math.abs(n) != 1) continue;
                location = this.getTargetLocation().clone().add((double)n2 * 0.5, 1.0, (double)n * 0.5);
                packetHologram = new PacketHologram("", location, location.getY(), this.getHandler());
                packetHologram.createEquipmentPacketHelmet(new ItemStack(Material.BASALT));
                this.volcanoSlopes.add(packetHologram);
                this.getAnimationHolograms().add(packetHologram);
                this.getPackets().addAll(packetHologram.getAllPackets(true));
            }
        }
        for (n2 = 0; n2 < 360; n2 += 45) {
            double d = Math.toRadians(n2);
            packetHologram = this.getTargetLocation().clone().add(Math.cos(d) * 0.7, 1.5, Math.sin(d) * 0.7);
            PacketHologram packetHologram2 = new PacketHologram("", (Location)packetHologram, packetHologram.getY(), this.getHandler());
            packetHologram2.createEquipmentPacketHelmet(new ItemStack(Material.BLACKSTONE));
            this.volcanoSlopes.add(packetHologram2);
            this.getAnimationHolograms().add(packetHologram2);
            this.getPackets().addAll(packetHologram2.getAllPackets(true));
        }
        this.volcanoCore = new PacketHologram("", this.getTargetLocation().clone().add(0.0, 2.0, 0.0), this.getTargetLocation().getY() + 2.0, this.getHandler());
        this.volcanoCore.createEquipmentPacketHelmet(new ItemStack(Material.MAGMA_BLOCK));
        this.getAnimationHolograms().add(this.volcanoCore);
        this.getPackets().addAll(this.volcanoCore.getAllPackets(true));
    }

    @Override
    public void run() {
        if (this.getCounter() < 80) {
            this.pressure += 0.02;
            if (this.getCounter() > 20) {
                this.volcanoSlopes.forEach(packetHologram -> {
                    Location location = packetHologram.getLocation();
                    double d = Math.sin((double)this.getCounter() * 0.3) * 0.05 * this.pressure;
                    Location location2 = location.clone().add(d, 0.0, d);
                    packetHologram.teleport(location2);
                    packetHologram.createTeleportPacket();
                });
            }
            double d = Math.sin((double)this.getCounter() * 0.2) * 0.1;
            this.volcanoCore.teleport(this.getTargetLocation().clone().add(0.0, 2.0 + d, 0.0));
            this.volcanoCore.createTeleportPacket();
            this.lavaBubbles.forEach(packetHologram -> {
                Location location = packetHologram.getLocation();
                location.add(0.0, 0.02 + this.pressure * 0.05, 0.0);
                packetHologram.teleport(location);
                packetHologram.createTeleportPacket();
                if (location.getY() > this.getTargetLocation().getY() + 2.5) {
                    this.sendParticlesAndEffects(location, Utils.isVersionOld() ? "LAVA" : null, Utils.isVersionOld() ? null : "LAVA", 3);
                    location.setY(this.getTargetLocation().getY() + 2.0);
                    location.setX(this.getTargetLocation().getX() + (Math.random() - 0.5) * 0.3);
                    location.setZ(this.getTargetLocation().getZ() + (Math.random() - 0.5) * 0.3);
                    packetHologram.teleport(location);
                }
            });
            this.ash.forEach(packetHologram -> {
                Location location = packetHologram.getLocation();
                location.add((Math.random() - 0.5) * 0.1, 0.1 + this.pressure * 0.02, (Math.random() - 0.5) * 0.1);
                packetHologram.teleport(location);
                packetHologram.createTeleportPacket();
                if (location.getY() > this.getTargetLocation().getY() + 6.0) {
                    location.setY(this.getTargetLocation().getY() + 2.5);
                    location.setX(this.getTargetLocation().getX() + (Math.random() - 0.5) * 0.5);
                    location.setZ(this.getTargetLocation().getZ() + (Math.random() - 0.5) * 0.5);
                    packetHologram.teleport(location);
                }
            });
            if (this.getCounter() % 5 == 0) {
                this.volcanoBase.forEach(packetHologram -> {
                    if (Math.random() < 0.3) {
                        this.sendParticlesAndEffects(packetHologram.getLocation(), Utils.isVersionOld() ? "SMOKE_NORMAL" : null, Utils.isVersionOld() ? null : "SMOKE_NORMAL", 2);
                    }
                });
            }
            if (this.getCounter() > 60 && this.getCounter() % 10 == 0) {
                this.sendParticlesAndEffects(this.volcanoCore.getLocation(), Utils.isVersionOld() ? "FLAME" : null, Utils.isVersionOld() ? null : "FLAME", 10);
            }
        } else if (this.getCounter() == 80) {
            PacketHologram packetHologram2;
            Location location;
            int n;
            this.erupting = true;
            this.sendParticlesAndEffects(this.volcanoCore.getLocation(), Utils.isVersionOld() ? "EXPLOSION_HUGE" : null, Utils.isVersionOld() ? null : "EXPLOSION_HUGE", 1);
            this.getLightningPackets().add(this.getHandler().getLightningPacket(this.volcanoCore.getLocation()));
            this.volcanoSlopes.stream().filter(packetHologram -> packetHologram.getLocation().getY() > this.getTargetLocation().getY() + 1.3).forEach(packetHologram -> {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
            });
            this.volcanoCore.setTimeToDestroy(true);
            this.volcanoCore.createDestroyPacket();
            for (n = 0; n < 25; ++n) {
                location = this.getTargetLocation().clone().add(0.0, 2.0, 0.0);
                packetHologram2 = new PacketHologram("", location, location.getY(), this.getHandler());
                Material[] materialArray = new Material[]{Material.BLACKSTONE, Material.BASALT, Material.OBSIDIAN, Material.MAGMA_BLOCK};
                packetHologram2.createEquipmentPacketHelmet(new ItemStack(materialArray[n % materialArray.length]));
                this.volcanicRocks.add(packetHologram2);
                this.getAnimationHolograms().add(packetHologram2);
                this.getPackets().addAll(packetHologram2.getAllPackets(true));
            }
            for (n = 0; n < 360; n += 30) {
                location = this.getTargetLocation().clone().add(0.0, 1.5, 0.0);
                packetHologram2 = new PacketHologram("", location, location.getY(), this.getHandler());
                packetHologram2.createEquipmentPacketHelmet(new ItemStack(Material.LAVA_BUCKET));
                this.lavaFlow.add(packetHologram2);
                this.getAnimationHolograms().add(packetHologram2);
                this.getPackets().addAll(packetHologram2.getAllPackets(true));
            }
        } else if (this.getCounter() < 120) {
            PacketHologram packetHologram3;
            int n;
            for (n = 0; n < this.volcanicRocks.size(); ++n) {
                packetHologram3 = this.volcanicRocks.get(n);
                Location location = packetHologram3.getLocation();
                double d = (double)(this.getCounter() - 80) * 0.1;
                double d2 = Math.cos((double)n * 0.25) * 2.5;
                double d3 = Math.sin((double)n * 0.25) * 2.5;
                double d4 = 6.0 - d * d * 0.8;
                Location location2 = this.getTargetLocation().clone().add(d2 * d, 2.0 + d4, d3 * d);
                packetHologram3.teleport(location2);
                packetHologram3.createTeleportPacket();
                this.sendParticlesAndEffects(location2, Utils.isVersionOld() ? "FLAME" : null, Utils.isVersionOld() ? null : "FLAME", 2);
                if (!(location2.getY() < this.getTargetLocation().getY())) continue;
                packetHologram3.setTimeToDestroy(true);
                packetHologram3.createDestroyPacket();
                this.sendParticlesAndEffects(location2, Utils.isVersionOld() ? "SMOKE_LARGE" : null, Utils.isVersionOld() ? null : "SMOKE_LARGE", 5);
            }
            for (n = 0; n < this.lavaFlow.size(); ++n) {
                packetHologram3 = this.lavaFlow.get(n);
                double d = 360.0 / (double)this.lavaFlow.size() * (double)n;
                double d5 = (double)(this.getCounter() - 80) * 0.08;
                Location location = this.getTargetLocation().clone().add(Math.cos(Math.toRadians(d)) * d5, Math.max(0.0, 1.5 - d5 * 0.3), Math.sin(Math.toRadians(d)) * d5);
                packetHologram3.teleport(location);
                packetHologram3.createTeleportPacket();
                if (this.getCounter() % 3 != 0) continue;
                this.sendParticlesAndEffects(location, Utils.isVersionOld() ? "LAVA" : null, Utils.isVersionOld() ? null : "LAVA", 1);
            }
            if (this.getCounter() % 2 == 0) {
                Location location = this.getTargetLocation().clone().add((Math.random() - 0.5) * 3.0, 2.0 + Math.random() * 3.0, (Math.random() - 0.5) * 3.0);
                packetHologram3 = new PacketHologram("\u00a78\u25cf", location, location.getY(), this.getHandler());
                this.ash.add(packetHologram3);
                this.getAnimationHolograms().add(packetHologram3);
                this.getPackets().addAll(packetHologram3.getAllPackets(true));
            }
        } else if (this.getCounter() == 120) {
            this.volcanoBase.forEach(packetHologram -> {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
            });
            this.volcanoSlopes.forEach(packetHologram -> {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
            });
            this.lavaBubbles.forEach(packetHologram -> {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
            });
            this.volcanicRocks.forEach(packetHologram -> {
                if (!packetHologram.isTimeToDestroy()) {
                    packetHologram.setTimeToDestroy(true);
                    packetHologram.createDestroyPacket();
                }
            });
            this.lavaFlow.forEach(packetHologram -> {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
            });
            for (int i = 0; i < this.getRewards().size(); ++i) {
                PacketHologram packetHologram4;
                Object object;
                Reward reward = this.getRewards().get(i);
                double d = Math.PI * 2 / (double)this.getRewards().size() * (double)i;
                Location location = this.getTargetLocation().clone().add(Math.cos(d) * 2.5, 0.5, Math.sin(d) * 2.5);
                PacketHologram packetHologram5 = new PacketHologram("", location.clone().subtract(0.0, 0.3, 0.0), location.getY() - 0.3, this.getHandler());
                packetHologram5.createEquipmentPacketHelmet(new ItemStack(Material.OBSIDIAN));
                this.getAnimationHolograms().add(packetHologram5);
                this.getPackets().addAll(packetHologram5.getAllPackets(true));
                for (int j = 0; j < 5; ++j) {
                    object = location.clone().add((Math.random() - 0.5) * 0.5, Math.random() * 1.5, (Math.random() - 0.5) * 0.5);
                    packetHologram4 = new PacketHologram("\u00a77\u25cb", (Location)object, object.getY(), this.getHandler());
                    this.getAnimationHolograms().add(packetHologram4);
                    this.getPackets().addAll(packetHologram4.getAllPackets(true));
                }
                PacketHologram packetHologram6 = new PacketHologram("", location.clone().add(0.3, 0.0, 0.0), location.getY(), this.getHandler());
                packetHologram6.createEquipmentPacketHelmet(new ItemStack(Material.AMETHYST_CLUSTER));
                this.getAnimationHolograms().add(packetHologram6);
                this.getPackets().addAll(packetHologram6.getAllPackets(true));
                object = new PacketHologram("\u00a7c\u00a7lFORGED IN FIRE", location.clone().add(0.0, 1.2, 0.0), location.getY() + 1.2, this.getHandler());
                this.getAnimationHolograms().add((PacketHologram)object);
                this.getPackets().addAll(((PacketHologram)object).getAllPackets(true));
                packetHologram4 = new PacketHologram("\u00a76" + reward.getItemBuilder().getDisplayName(), location, location.getY(), this.getHandler());
                packetHologram4.createEquipmentPacket(reward.getReward());
                this.getAnimationHolograms().add(packetHologram4);
                this.getPackets().addAll(packetHologram4.getAllPackets(true));
            }
            Utils.sendFinalMessages(this.getCrate(), this.getRewards(), this.getPlayer());
        } else if (this.getCounter() < 200) {
            this.ash.forEach(packetHologram -> {
                Location location = packetHologram.getLocation();
                location.add((Math.random() - 0.5) * 0.05, 0.03, (Math.random() - 0.5) * 0.05);
                packetHologram.teleport(location);
                packetHologram.createTeleportPacket();
                if (location.getY() > this.getTargetLocation().getY() + 7.0) {
                    packetHologram.setTimeToDestroy(true);
                    packetHologram.createDestroyPacket();
                }
            });
        } else if (this.getCounter() >= 200) {
            this.cleanup();
        }
        this.counterIncrement();
        this.getAllHolograms().forEach(packetHologram -> this.getPackets().addAll(packetHologram.getAllPackets(false)));
        this.sendPackets();
        this.clearPackets();
    }

    private void cleanup() {
        this.getAnimationHolograms().forEach(packetHologram -> {
            packetHologram.setTimeToDestroy(true);
            packetHologram.createDestroyPacket();
            packetHologram.removeEntity();
        });
        this.getDestroyPackets().forEach(object -> Bukkit.getOnlinePlayers().forEach(player -> this.getHandler().sendPacket((Player)player, object)));
        this.cancel();
    }
}

