/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.animations.utils;

import com.cryptomorin.xseries.advancedcrates.XSound;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.utils.SoundData;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public enum AnimationSound {
    ROUND_PLACE_CRATE("On_Crate_Place"),
    ROUND_WHILE_SPINNING("While_Spinning"),
    ROUND_LIGHTNING("On_Lightning_Strike"),
    ROUND_ITEM_CHANGE("On_Item_Change"),
    ROUND_SPIN_STOP("On_Spinning_Stop"),
    ROUND_CRATE_DISAPPEAR("On_Crate_Disappear"),
    DISPLAY_PLACE_CRATE("On_Crate_Place"),
    DISPLAY_ITEM_CHANGE("On_Item_Change"),
    DISPLAY_SPIN_STOP("On_Spinning_Stop"),
    DISPLAY_CRATE_DISAPPEAR("On_Crate_Disappear"),
    PYRAMID_PLACE_CRATE("On_Crate_Place"),
    PYRAMID_LIGHTNING("On_Lightning_Strike"),
    PYRAMID_FLYING_END("On_Flying_Stop"),
    PYRAMID_DISAPPEAR("On_Crate_Disappear"),
    ROUND2_PLACE_CRATE("On_Crate_Place"),
    ROUND2_WHILE_SPINNING("While_Spinning"),
    ROUND2_LIGHTNING("On_Lightning_Strike"),
    ROUND2_SPIN_STOP("On_Spinning_Stop"),
    ROUND2_CRATE_DISAPPEAR("On_Crate_Disappear"),
    POUCH_PLACE("On_Pouch_Place"),
    POUCH_LIGHTNING("On_Lightning_Strike"),
    POUCH_DISAPPEAR("On_Pouch_Disappear"),
    COSMIC_BREAKING("While_Breaking"),
    COSMIC_GIANT_APPEAR("Giant_Chest_Appears"),
    COSMIC_GIANT_CHEST_SPINNING("While_Giant_Chest_Spinning"),
    GIANT_REWARDS_FLY("While_Individual_Rewards_Fly"),
    GIANT_CRATE_DISAPPEAR("On_Crate_Disappear"),
    NO_ANIMATION_OPEN("On_Crate_Open"),
    CONTRABAND_PLACE_CRATE("On_Crate_Place"),
    CONTRABAND_REVEAL_ITEMS("On_Item_Reveal"),
    CONTRABAND_ITEMS_DISAPPEAR("On_Crate_Disappear"),
    CONTRABAND_FINAL_ITEMS_REVEAL("On_Final_Items_Reveal"),
    CONTRABAND_FINAL_ITEMS_SPIN("While_Final_Items_Spinning"),
    CONTRABAND_CRATE_DISAPPEAR("On_Crate_Disappear"),
    AIRSTRIKE_PLACE_CRATE("On_Crate_Place"),
    AIRSTRIKE_AXE_IMPACT("On_Axe_Impact"),
    AIRSTRIKE_CRATE_SPIN("While_Crate_Spinning"),
    AIRSTRIKE_DISAPPEAR("On_Crate_Disappear"),
    BREAKOUT_WHILE_BREAKING("While_Breaking"),
    BREAKOUT_DISAPPEAR("On_Crate_Disappear"),
    KNIGHT_CRATE_PLACE("On_Crate_Place"),
    KNIGHT_ITEM_REVEAL("On_Item_Reveal"),
    KNIGHT_CRATE_DISAPPEAR("On_Crate_Disappear");

    private final String sound;

    private AnimationSound(String string2) {
        this.sound = string2;
    }

    public String getSound() {
        return this.sound;
    }

    public String getFullPath() {
        String string = this.name().split("_")[0];
        if (string.equalsIgnoreCase("airstrike")) {
            string = "AirStrike";
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1).toLowerCase() + "_Animation_Sounds." + this.getSound();
    }

    public String getVolumePath(String string) {
        return string + "_Volume";
    }

    public String getPitchPath(String string) {
        return string + "_Pitch";
    }

    public void playSounds(Set<Player> set, Player player2, Location location) {
        String string2 = this.getFullPath();
        List list = MonthlyCrate.sounds.getOrDefault(string2, Collections.emptyList());
        float f = MonthlyCrate.soundsVolumes.containsKey(string2 + "_Volume") ? (float)MonthlyCrate.soundsVolumes.get(string2 + "_Volume").intValue() : 1.0f;
        float f2 = MonthlyCrate.soundsVolumes.containsKey(string2 + "_Pitch") ? (float)MonthlyCrate.soundsVolumes.get(string2 + "_Pitch").intValue() : 1.0f;
        List list2 = list.stream().filter(string -> string != null && !string.isEmpty()).map(XSound::matchXSound).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        for (XSound xSound : list2) {
            SoundData soundData = new SoundData(xSound, f, f2);
            if (player2 != null && player2.isOnline()) {
                soundData.playTo(player2, location);
            }
            set.forEach(player -> soundData.playTo((Player)player, location));
        }
    }
}

