/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.animations.utils;

import com.cryptomorin.xseries.advancedcrates.XMaterial;
import de.tr7zw.advancedcrates.nbtapi.utils.MinecraftVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.animations.cosmic.CosmicAnimationEndV2;
import me.PM2.AdvancedCrates.animations.utils.AnimationType;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.hologramHandler.PacketHologram;
import me.PM2.AdvancedCrates.playerHandler.PlayerData;
import me.PM2.AdvancedCrates.rewards.Reward;
import me.PM2.AdvancedCrates.utils.RepeatingTaskHelper;
import me.PM2.AdvancedCrates.utils.Utils;
import me.PM2.HologramPackets.INMSHandler;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AnimationHandler
extends BukkitRunnable {
    private AnimationType animationType;
    private RepeatingTaskHelper taskHelper;
    private Set<Player> shownToPlayers = Collections.newSetFromMap(new ConcurrentHashMap());
    private String crateName;
    private Player player;
    private Location targetLocation;
    private Location removeLoc;
    private Set<Reward> removeItems = new HashSet<Reward>();
    private Crate crate;
    private HashMap<List<String>, List<Reward>> blacklistedPermissions = new HashMap();
    private List<Reward> removeItemsHigh = new ArrayList<Reward>();
    private HashMap<List<String>, List<Reward>> blacklistedPermissionsHigh = new HashMap();
    private boolean rewardsDontRepeat = false;
    private List<Reward> excludeRewards = new ArrayList<Reward>();
    private INMSHandler handler;
    private List<Object> packets = new CopyOnWriteArrayList<Object>();
    private int howFarShown = MonthlyCrate.howFarShownPackets ^ 2;
    private int proximityDistance = 25;
    private List<Reward> guaranteedRewards = new ArrayList<Reward>();
    private boolean individual = false;
    private boolean all = false;
    private List<Reward> wonPrizes = new ArrayList<Reward>();
    private int soundHearingDistance = MonthlyCrate.soundsVolumes.getOrDefault("Sound_Hearing_Distance", 8);
    private boolean playPackets;
    private float radPerSec = 1.45f;
    private int prizeSize = 0;
    private List<PacketHologram> rewardStands = new CopyOnWriteArrayList<PacketHologram>();
    private List<Location> spawnLocations = new ArrayList<Location>();
    private Set<Player> shownToPlayersAll = Collections.newSetFromMap(new ConcurrentHashMap());
    private double animationLength;
    private PacketHologram mainStand;
    private List<Object> lightningPackets = new ArrayList<Object>();
    private List<PacketHologram> animationHolograms = new ArrayList<PacketHologram>();
    private double randomNumber = 1.0;
    private HashMap<Reward, Double> randomNumberValues = new HashMap();
    private LivingEntity giantLivingEntity;
    private List<Object> giantSpawnPackets = new ArrayList<Object>();
    private Object giantNoItemEquipPacket;
    private Object giantDestroyPacket;
    private Object zombie;
    private List<CosmicAnimationEndV2> cosmicEndingTasks = new ArrayList<CosmicAnimationEndV2>();
    private Block block;
    private List<String> finalMessages;
    private String direction;
    private List<Reward> guaranteedRewardsCheck = new ArrayList<Reward>();
    private int directionInteger = 0;
    private int minPrizeSize = 1;
    private int maxPrizeSize = 1;
    private Location chestLocation;
    private double enderchestHeight = (Double)MonthlyCrate.defaultConfig.get("Contraband_Height");
    private Object chestOpenPacket;
    private List<String> guaranteedRewardIndexes = new ArrayList<String>();
    private List<String> dontRepeatRewardIndexes = new ArrayList<String>();
    private Location middle;
    private double floatingItemsSpeed = (Double)MonthlyCrate.defaultConfig.get("Contraband_Floating_Item_Animation_Speed");
    private boolean contrabandItemsFollowing = true;
    private int counter = 0;
    private double floatingTimeBeforeStartingToDisappear = (Double)MonthlyCrate.defaultConfig.get("Contraband_Floating_Items_Time");
    private double floatingSpawningInterval = (Double)MonthlyCrate.defaultConfig.get("Contraband_Floating_Item_Spawn_Interval");
    private double floatingDisappearingInterval = (Double)MonthlyCrate.defaultConfig.get("Contraband_Floating_Item_Disappear_Interval");
    private double floatingTimeFinalRewards = (Double)MonthlyCrate.defaultConfig.get("Contraband_Final_Items_Floating_Time");
    private double floatingTimeRewardsWonDisplayedToPlayer = (Double)MonthlyCrate.defaultConfig.get("Contraband_Won_Items_Displayed_Time");
    private int size;
    private ItemStack helmet;
    private boolean skip = false;
    private PacketHologram flyingAxe;
    private List<Item> droppedItems = new ArrayList<Item>();
    private List<Object> droppedItemsSpawnPackets = new ArrayList<Object>();
    private List<Object> droppedItemsDestroyPackets = new ArrayList<Object>();
    private List<Object> entityItems = new ArrayList<Object>();
    private boolean despawnItems = false;
    private boolean timeToSpawn = false;
    private PlayerData playerData;
    private boolean spawnItems = false;
    private List<Location> flyingAxeLocations = new ArrayList<Location>();
    private List<Reward> rewards = new ArrayList<Reward>();
    boolean showWaterDrops = !MonthlyCrate.defaultConfig.containsKey("Display_Animation_Water_Drops") || (Boolean)MonthlyCrate.defaultConfig.get("Display_Animation_Water_Drops") != false;
    boolean showLavaDrops = MonthlyCrate.defaultConfig.containsKey("Display_Animation_Lava_Drops") && (Boolean)MonthlyCrate.defaultConfig.get("Display_Animation_Lava_Drops") != false;
    boolean showVillagerParticle = !MonthlyCrate.defaultConfig.containsKey("Display_Animation_Villager_Particle") || (Boolean)MonthlyCrate.defaultConfig.get("Display_Animation_Villager_Particle") != false;
    double itemChange = (Double)MonthlyCrate.defaultConfig.get("Display_Animation_Item_Change");
    private int whichStandHasItem = 0;
    private List<PacketHologram> animationSmallStands = new CopyOnWriteArrayList<PacketHologram>();
    private Object chestClosePacket;
    private boolean timeToOpen = false;
    private boolean timeToClose = false;

    public AnimationHandler(Crate crate, INMSHandler iNMSHandler, Player player, RepeatingTaskHelper repeatingTaskHelper) {
        this.crate = crate;
        this.handler = iNMSHandler;
        this.individual = crate.getVisibilityOption().equalsIgnoreCase("Individual") || crate.getVisibilityOption().equalsIgnoreCase("Opener");
        this.all = crate.getVisibilityOption().equalsIgnoreCase("All");
        this.howFarShown = MonthlyCrate.howFarShownPackets * MonthlyCrate.howFarShownPackets;
        this.proximityDistance = crate.getProximity() * crate.getProximity();
        this.crateName = this.crateName;
        this.guaranteedRewards.addAll(crate.getGuaranteedRewards());
        this.player = player;
        this.prizeSize = crate.getSize();
        this.blacklistedPermissions = new HashMap<List<String>, List<Reward>>(crate.getBlacklistedPermissions());
        this.blacklistedPermissionsHigh = new HashMap<List<String>, List<Reward>>(crate.getBlacklistedPermissionsHigh());
        this.rewardsDontRepeat = crate.getRewardsDontRepeat();
        this.taskHelper = repeatingTaskHelper;
        this.contrabandItemsFollowing = crate.isContrabandRewardsFollowing();
        block0: for (List<String> list : this.blacklistedPermissions.keySet()) {
            for (String string : list) {
                if (!this.player.hasPermission(string)) continue;
                this.removeItems.addAll((Collection<Reward>)this.blacklistedPermissions.get(list));
                continue block0;
            }
        }
        block2: for (List<String> list : this.blacklistedPermissionsHigh.keySet()) {
            for (String string : list) {
                if (!this.player.hasPermission(string)) continue;
                this.removeItemsHigh.addAll((Collection<Reward>)this.blacklistedPermissionsHigh.get(list));
                continue block2;
            }
        }
        this.excludeRewards.clear();
        this.excludeRewards.addAll(this.removeItems);
    }

    public AnimationHandler(AnimationHandler animationHandler) {
        if (animationHandler == null) {
            return;
        }
        this.animationType = animationHandler.animationType;
        this.taskHelper = animationHandler.taskHelper;
        this.shownToPlayers = animationHandler.shownToPlayers;
        this.crateName = animationHandler.crateName;
        this.player = animationHandler.player;
        this.targetLocation = animationHandler.targetLocation;
        this.removeLoc = animationHandler.removeLoc;
        this.removeItems = animationHandler.removeItems;
        this.crate = animationHandler.crate;
        this.blacklistedPermissions = animationHandler.blacklistedPermissions;
        this.removeItemsHigh = animationHandler.removeItemsHigh;
        this.blacklistedPermissionsHigh = animationHandler.blacklistedPermissionsHigh;
        this.rewardsDontRepeat = animationHandler.rewardsDontRepeat;
        this.excludeRewards = animationHandler.excludeRewards;
        this.handler = animationHandler.handler;
        this.packets = animationHandler.packets;
        this.howFarShown = animationHandler.howFarShown;
        this.proximityDistance = animationHandler.proximityDistance;
        this.guaranteedRewards = animationHandler.guaranteedRewards;
        this.individual = animationHandler.individual;
        this.all = animationHandler.all;
        this.wonPrizes = animationHandler.wonPrizes;
        this.soundHearingDistance = animationHandler.soundHearingDistance;
        this.playPackets = animationHandler.playPackets;
        this.radPerSec = animationHandler.radPerSec;
        this.prizeSize = animationHandler.prizeSize;
        this.rewardStands = animationHandler.rewardStands;
        this.spawnLocations = animationHandler.spawnLocations;
        this.shownToPlayersAll = animationHandler.shownToPlayersAll;
        this.animationLength = animationHandler.animationLength;
        this.mainStand = animationHandler.mainStand;
        this.lightningPackets = animationHandler.lightningPackets;
        this.animationHolograms = animationHandler.animationHolograms;
        this.giantLivingEntity = animationHandler.giantLivingEntity;
        this.giantSpawnPackets = animationHandler.giantSpawnPackets;
        this.giantNoItemEquipPacket = animationHandler.giantNoItemEquipPacket;
        this.giantDestroyPacket = animationHandler.giantDestroyPacket;
        this.zombie = animationHandler.zombie;
        this.cosmicEndingTasks = animationHandler.cosmicEndingTasks;
        this.block = animationHandler.block;
        this.finalMessages = animationHandler.finalMessages;
        this.direction = animationHandler.direction;
        this.guaranteedRewardsCheck = animationHandler.guaranteedRewardsCheck;
        this.directionInteger = animationHandler.directionInteger;
        this.minPrizeSize = animationHandler.minPrizeSize;
        this.maxPrizeSize = animationHandler.maxPrizeSize;
        this.chestLocation = animationHandler.chestLocation;
        this.enderchestHeight = animationHandler.enderchestHeight;
        this.chestOpenPacket = animationHandler.chestOpenPacket;
        this.guaranteedRewardIndexes = animationHandler.guaranteedRewardIndexes;
        this.dontRepeatRewardIndexes = animationHandler.dontRepeatRewardIndexes;
        this.middle = animationHandler.middle;
        this.floatingItemsSpeed = animationHandler.floatingItemsSpeed;
        this.contrabandItemsFollowing = animationHandler.contrabandItemsFollowing;
        this.counter = animationHandler.counter;
        this.floatingTimeBeforeStartingToDisappear = animationHandler.floatingTimeBeforeStartingToDisappear;
        this.floatingSpawningInterval = animationHandler.floatingSpawningInterval;
        this.floatingDisappearingInterval = animationHandler.floatingDisappearingInterval;
        this.floatingTimeFinalRewards = animationHandler.floatingTimeFinalRewards;
        this.floatingTimeRewardsWonDisplayedToPlayer = animationHandler.floatingTimeRewardsWonDisplayedToPlayer;
        this.size = animationHandler.size;
        this.helmet = animationHandler.helmet;
    }

    public void setupRewardStands() {
        this.rewardStands = this.crate.getPublicHologramText().isEmpty() ? new ArrayList<PacketHologram>() : MonthlyCrate.publicHologramCosmicPacket(this.targetLocation.clone().add(0.0, 4.0, 0.0), this.getPlayer(), this.crate.getPublicHologramText(), this.handler);
        this.rewardStands.forEach(packetHologram -> this.getPackets().addAll(packetHologram.getAllPackets(true)));
    }

    private void processPlayersInBatches(List<Player> list, int n, Consumer<Player> consumer) {
        for (int i = 0; i < list.size(); i += n) {
            ArrayList<Player> arrayList = new ArrayList<Player>(list.subList(i, Math.min(i + n, list.size())));
            arrayList.forEach(consumer);
        }
    }

    public void sendPackets() {
        CopyOnWriteArrayList<Player> copyOnWriteArrayList = new CopyOnWriteArrayList<Player>(this.getNearbyEntities());
        if (this.player != null && this.player.isOnline()) {
            copyOnWriteArrayList.add(this.player);
        }
        this.processPlayersInBatches(copyOnWriteArrayList, 10, this::processPlayer);
        if ((this.crate.getAnimationType() == AnimationType.AIR_STRIKE || this.crate.getAnimationType() == AnimationType.BREAKOUT) && this.isSpawnItems()) {
            Bukkit.getScheduler().runTaskLater((Plugin)MonthlyCrate.getInstance(), () -> this.setSpawnItems(false), 1L);
        }
        List<Object> list = this.getDestroyPackets();
        HashSet<OfflinePlayer> hashSet = new HashSet<OfflinePlayer>();
        this.removeOfflinePlayers(this.shownToPlayers, copyOnWriteArrayList, list, hashSet);
        this.shownToPlayersAll.addAll(this.shownToPlayers);
        this.shownToPlayers.removeAll(hashSet);
        this.lightningPackets.clear();
        hashSet.forEach(offlinePlayer -> this.unhidePublicHolograms((Player)offlinePlayer));
    }

    private void processPlayer(final Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        CopyOnWriteArrayList<Object> copyOnWriteArrayList = new CopyOnWriteArrayList<Object>(this.packets);
        if (this.crate.getAnimationType() == AnimationType.CONTRABAND && (double)this.counter == this.floatingTimeBeforeStartingToDisappear * 20.0 + 15.0 * this.floatingSpawningInterval * 20.0 + 41.0 + this.floatingDisappearingInterval * 20.0 * (double)(14 - this.size) + this.floatingTimeFinalRewards * 20.0) {
            if (this.chestLocation.getBlock().getType() == XMaterial.PLAYER_HEAD.parseMaterial()) {
                this.handler.sendPlayerHeadTexturePacket(player, this.chestLocation);
            } else {
                new BukkitRunnable(){

                    public void run() {
                        player.sendBlockChange(AnimationHandler.this.chestLocation, AnimationHandler.this.chestLocation.getBlock().getType(), AnimationHandler.this.chestLocation.getBlock().getData());
                    }
                }.runTask((Plugin)MonthlyCrate.getInstance());
            }
        }
        this.getAllHolograms().forEach(packetHologram -> {
            if (packetHologram.isTimeToDestroy()) {
                this.handler.sendPacket(player, packetHologram.getDestroyPacket());
            }
        });
        boolean bl = this.shownToPlayers.contains(player);
        if (bl) {
            if ((this.crate.getAnimationType() == AnimationType.AIR_STRIKE || this.crate.getAnimationType() == AnimationType.BREAKOUT) && this.isSpawnItems()) {
                this.getDroppedItemsSpawnPackets().forEach(object -> this.getHandler().sendPacket(player, object));
            }
            if (this.crate.getAnimationType() == AnimationType.KNIGHT) {
                if (this.isTimeToOpen()) {
                    this.handler.sendPacket(player, this.chestOpenPacket);
                }
                if (this.timeToClose) {
                    this.handler.sendPacket(player, this.chestClosePacket);
                }
            }
            if (this.getCrate().getAnimationType() == AnimationType.CONTRABAND) {
                if (this.counter == 36) {
                    new BukkitRunnable(){

                        public void run() {
                            player.sendBlockChange(AnimationHandler.this.chestLocation, AnimationHandler.this.helmet.getType(), (byte)AnimationHandler.this.directionInteger);
                        }
                    }.runTask((Plugin)MonthlyCrate.getInstance());
                    new BukkitRunnable(){

                        public void run() {
                            player.sendBlockChange(AnimationHandler.this.chestLocation, AnimationHandler.this.helmet.getType(), (byte)AnimationHandler.this.directionInteger);
                        }
                    }.runTaskLater((Plugin)MonthlyCrate.getInstance(), 1L);
                } else if (this.counter == 40) {
                    this.handler.sendPacket(player, this.chestOpenPacket);
                }
            }
            copyOnWriteArrayList.forEach(object -> this.handler.sendPacket(player, object));
            if (this.mainStand != null) {
                this.mainStand.sendAllPackets(player, this.mainStand.isNeedToSpawn());
            }
            if (this.getFlyingAxe() != null) {
                this.getFlyingAxe().sendAllPackets(player);
            }
        } else {
            if ((this.crate.getAnimationType() == AnimationType.AIR_STRIKE || this.crate.getAnimationType() == AnimationType.BREAKOUT) && this.isSpawnItems()) {
                this.getDroppedItemsSpawnPackets().forEach(object -> this.getHandler().sendPacket(player, object));
            }
            if (this.crate.getAnimationType() == AnimationType.KNIGHT) {
                if (this.getBlock().getType() == Material.AIR) {
                    this.getPlayer().sendBlockChange(this.getBlock().getLocation(), Material.ENDER_CHEST, (byte)this.directionInteger);
                    new BukkitRunnable(){

                        public void run() {
                            AnimationHandler.this.getPlayer().sendBlockChange(AnimationHandler.this.getBlock().getLocation(), Material.ENDER_CHEST, (byte)AnimationHandler.this.directionInteger);
                        }
                    }.runTaskLater((Plugin)MonthlyCrate.getInstance(), 1L);
                }
                if (this.isTimeToOpen()) {
                    this.getHandler().sendPacket(this.getPlayer(), this.chestOpenPacket);
                }
                if (this.isTimeToClose()) {
                    this.getHandler().sendPacket(this.getPlayer(), this.chestClosePacket);
                }
            }
            if (this.getCrate().getAnimationType() == AnimationType.CONTRABAND) {
                if (this.counter >= 36 && this.counter < 477) {
                    new BukkitRunnable(){

                        public void run() {
                            player.sendBlockChange(AnimationHandler.this.chestLocation, AnimationHandler.this.helmet.getType(), (byte)AnimationHandler.this.directionInteger);
                        }
                    }.runTask((Plugin)MonthlyCrate.getInstance());
                }
                if (this.counter >= 40 && this.counter < 477) {
                    this.handler.sendPacket(player, this.chestOpenPacket);
                }
            }
            this.hidePublicHolograms(player);
            this.giantSpawnPackets.forEach(object -> this.handler.sendPacket(player, object));
            if (this.mainStand != null) {
                this.mainStand.sendAllPackets(player, true);
            }
            copyOnWriteArrayList.forEach(object -> this.handler.sendPacket(player, object));
            this.shownToPlayers.add(player);
            if (this.crate.getAnimationType() == AnimationType.COSMIC && this.taskHelper.getCounter() < this.prizeSize / 4 * 3 * 35 + 33 && this.rewardStands != null) {
                this.rewardStands.forEach(packetHologram -> packetHologram.sendAllPackets(player, true));
            }
        }
        if ((this.crate.getAnimationType() == AnimationType.AIR_STRIKE || this.crate.getAnimationType() == AnimationType.BREAKOUT || this.crate.getAnimationType() == AnimationType.KNIGHT) && this.isDespawnItems()) {
            this.getDroppedItemsDestroyPackets().forEach(object -> this.getHandler().sendPacket(player, object));
        }
        this.lightningPackets.forEach(object -> this.getHandler().sendPacket(player, object));
    }

    private void removeOfflinePlayers(Set<Player> set, List<Player> list, List<Object> list2, Set<OfflinePlayer> set2) {
        set.stream().filter(player -> !list.contains(player) && player != null && player.isOnline()).forEach(player -> {
            if (this.crate.getAnimationType() == AnimationType.AIR_STRIKE) {
                if (this.getBlock().getType() == Material.AIR || this.getBlock().getType() == XMaterial.BARRIER.parseMaterial()) {
                    if (!this.getCrate().getItemsAdderEntityMap().containsKey(this.getBlock().getLocation().toString())) {
                        player.sendBlockChange(this.getTargetLocation(), this.getTargetLocation().getBlock().getType(), this.getTargetLocation().getBlock().getData());
                    } else {
                        this.getCrate().getItemsAdderEntityMap().get(this.getBlock().getLocation().toString()).sendShowPacket((Player)player);
                    }
                }
                this.getDroppedItemsDestroyPackets().forEach(object -> this.getHandler().sendPacket((Player)player, object));
            }
            list2.forEach(object -> this.handler.sendPacket((Player)player, object));
            set2.add((OfflinePlayer)player);
        });
    }

    private void clear() {
        this.handler.sendPacket(this.player, this.giantNoItemEquipPacket);
        try {
            if (this.giantLivingEntity != null && !this.giantLivingEntity.isDead()) {
                this.giantLivingEntity.teleport(this.giantLivingEntity.getLocation().add(0.0, -300.0, 0.0));
                this.packets.add(this.handler.getTeleportPacket(this.giantLivingEntity));
                this.giantDestroyPacket = this.handler.getDestroyPacket(this.handler.getLivingEntity(this.zombie));
                this.handler.sendPacket(this.player, this.giantDestroyPacket);
            }
            new BukkitRunnable(){

                public void run() {
                    if (AnimationHandler.this.giantLivingEntity != null && !AnimationHandler.this.giantLivingEntity.isDead()) {
                        AnimationHandler.this.giantLivingEntity.remove();
                    }
                }
            }.runTask((Plugin)MonthlyCrate.getInstance());
            ArrayList<Object> arrayList = new ArrayList<Object>(this.packets);
            for (Player player : Bukkit.getOnlinePlayers()) {
                arrayList.forEach(object -> this.handler.sendPacket(player, object));
            }
            if (this.taskHelper != null) {
                Bukkit.getScheduler().cancelTask(this.taskHelper.getTaskID());
            }
        }
        catch (Exception exception) {
            new BukkitRunnable(){

                public void run() {
                    if (AnimationHandler.this.giantLivingEntity != null && !AnimationHandler.this.giantLivingEntity.isDead()) {
                        AnimationHandler.this.giantLivingEntity.teleport(AnimationHandler.this.giantLivingEntity.getLocation().add(0.0, -300.0, 0.0));
                        AnimationHandler.this.packets.add(AnimationHandler.this.handler.getTeleportPacket(AnimationHandler.this.giantLivingEntity));
                    }
                    AnimationHandler.this.giantDestroyPacket = AnimationHandler.this.handler.getDestroyPacket(AnimationHandler.this.handler.getLivingEntity(AnimationHandler.this.zombie));
                    AnimationHandler.this.handler.sendPacket(AnimationHandler.this.player, AnimationHandler.this.giantDestroyPacket);
                    if (AnimationHandler.this.giantLivingEntity != null && !AnimationHandler.this.giantLivingEntity.isDead()) {
                        AnimationHandler.this.giantLivingEntity.remove();
                    }
                    ArrayList arrayList = new ArrayList(AnimationHandler.this.packets);
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        arrayList.forEach(object -> AnimationHandler.this.handler.sendPacket(player, object));
                    }
                    for (Player player : AnimationHandler.this.shownToPlayersAll) {
                        AnimationHandler.this.crate.getDeletePacketForPlayer().put(player, AnimationHandler.this.getDestroyPackets());
                    }
                    if (AnimationHandler.this.taskHelper != null) {
                        Bukkit.getScheduler().cancelTask(AnimationHandler.this.taskHelper.getTaskID());
                    }
                }
            }.runTask((Plugin)MonthlyCrate.getInstance());
        }
        this.getDestroyPackets().forEach(object -> Bukkit.getOnlinePlayers().forEach(player -> this.handler.sendPacket((Player)player, object)));
        for (Player player : this.shownToPlayersAll) {
            if (this.crate.getDeletePacketForPlayer().containsKey(player)) {
                this.crate.getDeletePacketForPlayer().get(player).addAll(this.getDestroyPackets());
            } else {
                this.crate.getDeletePacketForPlayer().put(player, this.getDestroyPackets());
            }
            this.crate.getDeletePacketForPlayer().get(player).add(this.giantDestroyPacket);
        }
    }

    public Set<Player> getNearbyEntities() {
        if (this.individual) {
            return new HashSet<Player>();
        }
        HashSet<Player> hashSet = new HashSet<Player>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            double d;
            if (player.getLocation().getWorld() != this.targetLocation.getWorld() || !((d = this.targetLocation.distanceSquared(player.getLocation())) < (double)this.howFarShown) || !(d > (double)this.proximityDistance) && !this.all) continue;
            hashSet.add(player);
        }
        return hashSet;
    }

    private Particle resolveParticle(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        switch (string2.toUpperCase(Locale.ROOT)) {
            case "INSTANT_SPELL": 
            case "SPELL_INSTANT": 
            case "INSTANT_EFFECT": {
                return Particle.INSTANT_EFFECT;
            }
            case "SMOKE_LARGE": 
            case "LARGE_SMOKE": {
                return Particle.LARGE_SMOKE;
            }
            case "EXPLOSION_HUGE": {
                return Particle.EXPLOSION_EMITTER;
            }
            case "ITEM_CRACK": {
                return Particle.ITEM;
            }
            case "REDSTONE": 
            case "DUST": {
                return Particle.DUST;
            }
        }
        try {
            return Particle.valueOf((String)string2.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string3 = string2.replace('-', '_').toUpperCase(Locale.ROOT);
            try {
                return Particle.valueOf((String)string3);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                return null;
            }
        }
    }

    private static boolean hasParticleSpellClass() {
        try {
            Class.forName("org.bukkit.Particle$Spell", false, Particle.class.getClassLoader());
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static Object newParticleSpell(Color color, float f) {
        try {
            Class<?> clazz = Class.forName("org.bukkit.Particle$Spell", true, Particle.class.getClassLoader());
            return clazz.getConstructor(Color.class, Float.TYPE).newInstance(color, Float.valueOf(f));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private Object defaultDataFor(Particle particle) {
        if (particle == null) {
            return null;
        }
        switch (particle) {
            case INSTANT_EFFECT: 
            case EFFECT: {
                Object object;
                if (AnimationHandler.hasParticleSpellClass() && (object = AnimationHandler.newParticleSpell(Color.fromRGB((int)255, (int)255, (int)255), 1.0f)) != null) {
                    return object;
                }
                return null;
            }
            case ENTITY_EFFECT: {
                return Color.fromRGB((int)0, (int)255, (int)0);
            }
            case DUST: {
                return new Particle.DustOptions(Color.fromRGB((int)255, (int)255, (int)255), 1.0f);
            }
        }
        return null;
    }

    public void sendParticlesAndEffects(Location location, String string, String string2, int n) {
        if (string2 != null && string2.equalsIgnoreCase("Instant_Spell")) {
            if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_20_R4)) {
                this.sendParticlesAndEffects(location, null, "END_ROD", 6);
            } else {
                this.sendParticlesAndEffects(location, "INSTANT_SPELL", null, 2);
            }
            return;
        }
        this.sendParticlesAndEffects(location, string, string2, n, null);
    }

    public void sendParticlesAndEffects(Location location, String string, String string2, int n, ItemStack itemStack) {
        Set<Player> set = this.getNearbyEntities();
        if (this.player != null && this.player.isOnline()) {
            set.add(this.player);
        }
        Bukkit.getScheduler().runTask((Plugin)MonthlyCrate.getInstance(), () -> {
            for (Player player : set) {
                if (player == null || !player.isOnline()) continue;
                try {
                    Object object;
                    if (string != null) {
                        Utils.playEffect(player, string, n, location);
                        continue;
                    }
                    Particle particle = this.resolveParticle(string2);
                    if (particle == null) {
                        player.spawnParticle(Particle.END_ROD, location, Math.max(1, n));
                        continue;
                    }
                    if (particle == Particle.DUST) {
                        object = new Particle.DustOptions(Color.RED, 1.0f);
                        player.spawnParticle(Particle.DUST, location, n, 0.0, 0.0, 0.0, 0.0, object);
                        continue;
                    }
                    if (particle == Particle.ITEM) {
                        object = itemStack != null ? itemStack : new ItemStack(Material.DIAMOND);
                        player.spawnParticle(Particle.ITEM, location, n, 0.0, 0.0, 0.0, 0.0, object);
                        continue;
                    }
                    if (particle == Particle.INSTANT_EFFECT || particle == Particle.EFFECT || particle == Particle.ENTITY_EFFECT) {
                        object = this.defaultDataFor(particle);
                        if (object != null) {
                            player.spawnParticle(particle, location, n, 0.0, 0.0, 0.0, 0.0, object);
                            continue;
                        }
                        player.spawnParticle(Particle.END_ROD, location, Math.max(1, n));
                        continue;
                    }
                    player.spawnParticle(particle, location, n, 0.0, 0.0, 0.0, 0.0);
                }
                catch (Throwable throwable) {
                    try {
                        player.spawnParticle(Particle.END_ROD, location, Math.max(1, n));
                    }
                    catch (Throwable throwable2) {}
                }
            }
        });
    }

    public void sendColoredDust(Location location, Color color, float f, int n) {
        Set<Player> set = this.getNearbyEntities();
        if (this.player != null && this.player.isOnline()) {
            set.add(this.player);
        }
        set.forEach(player -> {
            if (player != null && player.isOnline()) {
                try {
                    Particle.DustOptions dustOptions = new Particle.DustOptions(color, f);
                    player.spawnParticle(Particle.DUST, location, n, 0.0, 0.0, 0.0, 0.0, (Object)dustOptions);
                }
                catch (Exception exception) {
                    player.spawnParticle(Particle.DRAGON_BREATH, location, n);
                }
            }
        });
    }

    public void hidePublicHolograms(final Player player) {
        if (this.getCrate().getAnimationType() == AnimationType.CONTRABAND) {
            new BukkitRunnable(){

                public void run() {
                    if (!AnimationHandler.this.getCrate().getItemsAdderEntityMap().containsKey(AnimationHandler.this.getBlock().getLocation().toString())) {
                        player.sendBlockChange(AnimationHandler.this.getBlock().getLocation(), Material.AIR, (byte)0);
                    } else {
                        AnimationHandler.this.getCrate().getItemsAdderEntityMap().get(AnimationHandler.this.getBlock().getLocation().toString()).sendHidePacket(player);
                    }
                }
            }.runTask((Plugin)MonthlyCrate.getInstance());
        }
        if (this.crate.getHiddenHologramsLocations().containsKey(player.getUniqueId())) {
            if (this.crate.getHiddenHologramsLocations().get(player.getUniqueId()).contains(this.targetLocation)) {
                return;
            }
            this.crate.getHiddenHologramsLocations().get(player.getUniqueId()).add(this.targetLocation);
        } else {
            HashSet<Location> hashSet = new HashSet<Location>();
            hashSet.add(this.targetLocation);
            this.crate.getHiddenHologramsLocations().put(player.getUniqueId(), hashSet);
        }
        if (!this.crate.getItemsAdderEntityMap().containsKey(this.targetLocation.getBlock().getLocation().toString())) {
            if (this.getCrate().getAnimationType() != AnimationType.OCEAN) {
                player.sendBlockChange(this.targetLocation, Material.AIR, (byte)0);
            }
        } else {
            this.crate.getItemsAdderEntityMap().get(this.targetLocation.getBlock().getLocation().toString()).sendHidePacket(player);
        }
    }

    public void unhidePublicHolograms(final Player player) {
        if (this.getCrate().getAnimationType() == AnimationType.CONTRABAND) {
            if (this.chestLocation.getBlock().getType() == XMaterial.PLAYER_HEAD.parseMaterial()) {
                this.handler.sendPlayerHeadTexturePacket(player, this.block.getLocation());
            } else {
                new BukkitRunnable(){

                    public void run() {
                        if (!AnimationHandler.this.getCrate().getItemsAdderEntityMap().containsKey(AnimationHandler.this.getBlock().getLocation().toString())) {
                            player.sendBlockChange(AnimationHandler.this.getBlock().getLocation(), AnimationHandler.this.block.getType(), AnimationHandler.this.block.getData());
                        } else {
                            AnimationHandler.this.getCrate().getItemsAdderEntityMap().get(AnimationHandler.this.getBlock().getLocation().toString()).sendShowPacket(AnimationHandler.this.getPlayer());
                        }
                    }
                }.runTask((Plugin)MonthlyCrate.getInstance());
            }
        }
        if (this.crate.getHiddenHologramsLocations().containsKey(player.getUniqueId()) && this.crate.getHiddenHologramsLocations().get(player.getUniqueId()).contains(this.targetLocation)) {
            if (this.crate.getUnhideHologramLocations().containsKey(player.getUniqueId()) && !this.crate.getUnhideHologramLocations().get(player.getUniqueId()).contains(this.targetLocation)) {
                this.crate.getUnhideHologramLocations().get(player.getUniqueId()).add(this.targetLocation);
            } else {
                this.crate.getUnhideHologramLocations().put(player.getUniqueId(), new HashSet<Location>(Arrays.asList(this.targetLocation)));
            }
        }
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_9_R1) ? this.targetLocation.getBlock().getType() == XMaterial.PLAYER_HEAD.parseMaterial() : this.targetLocation.getBlock().getType() == Material.valueOf((String)"SKULL_ITEM")) {
            this.handler.sendPlayerHeadTexturePacket(player, this.targetLocation);
        } else if (!this.crate.getItemsAdderEntityMap().containsKey(this.targetLocation.getBlock().getLocation().toString())) {
            player.sendBlockChange(this.targetLocation, this.targetLocation.getBlock().getType(), this.targetLocation.getBlock().getData());
        } else {
            this.crate.getItemsAdderEntityMap().get(this.targetLocation.getBlock().getLocation().toString()).sendShowPacket(player);
        }
    }

    public Set<Player> getNearbyEntitiesSounds() {
        if (this.individual) {
            return new HashSet<Player>();
        }
        HashSet<Player> hashSet = new HashSet<Player>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            double d;
            if (player.getLocation().getWorld() != this.targetLocation.getWorld() || !((d = this.targetLocation.distanceSquared(player.getLocation())) < (double)this.soundHearingDistance)) continue;
            hashSet.add(player);
        }
        return hashSet;
    }

    public List<Object> getDestroyPackets() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.getAllHolograms().forEach(packetHologram -> {
            if (packetHologram != null) {
                arrayList.add(packetHologram.getDestroyPacket());
            }
        });
        return arrayList;
    }

    public List<PacketHologram> getAllHolograms() {
        ArrayList<PacketHologram> arrayList = new ArrayList<PacketHologram>();
        if (this.mainStand != null) {
            arrayList.add(this.mainStand);
        }
        if (this.flyingAxe != null) {
            arrayList.add(this.flyingAxe);
        }
        if (this.rewardStands != null) {
            arrayList.addAll(this.rewardStands);
        }
        if (!this.animationHolograms.isEmpty()) {
            arrayList.addAll(this.animationHolograms);
        }
        if (!this.cosmicEndingTasks.isEmpty()) {
            this.cosmicEndingTasks.forEach(cosmicAnimationEndV2 -> arrayList.addAll(cosmicAnimationEndV2.getAllHolograms()));
        }
        arrayList.addAll(this.animationSmallStands);
        return arrayList;
    }

    public void loadGiantInfo(Object object) {
        this.zombie = object;
        if (this.zombie != null) {
            this.giantNoItemEquipPacket = this.handler.getPacketEntityEquipmentHand(this.zombie, new ItemStack(Material.AIR));
        }
    }

    public void clearPackets() {
        this.getPackets().clear();
    }

    public void run() {
    }

    public void counterIncrement() {
        ++this.counter;
    }

    public Reward getRandomReward() {
        Reward reward;
        if (!this.guaranteedRewards.isEmpty()) {
            reward = this.guaranteedRewards.get(ThreadLocalRandom.current().nextInt(0, this.guaranteedRewards.size()));
            this.guaranteedRewards.remove(reward);
        } else {
            reward = this.getCrate().getRandomRewardLow((List<Reward>)(this.rewardsDontRepeat ? this.excludeRewards : new ArrayList<Reward>(this.removeItems)));
        }
        if (this.rewardsDontRepeat) {
            this.excludeRewards.add(reward);
        }
        return reward;
    }

    public List<Reward> getRandomRewards(int n) {
        ArrayList<Reward> arrayList = new ArrayList<Reward>();
        for (int i = 0; i < n; ++i) {
            Reward reward;
            if (this.rewardsDontRepeat && this.getCrate().getLowRewards().size() <= this.getCrate().getSize() && i + 1 >= this.getCrate().getLowRewards().size()) {
                this.rewardsDontRepeat = false;
                this.removeItems.addAll(this.excludeRewards);
            }
            if (!this.guaranteedRewards.isEmpty()) {
                reward = this.guaranteedRewards.get(ThreadLocalRandom.current().nextInt(0, this.guaranteedRewards.size()));
                this.guaranteedRewards.remove(reward);
            } else {
                reward = this.getCrate().getRandomRewardLow((List<Reward>)(this.rewardsDontRepeat ? this.excludeRewards : new ArrayList<Reward>(this.removeItems)));
            }
            arrayList.add(reward);
            if (!this.rewardsDontRepeat) continue;
            this.excludeRewards.add(reward);
        }
        return arrayList;
    }

    public RepeatingTaskHelper getTaskHelper() {
        return this.taskHelper;
    }

    public void setTaskHelper(RepeatingTaskHelper repeatingTaskHelper) {
        this.taskHelper = repeatingTaskHelper;
    }

    public Set<Player> getShownToPlayers() {
        return this.shownToPlayers;
    }

    public String getCrateName() {
        return this.crateName;
    }

    public void setCrateName(String string) {
        this.crateName = string;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Location getTargetLocation() {
        return this.targetLocation;
    }

    public void setTargetLocation(Location location) {
        this.targetLocation = location;
    }

    public Location getRemoveLoc() {
        return this.removeLoc;
    }

    public void setRemoveLoc(Location location) {
        this.removeLoc = location;
    }

    public Set<Reward> getRemoveItems() {
        return this.removeItems;
    }

    public Crate getCrate() {
        return this.crate;
    }

    public void setCrate(Crate crate) {
        this.crate = crate;
    }

    public HashMap<List<String>, List<Reward>> getBlacklistedPermissions() {
        return this.blacklistedPermissions;
    }

    public List<Reward> getRemoveItemsHigh() {
        return this.removeItemsHigh;
    }

    public HashMap<List<String>, List<Reward>> getBlacklistedPermissionsHigh() {
        return this.blacklistedPermissionsHigh;
    }

    public boolean isRewardsDontRepeat() {
        return this.rewardsDontRepeat;
    }

    public void setRewardsDontRepeat(boolean bl) {
        this.rewardsDontRepeat = bl;
    }

    public List<Reward> getExcludeRewards() {
        return this.excludeRewards;
    }

    public INMSHandler getHandler() {
        return this.handler;
    }

    public List<Object> getPackets() {
        return this.packets;
    }

    public int getHowFarShown() {
        return this.howFarShown;
    }

    public void setHowFarShown(int n) {
        this.howFarShown = n;
    }

    public int getProximityDistance() {
        return this.proximityDistance;
    }

    public void setProximityDistance(int n) {
        this.proximityDistance = n;
    }

    public List<Reward> getGuaranteedRewards() {
        return this.guaranteedRewards;
    }

    public boolean isIndividual() {
        return this.individual;
    }

    public void setIndividual(boolean bl) {
        this.individual = bl;
    }

    public boolean isAll() {
        return this.all;
    }

    public void setAll(boolean bl) {
        this.all = bl;
    }

    public List<Reward> getWonPrizes() {
        return this.wonPrizes;
    }

    public int getSoundHearingDistance() {
        return this.soundHearingDistance;
    }

    public void setSoundHearingDistance(int n) {
        this.soundHearingDistance = n;
    }

    public boolean isPlayPackets() {
        return this.playPackets;
    }

    public void setPlayPackets(boolean bl) {
        this.playPackets = bl;
    }

    public float getRadPerSec() {
        return this.radPerSec;
    }

    public void setRadPerSec(float f) {
        this.radPerSec = f;
    }

    public int getPrizeSize() {
        return this.prizeSize;
    }

    public void setPrizeSize(int n) {
        this.prizeSize = n;
    }

    public List<PacketHologram> getRewardStands() {
        return this.rewardStands;
    }

    public void setRewardStands(List<PacketHologram> list) {
        this.rewardStands = list;
    }

    public List<Location> getSpawnLocations() {
        return this.spawnLocations;
    }

    public Set<Player> getShownToPlayersAll() {
        return this.shownToPlayersAll;
    }

    public double getAnimationLength() {
        return this.animationLength;
    }

    public void setAnimationLength(double d) {
        this.animationLength = d;
    }

    public PacketHologram getMainStand() {
        return this.mainStand;
    }

    public void setMainStand(PacketHologram packetHologram) {
        this.mainStand = packetHologram;
    }

    public List<Object> getLightningPackets() {
        return this.lightningPackets;
    }

    public List<PacketHologram> getAnimationHolograms() {
        return this.animationHolograms;
    }

    public double getRandomNumber() {
        return this.randomNumber;
    }

    public void setRandomNumber(double d) {
        this.randomNumber = d;
    }

    public HashMap<Reward, Double> getRandomNumberValues() {
        return this.randomNumberValues;
    }

    public void setRandomNumberValues(HashMap<Reward, Double> hashMap) {
        this.randomNumberValues = hashMap;
    }

    public LivingEntity getGiantLivingEntity() {
        return this.giantLivingEntity;
    }

    public void setGiantLivingEntity(LivingEntity livingEntity) {
        this.giantLivingEntity = livingEntity;
    }

    public List<Object> getGiantSpawnPackets() {
        return this.giantSpawnPackets;
    }

    public Object getGiantNoItemEquipPacket() {
        return this.giantNoItemEquipPacket;
    }

    public void setGiantNoItemEquipPacket(Object object) {
        this.giantNoItemEquipPacket = object;
    }

    public Object getGiantDestroyPacket() {
        return this.giantDestroyPacket;
    }

    public void setGiantDestroyPacket(Object object) {
        this.giantDestroyPacket = object;
    }

    public Object getZombie() {
        return this.zombie;
    }

    public void setZombie(Object object) {
        this.zombie = object;
    }

    public List<CosmicAnimationEndV2> getCosmicEndingTasks() {
        return this.cosmicEndingTasks;
    }

    public Block getBlock() {
        return this.block;
    }

    public void setBlock(Block block) {
        this.block = block;
    }

    public List<String> getFinalMessages() {
        return this.finalMessages;
    }

    public void setFinalMessages(List<String> list) {
        this.finalMessages = list;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String string) {
        this.direction = string;
    }

    public List<Reward> getGuaranteedRewardsCheck() {
        return this.guaranteedRewardsCheck;
    }

    public void setGuaranteedRewardsCheck(List<Reward> list) {
        this.guaranteedRewardsCheck = list;
    }

    public int getDirectionInteger() {
        return this.directionInteger;
    }

    public void setDirectionInteger(int n) {
        this.directionInteger = n;
    }

    public int getMinPrizeSize() {
        return this.minPrizeSize;
    }

    public void setMinPrizeSize(int n) {
        this.minPrizeSize = n;
    }

    public int getMaxPrizeSize() {
        return this.maxPrizeSize;
    }

    public void setMaxPrizeSize(int n) {
        this.maxPrizeSize = n;
    }

    public Location getChestLocation() {
        return this.chestLocation;
    }

    public void setChestLocation(Location location) {
        this.chestLocation = location;
    }

    public double getEnderchestHeight() {
        return this.enderchestHeight;
    }

    public void setEnderchestHeight(double d) {
        this.enderchestHeight = d;
    }

    public Object getChestOpenPacket() {
        return this.chestOpenPacket;
    }

    public void setChestOpenPacket(Object object) {
        this.chestOpenPacket = object;
    }

    public List<String> getGuaranteedRewardIndexes() {
        return this.guaranteedRewardIndexes;
    }

    public void setGuaranteedRewardIndexes(List<String> list) {
        this.guaranteedRewardIndexes = list;
    }

    public List<String> getDontRepeatRewardIndexes() {
        return this.dontRepeatRewardIndexes;
    }

    public void setDontRepeatRewardIndexes(List<String> list) {
        this.dontRepeatRewardIndexes = list;
    }

    public Location getMiddle() {
        return this.middle;
    }

    public void setMiddle(Location location) {
        this.middle = location;
    }

    public double getFloatingItemsSpeed() {
        return this.floatingItemsSpeed;
    }

    public void setFloatingItemsSpeed(double d) {
        this.floatingItemsSpeed = d;
    }

    public boolean isContrabandItemsFollowing() {
        return this.contrabandItemsFollowing;
    }

    public void setContrabandItemsFollowing(boolean bl) {
        this.contrabandItemsFollowing = bl;
    }

    public int getCounter() {
        return this.counter;
    }

    public void setCounter(int n) {
        this.counter = n;
    }

    public double getFloatingTimeBeforeStartingToDisappear() {
        return this.floatingTimeBeforeStartingToDisappear;
    }

    public void setFloatingTimeBeforeStartingToDisappear(double d) {
        this.floatingTimeBeforeStartingToDisappear = d;
    }

    public double getFloatingSpawningInterval() {
        return this.floatingSpawningInterval;
    }

    public void setFloatingSpawningInterval(double d) {
        this.floatingSpawningInterval = d;
    }

    public double getFloatingDisappearingInterval() {
        return this.floatingDisappearingInterval;
    }

    public void setFloatingDisappearingInterval(double d) {
        this.floatingDisappearingInterval = d;
    }

    public double getFloatingTimeFinalRewards() {
        return this.floatingTimeFinalRewards;
    }

    public void setFloatingTimeFinalRewards(double d) {
        this.floatingTimeFinalRewards = d;
    }

    public double getFloatingTimeRewardsWonDisplayedToPlayer() {
        return this.floatingTimeRewardsWonDisplayedToPlayer;
    }

    public void setFloatingTimeRewardsWonDisplayedToPlayer(double d) {
        this.floatingTimeRewardsWonDisplayedToPlayer = d;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public ItemStack getHelmet() {
        return this.helmet;
    }

    public void setHelmet(ItemStack itemStack) {
        this.helmet = itemStack;
    }

    public PacketHologram getFlyingAxe() {
        return this.flyingAxe;
    }

    public void setFlyingAxe(PacketHologram packetHologram) {
        this.flyingAxe = packetHologram;
    }

    public List<Item> getDroppedItems() {
        return this.droppedItems;
    }

    public void setDroppedItems(List<Item> list) {
        this.droppedItems = list;
    }

    public List<Object> getDroppedItemsSpawnPackets() {
        return this.droppedItemsSpawnPackets;
    }

    public void setDroppedItemsSpawnPackets(List<Object> list) {
        this.droppedItemsSpawnPackets = list;
    }

    public List<Object> getDroppedItemsDestroyPackets() {
        return this.droppedItemsDestroyPackets;
    }

    public void setDroppedItemsDestroyPackets(List<Object> list) {
        this.droppedItemsDestroyPackets = list;
    }

    public List<Object> getEntityItems() {
        return this.entityItems;
    }

    public void setEntityItems(List<Object> list) {
        this.entityItems = list;
    }

    public boolean isDespawnItems() {
        return this.despawnItems;
    }

    public void setDespawnItems(boolean bl) {
        this.despawnItems = bl;
    }

    public boolean isTimeToSpawn() {
        return this.timeToSpawn;
    }

    public void setTimeToSpawn(boolean bl) {
        this.timeToSpawn = bl;
    }

    public PlayerData getPlayerData() {
        return this.playerData;
    }

    public void setPlayerData(PlayerData playerData) {
        this.playerData = playerData;
    }

    public boolean isSpawnItems() {
        return this.spawnItems;
    }

    public void setSpawnItems(boolean bl) {
        this.spawnItems = bl;
    }

    public List<Location> getFlyingAxeLocations() {
        return this.flyingAxeLocations;
    }

    public void setFlyingAxeLocations(List<Location> list) {
        this.flyingAxeLocations = list;
    }

    public List<Reward> getRewards() {
        return this.rewards;
    }

    public void setRewards(List<Reward> list) {
        this.rewards = list;
    }

    public boolean isShowWaterDrops() {
        return this.showWaterDrops;
    }

    public void setShowWaterDrops(boolean bl) {
        this.showWaterDrops = bl;
    }

    public boolean isShowLavaDrops() {
        return this.showLavaDrops;
    }

    public void setShowLavaDrops(boolean bl) {
        this.showLavaDrops = bl;
    }

    public boolean isShowVillagerParticle() {
        return this.showVillagerParticle;
    }

    public void setShowVillagerParticle(boolean bl) {
        this.showVillagerParticle = bl;
    }

    public double getItemChange() {
        return this.itemChange;
    }

    public void setItemChange(double d) {
        this.itemChange = d;
    }

    public int getWhichStandHasItem() {
        return this.whichStandHasItem;
    }

    public void setWhichStandHasItem(int n) {
        this.whichStandHasItem = n;
    }

    public List<PacketHologram> getAnimationSmallStands() {
        return this.animationSmallStands;
    }

    public void setAnimationSmallStands(List<PacketHologram> list) {
        this.animationSmallStands = list;
    }

    public Object getChestClosePacket() {
        return this.chestClosePacket;
    }

    public void setChestClosePacket(Object object) {
        this.chestClosePacket = object;
    }

    public boolean isTimeToOpen() {
        return this.timeToOpen;
    }

    public void setTimeToOpen(boolean bl) {
        this.timeToOpen = bl;
    }

    public boolean isTimeToClose() {
        return this.timeToClose;
    }

    public void setTimeToClose(boolean bl) {
        this.timeToClose = bl;
    }
}

