/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.animations.tsunami;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.animations.utils.AnimationHandler;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.hologramHandler.PacketHologram;
import me.PM2.AdvancedCrates.rewards.Reward;
import me.PM2.AdvancedCrates.utils.RepeatingTaskHelper;
import me.PM2.AdvancedCrates.utils.Utils;
import me.PM2.HologramPackets.INMSHandler;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class OceanTsunamiAnimationV2
extends AnimationHandler {
    private List<List<PacketHologram>> waveRows = new ArrayList<List<PacketHologram>>();
    private List<PacketHologram> seafoam = new ArrayList<PacketHologram>();
    private List<PacketHologram> dolphins = new ArrayList<PacketHologram>();
    private List<PacketHologram> cobwebNets = new ArrayList<PacketHologram>();
    private List<PacketHologram> floatingRewards = new ArrayList<PacketHologram>();
    private Map<PacketHologram, Reward> rewardMap = new HashMap<PacketHologram, Reward>();
    private Map<PacketHologram, PacketHologram> rewardToWebMap = new HashMap<PacketHologram, PacketHologram>();
    private double waveHeight = 1.0;
    private double waveDistance = 12.0;
    private boolean rewardsStuck = false;

    public OceanTsunamiAnimationV2(RepeatingTaskHelper repeatingTaskHelper, Block block, Player player, Crate crate, INMSHandler iNMSHandler) {
        super(crate, iNMSHandler, player, repeatingTaskHelper);
        this.setBlock(block);
        this.setTargetLocation(block.getLocation().clone().add(0.5, -0.5, -2.0));
        this.getRewards().addAll(this.getRandomRewards(crate.getSize()));
        this.createWave();
        this.createCobwebNets();
        this.createFloatingRewards();
        this.createDolphins();
        this.runTaskTimerAsynchronously((Plugin)MonthlyCrate.getInstance(), 0L, 1L);
        this.getTaskHelper().setTaskID(super.getTaskId());
        this.sendPackets();
        this.clearPackets();
    }

    private void createWave() {
        Location location;
        int n;
        for (n = 0; n < 5; ++n) {
            location = new ArrayList();
            for (int i = -10; i <= 10; ++i) {
                Location location2 = this.getTargetLocation().clone().add((double)i * 0.5, -1.7 + (double)n * 0.5, this.waveDistance);
                PacketHologram packetHologram = new PacketHologram("", location2, location2.getY(), this.getHandler());
                Material material = n == 0 ? Material.LIGHT_BLUE_STAINED_GLASS : Material.BLUE_STAINED_GLASS;
                packetHologram.createEquipmentPacketHelmet(new ItemStack(material));
                location.add(packetHologram);
                this.getAnimationHolograms().add(packetHologram);
                this.getPackets().addAll(packetHologram.getAllPackets(true));
            }
            this.waveRows.add((List<PacketHologram>)location);
        }
        for (n = 0; n < 30; ++n) {
            location = this.getTargetLocation().clone().add((Math.random() - 0.5) * 10.0, 1.5, this.waveDistance);
            PacketHologram packetHologram = new PacketHologram("\u00a7f\u25cb", location, location.getY(), this.getHandler());
            this.seafoam.add(packetHologram);
            this.getAnimationHolograms().add(packetHologram);
            this.getPackets().addAll(packetHologram.getAllPackets(true));
        }
    }

    private void createCobwebNets() {
        int n = this.getRewards().size();
        double d = 10.0 / (double)(n + 1);
        for (int i = 0; i < n; ++i) {
            double d2 = -5.0 + d * (double)(i + 1);
            for (int j = 0; j < 3; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    Location location = this.getTargetLocation().clone().add(d2 + (double)k * 0.4, -1.2 + (double)j * 0.5, 3.0);
                    PacketHologram packetHologram = new PacketHologram("", location, location.getY(), this.getHandler());
                    packetHologram.createEquipmentPacketHelmet(new ItemStack(Material.COBWEB));
                    this.cobwebNets.add(packetHologram);
                    this.getAnimationHolograms().add(packetHologram);
                    this.getPackets().addAll(packetHologram.getAllPackets(true));
                }
            }
        }
    }

    private void createFloatingRewards() {
        for (int i = 0; i < this.getRewards().size(); ++i) {
            int n;
            Reward reward = this.getRewards().get(i);
            double d = -4.0 + 8.0 / (double)this.getRewards().size() * (double)i;
            Location location = this.getTargetLocation().clone().add(d, -1.5, this.waveDistance);
            PacketHologram packetHologram = new PacketHologram("\u00a7b\u00a7l" + reward.getItemBuilder().getDisplayName(), location, location.getY(), this.getHandler());
            packetHologram.createEquipmentPacket(reward.getReward());
            this.floatingRewards.add(packetHologram);
            this.getAnimationHolograms().add(packetHologram);
            this.getPackets().addAll(packetHologram.getAllPackets(true));
            this.rewardMap.put(packetHologram, reward);
            if (i >= this.cobwebNets.size() / 9 || (n = i * 9 + 4) >= this.cobwebNets.size()) continue;
            this.rewardToWebMap.put(packetHologram, this.cobwebNets.get(n));
        }
    }

    private void createDolphins() {
        for (int i = 0; i < 3; ++i) {
            Location location = this.getTargetLocation().clone().add((double)((i - 1) * 3), 0.30000000000000004, this.waveDistance - 1.0);
            PacketHologram packetHologram = new PacketHologram("\u00a7b\ud83d\udc2c", location, location.getY(), this.getHandler());
            packetHologram.createEquipmentPacketHelmet(new ItemStack(Material.TROPICAL_FISH));
            this.dolphins.add(packetHologram);
            this.getAnimationHolograms().add(packetHologram);
            this.getPackets().addAll(packetHologram.getAllPackets(true));
        }
    }

    @Override
    public void run() {
        if (this.getCounter() < 120) {
            double d;
            int n;
            this.waveDistance = Math.max(0.0, 12.0 - (double)this.getCounter() * 0.1);
            if (this.getCounter() < 82) {
                this.waveHeight = 1.0 + (1.0 - this.waveDistance / 12.0) * 4.0;
            } else {
                n = this.getCounter() - 82;
                double d2 = Math.max(0.0, 1.0 - (double)n / 38.0);
                this.waveHeight = (1.0 + (1.0 - this.waveDistance / 12.0) * 4.0) * d2;
            }
            for (n = 0; n < this.waveRows.size(); ++n) {
                List<PacketHologram> list = this.waveRows.get(n);
                d = this.waveHeight - (double)n * 0.5;
                for (int i = 0; i < list.size(); ++i) {
                    PacketHologram packetHologram2 = list.get(i);
                    double d3 = Math.sin((double)this.getCounter() * 0.1 + (double)i * 0.2) * 0.2;
                    Location location = this.getTargetLocation().clone().add((double)(i - 10) * 0.5, d + d3 - 2.6, this.waveDistance);
                    packetHologram2.teleport(location);
                    packetHologram2.createTeleportPacket();
                }
            }
            this.seafoam.forEach(packetHologram -> {
                Location location = packetHologram.getLocation();
                location.setZ(this.getTargetLocation().getZ() + this.waveDistance);
                location.setY(-1.7 + this.getTargetLocation().getY() + this.waveHeight + Math.random() * 0.3);
                packetHologram.teleport(location);
                packetHologram.createTeleportPacket();
            });
            if (!this.rewardsStuck) {
                this.floatingRewards.forEach(packetHologram -> {
                    Location location = packetHologram.getLocation();
                    location.setZ(this.getTargetLocation().getZ() + this.waveDistance);
                    location.setY(-1.7 + this.getTargetLocation().getY() + this.waveHeight - 0.5 + Math.sin((double)this.getCounter() * 0.1) * 0.2);
                    packetHologram.teleport(location);
                    packetHologram.createTeleportPacket();
                    packetHologram.setHeadPose(this.getCounter() * 3, this.getCounter() * 2, (float)(Math.sin((double)this.getCounter() * 0.1) * 10.0));
                });
            }
            for (n = 0; n < this.dolphins.size(); ++n) {
                PacketHologram packetHologram3 = this.dolphins.get(n);
                d = (double)this.getCounter() * 0.1 + (double)(n * 2);
                double d4 = Math.sin(d) * 2.0;
                Location location = this.getTargetLocation().clone().add((double)((n - 1) * 3) + Math.sin((double)this.getCounter() * 0.05), -1.7 + this.waveHeight + Math.max(d4, -0.5), this.waveDistance);
                packetHologram3.teleport(location);
                packetHologram3.createTeleportPacket();
                if (!(d4 < 0.0) || !(Math.sin(d - 0.1) >= 0.0)) continue;
                this.sendParticlesAndEffects(location, Utils.isVersionOld() ? "WATER_SPLASH" : null, Utils.isVersionOld() ? null : "WATER_SPLASH", 10);
            }
            if (this.waveDistance <= 3.6 && !this.rewardsStuck) {
                this.stickRewardsToWebs();
            }
        } else if (this.getCounter() == 110) {
            this.finalReveal();
        } else if (this.getCounter() == 120) {
            this.clearWave();
            Utils.sendFinalMessages(this.getCrate(), this.getRewards(), this.getPlayer());
        } else if (this.getCounter() <= 278) {
            this.animateStuckRewards();
        } else if (this.getCounter() >= 280) {
            this.cleanup();
        }
        this.counterIncrement();
        this.getAllHolograms().forEach(packetHologram -> this.getPackets().addAll(packetHologram.getAllPackets(false)));
        this.sendPackets();
        this.clearPackets();
    }

    private void stickRewardsToWebs() {
        this.rewardsStuck = true;
        this.floatingRewards.forEach(packetHologram -> {
            PacketHologram packetHologram2 = this.rewardToWebMap.get(packetHologram);
            if (packetHologram2 != null) {
                Location location = packetHologram2.getLocation().clone().add(0.0, 0.0, 0.0);
                packetHologram.teleport(location);
                packetHologram.createTeleportPacket();
                packetHologram.setHeadPose(0.0f, 0.0f, 0.0f);
            }
        });
        this.sendParticlesAndEffects(this.getTargetLocation().clone().add(0.0, 2.0, 3.0), Utils.isVersionOld() ? "WATER_SPLASH" : null, Utils.isVersionOld() ? null : "WATER_SPLASH", 200);
    }

    private void clearWave() {
        this.waveRows.forEach(list -> list.forEach(packetHologram -> {
            packetHologram.setTimeToDestroy(true);
            packetHologram.createDestroyPacket();
        }));
        this.seafoam.forEach(packetHologram -> {
            packetHologram.setTimeToDestroy(true);
            packetHologram.createDestroyPacket();
        });
        this.dolphins.forEach(packetHologram -> {
            packetHologram.setTimeToDestroy(true);
            packetHologram.createDestroyPacket();
        });
        this.cobwebNets.forEach(packetHologram -> packetHologram.setTimeToDestroy(true));
    }

    private void animateStuckRewards() {
        this.floatingRewards.forEach(packetHologram -> {
            Location location = packetHologram.getLocation();
            double d = Math.sin((double)this.getCounter() * 0.3) * 0.05;
            location.add(d, 0.0, d);
            packetHologram.teleport(location);
            packetHologram.createTeleportPacket();
        });
    }

    private void finalReveal() {
        this.cobwebNets.forEach(packetHologram -> {
            packetHologram.setTimeToDestroy(true);
            packetHologram.createDestroyPacket();
        });
        this.floatingRewards.forEach(packetHologram -> {
            Reward reward = this.rewardMap.get(packetHologram);
            if (reward != null) {
                Location location = packetHologram.getLocation();
                this.sendParticlesAndEffects(location, Utils.isVersionOld() ? "FIREWORKS_SPARK" : null, Utils.isVersionOld() ? null : "FIREWORKS_SPARK", 50);
            }
        });
    }

    private void cleanup() {
        this.getAnimationHolograms().forEach(packetHologram -> {
            packetHologram.setTimeToDestroy(true);
            packetHologram.createDestroyPacket();
            packetHologram.removeEntity();
        });
        this.getDestroyPackets().forEach(object -> Bukkit.getOnlinePlayers().forEach(player -> this.getHandler().sendPacket((Player)player, object)));
        this.cancel();
    }
}

