/*
 * Decompiled with CFR 0.152.
 */
package me.PM2.AdvancedCrates.animations.tornado;

import java.util.ArrayList;
import java.util.List;
import me.PM2.AdvancedCrates.MonthlyCrate;
import me.PM2.AdvancedCrates.animations.utils.AnimationHandler;
import me.PM2.AdvancedCrates.animations.utils.AnimationSound;
import me.PM2.AdvancedCrates.cratesHandler.Crate;
import me.PM2.AdvancedCrates.hologramHandler.PacketHologram;
import me.PM2.AdvancedCrates.rewards.GiveOutRewards;
import me.PM2.AdvancedCrates.rewards.Reward;
import me.PM2.AdvancedCrates.utils.RepeatingTaskHelper;
import me.PM2.AdvancedCrates.utils.Utils;
import me.PM2.HologramPackets.INMSHandler;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TornadoAnimationV2
extends AnimationHandler {
    private final List<PacketHologram> tornadoDebris = new ArrayList<PacketHologram>();
    private final List<PacketHologram> swirlingRewards = new ArrayList<PacketHologram>();
    private double tornadoHeight = 0.1;
    private double tornadoRadius = 0.1;
    private int rotationSpeed = 1;
    private boolean itemsInTornado = false;
    private final Location tornadoCenter;

    public TornadoAnimationV2(RepeatingTaskHelper repeatingTaskHelper, Block block, Player player, Crate crate, INMSHandler iNMSHandler) {
        super(crate, iNMSHandler, player, repeatingTaskHelper);
        this.setTargetLocation(block.getLocation());
        this.setBlock(block);
        this.setPlayerData(MonthlyCrate.getInstance().getPlayerDataManager().getPlayerData(player.getUniqueId().toString()));
        this.tornadoCenter = this.getTargetLocation().clone().add(0.5, 0.0, 0.5);
        Material[] materialArray = new Material[]{Material.DIRT, Material.OAK_LEAVES, Material.STICK, Material.COBBLESTONE, Material.SAND};
        for (int i = 0; i < 10; ++i) {
            Location location = this.tornadoCenter.clone().add((Math.random() - 0.5) * 4.0, Math.random() * 0.5, (Math.random() - 0.5) * 4.0);
            PacketHologram packetHologram = new PacketHologram("", location, location.getY(), iNMSHandler);
            packetHologram.createEquipmentPacketHelmet(new ItemStack(materialArray[i % materialArray.length]));
            packetHologram.setHeadPose((float)(Math.random() * 360.0), (float)(Math.random() * 360.0), 0.0f);
            this.tornadoDebris.add(packetHologram);
            this.getAnimationHolograms().add(packetHologram);
            this.getPackets().addAll(packetHologram.getAllPackets(true));
        }
        AnimationSound.COSMIC_BREAKING.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), this.getTargetLocation());
        this.runTaskTimer((Plugin)MonthlyCrate.getInstance(), 0L, 1L);
        this.getTaskHelper().setTaskID(super.getTaskId());
    }

    @Override
    public void run() {
        if (this.getCounter() < 60) {
            this.tornadoHeight = Math.min(5.0, this.tornadoHeight + 0.1);
            this.tornadoRadius = Math.min(2.5, this.tornadoRadius + 0.05);
            this.rotationSpeed = Math.min(10, this.getCounter() / 6);
            int n = 0;
            while ((double)n < this.tornadoHeight) {
                double d = this.tornadoRadius * (1.0 - (double)n / 10.0);
                for (int i = 0; i < 8; ++i) {
                    double d2 = Math.toRadians(i * 45 + this.getCounter() * this.rotationSpeed + n * 20);
                    Location location = this.tornadoCenter.clone().add(Math.cos(d2) * d, (double)n * 0.5, Math.sin(d2) * d);
                    this.sendParticlesAndEffects(location, null, "CLOUD", 1);
                    if (i % 2 != 0) continue;
                    this.sendParticlesAndEffects(location, null, "SMOKE_NORMAL", 1);
                }
                ++n;
            }
            for (n = 0; n < this.tornadoDebris.size(); ++n) {
                PacketHologram packetHologram2 = this.tornadoDebris.get(n);
                Location location = packetHologram2.getLocation();
                double d = this.tornadoCenter.getX() - location.getX();
                double d3 = this.tornadoCenter.getZ() - location.getZ();
                location.add(d * 0.05, 0.05, d3 * 0.05);
                packetHologram2.setHeadPose((float)(Math.random() * 360.0), this.getCounter() * 10 + n * 36, (float)(Math.random() * 360.0));
                packetHologram2.teleport(location);
                packetHologram2.createTeleportPacket();
                packetHologram2.createMetadataPacket();
            }
            if (this.getCounter() % 5 == 0) {
                for (n = 0; n < 360; n += 30) {
                    double d = Math.toRadians(n);
                    Location location = this.tornadoCenter.clone().add(Math.cos(d) * 3.0, 0.1, Math.sin(d) * 3.0);
                    this.sendParticlesAndEffects(location, null, "SPELL", 2);
                }
                AnimationSound.COSMIC_GIANT_CHEST_SPINNING.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), this.tornadoCenter);
            }
        } else if (this.getCounter() == 60) {
            this.itemsInTornado = true;
            this.tornadoDebris.forEach(packetHologram -> {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
                this.getPackets().add(packetHologram.getDestroyPacket());
            });
            if (this.getRewards().isEmpty()) {
                this.getRewards().addAll(this.getRandomRewards(this.getCrate().getSize()));
            }
            for (int i = 0; i < this.getRewards().size(); ++i) {
                Reward reward = this.getRewards().get(i);
                double d = Math.toRadians((double)i * (360.0 / (double)Math.max(1, this.getRewards().size())));
                Location location = this.tornadoCenter.clone().add(Math.cos(d) * 2.0, 0.0, Math.sin(d) * 2.0);
                PacketHologram packetHologram3 = new PacketHologram("", location, location.getY(), this.getHandler());
                if (Utils.checkIfContainsTools(reward.getReward().getType())) {
                    packetHologram3.setRightArmPose(260.0f, 315.0f, 0.0f);
                } else if (Utils.checkIfContainsItems(reward.getReward().getType())) {
                    packetHologram3.setRightArmPose(275.0f, 320.0f, 0.0f);
                } else {
                    packetHologram3.setRightArmPose(350.0f, 325.0f, 345.0f);
                }
                packetHologram3.createEquipmentPacket(reward.getReward());
                this.swirlingRewards.add(packetHologram3);
                this.getAnimationHolograms().add(packetHologram3);
                this.getPackets().addAll(packetHologram3.getAllPackets(true));
                this.getPackets().addAll(packetHologram3.getEquipmentPacket());
            }
            AnimationSound.GIANT_REWARDS_FLY.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), this.tornadoCenter);
        } else if (this.getCounter() > 60 && this.getCounter() < 120) {
            double d;
            int n = 0;
            while ((double)n < this.tornadoHeight) {
                double d4 = this.tornadoRadius * (1.0 - (double)n / 10.0);
                for (int i = 0; i < 8; ++i) {
                    d = Math.toRadians(i * 45 + this.getCounter() * this.rotationSpeed + n * 20);
                    Location location = this.tornadoCenter.clone().add(Math.cos(d) * d4, (double)n * 0.5, Math.sin(d) * d4);
                    this.sendParticlesAndEffects(location, null, "CLOUD", 1);
                }
                ++n;
            }
            for (n = 0; n < this.swirlingRewards.size(); ++n) {
                PacketHologram packetHologram4 = this.swirlingRewards.get(n);
                double d5 = (double)(this.getCounter() - 60) / 60.0;
                d = Math.toRadians((double)(this.getCounter() * 8) + (double)n * (360.0 / (double)Math.max(1, this.swirlingRewards.size())));
                double d6 = 1.5 * (1.0 - d5 * 0.5);
                double d7 = d5 * 4.0;
                Location location = this.tornadoCenter.clone().add(Math.cos(d) * d6, d7, Math.sin(d) * d6);
                packetHologram4.setRightArmPose(0.0f, this.getCounter() * 5 + n * 60, 60.0f);
                packetHologram4.teleport(location);
                packetHologram4.createTeleportPacket();
                packetHologram4.createMetadataPacket();
                this.sendParticlesAndEffects(location, null, "SPELL_MOB", 1);
            }
        } else if (this.getCounter() == 120) {
            this.sendParticlesAndEffects(this.tornadoCenter.clone().add(0.0, 4.0, 0.0), Utils.isVersionOld() ? "EXPLOSION_HUGE" : null, Utils.isVersionOld() ? null : "EXPLOSION_HUGE", 1);
            this.getLightningPackets().add(this.getHandler().getLightningPacket(this.tornadoCenter.clone().add(0.0, 4.0, 0.0)));
            this.swirlingRewards.forEach(packetHologram -> {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
                this.getPackets().add(packetHologram.getDestroyPacket());
            });
            for (int i = 0; i < this.getRewards().size(); ++i) {
                Reward reward = this.getRewards().get(i);
                double d = Math.toRadians((double)i * (360.0 / (double)Math.max(1, this.getRewards().size())));
                Object object = this.getHandler().getEntityItem(this.tornadoCenter.clone().add(Math.cos(d) * 1.5, 4.0, Math.sin(d) * 1.5), reward.getReward(), false, true);
                this.getEntityItems().add(object);
                this.getDroppedItemsSpawnPackets().add(this.getHandler().getItemSpawnPacket(object));
                this.getDroppedItemsSpawnPackets().add(this.getHandler().getItemMetaDataPacket(object));
                this.getDroppedItemsSpawnPackets().add(this.getHandler().getItemVelocityPacket(object));
                this.getDroppedItemsDestroyPackets().add(this.getHandler().getItemDestroyPacket(object));
            }
            this.setSpawnItems(true);
            AnimationSound.GIANT_CRATE_DISAPPEAR.playSounds(this.getNearbyEntitiesSounds(), this.getPlayer(), this.getTargetLocation());
            new BukkitRunnable(){

                public void run() {
                    TornadoAnimationV2.this.getCrate().getRewardsGiveQueue().put(TornadoAnimationV2.this.getTaskHelper().getUniqueOpeningID(), new GiveOutRewards(TornadoAnimationV2.this.getTaskHelper().getUniqueOpeningID(), TornadoAnimationV2.this.getPlayer(), TornadoAnimationV2.this.getRewards(), (Long)System.currentTimeMillis(), TornadoAnimationV2.this.getCrate()));
                    Utils.sendFinalMessages(TornadoAnimationV2.this.getCrate(), TornadoAnimationV2.this.getRewards(), TornadoAnimationV2.this.getPlayer());
                }
            }.runTask((Plugin)MonthlyCrate.getInstance());
        } else if (this.getCounter() > 120 && this.getCounter() < 160) {
            double d = 1.0 - (double)(this.getCounter() - 120) / 40.0;
            int n = 0;
            while ((double)n < this.tornadoHeight * d) {
                double d8 = this.tornadoRadius * d * (1.0 - (double)n / 10.0);
                for (int i = 0; i < 4; ++i) {
                    double d9 = Math.toRadians(i * 90 + this.getCounter() * 5);
                    Location location = this.tornadoCenter.clone().add(Math.cos(d9) * d8, (double)n * 0.5, Math.sin(d9) * d8);
                    this.sendParticlesAndEffects(location, null, "CLOUD", 1);
                }
                ++n;
            }
        } else if (this.getCounter() >= 200) {
            this.clearRunnable();
            return;
        }
        this.counterIncrement();
        this.getAllHolograms().forEach(packetHologram -> this.getPackets().addAll(packetHologram.getAllPackets(false)));
        this.sendPackets();
        this.clearPackets();
    }

    public void clearRunnable() {
        this.getAllHolograms().forEach(packetHologram -> {
            if (packetHologram != null && !packetHologram.isTimeToDestroy()) {
                packetHologram.setTimeToDestroy(true);
                packetHologram.createDestroyPacket();
                this.getPackets().add(packetHologram.getDestroyPacket());
            }
        });
        if (this.getCrate().getDeletePacketForPlayer().containsKey(this.getPlayer())) {
            this.getCrate().getDeletePacketForPlayer().get(this.getPlayer()).addAll(this.getDestroyPackets());
        } else {
            this.getCrate().getDeletePacketForPlayer().put(this.getPlayer(), this.getDestroyPackets());
        }
        if (MonthlyCrate.PlayersOpeningCrate.contains(this.getPlayer())) {
            MonthlyCrate.PlayersOpeningCrate.remove(this.getPlayer());
        }
        MonthlyCrate.CratesLocationsWithoutPackets.remove(this.getTargetLocation());
        --MonthlyCrate.GlobalCratesOpening;
        this.getPlayerData().setOpeningCrate(false, this.getTargetLocation());
        if (!this.getCrate().isRerollEnabled()) {
            this.getPlayerData().closeCrate();
        }
        this.setDespawnItems(true);
        this.sendPackets();
        super.cancel();
    }
}

